# -*- coding: utf-8 -*-
#
# This module contains the configuration of the individual eric installation
#

_pkg_config = {
    'ericDir'             : '.',
    'ericPixDir'          : './pixmaps',
    'ericIconDir'         : './icons',
    'ericDTDDir'          : './DTDs',
    'ericDocDir'          : './Documentation',
    'ericExamplesDir'     : './Examples',
    'ericTranslationsDir' : '.',
    'ericWizardsDir'      : './Wizards',
    'ericTemplatesDir'    : './DesignerTemplates',
    'ericOthersDir'       : '.',
    'bindir'              : '.',
    'mdir'                : '/usr/lib/python2.3/site-packages',
}

def getConfig(name):
    '''
    Module function to get a configuration value.

    @param name the name of the configuration value (string).
    '''
    try:
        return _pkg_config[name]
    except KeyError:
        pass

    raise AttributeError, '"%s" is not a valid configuration value' % name
