#!/usr/bin/env entity
<object>
  <window ondelete="entity:exit">
    <frame title="perl">
      <button name="foo1" label="$obj->child_rx (button.foo1)" onclick="test1"/>
      <button name="foo2" label="enode_rx (button\.b.*)" onclick="test2"/>
      <button name="boo2" label="enode_rx (w.*)" onclick="test3"/>
      <button name="goo1" label="$obj->children_rx (button.foo1)"
              onclick="test4"/>
      <button name="goo2" label="elist_rx (b.*?2)" onclick="test5"/>
      <button name="roo2" label="$obj->children_rx (.*)" onclick="test6"/>
    </frame>
    <data name="test" />

    <!-- A test for the bindings in perl -->
    <?perl

sub test1
{
    print "Running test1 (child_rx)\n";
    my $obj = enode ("object");
    my $node = $obj->child_rx ('button.foo1');
    print ("Returned node $node\n");
}

sub test2
{
    print "Running test2 (enode_rx)\n";
    my $node = enode_rx ('button\.b.*');
    print ("Returned node $node\n");
}
  
sub test3
{
    print "Running test3 (enode_rx)\n";
    my $node = enode_rx ('w.*');
    print ("Returned node $node\n");
}

sub test4
{
    print "Running test4 (children_rx)\n";
    my $obj = enode ("object");
    my @nodes = $obj->children_rx ('button.foo1');
    foreach $node (@nodes) { print ("nodelist - $node\n"); }
}

sub test5
{
    print "Running test5 (elist_rx)\n";
    my @nodes = elist_rx ('b.*?2');
    foreach $node (@nodes) { print ("nodelist - $node\n"); }
}

sub test6
{
    print "Running test6 (children_rx\n)";
    my $obj = enode ("object");
    my @nodes = $obj->children_rx ('.*');
    foreach $node (@nodes) { print ("nodelist - $node\n"); }
}
  
?>
  </window>
</object>

<!-- Run the same tests for python. -->
<object>
  <window ondelete="entity:exit">
    <frame title="python">
      <button name="foo1" label="obj.child_rx (button.foo1)"
              onclick="python:test1"/>
      <button name="foo2" label="enode_rx (button\.b.*)"
              onclick="python:test2"/>
      <button name="boo2" label="enode_rx (w.*)"
              onclick="python:test3"/>
      <button name="goo1" label="obj.children_rx (button.foo1)"
              onclick="python:test4"/>
      <button name="goo2" label="elist_rx (b.*?2)"
              onclick="python:test5"/>
      <button name="roo2" label="obj.children_rx (.*)"
              onclick="python:test6"/>
    </frame>
  </window>

<?python

def test1(node):
	obj = enode("object")
	node = obj.child_rx('button.foo1');
	print "Returned node", node

def test2(node):
	node = enode_rx('button\.b.*')
	print "Returned node", node

def test3(node):
	node = enode_rx('w.*')
	print "Returned node", node

def test4(node):
	obj = enode("object")
	nodes = obj.children_rx('button.foo1')
	for node in nodes:
		print "nodelist -", node

def test5(node):
	nodes = elist_rx('b.*?2')
	for node in nodes:
		print "nodelist -", node

def test6(node):
	obj = enode("object")
	nodes = obj.children_rx ('.*')
	for node in nodes:
		print "nodelist -", node

?>
</object>
