#!/usr/bin/env entity

<object name="StemBuilder" default-lang="javascript">
 
  <!-- selected XML tree chunk for cut/copy/paste etc. -->
  <data name="cutpaste"/>
 
  <!-- Context Menu -->
  <popupmenu name="context">
    <menuitem onselect="menu_view_xml_tree" label="View XML Tree"/>
    <menuitem sensitive="false" />
    <menuitem onselect="cut_tree" label="Cut Tree"/>
    <menuitem onselect="cut_children_tree" label="Cut Children"/>
    <menuitem onselect="copy_tree" label="Copy Tree"/>
    <menuitem onselect="copy_children_tree" label="Copy Children"/>
    <menuitem name="paste" onselect="paste_tree" label="Paste as Child" sensitive="false"/>
    <menuitem sensitive="false"/>
    <menuitem onselect="menu_edit_data" label="Edit Data"/>
    <!-- <menuitem onselect="menu_edit_xml_tree" label="Edit XML Tree (NYI)" sensitive="false"/> -->
    <menuitem sensitive="false" />
    <menuitem onselect="menu_save_xml_tree" label="Save XML Tree"/>
    <menuitem sensitive="false" />
    <menuitem sensitive="false" />
    <menuitem onselect="menu_delete_tree" label="Delete Tree"/>
  </popupmenu>
  
  <filesel name="dialog" visible="false"/>
  
  <!-- Main window -->
  <window name="StemBuilder" position="center" 
   height="500" width="350" ondelete="entity:quit" 
   title="StemBuilder Tree" border="1">
    <menubar>
      <menu label="File">
        <menuitem onselect="menu_save_xml_tree" label="Save XML Tree"/>
        <menuitem onselect="menu_load_file" label="Load Entity Application"/>
        <menuitem onselect="entity:quit" label="Quit"/>
      </menu>
       <menu label="Edit">
    	<menuitem onselect="cut_tree" label="Cut Tree"/>
    	<menuitem onselect="cut_children_tree" label="Cut Children"/>
    	<menuitem onselect="copy_tree" label="Copy Tree"/>
    	<menuitem onselect="copy_children_tree" label="Copy Children"/>
    	<menuitem name="editpaste" onselect="paste_tree" label="Paste as Child" sensitive="false"/>
    	<menuitem onselect="show_search_dialog" label="Find Node"/>
      </menu>
      <menu label="View">
        <menuitem onselect="menu_view_xml_tree" label="View XML Tree"/>
      </menu>
    </menubar>
    <halign>
      <button expand="true" onclick="cut_tree">
        <label text="Cut" expand="true"/>
      </button>
      <button expand="true" onclick="cut_children_tree">
        <label text="Cut"/>
	<label text="Children"/>
      </button>	
      <button expand="true" onclick="copy_tree">
        <label text="Copy" expand="true"/>
      </button>
      <button expand="true" onclick="copy_children_tree">
        <label text="Copy"/>
	<label text="Children"/>
      </button>
      <button expand="true" name="toolbarpaste" sensitive="false" onclick="paste_tree">
        <label text="Paste" expand="true"/>
      </button>
      <button expand="true" onclick="show_search_dialog">
        <label text="Find"/>
	<label text="Node"/>
      </button>
    </halign>
    <valign expand="true">
      <scrollwindow expand="true">
	    <ctree name="top"
		  expand="true"
	          selection-type="single"
		  onbuttonpress="popup_context"
                  onselect="properties"
                  onexpand="expand_tree">
	      <ctree-column title="Entity XML Tree"/>
	      <ctree-row name="root" dest-node="/">
                <ctree-cell text="/ (root node)"/>
	        <ctree-row>
                  <ctree-cell text="dummy"/>
                </ctree-row>
              </ctree-row>
	    </ctree>
      </scrollwindow>
    </valign>
  </window>
  <include name="properties-window" file="properties-window.e"/>
  <include name="element-toolbox" file="element-toolbox.e"/>
  <include name="xml-viewer" file="xml-viewer.e"/>
  <include name="search-dialog.e" file="search-dialog.e"/>
  <include name="stembuilder.js" file="stembuilder.js"/>
</object>
 

