<object>
  <window ondelete="entity:quit">
    <label text="Non-blocking DNS lookups"/>
    <entry name="userinput"/> 
    <button label="Get hostname from IP" onclick="lookup_host"/>
    <button label="Get IP from hostname" onclick="lookup_ip"/>
    <resolver name="first" ip="127.0.0.1" action="first_lookup_finished"/>
  </window>
  <?perl

sub lookup_host
{
	my $ip = enode("entry.userinput")->attrib("text");

	my $obj = enode("object");
	$res = $obj->new_child ("resolver");
	$res->attrib("action" => "host_lookup_finished");
	$res->attrib("onerror" => "lookup_error");
	$res->attrib("ip" => "$ip");
}

sub lookup_ip
{
	my $hostname = enode("entry.userinput")->attrib("text");
	
	my $obj = enode("object");

	# Build a resolver with append_xml to verify the sync_attribs works.
	my $xml = 
	   qq!<resolver hostname="$hostname" action="ip_lookup_finished"/>!;
	$obj->append_xml($xml);
}

sub first_lookup_finished
{
	my ($node, $result) = @_;
	print "127.0.0.1 resolves to $result\n";
	$node->destroy();
}

sub host_lookup_finished
{
	my ($node, $result) = @_;
	print "hostname resolved to $result\n";
	$node->destroy();
}

sub ip_lookup_finished
{
	my ($node, $result) = @_;
	print "ip resolved to $result\n";
	$node->destroy();
}

sub lookup_error
{
	my ($node, $error) = @_;
	print "error in resolving: $error\n";
}

  ?>
</object>
