#include <gtk/gtk.h>
#include <gtkwrapbox.h>
#include <gtkvwrapbox.h>
#include <gtkhwrapbox.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static void
rendgtk_hwrapbox_render (ENode * node)
{
    GtkWidget *widget;

    widget = gtk_type_new (gtk_hwrap_box_get_type ());

    enode_set_kv (node, "top-widget", widget);
    enode_set_kv (node, "bottom-widget", widget);

    rendgtk_show_cond (node, widget);

    /* Make it so you can drop other apps into boxes */
    rendgtk_dnd_dragtag_target_create (node, widget);

    enode_attribs_sync (node);
}

static void
rendgtk_vwrapbox_render (ENode * node)
{
    GtkWidget *widget;

    widget = gtk_type_new (gtk_vwrap_box_get_type ());

    enode_set_kv (node, "top-widget", widget);
    enode_set_kv (node, "bottom-widget", widget);

    rendgtk_show_cond (node, widget);

    /* Make it so you can drop other apps into boxes */
    rendgtk_dnd_dragtag_target_create (node, widget);

    enode_attribs_sync (node);
}


static void
rendgtk_wrapalign_box_pack (ENode * parent_node, ENode * child_node)
{
    gint vfill = BOX_PACK_FILL_DEFAULT;
    gint hfill = BOX_PACK_FILL_DEFAULT;
    EBuf *fillv;
    EBuf *fillh;
    gint vexpand = BOX_PACK_EXPAND_DEFAULT;
    gint hexpand = BOX_PACK_EXPAND_DEFAULT;
    EBuf *expandv;
    EBuf *expandh;
    GtkWidget *child;
    GtkWidget *parent;

    child = enode_get_kv (child_node, "top-widget");
    parent = enode_get_kv (parent_node, "bottom-widget");

    if (!child || !parent)
	return;

    expandh = enode_attrib (child_node, "hexpand", NULL);
    if (ebuf_not_empty (expandh))
	hexpand = erend_value_is_true (expandh);

    expandv = enode_attrib (child_node, "vexpand", NULL);
    if (ebuf_not_empty (expandv))
	vexpand = erend_value_is_true (expandv);

    fillh = enode_attrib (child_node, "hfill", NULL);
    if (ebuf_not_empty (fillh))
	hfill = erend_value_is_true (fillh);

    fillv = enode_attrib (child_node, "vfill", NULL);
    if (ebuf_not_empty (fillh))
	vfill = erend_value_is_true (fillv);

    gtk_wrap_box_pack (GTK_WRAP_BOX (parent), child,
		       hexpand, hfill, vexpand, vfill);
}

void
rendgtk_wrapalign_boxpack_child_attr_set (ENode * parent_node,
					  ENode * child_node,
					  EBuf * attr, EBuf * value)
{
    gint vfill = BOX_PACK_FILL_DEFAULT;
    gint hfill = BOX_PACK_FILL_DEFAULT;
    EBuf *fillv;
    EBuf *fillh;
    gint vexpand = BOX_PACK_EXPAND_DEFAULT;
    gint hexpand = BOX_PACK_EXPAND_DEFAULT;
    EBuf *expandv;
    EBuf *expandh;
    GtkWidget *box;
    GtkWidget *child_widget;

    box = enode_get_kv (parent_node, "bottom-widget");
    child_widget = enode_get_kv (child_node, "top-widget");

    if (!box || !child_widget)
	return;

    expandh = enode_attrib (child_node, "hexpand", NULL);
    if (ebuf_not_empty (expandh))
	hexpand = erend_value_is_true (expandh);

    expandv = enode_attrib (child_node, "vexpand", NULL);
    if (ebuf_not_empty (expandv))
	vexpand = erend_value_is_true (expandv);

    fillh = enode_attrib (child_node, "hfill", NULL);
    if (ebuf_not_empty (fillh))
	hfill = erend_value_is_true (fillh);

    fillv = enode_attrib (child_node, "vfill", NULL);
    if (ebuf_not_empty (fillv))
	vfill = erend_value_is_true (fillv);

    gtk_wrap_box_set_child_packing (GTK_WRAP_BOX (box),
				    child_widget,
				    hexpand, hfill, vexpand, vfill);
}

gint rendgtk_wrapalign_hspacing_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *widget = enode_get_kv (node, "top-widget");

    if (widget)
	gtk_wrap_box_set_hspacing (GTK_WRAP_BOX (widget),
				   erend_get_integer (value));

    return (TRUE);
}

gint rendgtk_wrapalign_vspacing_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *widget = enode_get_kv (node, "top-widget");

    if (widget)
	gtk_wrap_box_set_vspacing (GTK_WRAP_BOX (widget),
				   erend_get_integer (value));

    return (TRUE);
}

gint rendgtk_wrapalign_homogeneous_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *widget = enode_get_kv (node, "top-widget");

    if (widget)
	gtk_wrap_box_set_homogeneous (GTK_WRAP_BOX (widget),
				      erend_value_is_true (value));

    return (TRUE);
}


void
wrapalign_renderer_register (void)
{
    Element *velement;
    Element *helement;
    ElementAttr *e_attr;

    /* vwrapailgn */
    velement = g_malloc0 (sizeof (Element));
    velement->render_func = rendgtk_vwrapbox_render;
    velement->destroy_func = rendgtk_element_destroy;
    velement->parent_func = rendgtk_wrapalign_box_pack;
    velement->tag = "vwrapalign";
    velement->description =
	"Creates a new vertical alignment, that allows for children to wrap if they are constrained for space";
    element_register (velement);

    /* hwrapalign */
    helement = g_malloc0 (sizeof (Element));
    helement->render_func = rendgtk_hwrapbox_render;
    helement->destroy_func = rendgtk_element_destroy;
    helement->parent_func = rendgtk_wrapalign_box_pack;
    helement->tag = "hwrapalign";
    helement->description =
	"Creates a new horizontal alignment, that allows for children to wrap if they are constrained for space";
    element_register (helement);

    rendgtk_widget_attr_register (helement, GTK_TYPE_WRAP_BOX);
    rendgtk_widget_attr_register (velement, GTK_TYPE_WRAP_BOX);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "vexpand";
    e_attr->description =
	"Toggle whether the widgets area should 'expand' vertically if given space to do so.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_child_attr_func = rendgtk_wrapalign_boxpack_child_attr_set;
    element_register_child_attrib (helement, e_attr);
    element_register_child_attrib (velement, e_attr);


    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "hexpand";
    e_attr->description =
	"Toggle whether the widgets area should 'expand' horizontally if given space to do so.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_child_attr_func = rendgtk_wrapalign_boxpack_child_attr_set;
    element_register_child_attrib (helement, e_attr);
    element_register_child_attrib (velement, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "hfill";
    e_attr->description =
	"Toggle whether the widget itself should 'fill' horizontally any extra space given to it";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_child_attr_func = rendgtk_wrapalign_boxpack_child_attr_set;
    element_register_child_attrib (velement, e_attr);
    element_register_child_attrib (helement, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "vfill";
    e_attr->description =
	"Toggle whether the widget itself should 'fill' vertically any extra space given to it";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_child_attr_func = rendgtk_wrapalign_boxpack_child_attr_set;
    element_register_child_attrib (velement, e_attr);
    element_register_child_attrib (helement, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "homogeneous";
    e_attr->description =
	"Toggle whether child widgets should all be the same size";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_attr_func = rendgtk_wrapalign_homogeneous_set;
    element_register_attrib (helement, e_attr);
    element_register_attrib (velement, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "hspacing";
    e_attr->description = "Set horizontal spacing between child nodes.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "0,*";
    e_attr->set_attr_func = rendgtk_wrapalign_hspacing_set;
    element_register_attrib (velement, e_attr);
    element_register_attrib (helement, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "vspacing";
    e_attr->description = "Set horizontal spacing between child nodes.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "0,*";
    e_attr->set_attr_func = rendgtk_wrapalign_vspacing_set;
    element_register_attrib (velement, e_attr);
    element_register_attrib (helement, e_attr);
}
