"**************************************************************************
"enCore 3.3.2 to 3.3.3 Patch. 
"Copyright (C) 2003 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************

;;#0.("contributors") = {"Credits: Jan Rune Holmevik, Cynthia Haynes, Sindre Soerensen, Ken Schweller, Mark Blanchard, Jorge Barrios, Amy Bruckman, Matthew Campbell, John Towell, Gustavo Glusman, Craig Leikis, Juli Burk, Michael Thompson, Rui Miguel Barbosa Pinto, Andrew Wilson, Ken Fox, Matthew Beermann, Jason Nolan, Noel Davis, Stephen Ashley, Herve Collin, Emma Jane Hogbin, Claudijo Borovic, Alexandre Borgia, and Scott Carmichael."}

@program $httpd:get
"===========================================================";
"Copyright (C) 1998-2003, Jan Rune Holmevik, sindre.sorensen@rasmus.uib.no and Scott Carmichael";
"This verb handles and directs all http requests";
"===========================================================";
if (caller != this)
  return E_PERM;
endif
try
  "==========================";
  "== Initialize variables ==";
  "==========================";
  {method, uri, httpver} = args;
  body = result = html = head = page_props = footer = {};
  data = message = cookie = content_type = content_type_incoming = boundary = "";
  authentication_ok = 0;
  status = "200_OK";
  conn = player;
  if (method in {"GET", "POST"})
    "=================================================================";
    "== Find and return the object and verb that the user requested ==";
    "=================================================================";
    if (valid_uri = $encore_web_utils:parse_url(uri))
      object = valid_uri[1];
      program = valid_uri[2];
      client_headers = this:collect_user_agent_headers(conn);
      if ("GET" == method)
        "Make sure form data is preserved in POST requests";
        data = valid_uri[3];
        form_fields = $encore_web_utils:parse_form(data);
      elseif ("POST" == method)
        {data, content_type_incoming, boundary} = this:collect_user_agent_POST(conn, client_headers);
        form_fields = $encore_web_utils:parse_form(data, content_type_incoming, boundary);
      endif
      "========================================";
      "== Perform HTTP-cookie authentication ==";
      "========================================";
      {authentication_ok, user, login, cookie, message} = this:authenticate(uri, client_headers, form_fields, object, program, method);
      if (authentication_ok)
        "==============================================================";
        "Generate HTML code for the requested object or web application";
        "Verify that form data originated from this server. SDC";
        "==============================================================";
        referer = "Referer" in client_headers;
        referer = referer != 0 ? client_headers[referer + 1] | "";
        if (!match(referer, tostr("^http://", $network.site)) && form_fields[2] != {});
          body = "403_Forbidden";
        elseif (login)
          body = $xpress_login:login(user, message);
        else
          body = object:(program)(user, form_fields);
        endif
        "==============================================================";
        "Perform misc error checks";
        "==============================================================";
        "Check to see if the verb returns anything but a list of strings:";
        if (!$list_utils:flat_list_of_STR(body) && typeof(body) != STR)
          status = "500_Internal_Server_Error";
          body = {"The verb did not return a flat list of strings:<P><PRE>", toliteral(body), "</PRE>"};
        endif
        "Check to see if a type 400 error code has been returned";
        if (body in {"400_Bad_Request", "403_Forbidden"})
          status = body;
        else
          !body ? body = {"HTTP-EQUIV=\"content-type\""} | 0;
          if (match(body[1], "HTTP-EQUIV=\"content-type\""))
            "A plain text is to be returned.";
            content_type_source = body[1];
            html = listdelete(body, 1);
          else
            if ($encore_web_utils:page_assembled(body))
              "=========================================================";
              "The page has already been assembled either by";
              "a web application or by the owner of the owner";
              "=========================================================";
              html = body;
            else
              "=========================================================";
              "Assemble the elements of the web page";
              "=========================================================";
              head = $encore_web_utils:make_head(user, object);
              body = $encore_web_utils:make_body(user, object, body);
              html = $encore_web_utils:make_page(user, object, $list_utils:append(head, body));
            endif
            content_type_source = html[3];
          endif
          "Determine correct content type for outgoing page";
          content_type = this:determine_content_type(content_type_source);
        endif
        this.total_pages_served = this.total_pages_served + 1;
      else
        "==============================================================";
        "Authentication failed. Determine where to direct user";
        "==============================================================";
        "Authentication failed for logged in user return login page";
        if (login)
          html = $xpress_login:login(user, message);
        else
          "First point of access. Return usert to main frameset.";
          html = $Xpress_login:login_page(user);
        endif
      endif
    else
      "Object not found";
      status = "404_Not_Found";
    endif
  else
    "HTTP Method not Implemented";
    status = "501_Not_Implemented";
  endif
  "===========================================================";
  "== Add server response header and send data back to user ==";
  "===========================================================";
  result = $httpd:generate_server_response_header(status, cookie, html, content_type, argstr);
  if (this.watchers)
    this:log(tostr(status, " Sent ", length(result), " lines."), 9);
    if ({{}, {}} != form_fields)
      this:log("User agent posted data: " + toliteral(form_fields), 7);
    endif
  endif
except error (ANY)
  body = {"<PRE>", @this:generate_traceback(error), "</PRE>"};
  status = "500_Internal_Server_Error";
  result = $httpd:generate_server_response_header(status, "", body, "", argstr);
endtry
for line in (result)
  while (!notify(conn, line, 1) && conn in connected_players(1))
    suspend(0);
  endwhile
endfor
if (buffered_output_length(conn))
  "========================================";
  "== Make sure the user gets everything ==";
  "========================================";
  while (buffered_output_length(conn))
    suspend(0);
  endwhile
endif
return;
.

@program $player:notify
if (caller != this && !$perm_utils:controls(caller_perms(), this))
  return E_PERM;
endif
line = args[1];
"---------------------------------------------------------------------";
"Scan for URL and strip data. SDC";
"Security update to prevent malicious users from sending code to the MOO via MOOtcan";
"---------------------------------------------------------------------";
if (this.ts_client)
  if ((start = match(line, tostr("<http://", $network.site))) != {})
    if (start[2] != -1)
      if ((end = match(line[start[2] + 1..$], ">%.")) != {})
        if (end[2] != -1)
          url = line[start[2] + 1..end[1] + start[2] - 1];
          if ((urldata = match(url, "%?")) != {})
            if (urldata[2] != -1)
              "Encoded data found on Xpress URL";
              line = tostr(line[1..start[1] - 1], line[end[2] + start[2] + 1..$]);
            endif
          endif
        endif
      endif
    endif
  endif
endif
if (!$object_utils:connected(this))
  clear_property(this, "memory");
  return;
elseif (!is_clear_property(this, "memory"))
  if (idle_seconds(this) > 120)
    task = $code_utils:queued_tasks_matching(E_NONE, E_NONE, "say emote", E_NONE, 
this)[1][1];
    task && kill_task(task);
    totell = this.memory;
    clear_property(this, "memory");
    this:tell_lines(totell);
    this:tell();
    this:tell("You took more than 2 minutes to type your statement/command, please try again.");
    this:tell("Type: 'help output' for further information on output control.");
  else
    this.memory = {@this.memory, line};
    return;
  endif
elseif (this.pagelen)
  "...need wizard perms if this and this.owner are different, since...";
  "...only this can notify() and only this.owner can read .linebuffer...";
  if (player == this && this.linetask[2] != task_id())
    "...player has started a new task...";
    "....linetask[2] is the taskid of the most recent player task...";
    if (this.linetask[2] != this.linetask[1])
      this.linesleft = this.pagelen - 2;
    endif
    this.linetask[2] = task_id();
  endif
  "... digest the current line...";
  if (this.linelen > 0)
    lbuf = {@this.linebuffer, @this:linesplit(line, this.linelen)};
  else
    lbuf = {@this.linebuffer, line};
  endif
  "... print out what we can...";
  if (this.linesleft)
    howmany = min(this.linesleft, length(lbuf));
    for l in (lbuf[1..howmany])
      notify(this, l);
    endfor
    this.linesleft = this.linesleft - howmany;
    lbuf[1..howmany] = {};
  endif
  if (lbuf)
    "...see if we need to say ***More***";
    if (this.linetask[1] != this.linetask[2])
      "....linetask[1] is the taskid of the most recent player task";
      "...   for which ***More*** was printed...";
      this.linetask[1] = this.linetask[2];
      fork (0)
        notify(this, strsub(this.more_msg, "%n", tostr(length(this.linebuffer))));
      endfork
    endif
    llen = length(lbuf);
    if (llen > 500)
      "...way too much saved text, flush some of it...";
      lbuf[1..llen - 100] = {"*** buffer overflow, lines flushed ***"};
    endif
  endif
  this.linebuffer = lbuf;
elseif (this.linelen > 0)
  for l in (this:linesplit(line, this.linelen))
    notify(this, l);
  endfor
else
  notify(this, line);
endif
.

;#0.("core_history") = {{"enCore enCore 3.3.3", "1.8.1", 1043507175}, {"enCore 3.3.2", "1.8.1", 1041824617}, {"enCore 3.3.1", "1.8.1", 1040185243}, {"enCore 3.3", "1.8.1", 1040053857}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}

@set #0.core_version to "enCore 3.3.3"