"**************************************************************************
"enCore 3.2 to 3.3 Patch. 
"Copyright (C) 2002 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************

;;#0.("license") = {"License: enCore and enCore Xpress is Copyright (C) 1997-2003 of the enCore Open Source MOO Project. All rights reserved. The core of this program is Copyright (C) 1991-1997 of LambdaMOO. The enCore layer is Copyright (C) 1997-2003 of its respective authors. The Xpress client and GUI is is Copyright (C) 1998-2003 of Jan Rune Holmevik and Cynthia Haynes. The MOOtcan telnet applet is Copyright 1998-2003 of Sindre Srensen and Jan Rune Holmevik. The Virtual Assignment Server Environment is Copyright (C) 2000-2003 of Jason Nolan and the University of Toronto. This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License See http://lingua.utdallas.edu/encore/gpl.html for details. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY."}

;;#0.("contributors") = {"Credits: Jan Rune Holmevik, Cynthia Haynes, Sindre Srensen, Ken Schweller, Mark Blanchard, Jorge Barrios, Amy Bruckman, Matthew Campbell, John Towell, Gustavo Glusman, Craig Leikis, Juli Burk, Michael Thompson, Rui Miguel Barbosa Pinto, Andrew Wilson, Ken Fox, Matthew Beermann, Jason Nolan, Noel Davis, Stephen Ashley, Herv Collin, Emma Jane Hogbin, Claudijo Borovic and Alexandre Borgia."}

@property #0.copyright "Copyright &copy; 1997-2003 enCore Open Source Project, All Rights Reserved"

;"Security Patch 11/12/2002";
;"USAGE: copy & paste entire document into the MOO using a wizard character.";
;"";
;"This patch fixes an issue where a player could execute arbitrary lines of code with Wizardly privileges while saving properties using the EnCore Web Interface.";
;"Please report any irregularities while sending/changing/saving values from the Web Interface after applying this patch to 'aborgia@videotron.ca'";
;"";

;"Adding 2 new verbs, '$code_utils:tofloat' and '$string_utils:index_count'.  Backup copies will be made in case these verbs already exist, otherwise 'verb not found' errors are normal.";
@rename $code_utils:tofloat to tofloat_bak
@verb $code_utils:tofloat this none this rdx
@program $code_utils:tofloat
"tofloat(STR) => returns either a float or E_TYPE if STR is not a float.";
return match(s = args[1], "^ *[-+]?%([0-9]+%.?[0-9]*%|%.[0-9]+%)%(e[-+]?[0-9]+%)? *$") ? tofloat(s) | E_TYPE;
.

@rename $string_utils:index_count to index_count_bak
@verb $string_utils:index_count this none this rdx
@program $string_utils:index_count
":index_count(STR, str) => simply returns the number of times 'str' is found within 'STR'.  This is similar to length($string_utils:index_all(...));";
{text, char} = args;
count = 0;
index = 1;
inc = length(char) - 1;
while (goto = index(text[index..$], char))
  index = (index + goto) + inc;
  count = count + 1;
endwhile
return count;
.

;"There should be no errors from this point.";
;"Backing up '$xpress_program_editor:coerce' to '$xpress_program_editor:coerce_bak'";
@rename $xpress_program_editor:coerce to coerce_bak
;"Rewritting 'coerce' ...";
@verb $xpress_program_editor:coerce this none this rdx
@program $xpress_program_editor:coerce
"===========================================================";
"Original idea from Amy Bruckman (verb on $macmoose_utils)";
"";
"Rewritten (2002) by Alexandre Borgia so it no longer";
"relies on programmer permissions and can be executed";
"safely from within an arbitrary environment";
"===========================================================";
"";
":coerce(value) => 'value' will typically be a string-type value, else it will be returned intact.  This verb tries to typecast the string representation of a value into any other MOO-type value, including: OBJ, INT, FLOAT, ERR, LIST and any combination of these through LISTs.  Would it fail to do so, the original string will be returned.";
"";
"In other words, this is an inverse 'toliteral()' function which returns a value equal to 'eval(<value>);' as long as 'value' is a static expression (ie: the expression is not evaluated.)";
"";
"";
if ((typeof(value = args[1]) == STR) && value)
  if ((test = $code_utils:toobj(value)) != E_TYPE)
    return test;
  elseif ((test = $code_utils:toint(value)) != E_TYPE)
    return test;
  elseif ((test = $code_utils:tofloat(value)) != E_TYPE)
    return test;
  elseif (i = (test = $string_utils:trim(value)) in $code_utils.error_names)
    return $code_utils.error_list[i];
  elseif (test && (test[1] == "{") && (test[$] == "}"))
    if (!(test = test[2..$ - 1]))
      return {};
    endif
    test_list = {};
    chunk = "";
    index = 0;
    chunks = {};
    while (m = match(test, "[^,],[^,]"))
      chunks = {@chunks, test[1..m[1]]};
      test = test[m[1] + 2..$];
    endwhile
    if (!test)
      return value;
    endif
    chunks = {@chunks, test};
    for i in (chunks)
      index = (index + $string_utils:index_count(i, "{")) - $string_utils:index_count(i, "}");
      if (index < 0)
        return value;
      endif
      chunk = (chunk + (chunk ? "," | "")) + i;
      if (!index)
        if (typeof(chunk = this:coerce(chunk)) == STR)
          chunk = $string_utils:trim(chunk);
          if (!match(chunk, "^ *\".*\" *$"))
            return value;
          else
            chunk = chunk[2..$ - 1];
          endif
        endif
        test_list = {@test_list, chunk};
        chunk = "";
      endif
      $command_utils:suspend_if_needed(0);
    endfor
    return index ? value | test_list;
  endif
endif
return value;
.

"The following code represents misc fixes that I have collected over the past year. Some of these has been distributed on the enCore list. Unless you have made modifications to the verbs below you can safely reapply them to your MOO. Jan 12/11/02";

@program $encore_web_class:make_contextual_menu
"===========================================================";
"Copyright (C) 1999-2001, Jan Rune Holmevik";
"Verb that generates a contextual menu for an object.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, ?object = this, ?call_spec = "", ?return_functions = 1} = args;
contextual_menu = buttons = functions = {};
if (user != $no_one && $object_utils:isa(object, $encore_web_object) && user.show_contextual_menu || caller == $inventory_manager)
  base_url = tostr("http://", $network.site, ":", $network.webport, "/");
  image_url = $xpress_client.external_baseurl + $xpress_client.icons_folder;
  "----------------------------------------------------------------";
  "Insert browser back button. Rooms and inventory manager excluded.";
  "----------------------------------------------------------------";
  if (!$object_utils:isa(this, $room) && caller != $inventory_manager)
     buttons = {@buttons, tostr("<A HREF=\"back\" onClick=\"javascript:history.go(-1); return false;\">", $encore_web_utils:get_icon(user, $xpress_client, "back.gif", "Go Back/View Previous"), "</A>")};
  endif
  "----------------------------------------------------------------";
  "Insert contextual help and info button. Exits and basic rooms excluded";
  "----------------------------------------------------------------";
  if ($object_utils:isa(object, $thing) || $object_utils:isoneof(object, {$classroom, $moderated_room}))
    buttons = {@buttons, tostr("<A HREF=\"", base_url, toint(object), "/examine_html\" onClick=\"ContextSensitiveHelp()\" TARGET=\"", $help_browser:get_frame_name("ContextSensitiveHelp"), "\">", $encore_web_utils:get_icon(user, $help_browser, "help.gif", "About this object"), "</A>")};
    if (return_functions)
      functions = $list_utils:append(functions, $encore_web_utils:javascript_window_open($help_browser, "ContextSensitiveHelp", "", $help_browser.context_help_width, $help_browser.context_help_height));
    endif
  endif
  "----------------------------------------------------------------";
  "Insert contextual take/drop button is applicable";
  "Does not currently work in Netscape 4.X";
  "----------------------------------------------------------------";
  if ($encore_web_utils:can_handle(user, object))
    buttons = {@buttons, tostr("<A HREF=\"", base_url, toint(this), object in user.contents ? "/drop_html" | "/take_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", object in user.contents ? $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "drop.gif"), "Drop this object") | $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "take.gif"), "Take this object"), "</A>")};
  endif
  "----------------------------------------------------------------";
  "Insert download via email option for note objects";
  "----------------------------------------------------------------";
  if ($network.active && $network.maildrop != "" && $object_utils:isa(object, $note) && !$object_utils:isa(user, $guest))
    buttons = {@buttons, tostr("<A HREF=\"", base_url, toint(object), "/email_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "email.gif"), "Email contents to me"), "</A>")};
  endif
  "----------------------------------------------------------------";
  "Insert contextual Xpress Edit button if user has permission to edit it";
  "----------------------------------------------------------------";
  if ($encore_web_utils:permission_to_edit(user, object))
    buttons = {@buttons, tostr("<A HREF=\"", base_url, "Xpress_Object_Editor/view.html?", toint(object), "/\" TARGET=\"", $Xpress_Object_Editor:get_frame_name("openXpressEdit"), "\" onClick=\"openXpressEdit();\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "xpress_edit.gif"), "Edit this object"), "</A>")};
    "Add a window function for opening Xpress Edit";
    if (return_functions)
      functions = $list_utils:append(functions, $encore_web_utils:javascript_window_open($xpress_object_editor, "openXpressEdit", ""));
    endif
  endif
  if (user == object.owner)
    "----------------------------------------------------------------";
    "Insert lock/unlock icon, Exits excluded.";
    "----------------------------------------------------------------";
    if (!$object_utils:isa(object, $exit))
      buttons = {@buttons, tostr("<A HREF=\"", base_url, toint(this), "/", object.key == 0 ? "lock_html" | "unlock_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, object.key == 0 ? "unlocked.gif" | "locked.gif"), tostr(object.key == 0 ? "Lock" | "Unlock", " this object")), "</A>")};
    endif
  endif
  if (user == object.owner && caller == $inventory_manager && !$object_utils:isa(object, $player) && !$object_utils:isa(object, $exit))
    "----------------------------------------------------------------";
    "Insert Recycle icon for inventory manager. Exits and player objects excluded.";
    "----------------------------------------------------------------";
    buttons = {@buttons, tostr("<A HREF=\"", base_url, "Xpress_Object_Editor/recycle_object?", toint(object), call_spec == "" ? "" | tostr("&", call_spec), "\" onClick=\"return confirmDelete();\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "recycle.gif"), "Recycle this object"), "</A>")};
  endif
  if (buttons != {})
    functions = $encore_web_utils:insert_javascript(functions);
  endif
endif
if (return_functions)
  return {functions, buttons};
else
  return buttons;
endif
.

@program $xpress_object_editor:menu_html
"===========================================================";
"Copyright (C) 1999-2001, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
menu = buttons = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_Object_Editor/");
{help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Object_Editor");
help_window_function = $encore_web_utils:insert_javascript(help_window_function);
buttons = {tostr("Object: <INPUT TYPE=text NAME=\"search_string\" VALUE=\"\" SIZE=15><INPUT TYPE=submit NAME=Submit VALUE=\"View\"><INPUT TYPE=\"button\" VALUE=\"My Objects\" onClick=\"parent.list.location.href = '", base_url, "list_objects_html", "'\"><INPUT TYPE=\"button\" VALUE=\"Create New Object\" onClick=\"parent.list.location.href = '", base_url, "classes_html", "'\">")};
title = $encore_web_utils:get_title(user, this, "Xpress Object Editor");
menu = $list_utils:append(title, help_button, buttons);
menu = $encore_web_utils:append_close_button(menu);
menu = $encore_web_utils:form(menu, "search", "/Xpress_Object_Editor/view_html", "", "view");
body = $list_utils:append(help_window_function, menu);
result = this:build(user, body, "Xpress Object Editor", "document.search.search_string.focus();", "properties");
return result;
.

@program $prog:_web_menu
"===========================================================";
"Copyright (C) 1999-2001, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{menu, functions, preload, base_url} = pass(@args);
if (this.programmer);
external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + this.xpress_theme + "/";
program = {tostr("<A HREF=\"", base_url, "Xpress_Program_Editor/main.html\" TARGET=\"", $Xpress_Program_Editor:get_frame_name("openProgramEditor"), "\" onClick=\"openProgramEditor(); swapImage('program','", external_baseurl, "program1.jpg')\" onMouseOver=\"swapImage('program','", external_baseurl, "program2.jpg')\" onMouseOut=\"swapImage('program','", external_baseurl, "program1.jpg')\"><IMG SRC=\"", external_baseurl, "program1.jpg\" BORDER=0 ALIGN=bottom name=program ALT=\"Edit Verbs and Properties\" TITLE=\"Edit Verbs and Properties\"></A>")};
preload = {@preload, tostr("   program2 = new Image(); program2.src = \"", external_baseurl, "program2.jpg\";")};
Window = $encore_web_utils:javascript_window_open($Xpress_Program_Editor, "openProgramEditor", "");
menu = $list_utils:append(menu, program);
functions = $list_utils:append(functions, Window);
endif;
return {menu, functions, preload, base_url};
.

@program $encore_web_utils:can_handle
"===========================================================";
"Copyright (C) 2001, Jan Rune Holmevik";
"Verb that checks if a user can take or drop an object via Xpress. If true, 1 is returned, otherwise, 0 is returned. Currently, users can only handle $things that they own, or are shared owners of";
"===========================================================";
{user, object} = args;
if (!caller_perms().wizard)
  return E_PERM;
endif
result = 0;
"Added a check here to prevent breaking in case of datatype errors. Jan 12/17/01";
try
  if (user == object.owner || user in object.shared_owners || user.wizard && $object_utils:isa(object, $thing))
    result = 1;
  endif
except error (ANY)
endtry
return result;
.

@program $xpress_object_editor:Edit_Web_Slides
"===========================================================";
"Copyright (C) 2001, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = {};
form = {@form, "<B>Web Projector Slides:</B>"};
form = {@form, "<P>Target: "};
if (object.display_in_xpress)
  form = {@form, tostr("<INPUT TYPE=\"radio\" value=\"1\" name=\"display_in_xpress\" CHECKED> Xpress Client <INPUT TYPE=\"radio\" value=\"0\" name=\"display_in_xpress\"> New Browser Window <P>")};
else
  form = {@form, tostr("<INPUT TYPE=\"radio\" value=\"1\" name=\"display_in_xpress\"> Xpress Client <INPUT TYPE=\"radio\" value=\"0\" name=\"display_in_xpress\" CHECKED> New Browser Window")};
endif
form = {@form, "<P>Type the URLs for the web pages you wish to display in the text area below. Type only one URL per. line. If you choose Xpress client as target, please make sure your pages does not contain javascript code that will take over the whole client window and disconnect users.<P>"};
if (typeof(object.slides) == STR)
  form = {@form, tostr("Slides: <P><TEXTAREA NAME=slides ROWS=5 COLS=50 WRAP=virtual>", object.slides, "</TEXTAREA><P>")};
else
  form = {@form, tostr("Slides: <P><TEXTAREA NAME=slides ROWS=5 COLS=50 WRAP=virtual>")};
  for line in (object.slides)
    form = {@form, line};
  endfor
  form = {@form, "</TEXTAREA><P>"};
endif
return form;
.

@program $slide_projector:show
"Modifications by Rv";
if (!(this in player.location.contents) && this.location != player)
  player:tell("I see no ", this.name, " here...");
  return;
endif
sn = tonum(dobjstr);
if (sn > 10)
  player:tell("sorry, ", this.name, " holds a max of 10 slides.");
  return;
endif
s = this.("s" + dobjstr);
if (typeof(s) == STR)
  s = {s};
endif
size = length(s);
for thing in (player.location.contents)
  thing:tell("");
  thing:tell(player.name, " shows slide #", sn, ".");
  thing:tell("");
  thing:tell("                      * * * * * * * * * * * * * * * * * * * *");
  thing:tell("");
  for n in [1..size]
    $command_utils:suspend_if_needed(0);
    thing:tell(s[n]);
  endfor
  thing:tell("");
  thing:tell("                      * * * * * * * * * * * * * * * * * * * *");
  thing:tell("");
  $command_utils:suspend_if_needed(0);
endfor
.

@program $slide_projector:rev
if (!(this in player.location.contents) && this.location != player)
  player:tell("I see no ", this.name, " here...");
  return;
endif
sn = tonum(dobjstr);
if (sn > 10)
  player:tell("sorry, ", this.name, " holds a max of 10 slides.");
  return;
endif
player:tell("");
player:tell("You review slide #", sn, ".");
player:tell("");
player:tell("                      * * * * * * * * * * * * * * * * * * * *");
s = this.("s" + dobjstr);
if (typeof(s) == STR)
  s = {s};
endif
size = length(s);
if (size > 22)
  size = 22;
endif
remainder = 15 - size;
for n in [1..remainder / 2]
  player:tell("");
endfor
for n in [1..size]
  player:tell(s[n]);
endfor
for n in [1..remainder / 2]
  player:tell("");
endfor
player:tell("                      * * * * * * * * * * * * * * * * * * * *");
.

@program $webprojector:start
"===========================================================";
"Copyright (C) 2001, Jan Rune Holmevik";
"Routine for starting and stopping a slide show";
"Updated by Ken Schweller 9/3/02";
"===========================================================";
if (verb == "start")
  if (this.on)
    player:tell(tostr("Slide show is already running. To stop it, type Stop ", this.name));
  else
   if (length(this.slides) > 1)
      this.on = 1;
      player:tell("Slide show started.");
      player.location:announce(player.name, " starts slide show on ", this.name);
      this:slideshow();
    else
      player:tell("Sorry, there are no slides in the slide show. Go to edit and add some URLs.");
    endif
  endif
elseif (verb == "stop")
  if (!this.on)
    player:tell(tostr("Slide show is not running. To start it, type Start ", this.name));
  else
    this.on = 0;
    player:tell("Slide show stopped.");
    player.location:announce(player.name, " stops slide show on ", this.name);
  endif
elseif (verb == "reset")
  this.on = 0;
  this.index = 1;
  player:tell("You reset the slide show on ", this.name, ".");
endif
.


@program $xpress_login:login
"===========================================================";
"Copyright (C) 1999-2001, Jan Rune Holmevik";
"Generates a login page for connecting to the MOO from the web";
"IMPORTANT NOTE: You must not modify this verb in such a way that the copyright notice and the link to the license is moved or removed from the web display. If you want to add your own copyright notice, you should insert this below current copyright notices. Removing copyright notices consititutes a violation of the license under which this software is provided to you.";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, action} = args;
body = login = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/");
if (typeof(action) == LIST)
  action = "";
endif
if (match(action, "Permission Denied"))
  "Return a blank page";
  body = {};
else
  action = "document.useridForm.useridField.focus();document.useridForm.useridField.select();" + action;
  if (!children($guest))
    default_login_name = "";
  else
    default_login_name = "Guest";
  endif
  checkClient = this.checkClient;
  submit_hack = $encore_web_utils:insert_javascript(this.submit_hack);
  "---------------------------------------------------------";
  "Set up the main Xpress Client Screen based on users' preferences";
  "---------------------------------------------------------";
  screen_size = $string_utils:explode(user.Xpress_screen_size, ",");
  width = screen_size[1];
  height = screen_size[2];
  client_window = $encore_web_utils:javascript_window_open($xpress_client, "openXpress", tostr(base_url, "Xpress_client/", user.Xpress_layout, "/"), width, height);
  mootcan_standalone_url = tostr(base_url, "mootcan/standalone.html");
  mootcan_script = $encore_web_utils:javascript_window_open($mootcan, "openMOOtcan", mootcan_standalone_url);
  browse = $encore_web_utils:javascript_window_open($Xpress_login, "openBrowseMode", tostr(base_url, toint($player_start)));
  request = $encore_web_utils:javascript_window_open($Xpress_login, "openRequestForm", tostr(base_url, "Xpress_Login/character_application_html"));
  script = $list_utils:append(client_window, mootcan_script, browse, request);
  script = $encore_web_utils:insert_JavaScript(script);
  login = {@login, tostr("<H3>enCore Xpress ", $core_version, "</H3><P>", $copyright, "</P><P>This program is Free Software and comes WITHOUT ANY WARRANTY! Please see <A HREF=\"", $core_homepage, "gpl.html\" TARGET=_BLANK>license</A> for further details.</P>")};
  useridForm = {tostr("<FORM NAME=\"useridForm\" onSubmit='return submit1()'><TABLE BORDER=0><TR><TD><P ALIGN=right>User ID</TD><TD><INPUT CLASS=\"login\" TYPE=text NAME=\"useridField\" VALUE=\"", default_login_name, "\" SIZE=10></TD></TR></FORM>")};
  passwordForm = {tostr("<FORM NAME=\"passwordForm\" ACTION=\"", base_url, "\" METHOD=POST ENCTYPE=multipart/form-data onSubmit='return (submit2() && checkClient())'><TR><TD><P><P ALIGN=right>Password</TD><TD><INPUT  NAME=\"useridField\" TYPE=\"HIDDEN\"><INPUT CLASS=\"login\" TYPE=password NAME=\"passwordField\" VALUE=\"\" SIZE=10></TD></TR></TABLE><P><INPUT TYPE=hidden NAME=OS VALUE=\"\"><INPUT TYPE=submit NAME=xpress VALUE=\"Log in\"></FORM><P>")};
  login = $list_utils:append(login, useridForm, passwordForm);
  login = {@login, tostr("<P>[<A HREF=\"", $core_homepage, "xpress_system_requirements.html\" TARGET =\"_BLANK\">System Requirements</A>]</P><HR>")};
  scripted_open_mootcan = {"document.write('<FORM><INPUT TYPE=button NAME=mootcan VALUE=\"Open MOOtcan\" onClick=\"return openMOOtcan()\"></FORM>')"};
  noscript_open_mootcan = {tostr("<FORM ACTION=\"", mootcan_standalone_url, "\" TARGET=\"java_frame\"><INPUT TYPE=submit NAME=mootcan VALUE=\"Open MOOtcan\"></FORM>")};
  login = $list_utils:append(login, $encore_web_utils:insert_javascript(scripted_open_mootcan, noscript_open_mootcan));
  if ($xpress_client.http_09_enabled)
    login = {@login, "<P><FORM> <INPUT TYPE=button NAME=browse VALUE=\"Browse the MOO\" onClick=\"return openBrowseMode()\"></FORM></P>"};
  endif
  if ($login.create_enabled)
    login = {@login, "<P><FORM> <INPUT TYPE=button NAME=request VALUE=\"Create Account\" onClick=\"return openRequestForm()\"></FORM></P>"};
  endif
  login = $list_utils:append(login, {"</TD></TD><TD VALIGN=top WIDTH=\"80%\">"});
  end_html = {"</TD></TR>"};
  body = $list_utils:append(submit_hack, checkClient, script, login, end_html);
  body = $encore_web_utils:center(body);
endif
result = this:build(user, body, "Login", action);
return result;
.

@set #0.core_version to "3.3"

;;#0.("core_history") = {{"enCore 3.3", "1.8.1", 1039640446}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}

;"Done. Your MOO has been updated to enCore version 3.3!";

