/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.parser.Ajax;

public class JembossFileAuthServer {
    private String ps = new String(System.getProperty("path.separator"));
    JembossParams jp = new JembossParams();
    String embossBin = this.jp.getEmbossBin();
    String embossPath = this.jp.getEmbossPath();
    private String environ = "PATH=" + this.embossBin + this.ps + this.embossPath;

    public Vector embreo_roots(String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> vans = new Vector<String>();
        if (!this.verifyUser(aj, userName, passwd, vans)) {
            return vans;
        }
        String userHomeDir = aj.home + "/";
        vans.add("status");
        vans.add("0");
        vans.add("msg");
        vans.add("");
        vans.add("default-root");
        vans.add("HOME");
        vans.add("HOME");
        vans.add(userHomeDir);
        vans.add("EMBOSS results");
        vans.add("/tmp/SOAP/emboss/" + userName);
        return vans;
    }

    private String getRoot(String s, String userName, byte[] passwd) {
        String rt = null;
        Vector userRoots = this.embreo_roots(userName, passwd);
        for (int i = 0; i < userRoots.size(); i += 2) {
            String root = (String)userRoots.get(i);
            if (!root.equalsIgnoreCase(s)) continue;
            return (String)userRoots.get(i + 1);
        }
        return rt;
    }

    public Vector directory_shortls(String options, String dirname, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> vans = new Vector<String>();
        if (!this.verifyUser(aj, userName, passwd, vans)) {
            return vans;
        }
        int split = options.indexOf("=") + 1;
        aj.listFiles(userName, passwd, this.environ, this.getRoot(options.substring(split), userName, passwd) + "/" + dirname);
        String listAll = aj.getOutStd();
        aj.listDirs(userName, passwd, this.environ, this.getRoot(options.substring(split), userName, passwd) + "/" + dirname);
        String listDir = aj.getOutStd();
        listAll = listAll.concat("\n" + listDir);
        vans.add("status");
        vans.add("0");
        vans.add("msg");
        vans.add("");
        vans.add("list");
        vans.add(listAll);
        vans.add("dirlist");
        vans.add(listDir);
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector get_file(String options, String filename, String userName, byte[] passwd) {
        Vector<Object> vans = new Vector<Object>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String fullFileName = this.getRoot(options.substring(split), userName, passwd) + "/" + filename;
        byte[] fbuf = aj.getFile(userName, passwd, this.environ, fullFileName);
        if (aj.getFileok() == 1) {
            vans.add("contents");
            if (aj.getPrnt() == 1) {
                vans.add(new String(fbuf));
            } else {
                vans.add(fbuf);
            }
        } else {
            System.out.println("Cannot getFile " + fullFileName);
        }
        vans.add("status");
        vans.add("0");
        vans.add("msg");
        vans.add("");
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector mkdir(String options, String dirname, String userName, byte[] passwd) {
        Vector<String> vans = new Vector<String>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String fullDirname = this.getRoot(options.substring(split), userName, passwd) + "/" + dirname;
        boolean ok = true;
        try {
            ok = aj.makeDir(userName, passwd, this.environ, fullDirname);
        }
        catch (Exception exp) {
            // empty catch block
        }
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector delFile(String options, String filename, String userName, byte[] passwd) {
        Vector<String> vans = new Vector<String>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String fullname = this.getRoot(options.substring(split), userName, passwd) + "/" + filename;
        boolean ok = true;
        try {
            ok = aj.delFile(userName, passwd, this.environ, fullname);
        }
        catch (Exception exp) {
            // empty catch block
        }
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector delDir(String options, String filename, String userName, byte[] passwd) {
        Vector<String> vans = new Vector<String>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String fullname = this.getRoot(options.substring(split), userName, passwd) + "/" + filename;
        boolean ok = true;
        try {
            ok = aj.delDir(userName, passwd, this.environ, fullname);
        }
        catch (Exception exp) {
            // empty catch block
        }
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector rename(String options, String oldfile, String newfile, String userName, byte[] passwd) {
        Vector<String> vans = new Vector<String>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String oldname = this.getRoot(options.substring(split), userName, passwd) + "/" + oldfile;
        boolean ok = true;
        try {
            ok = aj.renameFile(userName, passwd, this.environ, oldname, newfile);
        }
        catch (Exception exp) {
            // empty catch block
        }
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    public Vector put_file(String options, String filename, byte[] filedata, String userName, byte[] passwd) {
        Vector<String> vans = new Vector<String>();
        Ajax aj = new Ajax();
        int split = options.indexOf("=") + 1;
        String fullFilename = this.getRoot(options.substring(split), userName, passwd) + "/" + filename;
        aj.putFile(userName, passwd, this.environ, fullFilename, filedata);
        vans.add("msg");
        vans.add("");
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    private boolean verifyUser(Ajax aj, String userName, byte[] passwd, Vector res) {
        if (userName == null || passwd == null) {
            res.add("msg");
            res.add("Failed Authorisation ");
            res.add("status");
            res.add("1");
            return false;
        }
        boolean ok = false;
        try {
            ok = aj.userAuth(userName, passwd, this.environ);
        }
        catch (Exception exp) {
            ok = false;
        }
        if (!ok) {
            System.out.println("Failed Authorisation " + userName);
            System.out.println("STDERR " + aj.getErrStd());
            res.add("msg");
            res.add("Failed Authorisation " + userName);
            res.add("status");
            res.add("1");
            return false;
        }
        return true;
    }
}

