/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

   help window
   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include "select.h"
#include "help.h"
#include "cmd.h"
#include "gettext.h"
#include "keymap.h"
#include "exec.h"
#include "misc.h"
#include "xmalloc.h"
#include "eprintf.h"
#include "ask.h"
#include "interface.h"
#include "color.h"
#include "label.h"
#include "clock.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/

static char *help_fmt = "%012k %030f %d";

static select_t *help_select = NULL;
static elabel_t *label       = NULL;

static chtype text_color;

static rstring_t *help_msg = NULL;

/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/

static rstring_t *
make_introduction (void)
{
        int        width, nothing;
        int        i;
        char      *str = NULL;
        rstring_t *cut;
        rstring_t *result;

        switch (cmd_state_get (0)){

                case CMD_INVALID:
                        str = xstrdup (_("This is a bug.  Please submit a report."));
                        break;

                case CMD_LIST:
                        str = xstrdup (
                                _("In this view, you can see messages "
                                  "from the currently opened box.  You can "
                                  "move the bar, select messages, move them "
                                  "to other boxes, and open a selected "
                                  "message. "
                                  "\n\n"
                                  "You can customize this view by setting "
                                  "the variables line_format and sent_format "
                                  "which control how messages are displayed. "
                                  "\n\n"));
                        break;

                case CMD_READ_MAIL:
                        str = xstrdup (
                                _("In this view, you can see the body of the "
                                  "message.  You can switch to the plain "
                                  "header, open attachments window."
                                  "\n\n"));
                        break;

                case CMD_SELECT_BOX:
                        str = xstrdup (
                                _("In this view, you can see list of boxes "
                                  "available in your mailbox.  Each box is "
                                  "followed by unread / total number of "
                                  "messages in it. "
                                  "\n\n"
                                  "You can customize this view by setting "
                                  "the variable win_boxes:box_fmt. "
                                  "\n\n"));
                        break;

                case CMD_FETCH:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_SENDER:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_ATTACH:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_ABOOK:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_ABOOK_ADD:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_ASK:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_READ:
                        str = xstrdup (_("\n"));
                        break;
    
                case CMD_HELP:
                        str = xstrdup (_("This is a bug.  Please submit a report."));
                        break;

                case CMD_DEBUG:
                        str = xstrdup (_("\n"));
                        break;

                case CMD_SEARCH:
                        str = xstrdup (_("\n"));
                        break;
        }

        getmaxyx (help_select->win, nothing, width);
        
        cut = rstring_split_lines (str, width);

        if (cut == NULL)
                return NULL;
  
        result = rstring_create_size (cut->count + 1);
  
        for (i = 0; i < cut->count; i++){
                rstring_add (result, xstrdup (cut->array[i]));
        }

        xfree (str);
        rstring_delete (cut);
        return result;
}


static rstring_t *
make_keys (void)
{
        int         i;
        char       *key_str;
        struct key *key;
        keymap_t   *keymap = keymaps + cmd_state_get (0);
        rstring_t  *result = rstring_create ();

        rstring_add (result, xstrdup (_("Current key combinations are:")));
  
        for (i = 0; i < keymap->k_count; i++){
                key     = keymap->keys + i;
                key_str = eprintf_key (help_fmt, key, 0);
                rstring_add (result, key_str);
        }

        for (i = 0; i < keymap->m_count; i++){
                key     = keymap->meta + i;
                key_str = eprintf_key (help_fmt, key, 1);
                rstring_add (result, key_str);
        }
  
        return result;
}


static rstring_t *
make_items (void)
{
        rstring_t *result = rstring_join (make_introduction (), make_keys ());
  
        result->allocated_all = 1;
        return result;
}



static void
draw_line (WINDOW *window, int maxlen, int index, search_t *search)
{
        if (help_msg && index < help_msg->count){
                maxlen -= window_addnstr (window, help_msg->array[index],
                                          maxlen);
        }

        while (maxlen-- > 0)
                window_addch (window, ' ');
}



static int
count (select_t *nothing)
{
        if (help_msg == NULL)
                return 0;

        return help_msg->count;
}



/* This file is generated by interface.pl script from interface.desc,
   and inc.in. */
static WINDOW *interface_init (void);
#include "help.inc"

/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/


void
help_init (void)
{
        WINDOW *window = interface_init ();

        help_select = select_open (window, 1, draw_line, count);

        window_set_functions (window, help_refresh, help_redraw,
                              help_set_focus, help_unset_focus);
}



void
help_free_resources (void)
{
        if (help_select)
                select_close (help_select);
        help_select = NULL;

        if (label)
                label_destroy (label);
        label = NULL;

        if (help_msg)
                rstring_delete (help_msg);
        help_msg = NULL;
}



void
help_refresh (void)
{
        select_show (help_select);

        if (label)
                label_show (label);
}



void
help_redraw (void)
{
        select_redraw (help_select);

        if (label)
                label_redraw (label);
}



void
help_set_focus (void)
{
        if (label){
                label_set_focus (label);
        }

        cmd_state_push (CMD_HELP);

        help_redraw ();
}



void
help_unset_focus (void)
{
        if (label){
                label_unset_focus (label);
                label_redraw (label);
        }

        cmd_state_pop ();
}



void
help_open (void)
{
        if (help_msg)
                rstring_delete (help_msg);
        
        help_msg = make_items ();

        window_show (help_select->win);
}




void
help_close (void)
{
        if (help_msg)
                rstring_delete (help_msg);
        help_msg = NULL;

        window_hide (help_select->win);
}



void
help_scroll_down (void)
{
        select_next (help_select);
}



void
help_scroll_up (void)
{
        select_prev (help_select);
}



void
help_prev_page (void)
{
        select_prev_page (help_select);
}



void
help_next_page (void)
{
        select_next_page (help_select);
}



void
help_beg (void)
{
        select_first (help_select);
}



void
help_end (void)
{
        select_last (help_select);
}


/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE help.c
 *
 ****************************************************************************/
