<?xml version="1.0"?>

<!--
 This file is part of EdiTeX, an editor of mathematical
 expressions based on TeX syntax.
 
 Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 For more information, please visit the project's home page
 http://helm.cs.unibo.it/editex/
 or send an email to <lpadovan@cs.unibo.it>
-->

<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
     xmlns:tml="http://helm.cs.unibo.it/2002/TML"
     xmlns:m="http://www.w3.org/1998/Math/MathML"
     exclude-result-prefixes="tml"
     version="1.0">

  <xsl:output indent="yes"/>

  <xsl:param name="id" select="/.."/>

  <xsl:template match="/">
   <wrapper>
    <xsl:choose>
      <xsl:when test="$id">
        <xsl:apply-templates select="descendant::*[@id=$id]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
   </wrapper>
  </xsl:template>

  <xsl:template match="tml:tex[not(tml:math)]">
    <!-- This is an empty TeX document. We generate the corresponding  -->
    <!-- empty MathML document.                                        -->
  </xsl:template>

  <xsl:template match="tml:math">
    <m:mstyle mathvariant="normal">
     <xsl:if test="@id">
       <xsl:attribute name="xref">
         <xsl:value-of select="@id"/>
       </xsl:attribute>
     </xsl:if>
      <xsl:if test="@display='1'">
       <xsl:attribute name="display">block</xsl:attribute>
     </xsl:if>
     <xsl:attribute name="display">block</xsl:attribute>
     <xsl:apply-templates select="*"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:i">
    <m:mi>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="@val"/>
    </m:mi>
  </xsl:template>

  <xsl:template match="tml:n">
    <m:mn>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="@val"/>
    </m:mn>
  </xsl:template>

  <xsl:template match="tml:o">
    <m:mo>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:s">
<!-- this template is used only for testing purpose and should not be here-->
    <m:mspace width="veryverythickmathspace">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
    </m:mspace>
  </xsl:template>

<!--
  <xsl:template name="cursor">
    <xsl:choose>
      <xsl:when test="contains(@val, '\')">
        <m:mrow>
	  <xsl:if test="@id">
	    <xsl:attribute name="xref">
	      <xsl:value-of select="@id"/>
	    </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="substring-before(@val, '\')">
            <m:mtext><xsl:value-of select="substring-before(@val, '\')"/></m:mtext>
	  </xsl:if>
          <m:mo stretchy="false">&#x2329;</m:mo>
          <m:mtext mathcolor="blue"><xsl:value-of select="concat('\', substring-after(@val, '\'))"/></m:mtext>
          <m:mo stretchy="false">&#x232a;</m:mo>
	</m:mrow>
      </xsl:when>
      <xsl:when test="string-length(@val)>=1">
        <m:mrow>
	  <xsl:if test="@id">
	    <xsl:attribute name="xref">
	      <xsl:value-of select="@id"/>
	    </xsl:attribute>
	  </xsl:if>
	  <xsl:choose>
	    <xsl:when test="contains('0123456789', substring(@val, 1, 1))">
              <m:mn>
	        <xsl:value-of select="@val"/>
	      </m:mn>
	    </xsl:when>
	    <xsl:otherwise>
	      <m:mi>
	        <xsl:value-of select="@val"/>
	      </m:mi>
	    </xsl:otherwise>
	  </xsl:choose>
	  <m:mtext mathcolor="blue">I</m:mtext>
	</m:mrow>
      </xsl:when>
      <xsl:otherwise>
        <m:mtext mathcolor="blue">
         <xsl:if test="@id">
           <xsl:attribute name="xref">
             <xsl:value-of select="@id"/>
           </xsl:attribute>
         </xsl:if>I</m:mtext>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  -->

  <xsl:template match="tml:o[@val='-']">
    <m:mo>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      &#x2212;
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:cursor">
    <xsl:choose>
      <xsl:when test="substring(@val,1,1)='\'">
        <m:mrow>
          <xsl:if test="@id">
            <xsl:attribute name="xref">
              <xsl:value-of select="@id"/>
            </xsl:attribute>
          </xsl:if>
          <m:mo stretchy="false">&#x2329;</m:mo>
          <m:mtext mathcolor="blue"><xsl:value-of select="@val"/></m:mtext>
          <m:mo stretchy="false">&#x232a;</m:mo>
        </m:mrow>
      </xsl:when>
      <xsl:when test="string-length(@val)>=1">
        <m:mrow>
	  <xsl:if test="@id">
	    <xsl:attribute name="xref">
	      <xsl:value-of select="@id"/>
	    </xsl:attribute>
	  </xsl:if>
	  <xsl:choose>
	    <xsl:when test="contains('0123456789', substring(@val, 1, 1))">
              <m:mn>
	        <xsl:value-of select="@val"/>
	      </m:mn>
	    </xsl:when>
	    <xsl:otherwise>
	      <m:mi>
	        <xsl:value-of select="@val"/>
	      </m:mi>
	    </xsl:otherwise>
	  </xsl:choose>
	  <xsl:if test="@visible='1'">
	   <m:mtext mathcolor="blue">I</m:mtext>
	  </xsl:if>
	</m:mrow>
      </xsl:when>
      <xsl:otherwise>
	<xsl:if test="@visible='1'">
         <m:mtext mathcolor="blue">
          <xsl:if test="@id">
            <xsl:attribute name="xref">
              <xsl:value-of select="@id"/>
            </xsl:attribute>
          </xsl:if>
	  <xsl:text>I</xsl:text>
	 </m:mtext>
	</xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:sb[@under='1'][*[1]/tml:sp[@over='1']]">
    <m:munderover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]/*[1]"/>
      <xsl:apply-templates select="*[2]"/>
      <xsl:apply-templates select="*[1]/*[2]"/>
    </m:munderover>
  </xsl:template>

  <xsl:template match="tml:sb[@under='1']">
    <m:munder>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:munder>
  </xsl:template>

  <xsl:template match="tml:sb[*[1][self::tml:sp[not(@over) or @over='0']]]">
    <m:msubsup>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]/*[1]"/>
      <xsl:apply-templates select="*[2]"/>
      <xsl:apply-templates select="*[1]/*[2]"/>
    </m:msubsup>
  </xsl:template>

  <xsl:template match="tml:sb">
    <m:msub>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:msub>
  </xsl:template>

  <xsl:template match="tml:sp[@over='1'][*[1]/tml:sb[@under='1']]">
    <m:munderover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]/*[1]"/>
      <xsl:apply-templates select="*[1]/*[2]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:munderover>
  </xsl:template>

  <xsl:template match="tml:sp[@over='1']">
    <m:mover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:sp[*[1][self::tml:sb[not(@over) or @over='0']]]">
    <m:msubsup>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]/*[1]"/>
      <xsl:apply-templates select="*[1]/*[2]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:msubsup>
  </xsl:template>

  <xsl:template match="tml:sp">
    <m:msup>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:msup>
  </xsl:template>

  <xsl:template match="tml:g">
    <xsl:choose>
      <xsl:when test="not(@id) and count(*) = 1">
        <xsl:apply-templates select="*[1]"/>
      </xsl:when>
      <xsl:when test="tml:cursor">
    	<m:mstyle mathbackground="#e0e0e0">
          <xsl:if test="@id">
            <xsl:attribute name="xref">
              <xsl:value-of select="@id"/>
            </xsl:attribute>
	  </xsl:if>
	  <m:mrow>
    	    <xsl:apply-templates select="*"/>
	  </m:mrow>
    	</m:mstyle>
      </xsl:when>
       <xsl:otherwise>
    	<m:mrow>
	  <xsl:if test="@id">
            <xsl:attribute name="xref">
              <xsl:value-of select="@id"/>
            </xsl:attribute>
	  </xsl:if>
    	  <xsl:apply-templates select="*"/>
    	</m:mrow>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:row">
    <m:mtr>
      <xsl:apply-templates select="cell"/>
    </m:mtr>
  </xsl:template>

  <xsl:template match="tml:cell">
    <m:mtd>
      <xsl:apply-templates select="*"/>
    </m:mtd>
  </xsl:template>

<!--/// CONTROL SEQUENCES ///-->

  <xsl:template match="tml:c">
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mtext mathcolor="blue">\<xsl:value-of select="@name"/></m:mtext>
      <xsl:apply-templates select="*"/>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='fun' and count(*)=3]">
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo mathcolor="red">&#x03bb;</m:mo>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>:</m:mo>
      <xsl:apply-templates select="*[2]"/>
      <m:mo>.</m:mo>
      <xsl:apply-templates select="*[3]"/>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='not'][*[1][self::tml:o]]">
<!-- not -->
    <m:mo>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>&#x0338;</m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='buildrel']">
<!-- buildrel -->
    <m:mover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[2]"/>
      <xsl:apply-templates select="*[1]"/>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='left' or @name='right'][*[1][self::tml:o]]">
<!-- left -->
    <m:mo stretchy="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='bigl' or @name='bigr' or @name='bigm' or @name='big'][*[1][self::tml:o]]">
<!-- bigl -->
    <m:mo stretchy="true" minsize="8.5pt">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='Bigl' or @name='Bigr' or @name='Bigm'][*[1][self::tml:o]]">
<!-- Bigl -->
    <m:mo stretchy="true" minsize="11.5pt">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='biggl' or @name='biggr' or @name='biggm'][*[1][self::tml:o]]">
<!-- biggl -->
    <m:mo stretchy="true" minsize="14.5pt">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='Biggl' or @name='Biggr' or @name='Biggm'][*[1][self::tml:o]]">
<!-- biggl -->
    <m:mo stretchy="true" minsize="17.5pt">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="*[1]/@val"/>
    </m:mo>
  </xsl:template>

  <xsl:template match="tml:c[@name='hat']">
<!-- hat -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0302;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='widehat']">
<!-- widehat -->
    <m:mover accent="false">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">&#x0302;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='check']">
<!-- check -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x030c;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='tilde']">
<!-- tilde -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0303;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='widetilde']">
<!-- widetilde -->
    <m:mover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">&#x0303;</m:mo>
    </m:mover>>
  </xsl:template>

  <xsl:template match="tml:c[@name='acute']">
<!-- acute -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0301;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='grave']">
<!-- grave -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0300;</m:mo>
    </m:mover>>
  </xsl:template>

  <xsl:template match="tml:c[@name='dot']">
<!-- dot -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0307;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='ddot']">
<!-- ddot -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0308;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='breve']">
<!-- breve -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0306;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='bar']">
<!-- bar -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x0304;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='vec']">
<!-- vec -->
    <m:mover accent="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo>&#x20d7;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='overline']">
<!-- overline -->
    <m:mover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">&#x0305;</m:mo>
    </m:mover>
  </xsl:template>

  <xsl:template match="tml:c[@name='underline']">
<!-- underline -->
    <m:munder>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">&#x0332;</m:mo>
    </m:munder>
  </xsl:template>

  <xsl:template match="tml:c[@name='sqrt']">
<!-- sqrt -->
    <m:msqrt>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*"/>
    </m:msqrt>
  </xsl:template>

  <xsl:template match="tml:c[@name='root']">
<!-- root -->
    <m:mroot>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="count(*) &lt; 2">
	  <m:mrow/>
	  <xsl:apply-templates select="*[1]"/>
	</xsl:when>
	<xsl:otherwise>
          <xsl:apply-templates select="*[2]"/>
          <xsl:apply-templates select="*[1]"/>
	</xsl:otherwise>
      </xsl:choose>
    </m:mroot>
  </xsl:template>

  <xsl:template match="tml:c[@name='frac']">
<!-- frac -->
    <m:mfrac>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mfrac>
  </xsl:template>

  <xsl:template match="tml:c[@name='over']">
<!-- over -->
    <m:mfrac>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mfrac>
  </xsl:template>

  <xsl:template match="tml:c[@name='atop']">
<!-- atop -->
    <m:mfrac linethickness="0">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mfrac>
  </xsl:template>

  <xsl:template match="tml:c[@name='choose']">
<!-- choose -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo stretchy="true">(</m:mo>
      <m:mfrac linethickness="0">
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </m:mfrac>
      <m:mo stretchy="true">)</m:mo>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='brace']">
<!-- brace -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo stretchy="true">{</m:mo>
      <m:mfrac linethickness="0">
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </m:mfrac>
      <m:mo stretchy="true">}</m:mo>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='brack']">
<!-- brack -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo stretchy="true">[</m:mo>
      <m:mfrac linethickness="0">
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </m:mfrac>
      <m:mo stretchy="true">]</m:mo>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='displaystyle']">
<!-- displaystyle -->
    <m:mstyle displaystyle="true">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='textstyle']">
<!-- textstyle -->
    <m:mstyle scriptlevel="0">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:if test="tml:g/tml:cursor[@visible='1']">
        <m:msub>
          <m:mtext mathcolor="#808080">}</m:mtext>
    	  <m:mtext><xsl:value-of select="@name"/></m:mtext>
        </m:msub>
      </xsl:if>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='scriptstyle']">
<!-- scriptstyle -->
    <m:mstyle scriptlevel="1">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='scriptscriptstyle']">
<!-- scriptscriptstyle -->
    <m:mstyle scriptlevel="2">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='pmod']">
<!-- pmod -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo>(</m:mo>
      <m:mrow>
        <m:mo>mod</m:mo>
        <xsl:apply-templates select="*[1]"/>
      </m:mrow>
      <m:mo>)</m:mo>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='rm']">
<!-- rm -->
    <m:mstyle mathvariant="normal">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='bf']">
<!-- bf -->
    <m:mstyle mathvariant="bold">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='tt']">
<!-- tt -->
    <m:mstyle mathvariant="monospace">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='sl']">
<!-- sl -->
    <m:mstyle mathvariant="italic">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='it']">
<!-- it -->
    <m:mstyle mathvariant="italic">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='_']">
<!-- _ -->
    <m:mi>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:text>_</xsl:text>
    </m:mi>
  </xsl:template>

  <xsl:template match="tml:c[@name=',']">
<!-- , -->
    <m:mspace width="thinmathspace">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
    </m:mspace>
  </xsl:template>

  <xsl:template match="tml:c[@name='&gt;']">
<!-- > -->
    <m:mspace width="mediummathspace">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
    </m:mspace>
  </xsl:template>

  <xsl:template match="tml:c[@name=';']">
<!-- ; -->
    <m:mspace width="thickmathspace">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
    </m:mspace>
  </xsl:template>

  <xsl:template match="tml:c[@name='!']">
<!-- ! -->
    <m:mspace width="-0.166667em">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
    </m:mspace>
  </xsl:template>

  <xsl:template name="table-content">
      <xsl:choose>
        <xsl:when test="tml:row">
          <xsl:apply-templates select="tml:row"/>
        </xsl:when>
        <xsl:otherwise>
          <m:mtr>
            <m:mtd>
              <xsl:apply-templates select="*"/>
            </m:mtd>
          </m:mtr>
        </xsl:otherwise>
      </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:c[@name='matrix']">
<!-- matrix -->
    <m:mtable>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:call-template name="table-content"/>
    </m:mtable>
  </xsl:template>

  <xsl:template match="tml:row">
    <m:mtr>
      <xsl:apply-templates select="tml:cell"/>
    </m:mtr>
  </xsl:template>

  <xsl:template match="tml:cell">
    <m:mtd>
      <xsl:apply-templates select="*"/>
    </m:mtd>
  </xsl:template>

  <xsl:template match="tml:c[@name='pmatrix']">
<!-- pmatrix -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo stretchy="true">(</m:mo>
      <m:mtable>
        <xsl:call-template name="table-content"/>
      </m:mtable>
      <m:mo stretchy="true">)</m:mo>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='bordermatrix']">
<!-- bordermatrix -->
    <m:mtable>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mtr>
        <xsl:apply-templates select="tml:row[1]/tml:cell[1]"/>
        <m:mtd/>
        <xsl:apply-templates select="tml:row[1]/tml:cell[position() &gt; 1]"/>
	<m:mtd/>
      </m:mtr>
      <xsl:for-each select="tml:row[position() &gt; 1]">
        <m:mtr>
          <xsl:apply-templates select="tml:cell[1]"/>
          <xsl:if test="position() = 1">
            <m:mtd rowspan="{count(../tml:row) - 1}">
              <m:mo stretchy="true">(</m:mo>
            </m:mtd>
          </xsl:if>
          <xsl:apply-templates select="tml:cell[position() &gt; 1]"/>
          <xsl:if test="position() = 1">
            <m:mtd rowspan="{count(../tml:row) - 1}">
              <m:mo stretchy="true">)</m:mo>
            </m:mtd>
          </xsl:if>         
        </m:mtr>
      </xsl:for-each>      
    </m:mtable>
  </xsl:template>

  <xsl:template match="tml:c[@name='overbrace']">
<!-- overbrace -->
    <m:mover>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">????</m:mo>
    </m:mover>>
  </xsl:template>

  <xsl:template match="tml:c[@name='underbrace']">
<!-- underbrace -->
    <m:munder>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <m:mo stretchy="true">????</m:mo>
    </m:munder>
  </xsl:template>

  <xsl:template match="tml:c[@name='cases']">
<!-- cases -->
    <m:mrow>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <m:mo stretchy="true">{</m:mo>
      <m:mtable>
        <xsl:call-template name="table-content"/>
      </m:mtable>
    </m:mrow>
  </xsl:template>

  <xsl:template match="tml:c[@name='red']">
<!-- red  -->
    <m:mstyle mathcolor="red">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
	  <xsl:value-of select="@id"/>
	</xsl:attribute>
	<xsl:apply-templates/>
      </xsl:if>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='green']">
<!-- green  -->
    <m:mstyle mathcolor="green">
      <xsl:if test="@id">
        <xsl:attribute name="xref">
	  <xsl:value-of select="@id"/>
	</xsl:attribute>
	<xsl:apply-templates/>
      </xsl:if>
    </m:mstyle>
  </xsl:template>

  <xsl:template match="tml:c[@name='duedelim']">
<!-- duedelim  -->
    <m:mfrac>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mfrac>
  </xsl:template>

  <xsl:template match="tml:c[@name='nodeside']">
<!-- nodeside  -->
    <m:mfrac>
      <xsl:if test="@id">
        <xsl:attribute name="xref">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*[1]"/>
      <xsl:apply-templates select="*[2]"/>
    </m:mfrac>
  </xsl:template>

</xsl:stylesheet>
