<?xml version="1.0"?>

<!--
 This file is part of EdiTeX, an editor of mathematical
 expressions based on TeX syntax.
 
 Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 For more information, please visit the project's home page
 http://helm.cs.unibo.it/editex/
 or send an email to <lpadovan@cs.unibo.it>
-->

<xsl2:stylesheet
  version="1.0"
  xmlns:xsl2="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsl="http://www.w3.org/1999/XSL/TransformAlias"
  xmlns:tml="http://helm.cs.unibo.it/2002/TML">

<xsl:namespace-alias stylesheet-prefix="xsl" result-prefix="xsl2"/>

<xsl2:template match="/">
  <xsl:stylesheet version="1.0">
    <xsl:template match="tml:tex">
      <xsl:apply-templates select="*"/>
    </xsl:template>

    <xsl:template match="tml:i">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:value-of select="@val"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:n">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:value-of select="@val"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:o">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:value-of select="@val"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:cursor">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:value-of select="@val"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:sb[@under='1']">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:sb">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:sb[@over='1']">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:sp">
      <xsl:element name="xxx">
        <xsl:if test="@id">
          <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="*[1]"/>
        <xsl:apply-templates select="*[2]"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:g[@id]">
      <xsl:element name="xxx">
        <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:g">
      <xsl:element name="xxx">
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:template>

    <xsl:template match="tml:row">
      <xsl:apply-templates select="cell"/>
    </xsl:template>

    <xsl:template match="tml:cell">
      <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl2:comment>/// CONTROL SEQUENCES ///</xsl2:comment>

    <xsl2:apply-templates/>
  </xsl:stylesheet>
</xsl2:template>

<xsl2:template match="entry[not(@class) or @class='m']">
  <xsl:template match="tml:c[@name='{@name}']">
    <xsl2:comment><xsl2:value-of select="concat(' ',@name,' ')"/></xsl2:comment>
    <xsl:element name="xxx">
      <xsl:if test="@id">
        <xsl:attribute name="xref"><xsl:value-of select="@id"/></xsl:attribute>
      </xsl:if>
      <xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
</xsl2:template>

</xsl2:stylesheet>

