#ifndef _ECS_CHAMP_ATT_H_
#define _ECS_CHAMP_ATT_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associées à la structure `ecs_champ_t' décrivant un champ
 *   et propres aux champs auxiliaires de type "attribut"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/

/*============================================================================
 *                                 Visibilité
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille.h"
#include "ecs_descr.h"
#include "ecs_param_perio_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui assemble un champ donné dans un champ récepteur donné
 *
 *  Si les champs à assembler ont le même nom, le nom donné au champ récepteur
 *   sera ce même nom, et on passera en argument NULL au nom à donner
 *  Sinon, on donnera en argument le nouveau nom du champ récepteur
 *
 *  L'assemblage consiste à :
 *  - regrouper sous la même position les valeurs des 2 champs
 *    (cela suppose donc que les 2 champs ont le même nombre de positions)
 *  - assembler les membres des descripteurs des 2 champs
 *    Les descripteurs des 2 champs peuvent être à `NULL'
 *    et si le descripteur du champ récepteur est à `NULL',
 *          le descripteur du champ assemblé est celui du champ à assembler
 *
 *  Le champ à assembler est détruit apres assemblage
 *----------------------------------------------------------------------------*/

void ecs_champ_att__assemble
(
       ecs_champ_t    *const champ_recept,
       ecs_champ_t    *      champ_assemb,
 const char           *      nom
) ;


/*----------------------------------------------------------------------------
 *  Fonction réalisant l'héritage des valeurs d'un attribut d'un élément
 *   sur les sous-éléments issus de sa décomposition
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__herite
(
 ecs_champ_t      *const champ_att_elt,
 ecs_champ_t      *const champ_elt_def_sselt,
 size_t                  nbr_sselt
) ;


/*----------------------------------------------------------------------------
 *  Fonction réalisant la transformation d'un champ
 *   en fusionnant les propriétés de ses éléments
 *   qui sont identiquement transformes par le vecteur de transformation donné
 *----------------------------------------------------------------------------*/

void ecs_champ_att__fusionne
(
       ecs_champ_t    *const this_champ_att,
       size_t                nbr_elt_new,
 const ecs_tab_int_t         vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numéros de famille des éléments
 *
 *  Pour les éléments de famille 0 ou n'ayant pas de famille, on leur
 *   attribue le numéro de famille par défaut
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ_att__fam_elt
(
 ecs_champ_t    *const this_champ_fam,
 ecs_tab_int_t  *const tab_nbr_elt_fam
) ;


/*----------------------------------------------------------------------------
 * Fonction qui construit la liste des éléments  portant des numéros de
 *  familles marqués dans le tableau indic_famille
 *----------------------------------------------------------------------------*/

ecs_tab_int_t  ecs_champ_att__liste_elt_fam
(
       ecs_champ_t     *const champ_famille,
 const ecs_tab_int_t   *const liste_filtre,
 const ecs_tab_bool_t  *const indic_famille
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau donnant pour chaque valeur du champ
 *   le nombre d'éléments ayant cette valeur
 *----------------------------------------------------------------------------*/

ecs_int_t * ecs_champ_att__ret_nbr_elt_val
(
 ecs_champ_t  *const champ_att,
 size_t              nbr_val_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit un nouveau champ attribut à partir
 *   d'un champ donné qui contient la définition d'éléments
 *                                 en fonction de nouveaux éléments
 *  L'attribut crée donne la référence de l'élément d'origine
 *   auquel est associe le nouvel élément
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__filialise
(
 ecs_champ_t  *const champ_def,
 size_t              nbr_sselt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui remplit un tableau de booléens
 *   Le booléen correspondant à un élément du champ est à `true'
 *    si l'élément est sélectionné par la description donnée :
 *    - le numéro du descripteur
 *    - le nom    du descripteur
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_champ_att__cree_masque
(
       ecs_tab_bool_t  *const bool_elt_select,
 const ecs_tab_int_t   *const liste_filtre,
       ecs_champ_t     *const champ_select,
       int                    descr_ide,
 const char            *const descr_nom
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit les familles à partir
 *   de la liste chaînée de tous les champs de type "attribut"
 *   pour toutes des entités
 *
 *  Elle renvoie les champs "famille" par entité
 *
 *  Elle détermine aussi :
 *   - la tête de la liste chaînée des familles
 *   - le nombre de familles
 *   - les nombres d'éléments par famille et par entité
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ_att__construit_fam
(
 ecs_champ_t        *      champ_att_tete,
 ecs_famille_t    * *const vect_fam_tete,
 size_t                    nbr_elt_ent,
 int                       num_fam_deb,
 int                *const nbr_fam,
 ecs_int_t        * *const cpt_elt_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui crée les champs "couleur" et "groupe" à partir
 *   du champ "famille" et de la liste chaînée des familles
 *----------------------------------------------------------------------------*/

void ecs_champ_att__cree_att_fam
(
 ecs_champ_t      *const champ_famille,
 ecs_famille_t    *const famille,
 ecs_champ_t    * *const champ_couleur,
 ecs_champ_t    * *const champ_groupe
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met à jour la renumérotation
 *  "éléments initiaux -> éléments périodiques" en fonction d'un champ
 *  "éléments précédents -> nouveaux éléments" en cas de modifications
 *  successives de la définition des éléments.
 *  Valable pour les champs attributs de statut ECS_CHAMP_STATUT_REF_ELT
 *  On modifie à la fois 'val_tab' et on décale 'pos_tab'.
 *
 *  L'algorithme de renumérotation numéro 1 est utilisé dans l'algorithme
 *  de recollement et le numéro 2 dans celui de découpage des faces gauches.
 *----------------------------------------------------------------------------*/

void ecs_champ_att__renum_perio
(
 ecs_champ_t  *const champ_elt_perio,
 ecs_champ_t  *const champ_elt_old_new,
 size_t              nbr_elt_new
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met à jour le tableau renvoyé par
 * ecs_champ_def__typ_fac_cel() en fonction d'une connectivités ajoutée par
 * une périodicité.
 *----------------------------------------------------------------------------*/

void ecs_champ_att__typ_fac_perio
(
 ecs_champ_t    * champ_fac_perio,
 ecs_tab_int_t  * typ_fac
) ;


#endif /* _ECS_CHAMP_ATT_H_ */
