/* 
    interface.cc for tuxzap

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "interface.hh"
#include "ost/audio.h"

static void CreateToolbar (GtkWidget *vbox_main);
ChannelList chlist[NLIST];
GtkWidget *clists[NLIST];
GtkWidget *wclists[NLIST];
static int listn[NLIST];
static int last_on_list[NLIST];

int clistn = 0;
int dev = 0;

GtkWidget *t_widget;
extern GtkWidget *statusbar;
GtkAccelGroup *accel_group;
GtkWidget *channel_list();
GtkTooltips *tooltips;
DVB dvb;
int no_crypt;
static GtkWidget *win_main;
extern gint contextid;
GtkWidget *channel_list(char *name, int n);
void load_ch(gpointer data);
extern gint LISTX;
extern gint LISTY;
extern int ipaq;
extern int master;
extern	char filen[80];

int last_channel=0;

#define TABLEX 10
#define TABLEY 4
	

GtkWidget *buttons[TABLEX*TABLEY];

static void set_channel(gChannel & ch);

void save_dvb(GtkWidget * w, gpointer data)
{
	ofstream dvbout;

        dvbout.open(filen);
        if (dvbout) {
                status_message(_("Saving .dvbrc\n"));
                dvbout << dvb;
        }
        
}

void audioSetMixer(int vol)
{
	int ans;
	audioMixer_t am;
	int audio_fd;
        char path[256];
	ostrstream str(path,256);
	
	str << "/dev/ost/audio" << dev ;
	str << ends;

	am.volume_left = vol;
	am.volume_right = vol;

	if ((audio_fd = open(path, O_RDWR)) < 0){
		cerr << "DVB card has no audio device using master volume"
		     << endl;
		master = 1;
		return;
	}

	if ( (ans = ioctl(audio_fd,AUDIO_SET_MIXER, &am) < 0)){
		perror("AUDIO SET MIXER: ");
		return;
	}
	close (audio_fd);
}

void volume_change(GtkAdjustment *adjustment, gpointer user_data)
{
//	cout << "Volume: " << adjustment->value << endl;
	if (master) set_master_vol(int(adjustment->value));
	else audioSetMixer(int(adjustment->value));
}

int find_dvb(gChannel &ch)
{
	
        uint16_t onid  =  uint16_t((ch.DVB_Num() & 
				    0xFFFF000000000000ULL) >> 48);
	uint16_t satid =  uint16_t((ch.DVB_Num() & 
				    0x0000FFFF00000000ULL) >> 32);
        uint16_t tpid  =  uint16_t((ch.DVB_Num() & 
				    0x00000000FFFF0000ULL) >> 16);
	ushort sid     =  ushort   (ch.DVB_Num() & 0x000000000000FFFFULL);


	int chnr;
	int found=0;
	for (chnr=0; chnr< dvb.num[CHAN]; chnr++) {
		if (dvb.chans[chnr].pnr==sid   && 
		    (dvb.chans[chnr].onid==onid || onid == 0xffff) && 
		    (dvb.chans[chnr].satid==satid || satid == 0xffff)  && 
                    (dvb.chans[chnr].tpid==tpid)) {
		  found = 1;
		  break;
                }
	}

	if (found && chnr<dvb.num[CHAN]) return chnr;
	else {
		cerr << "channel not found" << endl;
		return -1;
	}
}

void quit(GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_exit(0);
}


void favorite_activate(GtkCheckMenuItem *menu, gpointer user_data)
{
	char buf[80];
	int cl = int(user_data);
	ostrstream str(buf, 80);
	
	if(menu->active){
		clistn = cl;
		
		if (!GTK_WIDGET_VISIBLE(wclists[clistn]) && !ipaq)
			gtk_widget_show(wclists[clistn]);
		str << _("Favorite ") << clistn << ends;
		status_message(buf);
		set_channel(chlist[clistn](last_on_list[clistn]));
	}
}

void fav_activate(GtkWidget *widget, gpointer user_data)
{
	char buf[80];
	int act;
	int cl = int(user_data);
	ostrstream str(buf, 80);
	
	act =   (int) (gtk_toggle_button_get_active
				   ((GtkToggleButton *) widget));

	if(act){
		clistn = cl;
		str << _("Favorite ") << clistn << ends;
		status_message(buf);
		int num = chlist[clistn].NumChan();

		if (num > TABLEX*TABLEY) num = TABLEX*TABLEY;
		for (int i = 0; i < num; i++) {
			int cnr;
			if ((cnr = find_dvb(chlist[clistn](i))) >= 0){
				gtk_widget_set_sensitive(buttons[i], TRUE);
				gtk_tooltips_set_tip (tooltips, buttons[i], 
						      dvb.chans[cnr].name, 
						      NULL);
			} else gtk_widget_set_sensitive(buttons[i], FALSE);
		
		}
		for (int i = num; i < TABLEX*TABLEY; i++) 
			gtk_widget_set_sensitive(buttons[i], FALSE);

		int c = last_on_list[clistn];
		while (find_dvb(chlist[clistn](c)) <0) c++;
		set_channel(chlist[clistn](c));
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(buttons[c]),
					     TRUE);
	}
}

void schan(GtkWidget *widget, gpointer user_data)
{
	char buf[80];
	int act;
	int c = int(user_data);
	ostrstream str(buf, 80);
	
	act =   (int) (gtk_toggle_button_get_active
				   ((GtkToggleButton *) widget));

	if(act){
		if( c < chlist[clistn].NumChan() ){
			set_channel(chlist[clistn](c));
			last_on_list[clistn] = c;
		}
	}
}

static void toggle_dvr (GtkWidget *widget, gpointer data)
{
	int act;
	act =   (int) (gtk_toggle_button_get_active
				   ((GtkToggleButton *) widget));

	if (act) dvb.enable_DVR();
	else dvb.disable_DVR();
	set_channel_dvb(widget,last_channel);
}


enum{OO,UP,DOWN};

static void switches (GtkWidget *widget, gpointer data)
{
  int in;
  int cap;
  int act;
  int remote;

  int l=(int) data;
  if (GTK_WIDGET_VISIBLE(widget)){
    switch(l){
      
    case OO:
      break;
      
    case DOWN:
	    if (ipaq){
		    last_on_list[clistn]--;
		    if (last_on_list[clistn] < 0) 
			    last_on_list[clistn] = chlist[clistn].NumChan()-1;
		    
		    int c = last_on_list[clistn];
		    set_channel(chlist[clistn](c));
		    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
						 (buttons[c]), TRUE);
	    } else {
		    listn[clistn]--;
		    if (listn[clistn] < 0)
			    listn[clistn] = chlist[clistn].NumChan() - 1;

		    gtk_clist_select_row(GTK_CLIST(clists[clistn]), 
					 listn[clistn], 0);
		    gtk_clist_moveto(GTK_CLIST(clists[clistn]), 
				     listn[clistn], 0, 0,0);
	    }
	    break;
	    
    case UP: 
	    if(ipaq){
		    last_on_list[clistn]++;
		    if (last_on_list[clistn] > chlist[clistn].NumChan()-1 ) 
			    last_on_list[clistn] = 0;

		    int c = last_on_list[clistn];
		    set_channel(chlist[clistn](c));
		    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
						 (buttons[c]), TRUE);
	    } else {
		    listn[clistn]++;
		    if (listn[clistn] > chlist[clistn].NumChan() - 1)
			    listn[clistn] = 0;
		    gtk_clist_select_row(GTK_CLIST(clists[clistn]), 
					 listn[clistn], 0);
		    gtk_clist_moveto(GTK_CLIST(clists[clistn]), 
				     listn[clistn], 0, 0,
			     0);
	    }
	    break;
    }
  }
}


void create_window (int devi)
{
	GtkWidget *vbox1;
	GtkWidget *menubar1;
	GtkWidget *file1;
	GtkWidget *file1_menu;
	GtkAccelGroup *file1_menu_accels;
	GtkWidget *quit1;
	GtkWidget *menuitem;
	GtkWidget *lists1;
	GtkWidget *lists1_menu;
	GtkAccelGroup *lists1_menu_accels;
	GtkWidget *dvb_tree1;
	GSList *favorite_group = NULL;
	GtkWidget *favorite;
	GSList *lists1_menu_group = NULL;
	GtkWidget *hbuttonbox1;
	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *button3;
	GtkWidget *widget;  
	GtkObject *adj;

	dev = devi;
	dvb.init("","",dev);
	tooltips = gtk_tooltips_new ();
	accel_group = gtk_accel_group_new ();

	no_crypt = 0;

	win_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (win_main), "win_main", win_main);
	gtk_window_set_title (GTK_WINDOW (win_main), "TuxZap");
	gtk_widget_show(win_main);
	t_widget = gtk_tree_new();

        if (accel_group == NULL) {
                accel_group = gtk_accel_group_new();
                gtk_accel_group_attach(accel_group, GTK_OBJECT(win_main));
        }


	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (win_main), vbox1);
	if (ipaq)
		gtk_widget_set_usize(vbox1, 220, 310);


	menubar1 = gtk_menu_bar_new ();
	gtk_widget_show (menubar1);
	gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);

	file1_menu = CreateBarSubMenu(menubar1, _("File"));
	quit1 = CreateMenuItem(file1_menu, _("Quit"), "^q", _("Quit"),
			       GTK_SIGNAL_FUNC(quit), (void *) "quit",
			       accel_group);
	
	menuitem = CreateMenuItem(file1_menu, _("Save DVB"), "^d",
				  _("Save dvbrc file"),
				  GTK_SIGNAL_FUNC(save_dvb), (void *)NULL,
				  accel_group);

	lists1_menu = CreateBarSubMenu(menubar1, _("Lists")); 
	widget = make_tree_dialog();
	dvb_tree1 = CreateMenuItem(lists1_menu, _("DVB Tree"), "d", _("DVB Tree"),
			       GTK_SIGNAL_FUNC(show_dvb), (void *) widget,
				   accel_group); 

	if (!ipaq){
		for (int i=0 ; i < NLIST; i++){
			char buf[80];
			ostrstream str(buf, 80);
			
			str << _("Favorite ") << i << ends;
			
			favorite = gtk_radio_menu_item_new_with_label (
				favorite_group, buf);
			favorite_group = gtk_radio_menu_item_group 
				(GTK_RADIO_MENU_ITEM (favorite));
			gtk_widget_show (favorite);
			gtk_container_add (GTK_CONTAINER (lists1_menu), 
					   favorite);
			gtk_tooltips_set_tip (tooltips, favorite, 
					      _("Favorite List"), NULL);
			gtk_widget_add_accelerator (favorite, "activate", 
						    accel_group,
						    GDK_F1+i, 0,
						    GTK_ACCEL_VISIBLE);
			gtk_signal_connect (GTK_OBJECT (favorite), "activate",
					    GTK_SIGNAL_FUNC(favorite_activate),
					    (void *)i);	
		}
	}
	CreateToolbar(vbox1);

	gtk_object_set_data (GTK_OBJECT (win_main), "tooltips", tooltips);

	CreateAudioMenu(menubar1, _("Audio"));

	if (ipaq){
		GSList *fav_group = NULL;
		widget = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (widget);
		gtk_box_pack_start (GTK_BOX (vbox1), widget, TRUE, TRUE, 0);
		
		for (int i = 0; i < NLIST; i++){
			char buf[10];
			ostrstream str1(buf, 10);
		
			str1 << "F" << i << ends;
			button1 = gtk_radio_button_new_with_label (fav_group, 
								   buf);
			fav_group = gtk_radio_button_group (
				GTK_RADIO_BUTTON (button1));
			gtk_widget_show (button1);
			gtk_box_pack_start (GTK_BOX (widget), button1, 
					    TRUE, TRUE, 0);
			gtk_tooltips_set_tip (tooltips, button1, 
					      _("Favorite List"), NULL);
			gtk_widget_add_accelerator (button1, "clicked", 
						    accel_group,
						    GDK_F1+i, 0,
						    GTK_ACCEL_VISIBLE);

			gtk_signal_connect (GTK_OBJECT (button1), "clicked",
					    GTK_SIGNAL_FUNC (fav_activate),
					    (void *)i);	
			//gtk_widget_set_usize(button1, 2, 3);
		}
	

		GSList *chan_group = NULL;
		widget = gtk_table_new (TABLEY, TABLEX, FALSE);
		gtk_widget_show (widget);
		gtk_box_pack_start (GTK_BOX (vbox1), widget, TRUE, TRUE, 0);

		for (int i=0; i < TABLEX; i++){
			for (int j = 0; j < TABLEY; j++){
				char buf[10];
				ostrstream str1(buf, 10);
				str1 << i+j*TABLEX << ends;
				
				button1 = gtk_radio_button_new_with_label (
					chan_group, buf);
				chan_group = gtk_radio_button_group (
					GTK_RADIO_BUTTON (button1));
				gtk_widget_show (button1);
				gtk_table_attach (GTK_TABLE (widget), 
						  button1, i, i+1, j, j+1,
						  (GtkAttachOptions) 
						  (GTK_EXPAND | GTK_FILL),
						  (GtkAttachOptions) 
						  (GTK_EXPAND | GTK_FILL), 
						  0, 0);
				gtk_toggle_button_set_mode(							   GTK_TOGGLE_BUTTON (button1), FALSE);
				gtk_signal_connect (GTK_OBJECT (button1), 
						    "clicked",
						    GTK_SIGNAL_FUNC (schan),
						    (void *)(i+j*TABLEX));
				buttons[i+j*TABLEX] = button1;
			}
		}
	}
// create volume slide
	int l;
	l = 200;
	audioSetMixer(l);
	if (master){
		sound_init ();
		get_master_vol(l);
	}

	adj = gtk_adjustment_new (l, 0, 255, 1, 0, 0); 

	widget = gtk_hscale_new (GTK_ADJUSTMENT (adj) );
	gtk_widget_show (widget);
	gtk_box_pack_start (GTK_BOX (vbox1), widget, TRUE, TRUE, 0);
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_signal_connect (adj, "value_changed",
			    GTK_SIGNAL_FUNC (volume_change), (void *)NULL);

	gtk_tooltips_set_tip(tooltips, widget, "Volume", NULL);


//create statusbar
        widget = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widget)
                                       , GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);
        gtk_container_set_border_width(GTK_CONTAINER(widget), 0);
        gtk_box_pack_start(GTK_BOX(vbox1), widget, FALSE, FALSE, FALSE);
        statusbar = gtk_statusbar_new();
        gtk_object_set_data(GTK_OBJECT(win_main), "statusbar", statusbar);
        gtk_widget_show(statusbar);
        gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(widget),
                                              statusbar);
        contextid =
            gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),
                                         "Statusbar");
        gtk_statusbar_push(GTK_STATUSBAR(statusbar), contextid,
                           _("Welcome to TuxZap"));
        gtk_widget_show(widget);


	gtk_window_add_accel_group (GTK_WINDOW (win_main), accel_group);
	if (get_dvbrc(filen,dvb,dev,80)) {
		cout << _("Found DVB input file ") << filen << endl;
	} else {
		cout << _("Could not find DVB input file ") 
		     << filen << endl;
		status_message(_("Please set LNB\n"));
	}


	for (int i = 0; i < NLIST; i++){
		char buf[80];
		ostrstream str1(buf, 80);
		
		str1 << _("Favorite ") << i << ends;
		listn[i] = 0;
		wclists[i] = channel_list(buf,i);
		load_ch((gpointer *)i);
	}
	if (ipaq)
		for (int i = chlist[clistn].NumChan(); i < TABLEX*TABLEY; i++) 
			gtk_widget_set_sensitive(buttons[i], FALSE);


}

static void CreateToolbar (GtkWidget *vbox_main)
{
	GtkWidget           *toolbar;
	GtkWidget           *tool;
	GtkWidget           *pixi;
	double z,mz;    
  
  
  
	//create the toolbar and add it to the window 
	toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	gtk_container_add ( GTK_CONTAINER ( vbox_main ) , toolbar );
	gtk_widget_show (toolbar);
  
	
	int ninput;
  
	tool=NULL;

	pixi=CreateWidgetFromXpm (win_main, (gchar **) dvb_xpm);
	tool= gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					  GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
					  NULL,
					  "Toggle DVR", "Toggle DVR"
					  ,"Toggle DVR",pixi,
					  (GtkSignalFunc) toggle_dvr,
					  NULL);
	if (dvb.DVR_enabled())
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tool), TRUE);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  

	pixi = CreateWidgetFromXpm (win_main, (gchar **) xpm_bigup);
	tool = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					  GTK_TOOLBAR_CHILD_BUTTON,
					  NULL,
					  "Up", "Up", "Up",pixi,
					  (GtkSignalFunc) switches,
					  gpointer(UP));
	gtk_widget_show (tool);
	gtk_widget_add_accelerator (tool, "clicked", accel_group,
				    GDK_Page_Up, 0,
				    GTK_ACCEL_VISIBLE);


	pixi = CreateWidgetFromXpm (win_main, (gchar **) xpm_bigdown);
	tool = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					  GTK_TOOLBAR_CHILD_BUTTON,
					  NULL,
					  "Down", "Down", "Down",pixi,
					  (GtkSignalFunc) switches,
					  gpointer(DOWN));
	gtk_widget_show (tool);
	gtk_widget_add_accelerator (tool, "clicked", accel_group,
				    GDK_Page_Down, 0,
				    GTK_ACCEL_VISIBLE);

}


static void set_channel(gChannel & ch)
{
	int chnr;
	if ((chnr = find_dvb(ch)) >= 0){
		set_channel_dvb(GTK_WIDGET(clists[0]),chnr);
		last_channel = chnr;
	}
}


void get_dvbfav(char *path, int nb, int len)
{
        const char *home = getenv("HOME");
        const char *file = ".dvbfav";

	ostrstream str(path,len);
	
	str << home << "/" << file << nb ;
	if (dev)
		str << "." << dev;
	str << ends; 
}



void selection_made(GtkWidget * clist,
                    gint row,
                    gint column, GdkEventButton * event, gpointer data)
{
	int nb = int(data);
        gchar *text;

        gtk_clist_get_text(GTK_CLIST(clist), row, column, &text);

        listn[nb] = row;
        set_channel(chlist[nb](row));
	last_on_list[nb] = row;

        return;
}


void set_list(int nb)
{
        gtk_clist_clear(GTK_CLIST(clists[nb]));
        for (int i = 0; i < chlist[nb].NumChan(); i++) {
                gchar *chan[2];
                gchar num[5];

                ostrstream snum(num, 5);
                snum << dec << setw(4) << i << ends;

                chan[1] = chlist[nb](i).Name();
                chan[0] = num;
                gtk_clist_append(GTK_CLIST(clists[nb]), chan);
        }
}


void hide_ch(gpointer data)
{
	int nb = int(data);
	if (GTK_WIDGET_VISIBLE(wclists[nb]))
		gtk_widget_hide(wclists[nb]);
}

void del_ch(gpointer data)
{
	int nb = int(data);

	chlist[nb].DelChannel(listn[nb]);
	set_list(nb);

	if (listn[nb] == chlist[nb].NumChan())
		if (listn[nb] >= 0)
			listn[nb]--;

	if (listn[nb] >= 0)
		gtk_clist_select_row(GTK_CLIST(clists[nb]), listn[nb], 0);
}

void load_ch(gpointer data)
{
	int nb = int(data);
	char filen[80];

	get_dvbfav(filen,nb,80);
	cout << _("Reading channel list from ") << filen << endl;
	chlist[nb].init(filen);
	set_list(nb);

}

void save_ch(gpointer data)
{
	int nb = int(data);
	char filen[80];
	char buf[80];
	ostrstream str(buf, 80);

	get_dvbfav(filen,nb,80);
	str << _("Writing channel list from ") << filen << endl;
	status_message(buf);

	ofstream fout(filen);
	fout << _("# This is the list of favorite channels") << endl;
	fout << _("# The format is:") << endl;
	fout << _("#   *   = start of a channel declaration") << endl;
	fout << _("#  Channel    : <Name>") << endl;
	fout << _("#               <dvbnum> id of channel in DVB structure")
	    << endl;
	fout << chlist[nb] << endl;
}

// create channel list

GtkWidget *channel_list(char *name, int nb)
{
	GtkWidget *window1;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *vbox1, *scrolledwindow1, *hbox1, *hbox2;
	GtkWidget *button_hide, *button_del, *button_load, *button_save;

	window1 = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(window1), "window1", window1);
	gtk_widget_set_usize(window1, LISTX, LISTY);
	gtk_window_set_title(GTK_WINDOW(window1), name);
	gtk_window_set_policy(GTK_WINDOW(window1), FALSE, FALSE, TRUE);
	gtk_window_set_wmclass(GTK_WINDOW(window1), name, "");

	gtk_accel_group_attach(accel_group, GTK_OBJECT(window1));


	vbox1 = gtk_vbox_new(FALSE, 4);
	gtk_object_set_data(GTK_OBJECT(window1), "vbox1", vbox1);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(window1), vbox1);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_object_set_data(GTK_OBJECT(window1), "scrolledwindow1",
			    scrolledwindow1);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(vbox1), scrolledwindow1, TRUE, TRUE, 0);


	clists[nb] = gtk_clist_new(2);
	gtk_object_set_data(GTK_OBJECT(clists[nb]), "clist", clists[nb]);
	gtk_widget_set_usize(clists[nb], LISTX, LISTY-100);;
	gtk_widget_show(clists[nb]);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), clists[nb]);
	gtk_clist_set_column_width(GTK_CLIST(clists[nb]), 0, 25);
	gtk_clist_set_column_width(GTK_CLIST(clists[nb]), 1, 80);
	gtk_clist_column_titles_show(GTK_CLIST(clists[nb]));
	gtk_clist_set_shadow_type(GTK_CLIST(clists[nb]),
				  GTK_SHADOW_ETCHED_OUT);

	label1 = gtk_label_new(_("Nr."));
	gtk_object_set_data(GTK_OBJECT(label1), "label1", label1);
	gtk_widget_show(label1);
	gtk_clist_set_column_widget(GTK_CLIST(clists[nb]), 0, label1);

	label2 = gtk_label_new(_("Name"));
	gtk_object_set_data(GTK_OBJECT(label2), "label2", label2);
	gtk_widget_show(label2);
	gtk_clist_set_column_widget(GTK_CLIST(clists[nb]), 1, label2);


	set_list(nb);

	gtk_signal_connect(GTK_OBJECT(clists[nb]), "select_row",
			   GTK_SIGNAL_FUNC(selection_made), (void *)nb);

	hbox1 = gtk_hbox_new(FALSE, 2);
	gtk_object_set_data(GTK_OBJECT(vbox1), "hbox1", hbox1);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);
	button_hide = gtk_button_new_with_label("Cancel");
	button_del = gtk_button_new_with_label(_("Delete Channel"));
	gtk_widget_set_usize(button_hide, LISTX/2, 5);;
	gtk_widget_set_usize(button_del, LISTX/2, 5);;
	gtk_box_pack_start(GTK_BOX(hbox1), button_hide, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox1), button_del, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new(FALSE, 2);
	gtk_object_set_data(GTK_OBJECT(vbox1), "hbox2", hbox2);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, TRUE, TRUE, 0);
	button_load = gtk_button_new_with_label(_("Load Channels"));
	button_save = gtk_button_new_with_label(_("Save Channels"));
	gtk_widget_set_usize(button_load, LISTX/2, 5);;
	gtk_widget_set_usize(button_save, LISTX/2, 5);;
	gtk_box_pack_start(GTK_BOX(hbox2), button_load, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox2), button_save, TRUE, TRUE, 0);

	/* Connect our callbacks to the four buttons */
	gtk_signal_connect_object(GTK_OBJECT(button_hide), "clicked",
				  GTK_SIGNAL_FUNC(hide_ch),
				  (GtkObject *)nb);
	gtk_signal_connect_object(GTK_OBJECT(button_del), "clicked",
				  GTK_SIGNAL_FUNC(del_ch),
				  (GtkObject *)nb);
	gtk_signal_connect_object(GTK_OBJECT(button_load), "clicked",
				  GTK_SIGNAL_FUNC(load_ch),
				  (GtkObject *)nb);
	gtk_signal_connect_object(GTK_OBJECT(button_save), "clicked",
				  GTK_SIGNAL_FUNC(save_ch),
				  (GtkObject *)nb);

	gtk_widget_show(button_hide);
	gtk_widget_show(button_del);
	gtk_widget_show(button_load);
	gtk_widget_show(button_save);

	return window1;

}
