/*
 * ftp.h -- Implements transparent access to ftp
 *
 * Created by: 	   Troy Heber (troy.heber@hp.com) 
 *
 * Copyright 2004 Hewlett-Packard Development Company, L.P.
 *
 * Adapted from ftplib.cpp part of LUFS,
 * a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 * 
 * Copyright 2004 Hewlett-Packard Development Company, L.P.
 * 
 * Adapted from lkcdutils
 * Created by: Matt D. Robinson (yakker@aparity.com)
 * Copyright 2001 Matt D. Robinson (yakker@aparity.com), all rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#define PORT		21
#define HOST		"troypc"
#define SYST		"SYST"
#define QUIT		"QUIT"
#define MEG		1024*1024
#define FTP_MAXLINE	4096
#define FTP_MAXFILE	1024
#define MAXCMD 		1024
#define FTP_MAXTRIES	7
#define FTP_TIMEOUT     2   /* timeout in seconds */
#define MAX_BUF		500

int     	cfd, dfd;
char 		*hostname, *fuser, *fpass;
char    	*last_cmd;
long long  	last_off;

struct url{
    char *user;
    char *pass;
    char *host;
    char *path;
    int  port;
    int  error;
};

int execute_open(char *, char *, long long);
void disconnect(int);
int FTPConnect();
int get_response();
int close_data();
int execute(char *, int, int);
int execute_retry(char *, int, int);
int do_open(char *);
int do_mkdir(char *);
int do_rmdir(char *);
int do_unlink(char *);
int do_rename(char *, char *);
int do_readFirstLine(char *, char *, int);
int parseUrl(char *, char **, char **, char **, int *, char **);
int protect_write(int, const char *, int);

