/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * check_func.c 
 */

#include <stdio.h>
#include <math.h>
#include <pm.h>
#include <defaults.h>
#include <symbols.h>
#include <constants.h>
#include <math_utils.h>
#include <continue.h>
#include <iterate.h>
 
/* Static equilibrium check function is in static_func.c */

/* int general_sn_check
 * 
 * General check procedure for saddle node routines
 * 
 */

int 
general_sn_check( color, n_varb, state, param )
int             n_varb, *color;
double          *state, *param;
{
  int   ierror=0;
 
  color[2] = MED_POINT;
  if( !cont_ds.Check_Switch )
     {   
      color[1] = 1;
     }   
  else
     { 
      color[1] = *((int *)pm(GET, "Color.Cont_Colors", SNB_COLOR, NULL));
     }
 
  return(ierror);
}


int 
general_hopf_check( color, n_varb, state, param )
int             n_varb, *color;
double          *state, *param;
{
   int          i, j, mode, *iwork, ierror=0;
   int          hopf=FALSE, nsn=FALSE, degen=FALSE;
   int          n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));
   double       *wr, *wi, *dwork;
/*   double     **jac; */
 
   color[1] = 1;
   if ( *((int *)pm(GET, "Cont.Search", NULL)) )
     color[2] = MED_TRI;
   else
     color[2] = MED_POINT;
   if( !cont_ds.Check_Switch ) return(ierror);
 
   iwork = cont_ds.i_workspace;
   wr = cont_ds.r_workspace;
   wi = wr + n_varb + 1;
   dwork = wi + n_varb + 1;
   
/*   jac = dmatrix(0,n_varb+1,0,n_varb+1); */
 
   get_Dxf( cont_ds.jacobian_wrt_x, n_varb, state, param ); 
   ierror = get_eigenval( cont_ds.jacobian_wrt_x, n_varb, wr, wi); /* fjw */
 
/*
   for(i=0; i<n_varb; i++)
     for(j=0; j<n_varb; j++)
        jac[i+1][j+1] = cont_ds.jacobian_wrt_x[i][j];
   ierror = rg(n_varb,n_varb,jac,&wr[0]-1,&wi[0]-1,0,NULL,iwork,dwork);
   if(ierror != 0)
      {
       free_dmatrix(jac,n_varb+1,0,n_varb+1);
       return(ierror);
      }
*/
   if(ierror != 0) return(ierror);
 
   if(cont_ds.Debug_Level > 0)
     {
      fprintf(stderr,"\nstate = ");
      for(i=0; i<n_varb; i++) fprintf(stderr," %g",state[i]);
      fprintf(stderr,"\nparam = ");
      for(i=0; i<n_params; i++) fprintf(stderr," %g",param[i]);
      for(i=0; i<n_varb; i++) fprintf(stderr,"\neig(%d) = (%g,%g)",i, wr[i],wi[i]);
     }
    
   if ( *((int *) pm( GET, "Model.Mapping_Flag", NULL )) )
     {                          /* fjw 8/11/92. Determine type for mapping */
       mode = TRUE;
       for(i=0; i<n_varb && mode; i++)
         for(j=i+1; j<n_varb && mode; j++)
           if( (fabs(fabs(wr[i]*wr[j] - wi[i]*wi[j]) - 1.0) < TINY ) 
              && (fabs(wi[i]*wr[j] + wr[i]*wi[j] )< TINY ) )/* i,j s.t. product of e-vals = 1.0 */
             mode = FALSE;
 
       if (!mode)               /* sucessful detection */
         {
           i--; j--;            /* correct for going too far */
           if( fabs(wr[i] + wr[j]) - 2.0 < TINY ) /* test selected i,j pair */
             {
               hopf = TRUE;
               color[1] = *((int *)pm(GET, "Color.Cont_Colors", HB_COLOR, NULL));   /* Hopf bifurcation color */
             }
           else if( fabs(wr[i] + wr[j]) - 2.0 > TINY )
             {
               nsn = TRUE;
               color[1] = *((int *)pm(GET, "Color.Cont_Colors", RSNB_COLOR, NULL));    /* Resonant saddle color */
             }
           else 
             {
               degen = TRUE;
               color[1] = *((int *)pm(GET, "Color.Cont_Colors", DHB_COLOR, NULL));   /* Degenerate hopf color */
             }
         }
       else
         {
           fprintf(stderr,"\nProblem in hopf?\n");
           for(i=0; i<n_varb; i++) fprintf(stderr,"\neig(%d) = (%g,%g)",i, wr[i],wi[i]);
         }
     }
   else                         /* determine type for vector field */
     {
       for(i=0; i<n_varb; i++)
         {
           if( fabs(wr[i]) < TINY && fabs(wi[i])>TINY )
             {
               hopf = TRUE;
               break;
             }
           if( fabs(wr[i])+fabs(wi[i]) < TINY )
             {
               degen=TRUE;
               break;
             }
           for(j=i; j<n_varb; j++)
             {
               if( fabs(wr[i]) > TINY && (wr[i]+wr[j])<TINY &&
                  (wi[i]+wi[j])<TINY &&  fabs(wi[i])<TINY     )
                 {
                   nsn = TRUE;
                   break;
                 }
             }
           if( nsn || hopf || degen ) break;
         }
       if(hopf) color[1] = *((int *)pm(GET, "Color.Cont_Colors", HB_COLOR, NULL));  /* Hopf color */
       if(degen) color[1] = *((int *)pm(GET, "Color.Cont_Colors", DHB_COLOR, NULL)); /* Degenerate Hopf Color */
       if(nsn) color[1] = *((int *)pm(GET, "Color.Cont_Colors", RSNB_COLOR, NULL));    /* Resonant Saddle color */
     }
 
   /* free_dmatrix(jac,0,n_varb+1,0,n_varb+1);*/
   return(ierror);
 
}

