
; do not remove all these blank lines, I use them to make sure a translation 
; in this file appears on the same line as in english-string-constants.ss



; Note: http://www.linux-france.org/prj/jargonf/ peut etre utile... Les dictionnaires online
; anglais->francais sont tres pauvres en ce qui concerne le jargon technique, et l'academie
; francaise (http://www-rocq.inria.fr/qui/Philippe.Deschamp/RETIF/) a quelques longueures de
; retard. http://www.can.ibm.com/francais/dico/ peut aider aussi...
; http://www.dicofr.com/ permet les recherches a partir du mot anglais.
; http://www.francophonie.hachette-livre.fr/ est un dico standard de base
; http://zeus.inalf.fr/academie9.htm est le dico de l'academie (A-M pour l'instant seulement)













































































(module french-string-constants "string-constant-lang.ss"
  ;;; when translating this constant, substitue name of actual langauge for `English'
  (is-this-your-native-language "Le Franais est-il votre langue maternelle ?")
  
  (are-you-sure-you-want-to-switch-languages
   "Ceci va changer le langage utilis par l'interface graphique, ce qui va ncessiter un redmarrage de DrScheme. Etes-vous certain de vouloir continuer ?")
  
  (interact-with-drscheme-in-language "Interagir avec DrScheme en Franais")
  
  ;; these two should probably be the same in all languages excepet English.
  ;; they are the button labels (under macos and windows, respectively)
  ;; that go the with the string above.
  (accept-and-quit "Accepter et Quitter")
  (accept-and-exit "Accepter et Quitter")
  
  ;;; general purpose (DrScheme is hereby a word in every language, by decree of Robby :)
  (plt "PLT")
  (drscheme "DrScheme")
  (ok "OK")
  (cancel "Annuler")
  (untitled "Sans Nom")
  (untitled-n "Sans Nom ~a")
  (warning "Avertissement")
  (error "Erreur")
  (close "Fermer") ;; as in, close an open window
  (stop "Stop")
  (&stop "&Stop") ;; for use in button and menu item labels, with short cut.
  (are-you-sure-delete? "Etes-vous certain de vouloir effacer ~a ?") ;; ~a is a filename
  (ignore "Ignorer")
  (revert "Retourner") ; revenir?
  
  ;; label for a generic check box, often supported on dialogs
  ;; that ask a binary choice of the user. If checked, the
  ;; dialog isn't going to be shown again.
  (dont-ask-again "Ne jamais redemander (utilisera toujours votre prsent choix)")
  
  ;;; important urls
  (web-materials "Sites web apparents") ;; menu item title
  (tool-web-sites "Sites web d'outils")   ;; menu item title
  (drscheme-homepage "DrScheme")
  (plt-homepage "PLT")
  (how-to-use-scheme "How to Use Scheme") ;; title of a book.
  (teachscheme!-homepage "TeachScheme!") ;; probably this should be a `word' in all languages
  
  ;;; bug report form
  (cancel-bug-report? "Annuler la soumission du formulaire de bogue ?")
  (are-you-sure-cancel-bug-report?
   "Etes-vous certain de vouloir annuler la soumission de ce formulaire de bogue ?")
  (bug-report-form "Formulaire de soumission de bogue")
  (bug-report-field-name "Nom")
  (bug-report-field-email "Email")
  (bug-report-field-summary "Rsum du problme")
  (bug-report-field-severity "Svrit")
  (bug-report-field-class "Classe")
  (bug-report-field-priority "Priorit")
  (bug-report-field-description "Description")
  (bug-report-field-reproduce1 "Etapes  suivre pour")
  (bug-report-field-reproduce2 "reproduire le bogue")
  (bug-report-field-environment "Environnement")
  (bug-report-field-tools "Outils")
  (bug-report-field-docs-installed "Documentations installes")
  (bug-report-field-language "Langage")
  (bug-report-field-teachpacks "Teachpacks")
  (bug-report-field-collections "Collections")
  (bug-report-field-human-language "Langage humain")
  (bug-report-field-version "Version")
  (bug-report-synthesized-information "Information Synthtise")  ;; dialog title
  (bug-report-show-synthesized-info "Montrer l'information synthtise")
  (bug-report-submit "Soumettre")
  (sending-bug-report "Soumission du formulaire de bogue en cours...")
  (error-sending-bug-report "Erreur durant la soumission du formulaire de bogue.")
  (error-sending-bug-report-expln "Une erreur s'est produite pendant la soumission de votre formulaire de bogue. Si votre connexion Internet fonctionne correctement, veuillez visiter :\n\n    http://bugs.plt-scheme.org/\n\net soumettre votre bogue en utilisant notre formulaire web en ligne. Je suis vraiment profondment dsol pour toutes vos difficults.\n\nLe message d'erreur est :\n~a")
  (bug-report-sent "Le bogue a t correctement soumis.")
  (bug-report-sent-detail "Merci pour votre soumission. Vous devriez recevoir une confirmation de votre soumission par email d'ici 30 minutes. Si vous ne recevez pas cette confirmation, veuillez envoyer un email  scheme@plt-scheme.org.")
  (illegal-bug-report "Formulaire de soumission de bogue incomplet.")
  (pls-fill-in-field "Merci de complter le champ \"~a\".")
  (malformed-email-address "Adresse email malforme.")
  (pls-fill-in-either-description-or-reproduce "Veuillez remplir soit le champ \"Description\", soit le champ \"Etapes  suivre pour reproduire le bogue\".")
  
  ;;; check syntax
  (check-syntax "Vrifier") ; "Syntaxe" ; "Vrificateur de syntaxe" est long...
  (cs-italic "Italique")
  (cs-bold "Gras")
  (cs-underline "Soulign")
  (cs-change-color "Changer la couleur")
  (cs-tack/untack-arrow "Coller/dcoller les flches")
  (cs-jump-to-next-bound-occurrence "Aller  l'occurence suivante")
  (cs-jump-to-binding "Aller  l'occurence liant celle-ci")
  (cs-jump-to-definition "Aller  la dfinition")
  (cs-error-message "Message d'erreur")
  (cs-open-file "Ouvrir ~a")
  (cs-rename-var "Renommer ~a")
  (cs-rename-id "Renommer l'identifieur")
  (cs-rename-var-to "Renommer ~a en :")
  (cs-name-duplication-error "Le nouveau nom que vous avez choisi, ~s, est en conflit avec un autre nom prexistant dans le mme contexte.")
  (cs-status-init "Vrificateur de syntaxe : initialisation de l'environnement pour le code de l'utilisateur")
  (cs-status-coloring-program "Vrificateur de syntaxe : coloriage d'une expression")
  (cs-status-eval-compile-time "Vrificateur de syntaxe : valuation pour l'expansion") ; peut mieux faire?
  (cs-status-expanding-expression "Vrificateur de syntaxe : expansion d'une expression")
  (cs-mouse-over-variable-import "la variable ~s est importe de ~s")
  (cs-mouse-over-syntax-import "la macro ~s est importe de ~s")
  
  (cs-lexical-variable "variable lexicale")
  (cs-lexical-syntax "syntaxe lexicale")
  (cs-imported-variable "variable importe")
  (cs-imported-syntax "syntaxe importe")

  ;;; info bar at botttom of drscheme frame
  (collect-button-label "Ramassage") ; de miettes
  (read-only "Lecture seulement")
  (read/write "Lecture/criture")
  (auto-extend-selection "Autoslection") ; "Slection auto-tendable" ?
  (overwrite "Correction") ; vs Insertion ? surimpression ?
  (running "en cours")
  (not-running "en attente") ; "en attente" ; pause ?
  
  ;;; misc
  (welcome-to-something "Bienvenue dans ~a.")
  
  ; this appears in the drscheme about box.
  (welcome-to-drscheme-version/language "Bienvenue dans DrScheme, version ~a, ~a.")
  
  ; these appear on subsequent lines in the `Help|Welcome to DrScheme' dialog.
  (welcome-to-drscheme "Bienvenue dans DrScheme")
  (version/language "version ~a, ~a.")
  
  (goto-line "Aller  la ligne")
  (goto-line-invalid-number
   "~a n'est pas un numro de ligne valide. Ce doit tre un entier entre 1 et ~a.")
  (goto-position "Aller  la position")
  (no-full-name-since-not-saved
   "Le fichier n'a pas encore de nom complet car il n'a pas encore t sauvegard.")
  (cannot-open-because-dne "Impossible d'ouvrir ~a car le fichier n'existe pas.")
  (interactions-out-of-sync
   "ATTENTION : la fentre d'interaction et la fentre de dfinition ne sont pas synchronises. Cliquez sur Excuter.")
  (file-is-not-saved "Le fichier \"~a\" n'a pas t sauvegard.")
  (save "Sauvegarder")
  (please-choose-either "Choisissez \"~a\" ou \"~a\".")
  (close-anyway "Fermer quand mme")
  (clear-anyway "Effacer quand mme")
  
  ;; menu item title
  (log-definitions-and-interactions "Enregistrer les dfinitions et interactions...")
  (stop-logging "Stopper l'enregistrement")
  (please-choose-a-log-directory "Slectionnez un rpertoire d'enregistrement")
  (logging-to "Enregistrer dans : ")
  (erase-log-directory-contents "Effacer le contenu du rpertoire d'enregistrement : ~a ?")
  (error-erasing-log-directory "Erreur durant l'effacement du contenu du rpertoire d'enregistrement.\n\n~a\n")
  
  ;; modes
  (mode-submenu-label "Modes")
  (scheme-mode "Mode scheme")
  (text-mode "Mode texte")
 
  (scheme-mode-color-symbol "Symbole")
  (scheme-mode-color-keyword "Mot rserv")
  (scheme-mode-color-comment "Commentaire")
  (scheme-mode-color-string "Chane de caractres")
  (scheme-mode-color-constant "Constante")
  (scheme-mode-color-parenthesis "Parenthses")
  (scheme-mode-color-error "Erreur")
  (scheme-mode-color-other "Autre")
 
  (url "URL")
  (url: "URL :")
  (open-url... "Ouvrir l'URL...")
  (open-url "Ouvrir l'URL")
  (browse... "Naviguer...")
  (bad-url "URL incorrect")
  (bad-url:this "URL incorrect : ~a")
  
  ;; Help Desk
  (help "Aide")
  (help-desk "Aide")
  (plt:hd:search-results "Rsultats de la recherche")
  (plt:hd:search "Chercher")
  (plt:hd:search-for "Chercher")
  (plt:hd:lucky "Chanceux !")
  (plt:hd:feeling-lucky "D'humeur chanceuse")
  (plt:hd:stop "Stop")
  (plt:hd:options "Options")
  (plt:hd:configure "Configurer")
  (plt:hd:home "Page principale de l'Aide")
  (plt:hd:show-manuals "Liste des manuels")
  (plt:hd:send-bug-report "Signaler un bogue") ; Envoyer un formulaire de bogue
  (plt:hd:query-bug-reports "Bogues connus")
  ; next 3 are popup menu choices at bottom of help desk window
  (plt:hd:search-for-keyword "par mot clef")
  (plt:hd:search-for-keyword-or-index "par mot clef ou entre dans l'index")
  (plt:hd:search-for-keyword-or-index-or-text "par mot clef, entre dans l'index ou dans le texte")
  (plt:hd:exact-match "mot exact")
  (plt:hd:containing-match "contenant le mot")
  (plt:hd:regexp-match "expression rgulire")
  (plt:hd:find-docs-for "Chercher dans les docs :")
  (plt:hd:nothing-found-for-search-key "Rien n'a t trouv pour \"~a\".")
  (plt:hd:searching "Recherche en cours...")
  (plt:hd:search-stopped "(Recherche stoppe.)")
  (plt:hd:search-stopped-too-many-matches "(Recherche stoppe - trop d'entres ont t trouves.)")
  (plt:hd:nothing-found-for "Rien n'a t trouv pour ~a.")
  (plt:hd:error-finding-docs "Documentation introuvable.\n\n~a")
  (plt:hd:and "et")
  (plt:hd:refresh "rafrachir")
  (plt:hd:refresh-all-manuals "rafrachir tous les manuels")
  (plt:hd:manual-installed-date "(install le ~a)")
  ; Help Desk configuration
  (plt:hd:configuration "Configuration de l'Aide")
  (plt:hd:no-frames "Pas de cadres")
  (plt:hd:use-frames "Utiliser des cadres")
  (plt:hd:use-html-frames "Utiliser des cadres HTML")
  (plt:hd:search-pane-options "Options pour le cadre de recherche")
  (plt:hd:height "Hauteur")
  (plt:hd:bg-color "Couleur de fond")
  (plt:hd:pixels "pixels")
  (plt:hd:text-color "Couleur du texte")
  (plt:hd:link-color "Couleur des liens")
  (plt:hd:text-sample "Le texte dans le cadre de recherche apparat dans cette couleur")
  (plt:hd:link-sample "Les liens dans le cadre de recherche apparassent dans cette couleur")
  (plt:hd:save-changes "Sauvegarder les modifications")
  (plt:hd:reset "Rinitialisation des options")
  (plt:hd:defaults "Valeurs par dfaut")
  (plt:hd:javascript-note
   "Les choix que vous faites sont montrs ici si vous avez Javascript et un navigateur rcent")
  ;; refreshing manuals
  (plt:hd:refresh-downloading "Tlchargement de ~a")
  (plt:hd:refresh-installing "Installation de la nouvelle version de ~a")
  (plt:hd:refresh-progress "Progrs du tlchargement des manuels")
  (plt:hd:refresh-done "Fin du tlchargement des manuels par CVS")
  (plt:hd:refresh-installation-log "Journal de l'installation")
  (plt:hd:refresh-stopped "Tlchargement des manuels stopp")
  (plt:hd:refreshing-manuals "Retlchargement des manuels")
  (plt:hd:refresh-downloading... "Tlchargement de ~a...")
  (plt:hd:refresh-deleting... "Effacement de l'ancienne version de ~a...")
  (plt:hd:refresh-installing... "Installation de la nouvelle version de ~a...")
  (plt:hd:refresh-clearing-indicies "Effacement des indices cachs")
  (plt:hd:refreshing-manuals-finished "Termin.")
  (plt:hd:about-help-desk "A propos de l'Aide")
  (plt:hd:help-desk-about-string
   "L'Aide est une source complte d'information  propos des logiciels du PLT, y compris DrScheme, MzScheme et MrEd.\n\nVersion ~a\nCopyright (c) 1995-2003 PLT.")
  (plt:hd:help-on-help "Aide de l'Aide")
  (plt:hd:help-on-help-details "Pour obtenir de l'aide sur comment utiliser l'Aide, suivez le lien `How to use Help Desk'  partir de la page principale de l'Aide (pour trouver la page principale, si vous n'y tes pas dj, cliquez sur le boutton `Home' qui apparat en haut de la fentre de l'Aide).")
  (reload "Rafrachir")
  (plt:hd:ask-about-separate-browser
   "Vous avez slectionn un lien vers une page sur le world-wide web. Voulez-vous voir cette page en utilisant le navigateur de l'Aide ou voulez-vous utiliser un navigateur spar ?")
  (plt:hd:homebrew-browser "Navigateur de l'Aide") ;; choice for the above string (in a button)
  (plt:hd:separate-browser "Navigateur spar") ;; other choice for the above string (also in a button)
  (plt:hd:external-link-in-help "URLs externes dans l'Aide")
  (plt:hd:use-homebrew-browser "Utiliser le navigateur de l'Aide pour les URLs externes")
  (plt:hd:new-help-desk "&Nouvelle Aide")
  (plt:hd:teaching-manuals "Manuels pour tudiants")
  (plt:hd:professional-manuals "Manuels pour professionnels")
  (plt:hd:all-manuals "Tous les manuels")

  ;; in the Help Desk language dialog, title on the right.
  (plt:hd:manual-search-ordering "Ordre de recherche dans les manuels")

  
  ; help desk htty proxy
  (http-proxy "Proxy HTTP")
  (proxy-direct-connection "Connexion directe")
  (proxy-use-proxy "Utiliser le proxy :")
  (proxy-host "Machine")
  (proxy-port "Port")
  (proxy-bad-host "Mauvaise machine proxy")
  
  ;; browser
  (rewind-in-browser-history "Retourner")
  (forward-in-browser-history "Avancer")
  (home "Maison")
  (browser "Navigateur")
  (choose-browser "Choisissez un navigateur")
  (external-browser-choice-title "Navigateur externe") ; title for radio-button set
  (browser-command-line-label "Ligne de commande :") ; label for radio button that is followed by text boxes
  (no-browser "Demander plus tard")
  (use-internal-browser-for-help "Lire l'Aide  l'aide du navigateur PLT interne") ; radio-button label
  (use-external-browser-for-help "Lire l'Aide  l'aide d'un navigateur externe") ; radio-button label
  (browser-cmdline-expl-line-1 "(La ligne de commande est la concatnation du prfixe, de l'URL,") ; explanatory text for dialog, line 1
  (browser-cmdline-expl-line-2 "et du suffixe, sans espace additionel entre eux.)") ; ... line 2. (Anyone need more lines?)
  (cannot-display-url "Impossible de montrer l'URL ~s : ~a")
  (install? "Installer ?")  ;; if a .plt file is found (title of dialog)
  (you-have-selected-an-installable-package "Vous avez slectionn un logiciel qui peut tre install.") ; package => paquetage, pas tres clair...
  (do-you-want-to-install-it? "Voulez-vous l'installer ?")
  (paren-file-size "(Le fichier fait ~a octets)")
  (download-and-install "Tlcharger && Installer") ;; button label
  (download "Tlcharger") ;; button label
  (save-downloaded-file/size "Sauvegarder le fichier tlcharg (~a octets) sous le nom") ;; label for get-file dialog
  (save-downloaded-file "Sauvegarder le fichier tlcharg sous le nom")  ;; label for get-file dialog
  (downloading "Tlchargement") ;; dialog title
  (downloading-file... "Tlchargement du fichier en cours...")
  (package-was-installed "Le logiciel  t install.")
  (download-was-saved "Le fichier tlcharg  t sauvegard.")
  (getting-page "Page en cours de rception") ;; dialog title
  
  (install-plt-file-menu-item... "Installer un fichier .plt...")
  (install-plt-file-dialog-title "Installer un fichier .plt")
  (install-plt-web-tab "Web")
  (install-plt-file-tab "Fichier")
  (install-plt-filename "Nom de fichier :")
  (install-plt-url "URL :")
  
  ;; install plt file when opened in drscheme strings
  (install-plt-file "Installer ~a ou l'ouvrir pour dition ?")
  (install-plt-file/yes "Installation")
  (install-plt-file/no "Edition")
  
  (plt-installer-progress-window-title "Progresssion de l'installation") ;; frame title
  (plt-installer-abort-installation "Abandonner l'installation") ;; button label
  (plt-installer-aborted "Installation abandonne.") ;; msg that appears in the installation window when installation is aborted
  
  ;;; about box
  (about-drscheme-frame-title "A propos de DrScheme")
  (take-a-tour "Faire un tour !")
  (release-notes "Notes pour la rvision")
  (parenthetical-last-version "(version prcdente ~a)")
  (parenthetical-last-language "(langage prcdent ~a)")
  (parenthetical-last-version/language "(version prcdente ~a, langage prcdent ~a)")
  
  
  ;;; save file in particular format prompting.
  (save-as-plain-text "Sauvegarder ce fichier au format texte ?")
  (save-in-drs-format "Sauvegarder ce fichier au format DrScheme (non-texte) ?")
  (yes "Oui")
  (no "Non")
  
  ;;; preferences
  (preferences "Prfrences")
  (saving-preferences "Sauvegarde des prfrences")
  (error-unmarshalling "Erreur durant la dessrialisation de la prfrence ~a.")
  (error-saving-preferences "Erreur durant la sauvegarde des prfrences : ~a.")
  (error-reading-preferences "Erreur durant la lecture des prfrences.")
  (expected-list-of-length2 "esprait une liste de longueur 2.")
  (scheme-prefs-panel-label "Scheme")
  (warnings-prefs-panel-label "Avertissements")
  (editor-prefs-panel-label "Edition")
  (general-prefs-panel-label "Gnral")
  (highlight-parens "Surligner les paires de parenthses.")
  (fixup-parens "Corriger les parenthses.")
  (flash-paren-match "Montrer la parenthse correspondante.")
  (auto-save-files "Sauvegarde automatique des fichiers.")
  (backup-files "Fichiers de sauvegarde.")
  (map-delete-to-backspace "La touche Delete gnre Backspace.")
  (verify-exit "Confirmation pour quitter.")
  (ask-before-changing-format "Confirmation avant de changer le format de sauvegarde.")
  (wrap-words-in-editor-buffers "Continuer une longue ligne sur la ligne suivante, dans les diteurs.")
  (show-status-line "Montrer la barre de status.")
  (count-columns-from-one "Compter les lignes et colonnes  partir de un.")
  (display-line-numbers "Montrer le numro de ligne et de colonne, pas la distance depuis le dbut d'diteur.")
  (enable-keybindings-in-menus "Raccourcis clavier dans les menus.")
  (automatically-to-ps "Imprimer automatiquement dans un fichier postscript.")
  (option-as-meta "Utiliser la touche option comme touche meta") ;; macos/macos x only
  (use-mdi "Utiliser les fentres MDI.") ;;; ms windows only -- use that window in a window thingy
  (separate-dialog-for-searching "Utiliser un dialogue spar pour les recherches.")
  (reuse-existing-frames "Rutiliser les fentres existantes lors de l'ouverture de nouveaux fichiers")
  (default-fonts "Polices par dfaut")
  (paren-match-color "Couleur de surlignage des parenthses") ; in prefs dialog
  (choose-color "Slectionnez une couleur") ; in prefs dialog
  (online-coloring-active "Colorier la syntaxe interactivement")
  (open-files-in-tabs "Ouvrir les fichiers dans de nouveaux onglets (pas dans de nouvelles fentres)")
  
  ; title of the color choosing dialog
  (choose-paren-highlight-color "Slectionnez une couleur pour surligner les parenthses")
  
  ; should have entire alphabet
  (font-example-string "abcdefghijklmnopqrstuvwxyz")
  
  (change-font-button-label "Changer")
  (fonts "Polices")
  
  ; filled with type of font, eg modern, swiss, etc.
  (choose-a-new-font "Slectionnez une nouvelle police \"~a\".")
  
  (font-size-slider-label "Taille")
  (restart-to-see-font-changes "Redmarrez pour voir le changement de polices.")
  
  (font-prefs-panel-title "Police")
  (font-name "Nom de la police")
  (font-size "Taille de la police")
  (set-font "Appliquer la police...")
  (font-smoothing-label  "Lissage de polices")
  (font-smoothing-none "Aucune")
  (font-smoothing-some "Certaines")
  (font-smoothing-all "Toutes")
  (font-smoothing-default "Utiliser la configuration par dfaut du systme")
  (select-font-name "Slectionnez une police")
  (example-text "Example de texte :")
  (only-warn-once "Prvenir une fois seulement quand excutions et interactions n'ont pas t synchronises.")
  
  ; warning message when lockfile is around
  (waiting-for-pref-lock "Attente sur le fichier de verrouillage des prfrences...")
  (pref-lock-not-gone
   "Les prfrences sont verrouilles par le fichier :\n\n   ~a\n\nqui empche les prfrences d'tre sauvegardes. Assurez-vous qu'aucun logiciel PLT n'est en cours d'excution et effacer le fichier.")
  (still-locked-exit-anyway? "Les prfrences n'ont pu tre sauvegardes correctement. Quitter quand mme ?")
  
  ;;; indenting preferences panel
  (indenting-prefs-panel-label "Indentation")
  
  ; filled with define, lambda, or begin
  (enter-new-keyword "Entrez un nouveau mot clef ressemblant  ~a :")
  (x-keyword "Mot clef ~a")
  (x-like-keywords "Mots clefs ressemblant  ~a")
  
  (expected-a-symbol "esprait un symbole, trouv : ~a")
  (already-used-keyword "\"~a\" est dj un mot clef avec une indentation spciale.")
  (add-keyword "Ajouter")
  (remove-keyword "Enlever")
  
  ;;; find/replace
  (find-and-replace "Chercher et remplacer")
  (find "Chercher")
  (replace "Remplacer")
  (dock "Attacher")
  (undock "Sparer")
  (use-separate-dialog-for-searching "Utiliser un menu spar pour chercher.")
  (replace&find-again "Remplacer && chercher  nouveau") ;;; need double & to get a single &
  (replace-to-end "Remplacer jusqu' la fin")
  (forward "En avant")
  (backward "En arrire")
  (hide "Cacher")
  
  ;;; multi-file-search
  (mfs-multi-file-search-menu-item "Rechercher dans les fichiers...")
  (mfs-string-match/graphics "Une chane de caractres (y compris dans les fichiers avec graphiques)")
  (mfs-regexp-match/no-graphics "Une expression rgulire (fichiers textuels seulement)")
  (mfs-searching... "Recherche en cours...")
  (mfs-configure-search "Configurer la recherche") ;; dialog title
  (mfs-files-section "Fichiers")   ;; section in config dialog
  (mfs-search-section "Rechercher") ;; section in config dialog
  (mfs-dir "Rpertoire")
  (mfs-recur-over-subdirectories "Rcursion dans les sous-rpertoires")
  (mfs-regexp-filename-filter "Filtre de nom de fichiers pour les expressions rgulires")
  (mfs-search-string "Chercher la chane de caractres")
  (mfs-drscheme-multi-file-search "DrScheme - Recherche dans des fichiers multiples") ;; results window and error message title
  (mfs-not-a-dir "\"~a\" n'est pas un rpertoire")
  (mfs-open-file "Ouvrir le fichier")
  (mfs-stop-search "Stopper la recherche")
  (mfs-case-sensitive-label "Diffrentier les lettres majuscules des minuscules.")
  (mfs-no-matches-found "Rien n'a t trouv.")
  (mfs-search-interrupted "Recherche avorte.")
  
  ;;;reverting a file
  (error-reverting "DrScheme - Erreur durant le retour  l'original.")
  (could-not-read "impossible de lire \"~a\".")
  (are-you-sure-revert
   "Etes-vous certain de vouloir retourner  la version de ce fichier qui est sur le disque dur ? Ce changement ne pourra pas tre dfait.")
  (are-you-sure-revert-title
   "Retourner ?")
  
  ;;; saving a file
  ; ~a is filled with the filename
  (error-saving "Erreur durant la sauvegarde") ;; title of error message dialog
  (error-saving-file/name "Une erreur s'est produite durant la sauvegarde de ~a.")
  (error-loading "Erreur durant le chargement")
  (error-loading-file/name "Une erreur s'est produite durant le chargement de ~a.")
  (unknown-filename "<< inconnu >>")
  
  ;;; finder dialog
  (must-specify-a-filename "Vous devez spcifier un nom de fichier.")
  (file-does-not-exist "Le fichier \"~a\" n'existe pas.")
  (ask-because-file-exists "Le fichier \"~a\" existe dj. Voulez-vous le remplacer ?")
  (dne-or-cycle "Le fichier \"~a\" contient un rpertoire non-existant, ou une boucle.")
  (get-file "Obtenir fichier")
  (put-file "Donner fichier")
  (full-pathname "Chemin de fichier complet")
  (show-dot-files "Montrer les fichiers et rpertoires dont le nom commence par un point.")
  (up-directory-button-label "Rpertoire parent")
  (add-button-label "Ajouter") ;;; for multi-file selection
  (add-all-button-label "Ajouter tous") ;;; for multi-file selection
  (remove-button-label "Enlever") ;;; for multi-file selection
  (file-wrong-form "Le format de ce nom de fichier est incorrect.")
  (select-files "Slectionnez des fichiers")
  (select-file "Slectionnez un fichier")
  (dir-dne "Ce rpertoire n'existe pas.")
  (file-dne "Ce fichier n'existe pas.")
  (empty-filename "Le nom de fichier doit contenir au moins quelques lettres.")
  (that-is-dir-name "Ceci est un nom de rpertoire.")
  
  ;;; raw menu names -- these must match the 
  ;;; versions below, once the &s have been stripped.
  ;;; if they don't, DrScheme's menus will appear
  ;;; in the wrong order.
  (file-menu "Fichier")
  (edit-menu "Editer")
  (help-menu "Aide")
  (windows-menu "Fentres")
  
  ;;; menus
  ;;; - in menu labels, the & indicates a alt-key based shortcut.
  ;;; - sometimes, things are stuck in the middle of 
  ;;; menu item labels. For instance, in the case of
  ;;; the "Save As" menu, you might see: "Save Definitions As". 
  ;;; be careful of spacing, follow the English, if possible.
  ;;; - the ellipses in the `after' strings indicates that
  ;;; more information is required from the user before completing
  ;;; the command.
  
  (file-menu-label-windows "Fichier")
  (file-menu-label-other "F&ichier")
  
  (new-info  "Ouvrir un nouveau fichier.")
  (new-menu-item "&Nouvelle fentre")
  (new-...-menu-item "&Nouvelle...")
  
  (open-info "Ouvrir un fichier  partir du disque dur.")
  (open-menu-item "&Ouvrir")
  (open-here-menu-item "&Ouvrir ici...")
  
  (open-recent-info "Une liste des fichiers ouverts rcemment.")
  (open-recent-menu-item "Ouvrir rcent")
  
  (revert-info "Retour  la version originale de ce fichier sur le disque dur.")
  (revert-menu-item "&Retour version disque")
  
  (save-info "Sauvegarder ce fichier sur le disque dur.")
  (save-menu-item "&Sauvegarder")
  
  (save-as-info "Demander un nom de fichier et sauver ce fichier sur le disque dur.")
  (save-as-menu-item "Sauvegarder ")
  
  (print-info "Envoyer ce fichier  une imprimante.")
  (print-menu-item "&Imprimer...")
  
  (close-info "Fermer ce fichier.")
  (close-menu-item "&Fermer")
  
  (quit-info "Fermer toutes les fentres.")
  (quit-menu-item-windows "&Quitter")
  (quit-menu-item-others "&Quitter")
  
  (edit-menu-label "&Editer")
  
  (undo-info "Dfaire l'action la plus rcente.")
  (undo-menu-item "&Dfaire")
  
  (redo-info "Refaire l'action qui vient d'tre dfaite.")
  (redo-menu-item "&Refaire")
  
  (cut-info "Dplacer dans le porte-bloc les lments slections, pour collage ultrieur.")
  (cut-menu-item "&Couper")
  
  (copy-info "Copier dans le porte-bloc les lments slections, pour collage ultrieur.")
  (copy-menu-item "Co&pier")
  
  (paste-info "Coller  la place des lments slectionns les lments qui ont t copis ou coups le plus rcemment.")
  (paste-menu-item "C&oller")
  
  (clear-info "Effacer les lments slectionns sans modifier le porte-bloc ou le collage.")
  (clear-menu-item-others "Effacer")
  (clear-menu-item-windows "&Effacer")
  
  (select-all-info "Slectionner tout le document.")
  (select-all-menu-item "&Slectionner tout")
  
  (find-info "Rechercher une chane de caractres.")
  (find-menu-item "Rechercher...")
  
  (find-again-info "Recherche  nouveau la mme chane de caractres.")
  (find-again-menu-item "Rechercher  nouveau")
  
  (replace-and-find-again-info "Remplacer le texte slectionn et rechercher  nouveau le mme texte.")
  (replace-and-find-again-menu-item "Remplacer && rechercher  nouveau")
  
  (preferences-info "Configurer vos prfrences.")
  (preferences-menu-item "Prfrences...")
  
  (keybindings-info "Montrer les raccourcis clavier actuellement actifs.")
  (keybindings-menu-item "Raccourcis clavier")
  (keybindings-frame-title "Raccourcis clavier")
  (keybindings-sort-by-name "Trier par nom")
  (keybindings-sort-by-key "Trier par raccourci")
  
  ;; menu items in the "special" menu
  (insert-text-box-item "Insrer une boite texte")
  (insert-pb-box-item "Insrer une boite  dessin")
  (insert-image-item "Insrer une image...")
  (insert-comment-box-menu-item-label "Insrer une boite  commentaires")
  (insert-lambda "Insrer un &Lambda")
  (insert-delta "Insrer un &Delta (define)")
  
  (wrap-text-item "Replier le texte")
  
  (windows-menu-label "Fe&ntres")
  (bring-frame-to-front "Amener une fentre au premier plan")       ;;; title of dialog
  (bring-frame-to-front... "Amener une fentre au premier plan...") ;;; corresponding title of menu item
  (next-window "Fentre suivante")
  (previous-window "Fentre prcdente")
  (most-recent-window "Fentre la plus rcente")
  
  (view-menu-label "&Montrer")
  (show-overview "Montrer le contour")
  (hide-overview "Cacher le contour")
  (show-module-browser "Montrer le navigateur de modules")
  (hide-module-browser "Cacher le navigateur de modules")
  
  (help-menu-label "&Aide")
  (about-info "Auteurs et dtails concernant ce logiciel.")
  (about-menu-item "A propos de ...")
  (help-menu-check-for-updates "Regarder les mises  jour...")
  
  ;; open here's new menu item
  (create-new-window-or-clear-current
   "Voulez-vous crer une nouvelle fentre ou effacer celle-ci ?")
  (clear-current "Effacer celle-ci")
  (new-window "Nouvelle fentre")
  
  ;;; exiting and quitting ``are you sure'' dialog
  ;;; exit is used on windows, quit on macos, in English. Other
  ;;; languages probably use the same word on both platforms.
  (exit "Quitter")
  (quit "Quitter")
  (are-you-sure-exit "Etes-vous certain de vouloir quitter ?")
  (are-you-sure-quit "Etes-vous certain de vouloir quitter ?")
  
  ;;; autosaving
  (error-autosaving "Erreur durant l'auto-sauvegarde de \"~a\".")
  (autosaving-turned-off "L'auto-sauvegarde est suspendue\njusqu' ce que le fichier soit sauvegard.")
  (recover-autosave-files-frame-title "Recouvrer des fichiers auto-sauvegards")
  (autosave-details "Dtails")
  (autosave-recover "Recouvrer")
  (autosave-unknown-filename "<<inconnu>>")
  
  ;; these are labels in a dialog that drscheme displays
  ;; if you have leftover autosave files. to see the dialog,
  ;; start up drscheme and modify (but don't save) a file
  ;; (also, do this with an unsaved file). Wait for the autosave
  ;; files to appear (typically 5 minutes). Kill DrScheme
  ;; and restart it. You'll see the dialog
  (autosave-autosave-label: "Fichier auto-sauvegard :")
  (autosave-original-label: "Fichier original :")
  (autosave-autosave-label "Fichier auto-sauvegard")
  (autosave-original-label "Fichier original")
  (autosave-compare-files "Comparer les fichiers auto-sauvegards")
  
  (autosave-show-autosave "Auto-sauvegarder un fichier") ;; title of a window showing the autosave file
  
  (autosave-explanation "DrScheme a trouv des fichiers auto-sauvegards, qui peuvent contenir votre travail non-sauvegard.")
  
  (autosave-recovered! "Recouvr !") ;; status of an autosave file
  (autosave-deleted "Effac")       ;; status of an autosave file
  
  (autosave-error-deleting "Erreur durant l'effacement de ~a\n\n~a") ;; first is a filename, second is an error message from mz.
  (autosave-delete-button "Effacer")
  (autosave-delete-title "Effacer")  ;; title of a dialog asking for deletion confirmation
  (autosave-done "Continuer")
  
  ;; appears in the file dialog
  (autosave-restore-to-where? "Slectionnez un rpertoire o sauvegarder le fichier auto-sauvegard.")
  
  
  ;;; file modified warning
  (file-has-been-modified
   "Ce fichier a t modifi depuis sa dernire sauvegarde. Voulez-vous craser les modifications ?")
  (overwrite-file-button-label "Ecraser")
  
  (definitions-modified 
   "Le texte de la fentre de dfinition a t modifi directement sur le disque dur. Sauvegardez ou retournez  la version sur le disque.")
  (drscheme-internal-error "Erreur interne de DrScheme.")
  
  ;;; tools
  (invalid-tool-spec "La spcification d'outil qui se trouve dans le fichier info.ss de la collection ~a est invalide. Esprait soit une chane de caractres, soit une liste de chanes de caractres, trouv : ~e")
  (error-loading-tool-title "DrScheme - Erreur durant le chargement de l'outil ~s; ~s")
  (error-invoking-tool-title "Erreur durant l'invocation de l'outil ~s;~s")
  (tool-tool-names-same-length
   "`tool-names' et `tools' ne sont pas des listes de la mme longueur, dans le fichier info.ss pour ~s. Trouv ~e et ~e")
  (tool-tool-icons-same-length
   "`tool-icons' et `tools' ne sont pas des listes de la mme longueur, dans le fichier info.ss pour ~s. Trouv ~e et ~e")
  (tool-tool-urls-same-length
   "`tool-urls' et `tools' ne sont pas des listes de la mme longueur, dans le fichier info.ss pour ~s. Trouv ~e et ~e")
  (error-getting-info-tool
   "erreur durant le chargement du fichier info.ss pour ~s")
  (tool-error-phase1 "Erreur durant la phase 1 pour l'outil ~s; ~s")
  (tool-error-phase2 "Erreur durant la phase 2 oour l'outil ~s; ~s")
  
  
  ;;; define popup menu
  (end-of-buffer-define "<< fin du tampon >>")
  (sort-by-name "Trier par nom")
  (sort-by-position "Trier par position dans le fichier")
  (no-definitions-found "<< aucune dfinition trouve >>")
  (jump-to-defn "Aller  la dfinition de ~a")
  
  (recent-items-sort-by-age "Trier par age")
  (recent-items-sort-by-name "Trier par nom")
  
  ;;; view menu
  (hide-definitions-menu-item-label "Cacher les &dfinitions")
  (show-definitions-menu-item-label "Montrer les &dfinitions")
  (definitions-menu-item-help-string "Cacher/montrer la fentre de dfinition")
  (show-interactions-menu-item-label "Montrer les &interactions")
  (hide-interactions-menu-item-label "Cacher les &interactions")
  (interactions-menu-item-help-string "Montrer/cacher la fentre d'interaction")
  (show-toolbar "Montrer la barre d'ou&tils")
  (hide-toolbar "Cacher la barre d'ou&tils")
  
  ;;; file menu
  (save-definitions-as "Sauvegarder les dfinitions...")
  (save-definitions "&Sauvegarder les dfinitions")
  (print-definitions "&Imprimer les dfinitions...")
  (about-drscheme "A propos de DrScheme")
  (save-other "Sauvegarder autre")
  (save-definitions-as-text "Sauvegarder les dfinitions au format texte...")
  (save-interactions "Sauvegarder les interactions")
  (save-interactions-as "Sauvegarder les interactions...")
  (save-interactions-as-text "Sauvegarder les interactions au format texte...")
  (print-interactions "Imprimer les interactions...")
  (new-tab "Nouvel onglet")
  (close-tab "Fermer l'onglet")
  
  ;;; edit-menu
  (split-menu-item-label "Di&viser")
  (collapse-menu-item-label "&Rassembler")
  
  ;;; language menu
  (language-menu-name "&Langage")
  
  ;;; scheme-menu
  (scheme-menu-name "&Scheme")
  (execute-menu-item-label "Excuter")
  (execute-menu-item-help-string "Rexcuter le program de la fentre de dfinition.")
  (break-menu-item-label "Stopper")
  (break-menu-item-help-string "Stopper l'excution.")
  (kill-menu-item-label "Tuer")
  (kill-menu-item-help-string "Tuer l'excution.")
  (clear-error-highlight-menu-item-label "Effacer le surlignage d'erreur")
  (clear-error-highlight-item-help-string "Efface le surlignage rose aprs une erreur")
  (reindent-menu-item-label "&Rindenter")
  (reindent-all-menu-item-label "Rindenter &tout")
  (semicolon-comment-out-menu-item-label "&Commenter  l'aide de points-virgules")
  (box-comment-out-menu-item-label "&Commenter  l'aide d'une boite")
  (uncomment-menu-item-label "&Dcommenter")
  
  (convert-to-semicolon-comment "Convertir en un commentaire avec points-virgules")
  
  ;;; executables
  (create-executable-menu-item-label "Crer un excutable...")
  (create-executable-title "Crer un excutable")
  (must-save-before-executable "Vous devez sauvegarder votre programme avant de crer un excutable.")
  (save-an-executable "Sauvegarder un excutable")
  (save-a-mred-launcher "Sauvegarder un lanceur de type MrEd")
  (save-a-mzscheme-launcher "Sauvegarder un lanceur de type MzScheme")
  (save-a-mred-stand-alone-executable "Sauvegarder un excutable autonome de type MrEd")
  (save-a-mzscheme-stand-alone-executable "Sauvegarder un excutable autonome de type MzScheme")
  
  (definitions-not-saved "La fentre de dfinition n'a pas t sauvegarde. L'excutable va utiliser la dernire version sauvegarde de la fentre de dfinition. Continuer ?")
  (inline-saved-program-in-executable?
   "Insrer dans l'excutable le programme sauvegard ? Si oui, vous pourrez copier l'excutable sur un autre ordinateur ~a, mais l'excutable sera probablement gros. Si vous choisissez non, vous ne pourrez pas copier l'excutable sur un autre ordinateur, mais il sera bien plus petit. De plus, si vous choisissez non, l'excutable utilisera toujours la version la plus rcente du programme.")
  (use-mred-binary?
   "Utiliser le binaire de mred pour cet excutable ?\n\nSi oui, votre program peut utiliser la bibliothque (lib \"mred.ss\" \"mred\"). Si non, DrScheme va choisir mzscheme comme binaire pour cet excutable.\n\nASi vous n'tes pas sr, choisissez oui.")
  (inline-saved-program-in-executable/windows/path
   "ATTENTION ! L'excutable gnr a besoin de trois DLLs : libmred.dll, libmzsch.gll et libgc.dll, qui sont localises dans\n\n~a\n\nL'excutable trouve les DLLs soit dans le rpertoire ou se trouve l'excutable soit en utilisant la variable d'environnement PATH.\n\nQuand vous avez install DrScheme, l'installateur a modifi le PATH de l'utilisateur pour y inclure le rpertoire dans lequel les DLLs se trouvent. Mfiez-vous des changements de configuration ou des changements faits par l'utilisateur depuis l'installation.\n\nSi vous dplacez l'excutable sur une autre machine, vous devez galement copier les DLLS sur l'autre machine, soit dans le mme rpertoire que l'excutable, soit dans un rpertoire qui figure dans le PATH sur l'autre machine.")
  (launcher "Lanceur")
  (stand-alone "Autonome")
  (executable-type "Type")
  (executable-base "Base")
  (filename "Nom de fichier : ")
  (create "Crer")
  (please-choose-an-executable-filename "Veuillez slectionner un nom de fichier pour sauvegarder l'excutable.")
  (windows-executables-must-end-with-exe
   "Le nom de fichier\n\n  ~a\n\nest illgal. Sous Windows, le nom d'un excutable doit se terminer par .exe.")
  (macosx-executables-must-end-with-app
   "Le nom de fichier\n\n  ~a\n\nest illgal. Sous MacOS X, le nom d'un excutable doit se terminer par .app.")
  (warning-directory-will-be-replaced
   "ATTENTION : le rpertoire :\n\n  ~a\n\nva tre remplac. Voulez-vous continuer ?")
  
  (create-servlet "Crer un servlet...") ;servlet = greffon, extension serveur?
  
  ; the ~a is a language such as "module" or "algol60"
  (create-servlet-unsupported-language
   "La cration de servlets n'est pas possible avec le langage ~a.")
  
  ;;; buttons
  (execute-button-label "Excuter")
  (save-button-label "Sauvegarder")
  (break-button-label "Stopper")
  
  ;;; search help desk popup menu
  (search-help-desk-for "Rechercher \"~a\" dans l'Aide.")
  (exact-lucky-search-help-desk-for "Faire une recherche \"J'ai de la chance\" dans l'Aide pour le texte exact \"~a\".")
  
  ;; collapse and expand popup menu items
  (collapse-sexp "Rtrcir une sexpression")
  (expand-sexp "Elargir une sexpression")
  
  ;;; fraction dialog
  (enter-fraction "Entrer une fraction")
  (whole-part "Partie entire")
  (numerator "Numrateur")
  (denominator "Dnominateur")
  (invalid-number "Nombre invalide : doit tre un nombre rel exact non-entier.")
  (insert-fraction-menu-item-label "Insrer une fraction...")
  
  ;; number snip popup menu
  (show-decimal-expansion "Montrer l'expansion dcimale")
  (show-fraction-view "Montrer sous forme de fraction")
  (show-mixed-fraction-view "Montrer sous forme partie-entire plus fraction")
  (show-improper-fraction-view "Montrer sous forme de fraction")
  (show-more-decimal-places "Montrer plus de dcimales")
  
  ;;; Teachpack messages
  (select-a-teachpack "Slectionner un teachpack")
  (clear-teachpack "Enlever le teachpack ~a")
  (teachpack-error-label "DrScheme - erreur avec un teachpack.")
  (teachpack-dne/cant-read "Le fichier teachpack ~a n'existe pas ou n'est pas lisible.")
  (teachpack-didnt-load "Le fichier teachpack ~a n'a pas t correctement charg.")
  (teachpack-error-invoke "Le fichier teachpack ~a a produit une erreur au moment de son invocation.")
  (add-teachpack-menu-item-label "Ajouter un teachpack...")
  (clear-all-teachpacks-menu-item-label "Enlever tous les teachpacks")
  (drscheme-teachpack-message-title "DrScheme teachpack")
  (already-added-teachpack "Le teachpack ~a a dj t ajout.")
  
  ;;; Language dialog
  (introduction-to-language-dialog
   "Veuillez slectionner un langage. Un tudiant dans un cours d'introduction prfrera le langage par dfaut.")
  (language-dialog-title "Configurer le langage")
  (case-sensitive-label "Diffrentier les lettres majuscules des minuscules.")
  (output-style-label "Style d'impression des rsultats")
  (constructor-printing-style "Constructeur")
  (quasiquote-printing-style "Quasiquote")
  (write-printing-style "write")
  (print-printing-style "current-print")
  (sharing-printing-label "Montrer le partage entre valeurs.")
  (use-pretty-printer-label "Insrer des retours-chariots lors de l'impression des rsultats.")
  (input-syntax "Syntaxe d'entre")
  (dynamic-properties "Proprits dynamiques")
  (output-syntax "Syntaxe de sortie")
  (no-debugging-or-profiling "Pas de dbogage ou profilage") ; Profilage. Eurk...
  (debugging "Dbogage")
  (debugging-and-profiling "Dbogage et profilage")
  (test-coverage "Couverture syntaxique de vos tests")
  (whole/fractional-exact-numbers-label "Imprimer les nombres sous forme de fractions.")
  (booleans-as-true/false-label "Imprimer les boolens sous forme true et false.")
  (show-details-button-label "Montrer les dtails")
  (hide-details-button-label "Cacher les dtails")
  (choose-language-menu-item-label "Slectionner le langage...")
  (revert-to-language-defaults "Retourner aux valeurs par dfaut pour le langage.")
  (language-docs-button-label "Docs langages")
  (fraction-style "Style de fractions")
  (use-mixed-fractions "Fractions mles")
  (use-repeating-decimals "Dcimales rptitives")
  (decimal-notation-for-rationals "Utiliser la notation dcimale pour les nombres rationnels")
  (please-select-a-language "Veuillez slectionner un langage")
  
  
  ;;; languages
  (beginning-student "Etudiant niveau dbutant")
  (beginning-one-line-summary "define, cond, structs, constantes, et primitives")
  (beginning-student/abbrev "Etudiant niveau dbutant avec abrviations pour les listes")
  (beginning/abbrev-one-line-summary "Dbutant, avec impression des rsultats dans le REPL sous forme de listes")
  (intermediate-student "Etudiant niveau intermdiaire")
  (intermediate-one-line-summary "Dbutant plus porte lexicale")
  (intermediate-student/lambda "Etudiant niveau intermdiaire, plus lambda")
  (intermediate/lambda-one-line-summary "Intermdiaire plus fonctions d'ordre suprieur")
  (advanced-student "Etudiant niveau avanc")
  (advanced-one-line-summary "Intermdiaire plus lambda et mutation")
  (full-language "Complet") ;; also in the HtDP languages section
  (how-to-design-programs "How to Design Programs") ;; should agree with MIT Press on this one...
  (r5rs-like-languages "R5RS et langages semblabes")
  (pretty-big-scheme "Assez gros Scheme")
  (pretty-big-scheme-one-line-summary "Graphique, plus de nombreuses bibliothques standards")
  (r5rs-lang-name "Standard (R5RS)")
  (r5rs-one-line-summary "R5RS, de base")
  (expander "Expanseur") ; compression, compresseur, compresser => expansion, expanseur, expanser (expandeur, expander fait trop franglais et expandion n'existe pas)
  (expander-one-line-summary "Expanse les expressions au lieu de les valuer")
  (professional-languages "Langages professionnels")
  (teaching-languages "Langages d'enseignement")
  (experimental-languages "Langages exprimentaux")
  
  (module-language-one-line-summary "Langage avec module comme seule forme")
  
  
  ;;; debug language
  (unknown-debug-frame "[inconnu]")
  (backtrace-window-title "Trace - DrScheme")
  (files-interactions "les interactions de ~a") ;; filled with a filename
  (current-interactions "interactions")
  (current-definitions "dfinitions")
  (mzscheme-w/debug "Textuel (MzScheme)")
  (mzscheme-one-line-summary "PLT Scheme sans la bibliothque graphique")
  (mred-w/debug "Graphique (MrEd)")
  (mred-one-line-summary "PLT Scheme plus la bibliothque graphique")
  
  ;; profiling
  (profiling-low-color "Bas")
  (profiling-high-color "Elev")
  (profiling-choose-low-color "Slectionnez une couleur pour Bas")
  (profiling-choose-high-color "Slectionnez une couleur pour Elev")
  (profiling "Profilage")
  (profiling-example-text "(define (whee) (whee))")
  (profiling-color-config "Gamme de couleurs pour le profil")
  (profiling-scale "Echelle de couleurs pour le profil")
  (profiling-sqrt "Racine Carre")
  (profiling-linear "Linaire")
  (profiling-square "Quadratique")
  (profiling-number "Numbre d'appels de fonctions")
  (profiling-time "Temps cumulatif")
  (profiling-clear "Effacer le profil")
  (profiling-update "Mettre  jour le profil")
  (profiling-col-percent-time "% Temps")
  (profiling-col-function "Fonction")
  (profiling-col-name "Nom")
  (profiling-col-time-in-msec "ms")
  (profiling-col-calls "Appels de fonctions")
  (profiling-show-profile "Montrer le profil")
  (profiling-hide-profile "Cacher le profil")
  (profiling-unknown-src "<< inconnu >>")
  (profiling-no-information-available "Pas d'information de profilage disponible. Assurez vous que l'option de profilage ait t spcifie pour ce langage et que vous ayez excut le programme.")
  (profiling-clear? "Modifier le contenu de la fentre de dfinition invalide le profil. Voulez-vous continuer ?")
  
  ;; test coverage
  (test-coverage-clear? "Modifier le contenu de la fentre de dfinition invalide l'information de couverture de vos tests. Voulez-vous continuer ?")
  (test-coverage-clear-and-do-not-ask-again "Oui, et ne me demandez pas  nouveau")
  (test-coverage-ask? "Demander  propos de l'invalidation de l'information de couverture des tests ?")
  
  ;; tracing
  (tracing-enable-tracing "Traage")
  (tracing-show-tracing-window "Montrer le traage")
  (tracing-hide-tracing-window "Cacher le traage")
  (tracing-tracing-nothing-to-show "Aucun rsultat de traage n'est disponible. Assurez-vous que votre language supporte le traage et que le traage est en place")

  ;;; repl stuff
  (evaluation-terminated "Evaluation termine.")
  (evaluation-terminated-explanation
   "Le thread d'valuation n'est plus en excution, toute valuation est donc impossible jusqu' la prochaine excution.")
  (last-stack-frame "Montrer le dernier appel de fonction sur la pile.")
  (last-stack-frames "Montrer les derniers ~a appels de fonction sur la pile.")
  (next-stack-frames "Montrer les ~a appels de fonction suivants sur la pile.")
  
  ;;; welcoming message in repl
  (language "Langage")
  (custom "personnalis")
  (teachpack "Teachpack")
  (welcome-to "Bienvenue dans")
  (version "version")
  
  ;;; kill evaluation dialog
  (kill-evaluation? "Voulez-vous tuer l'valuation ?")
  (just-break "Simplement stopper")
  (kill "Tuer")
  (kill? "Tuer ?")
  
  ;;; version checker
  ;; the next two are used in the initial wizard dialog.
  ;; Note that vc-wizard-check-prompt can (should) have newlines so
  ;; it will not make the dialog too wide.
  (vc-wizard-check-note "La version des logiciels que vous tes en train d'installer n'est peut-tre pas la dernire.~nSi vous le voulez DrScheme peut regarder pour une version plus rcente.")
  (vc-wizard-check-button "Regarder !")
  (vc-update-check "Vrification des mises  jour")
  (vc-please-wait "Veuillez patienter")
  (vc-connecting-version-server "Connexion au server de version de PLT en cours")
  (vc-network-timeout "Expiration du compte--rebours lors de la connexion rseau")
  (vc-cannot-connect "Impossible de se connecter au serveur de version de PLT")
  (vc-network-failure "Erreur rseau")
  (vc-old-binaries "Les fichiers binaires installs pour DrScheme (ou MzScheme) ne sont pas  jour")
  (vc-binary-information-format "Version binaire installe : ~a (itration ~a)")
  (vc-details-format "~a~nDtails :~n~a")
  (vc-details-text "Dtails :~n")
  (vc-error-format "Erreur : ~a")
  (vc-current-format "~a v.~a (itration ~a) est  jour")
  (vc-update-format "~a v.~a (itration ~a) doit tre remplac par v.~a (itration ~a)")
  (vc-binary-name "Binaire")
  (vc-updates-available "Les mises  jour sont disponibles ")
  (vc-latest-binary-information-format "Version la plus rcente : ~a (itration ~a)")
  (vc-update-dialog-title "Etat des mises  jour")
  (vc-need-update-string "Un ou plusieurs des logiciels PLT installs doivent tre mis  jour")
  (vc-no-update-string "Tous les logiciels PLT installs sont  jour")
  
  ;; special menu
  (special-menu "Spcial")
  
  ;; large semi colon letters
  (insert-large-letters... "Inserer de grandes lettres...")
  (large-semicolon-letters "Grandes lettres en points-virgules")
  (text-to-insert "Texte  inserer")
  
  (module-browser-filename-format "Nom de fichier complet : ~a (~a lignes)")
  (module-browser-root-filename "Nom de fichier de la racine : ~a")
  (module-browser-font-size-gauge-label "Taille de la police")
  (module-browser-progress-label "Avancement du navigateur de modules")
  (module-browser-adding-file "Ajout du fichier : ~a...")
  (module-browser-laying-out-graph-label "Tracer le graph")
  (module-browser-open-file-format "Ouvrir ~a")
  (module-browser "Navigateur de modules") ;; frame title
  (module-browser... "Navigateur de modules...") ;; menu item title
  (module-browser-error-expanding "Erreur durant l'expansion du programme :\n\n~a")
  (module-browser-show-lib-paths "Montrer les fichiers chargs  l'aide de chemins de fichiers du type (lib ..)")
  (module-browser-progress "Navigateur de modules : ~a") ;; prefix in the status line
  (module-browser-compiling-defns "Navigateur de modules : compilation des dfinitions")
  (module-browser-show-lib-paths/short "(require (lib ...))") ;; check box label in show module browser pane in drscheme window.
  (module-browser-refresh "Rafrachir") ;; button label in show module browser pane in drscheme window.
  (module-browser-only-in-plt-and-module-langs
   "Le navigateur de modules n'est disponible que pour les programmes crits dans l'un des langages PLT ou dans le langage \"module\", et seulement pour les programmes qui contiennent des modules.")
  
  (happy-birthday-matthias "Joyeux anniversaire, Matthias !")
  (happy-birthday-matthew "Joyeux anniversaire, Matthew !")
  (happy-birthday-shriram "Joyeux anniversaire, Shriram !")
  
  (mrflow-using-default-language-title "Langage par dfaut utilis")
  (mrflow-using-default-language "Le langage actuellement utilis n'a pas de table de types dfini pour ses primitives. R5RS Scheme est utilis  la place.")
  (mrflow-button-title "Analyzer")
  ;(mrflow-unknown-style-delta-error-title "Delta de Style de bote inconnu")
  ;(mrflow-unknown-style-delta-error "Delta de style de bote inconnu : ~a")
  (mrflow-coloring-error-title "Couleur inconnue")
  (mrflow-coloring-error "Pas de style dfini pour la couleur : ~a")
  (mrflow-popup-menu-show-type "Montrer le type")
  (mrflow-popup-menu-hide-type "Cacher le type")
  (mrflow-popup-menu-show-errors "Montrer les erreurs")
  (mrflow-popup-menu-hide-errors "Cacher les erreurs")
  ;(mrflow-read-exception-title "Exception lecture")
  ;(mrflow-read-exception "Exception durant la lecture : ~a")
  ;(mrflow-syntax-exception-title "Exception syntaxique")
  ;(mrflow-syntax-exception "Exception syntaxique : ~a")
  ;(mrflow-unknown-exception-title "Exception inconnue")
  ;(mrflow-unknown-exception "Exception inconnue : ~a")
  ;(mrflow-language-primitives-error-title "Erreur pour les primitives du langage")
  ;(mrflow-language-primitives-error "Mauvais nom de fichier pour la table des types des primitives du langage : ~a")
  
  (snips-and-arrows-popup-menu-tack-all-arrows "Coller toutes les flches")
  (snips-and-arrows-popup-menu-untack-all-arrows "Dcoller toutes les flches")
  (snips-and-arrows-user-action-disallowed-title "Changements actuellement interdits")
  (snips-and-arrows-user-action-disallowed "Les changements sont interdits dans les diteurs qui contiennent des botes inseres par un outil.  Cachez toutes les botes avant de modifier le contenu de l'diteur.")
  ;(snips-and-arrows-changing-terms-warning-title "Changer les termes ne pourra tre dfait")
  ;(snips-and-arrows-changing-terms-warning "Changer des termes dans un diteur n'est pas une action qui peut tre dfaite. Vous pouvez soit annuler cette action, cacher les botes, et ressayer le changement, soit vous pouvez continuer le changement, auquel cas le changement ne pourra pas tre dfait (tous les autres changements effectus avant ou aprs pourront cependant toujours tre dfaits).")
  (snips-and-arrows-hide-all-snips-in-editor "Cacher les botes de cet diteur")
  
  (xml-tool-menu "XML")
  (xml-tool-insert-xml-box "Insrer une bote XML")
  (xml-tool-insert-scheme-box "Insrer une bote Scheme")
  (xml-tool-insert-scheme-splice-box "Insrer une bote Scheme  raccord")
  (xml-tool-xml-box "Bote XML")
  (xml-tool-scheme-box "Bote Scheme")
  (xml-tool-scheme-splice-box "Bote Scheme  raccord")
  (xml-tool-switch-to-scheme "Changer pour une bote Scheme")
  (xml-tool-switch-to-scheme-splice "Changer pour une bote Scheme  raccord")
  (xml-tool-eliminate-whitespace-in-empty-tags
   "Eliminer les espaces dans les dlimiteurs vides")
  (xml-tool-leave-whitespace-alone
   "Laisser les espaces tel quel")
  
  (show-recent-items-window-menu-item "Montrer les fichiers rcemment ouverts dans une fentre spare")
  (show-recent-items-window-label "Fichiers rcemment ouverts")
  (number-of-open-recent-items "Nombre de fichiers rcents")
  (switch-anyway "Changer de fichier quand mme")
  
  (stepper-program-has-changed "Avertissement : le programme a t modifi.")
  (stepper-program-window-closed "Avertissement : la fentre du programme a disparu.")
  
  (wizard-next "Suivant")
  (wizard-back "Prcdent")
  (wizard-finish "Fin")
  
  ;; warnings about closing a drscheme frame when the program
  ;; might still be doing something interesting
  (program-is-still-running "Le programme dans la fentre de dfinition est toujours en cours d'excution. Fermer la fentre quand mme ?")
  (program-has-open-windows "Le programme dans la fentre de dfinition a d'autres fentres ouvertes. Fermer la fentre quand mme ?")
  
  ;; ml-command-line-arguments is for the command line arguments
  ;; label in the module language details in the language dialog.
  (ml-command-line-arguments "Arguments de ligne de commande, sous forme d'un vecteur de chanes de caractres (syntaxe de read)")

  ;; ml-cp names are all for the module language collection path
  ;; configuration. See the details portion of the language dialog
  ;; for the module language (at the bottom).
  (ml-cp-default-collection-path "<<chemins de rpertoires pour les collections par dfaut>>")
  
  ;; in std get-directory 
  (ml-cp-choose-a-collection-path "Choisissez un chemin de rpertoire pour une collection")
  
  ;; err msg when adding default twice
  (ml-cp-default-already-present
   "Les chemins de rpertoires pour les collections par dfaut sont dj prsents")
  
  ;; title of this section of the dialog (possibly the word
  ;; `Collection' should not be translated)
  (ml-cp-collection-paths "Chemins de rpertoires pour les collections")
  
  ;; button labels
  (ml-cp-add "Ajouter")
  (ml-cp-add-default "Ajouter les chemins par dfaut")
  (ml-cp-remove "Enlever")
  (ml-cp-raise "Monter")
  (ml-cp-lower "Descendre")

  ;; Profj
  (profj-java "Java")
  (profj-java-mode "mode Java")
  (profj-java-mode-color-keyword "mot rserv")
  (profj-java-mode-color-string "chane de caractres")
  (profj-java-mode-color-literal "valeur litrale")
  (profj-java-mode-color-comment "commentaire")
  (profj-java-mode-color-error "erreur")
  (profj-java-mode-color-identifier "identificateur") ; l'acadmie franaise ne reconnat pas ce mot
  (profj-java-mode-color-default "valeur par dfaut")
  
  ;; The Test Suite Tool
  ;; Errors
  (test-case-empty-error "Test vide")
  (test-case-too-many-expressions-error "Expressions trop nombreuses dans un test.")
  (test-case-not-at-top-level "Test n'est pas au premier niveau")
  ;; Dr. Scheme window menu items
  (test-case-insert "Insrer un test")
  (test-case-disable-all "Invalider tous les tests")
  (test-case-enable-all "Revalider tous les tests")
  ;; NOTE: The following three string constants are labels of the test-case fields. The width
  ;;       of the field is determined by the length of the longest of the following three words.
  ;;       if the words are too long the test case will take up too much horizontal room and
  ;;       not look very good.
  ;; This string is the label of the expression that is being tested in a test case.
  (test-case-to-test " tester")
  ;; This string is the label of the expression that is the expected value of the to-test expression.
  (test-case-expected "Attendu")
  ;; This string is the label of the actual result of the to test expression.
  (test-case-actual "Reu")
  
  )
