/******************************************************************************
 * ftvhelp.cpp,v 1.0 2000/09/06 16:09:00
 *
 * Kenney Wong <kwong@ea.com>
 *
 * Folder Tree View for offline help on browsers that do not support HTML Help.
 * Uses the FTV structure from: 
 * http://www.geocities.com/Paris/LeftBank/2178/ftexample.html
 */

#include <stdio.h>
#include <stdlib.h>
#include <qlist.h>
#include <qdict.h>
#include <qfileinfo.h>

#include "ftvhelp.h"
#include "config.h"
#include "message.h"
#include "doxygen.h"
#include "language.h"


const char treeview_data[]=
#include "treeview.h"
;

unsigned char ftv2blank_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x96, 0xd6, 0x11, 0x47, 0x00, 0x00, 0x00,
  0x02, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x01, 0x01, 0x94, 0xfd, 0xae, 0x00,
  0x00, 0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77,
  0x61, 0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20,
  0x32, 0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00,
  0x25, 0x74, 0x45, 0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
  0x00, 0x55, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x47, 0x49, 0x46, 0x20, 0x53,
  0x6d, 0x61, 0x72, 0x74, 0x53, 0x61, 0x76, 0x65, 0x72, 0x20, 0x56, 0x65,
  0x72, 0x20, 0x32, 0x2e, 0x30, 0x21, 0xf8, 0xd7, 0x5e, 0x53, 0x00, 0x00,
  0x00, 0x14, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x38, 0xc0, 0x80,
  0x80, 0x1f, 0x30, 0xe0, 0x7f, 0x42, 0x90, 0x00, 0x02, 0x00, 0x78, 0x3c,
  0x32, 0xcb, 0x72, 0x8f, 0x7c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2blank_png_len = 174;

unsigned char ftv2doc_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x5f, 0x54, 0x71, 0x2d, 0x00, 0x00, 0x00,
  0x15, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff,
  0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xb3, 0xbd, 0xfb, 0xc8, 0x00, 0x00, 0x00, 0x01, 0x74, 0x52,
  0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, 0x16, 0x74,
  0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00,
  0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32, 0x2e, 0x34, 0x2e,
  0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x76, 0x49, 0x44, 0x41,
  0x54, 0x78, 0xda, 0x63, 0x60, 0x60, 0x60, 0x60, 0x63, 0x60, 0x60, 0x64,
  0x00, 0x01, 0x27, 0x30, 0x62, 0x71, 0x01, 0xe2, 0x24, 0x06, 0x38, 0x60,
  0x71, 0x00, 0xca, 0x27, 0x33, 0x30, 0x30, 0x01, 0x31, 0xa3, 0x32, 0x03,
  0x0a, 0x70, 0x54, 0x32, 0x01, 0x53, 0x69, 0x60, 0x71, 0x27, 0x08, 0x15,
  0x1a, 0x1a, 0xca, 0x80, 0x01, 0x5c, 0x5c, 0xc0, 0x94, 0xa2, 0x90, 0x02,
  0x88, 0x52, 0x4b, 0x52, 0x05, 0x53, 0x69, 0xc8, 0x94, 0x18, 0x84, 0x52,
  0x52, 0x12, 0xc5, 0x69, 0x0a, 0x36, 0xe0, 0xa4, 0xa4, 0xa4, 0x68, 0x82,
  0xc4, 0x51, 0x82, 0x6b, 0x04, 0x71, 0x14, 0x4d, 0x61, 0x4e, 0x55, 0x04,
  0xf2, 0x60, 0x1c, 0x27, 0x45, 0x24, 0x19, 0x90, 0x01, 0x70, 0x19, 0x67,
  0x63, 0x20, 0x30, 0xc5, 0x6f, 0x23, 0x00, 0xf5, 0xd0, 0x11, 0xe0, 0x55,
  0x83, 0x47, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
  0x42, 0x60, 0x82
};
unsigned int ftv2doc_png_len = 255;

unsigned char ftv2folderclosed_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x5f, 0x54, 0x71, 0x2d, 0x00, 0x00, 0x00,
  0x12, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0xc0, 0xc0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x42,
  0xee, 0x40, 0xe1, 0x00, 0x00, 0x00, 0x01, 0x74, 0x52, 0x4e, 0x53, 0x00,
  0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, 0x16, 0x74, 0x45, 0x58, 0x74,
  0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x67, 0x69, 0x66,
  0x32, 0x70, 0x6e, 0x67, 0x20, 0x32, 0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e,
  0x47, 0x0e, 0x00, 0x00, 0x00, 0x7d, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda,
  0x8d, 0x8e, 0xc1, 0x0a, 0x84, 0x30, 0x10, 0x43, 0x23, 0x8c, 0x77, 0x0f,
  0xfb, 0x03, 0x42, 0xbd, 0x2b, 0xf8, 0x01, 0x65, 0x6d, 0xef, 0xa2, 0xcd,
  0xff, 0xff, 0x8a, 0x33, 0xad, 0xee, 0x5a, 0xf6, 0xb0, 0x06, 0xda, 0xf0,
  0x86, 0xa6, 0x13, 0x00, 0x88, 0x40, 0x03, 0x53, 0x02, 0x82, 0x9a, 0xd7,
  0x51, 0x42, 0x25, 0xae, 0x7a, 0x76, 0xa0, 0xed, 0xea, 0x79, 0x79, 0x17,
  0x49, 0x73, 0xe1, 0xf2, 0x32, 0x14, 0x8f, 0x5f, 0x49, 0xb9, 0xed, 0x23,
  0x60, 0x20, 0xcd, 0x36, 0x66, 0xe4, 0x40, 0x4b, 0xb4, 0xdb, 0xdb, 0xe5,
  0x16, 0xee, 0x16, 0x78, 0x20, 0xf9, 0x96, 0x15, 0x6d, 0xc2, 0x8b, 0xa2,
  0x6e, 0xf9, 0x50, 0x64, 0xa6, 0x70, 0xb6, 0x50, 0x0a, 0xd3, 0x78, 0x86,
  0x98, 0xa6, 0xde, 0x5d, 0x9d, 0x25, 0xcd, 0xfe, 0xdf, 0xc6, 0x03, 0xa0,
  0x13, 0x15, 0x98, 0x60, 0xbd, 0x81, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x49,
  0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2folderclosed_png_len = 259;

unsigned char ftv2folderopen_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x5f, 0x54, 0x71, 0x2d, 0x00, 0x00, 0x00,
  0x15, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff,
  0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x80, 0x92, 0x32, 0x8c, 0xe5, 0x00, 0x00, 0x00, 0x01, 0x74, 0x52,
  0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, 0x16, 0x74,
  0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00,
  0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32, 0x2e, 0x34, 0x2e,
  0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x7c, 0x49, 0x44, 0x41,
  0x54, 0x78, 0xda, 0x85, 0x8d, 0x41, 0x0e, 0x82, 0x30, 0x10, 0x45, 0x5f,
  0x08, 0xf5, 0x1e, 0x2d, 0x53, 0xd6, 0xc6, 0x18, 0xd7, 0x8d, 0x18, 0xd7,
  0x06, 0xd2, 0x1e, 0xa0, 0xb1, 0xde, 0xff, 0x08, 0x3a, 0x20, 0x21, 0x10,
  0xa2, 0x6f, 0xf3, 0xfe, 0xff, 0x8b, 0x19, 0x80, 0x0a, 0x6a, 0x14, 0x81,
  0x3c, 0x06, 0x2a, 0x61, 0xc5, 0xd3, 0x43, 0x69, 0xc1, 0xb4, 0xab, 0xf9,
  0x70, 0xac, 0x83, 0xca, 0xbb, 0xfb, 0xa4, 0x8b, 0xae, 0x26, 0x46, 0xb6,
  0x4c, 0x0f, 0xe8, 0xc3, 0x18, 0xfa, 0xb3, 0x7d, 0xa8, 0x1a, 0xeb, 0x17,
  0xa5, 0x46, 0x54, 0x46, 0x4e, 0x2a, 0xe2, 0xce, 0x95, 0x3d, 0xba, 0xb0,
  0x64, 0x93, 0x85, 0x9b, 0x0b, 0x73, 0x71, 0x83, 0x75, 0xd7, 0xf2, 0xa7,
  0x90, 0xf2, 0x20, 0x9d, 0xfb, 0x16, 0xd2, 0xeb, 0x43, 0xf9, 0xfd, 0xf2,
  0x0d, 0xa4, 0x29, 0x14, 0xcb, 0xda, 0x47, 0xac, 0x44, 0x00, 0x00, 0x00,
  0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2folderopen_png_len = 261;

unsigned char ftv2lastnode_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x4c, 0x83, 0x31, 0xd9, 0x00, 0x00, 0x00,
  0x30, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x18, 0xd3, 0xa0, 0x90, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x26,
  0x74, 0x45, 0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00,
  0x55, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x47, 0x49, 0x46, 0x20, 0x53, 0x6d,
  0x61, 0x72, 0x74, 0x53, 0x61, 0x76, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72,
  0x20, 0x32, 0x2e, 0x30, 0x69, 0x01, 0x6f, 0x3f, 0xcd, 0x06, 0x00, 0x00,
  0x00, 0x13, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x60, 0x18, 0x30,
  0xc0, 0x4f, 0x0c, 0x03, 0x04, 0xc8, 0x33, 0x1e, 0x00, 0x24, 0xa7, 0x00,
  0x88, 0x10, 0xca, 0x33, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
  0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2lastnode_png_len = 233;

unsigned char ftv2link_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x5f, 0x54, 0x71, 0x2d, 0x00, 0x00, 0x00,
  0x30, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x00, 0x80, 0x00, 0xff,
  0xff, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xff, 0x00, 0x80, 0x80, 0x80,
  0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x7e, 0x9b, 0x08, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x26,
  0x74, 0x45, 0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00,
  0x55, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x47, 0x49, 0x46, 0x20, 0x53, 0x6d,
  0x61, 0x72, 0x74, 0x53, 0x61, 0x76, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72,
  0x20, 0x32, 0x2e, 0x30, 0x19, 0x02, 0xd9, 0x09, 0xe5, 0x4a, 0x00, 0x00,
  0x00, 0x90, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x7d, 0x8c, 0xb1, 0x0a,
  0xc2, 0x30, 0x14, 0x45, 0x6f, 0x33, 0xb4, 0x63, 0x7e, 0xa1, 0x53, 0x57,
  0x8b, 0x7e, 0x80, 0x6e, 0xae, 0x16, 0x5a, 0xb2, 0xbe, 0x3a, 0x64, 0x35,
  0xb8, 0x64, 0xec, 0x2f, 0x07, 0x05, 0x1d, 0x9f, 0x79, 0x8d, 0x21, 0x50,
  0xd0, 0x03, 0xc9, 0xcd, 0xe1, 0xbe, 0x17, 0x00, 0xa8, 0x00, 0x82, 0xe0,
  0x81, 0x66, 0x7d, 0xc0, 0x9e, 0x51, 0x70, 0x40, 0x1d, 0xcf, 0xad, 0x07,
  0x18, 0x1b, 0x74, 0x90, 0xdb, 0x1c, 0x62, 0x0f, 0xe2, 0x20, 0xc1, 0xcc,
  0x61, 0x3b, 0x06, 0x6a, 0xbb, 0x14, 0x3b, 0xe9, 0x68, 0xba, 0xac, 0x51,
  0x9d, 0x24, 0xec, 0xdc, 0x4b, 0x68, 0xed, 0xd2, 0x5e, 0x1b, 0x7e, 0xfd,
  0x92, 0xa8, 0x6d, 0x84, 0xb2, 0x28, 0x28, 0x38, 0xca, 0xd2, 0x4c, 0x46,
  0x2d, 0x59, 0xcc, 0x38, 0x5c, 0x8b, 0xcc, 0xe3, 0xfe, 0x2b, 0x71, 0xfa,
  0x79, 0xbc, 0x67, 0x79, 0x85, 0x07, 0x54, 0x69, 0xde, 0xde, 0x2f, 0xf8,
  0xcf, 0x07, 0x71, 0x95, 0x2b, 0xa1, 0x10, 0x78, 0xd0, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2link_png_len = 358;

unsigned char ftv2mlastnode_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x02, 0x03, 0x00, 0x00, 0x01, 0xc3, 0xc3, 0xc4, 0x79, 0x00, 0x00, 0x00,
  0x09, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x00,
  0x00, 0x00, 0x3c, 0x5e, 0xbb, 0x2c, 0x00, 0x00, 0x00, 0x01, 0x74, 0x52,
  0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, 0x16, 0x74,
  0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00,
  0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32, 0x2e, 0x34, 0x2e,
  0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x23, 0x49, 0x44, 0x41,
  0x54, 0x78, 0xda, 0x63, 0x60, 0x20, 0x0b, 0x08, 0x08, 0x20, 0x10, 0x0a,
  0x60, 0x84, 0x11, 0x8c, 0xa1, 0xa1, 0x20, 0x06, 0x90, 0xc9, 0xa8, 0xb5,
  0x50, 0x10, 0xca, 0x02, 0x89, 0x61, 0x01, 0x00, 0x6d, 0x17, 0x02, 0xba,
  0xc0, 0xdc, 0x69, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
  0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2mlastnode_png_len = 160;

unsigned char ftv2mnode_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x4c, 0x83, 0x31, 0xd9, 0x00, 0x00, 0x00,
  0x24, 0x50, 0x4c, 0x54, 0x45, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x53, 0xbe, 0x1e, 0x99, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x2a,
  0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x60, 0xa0, 0x2e, 0xe0, 0x06,
  0x42, 0x74, 0x02, 0xa7, 0x52, 0x54, 0x06, 0xf7, 0x6e, 0x20, 0x80, 0xf1,
  0xc1, 0x62, 0xdc, 0x4c, 0x4a, 0x4a, 0xdc, 0xdc, 0xdc, 0xc8, 0x22, 0x30,
  0x35, 0x98, 0xda, 0xd1, 0x19, 0x00, 0xb7, 0x79, 0x07, 0x27, 0xaa, 0xf7,
  0x96, 0x03, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
  0x60, 0x82
};
unsigned int ftv2mnode_png_len = 194;

unsigned char ftv2node_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x4c, 0x83, 0x31, 0xd9, 0x00, 0x00, 0x00,
  0x30, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x18, 0xd3, 0xa0, 0x90, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x26,
  0x74, 0x45, 0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00,
  0x55, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x47, 0x49, 0x46, 0x20, 0x53, 0x6d,
  0x61, 0x72, 0x74, 0x53, 0x61, 0x76, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72,
  0x20, 0x32, 0x2e, 0x30, 0x69, 0x01, 0x6f, 0x3f, 0xcd, 0x06, 0x00, 0x00,
  0x00, 0x15, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x60, 0x18, 0x30,
  0xc0, 0x4f, 0x0c, 0x03, 0x04, 0x88, 0x56, 0x8c, 0xc2, 0x00, 0x00, 0x2e,
  0x52, 0x00, 0xe2, 0xfa, 0x45, 0x3a, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x49,
  0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2node_png_len = 235;

unsigned char ftv2plastnode_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x02, 0x03, 0x00, 0x00, 0x01, 0xc3, 0xc3, 0xc4, 0x79, 0x00, 0x00, 0x00,
  0x09, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x00,
  0x00, 0x00, 0x3c, 0x5e, 0xbb, 0x2c, 0x00, 0x00, 0x00, 0x01, 0x74, 0x52,
  0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, 0x16, 0x74,
  0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00,
  0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32, 0x2e, 0x34, 0x2e,
  0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x28, 0x49, 0x44, 0x41,
  0x54, 0x78, 0xda, 0x63, 0x60, 0x20, 0x0b, 0x08, 0x08, 0x30, 0x08, 0x81,
  0x11, 0x90, 0x81, 0x02, 0x18, 0x61, 0x04, 0x63, 0x68, 0x28, 0x90, 0x60,
  0x02, 0x32, 0x19, 0xb5, 0x16, 0x0a, 0x42, 0x59, 0x20, 0x31, 0x2c, 0x00,
  0x00, 0x6e, 0xc1, 0x02, 0xc2, 0xe5, 0xed, 0x75, 0xa7, 0x00, 0x00, 0x00,
  0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2plastnode_png_len = 165;

unsigned char ftv2pnode_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x4c, 0x83, 0x31, 0xd9, 0x00, 0x00, 0x00,
  0x24, 0x50, 0x4c, 0x54, 0x45, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x53, 0xbe, 0x1e, 0x99, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x30,
  0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x60, 0xa0, 0x2e, 0xe0, 0x06,
  0x42, 0x06, 0x6e, 0x26, 0x38, 0x01, 0xe2, 0xe2, 0x54, 0x8a, 0xca, 0xe0,
  0xde, 0x0d, 0x04, 0x10, 0x3e, 0x13, 0x44, 0x8c, 0x9b, 0x49, 0x49, 0x89,
  0x9b, 0x9b, 0x1b, 0x59, 0x04, 0xa6, 0x06, 0x53, 0x3b, 0x3a, 0x03, 0x00,
  0xba, 0x6b, 0x07, 0x2f, 0xaa, 0xcb, 0x1f, 0x6f, 0x00, 0x00, 0x00, 0x00,
  0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
unsigned int ftv2pnode_png_len = 200;

unsigned char ftv2vertline_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x16,
  0x04, 0x03, 0x00, 0x00, 0x01, 0x4c, 0x83, 0x31, 0xd9, 0x00, 0x00, 0x00,
  0x30, 0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x18, 0xd3, 0xa0, 0x90, 0x00, 0x00, 0x00,
  0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00,
  0x00, 0x16, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
  0x72, 0x65, 0x00, 0x67, 0x69, 0x66, 0x32, 0x70, 0x6e, 0x67, 0x20, 0x32,
  0x2e, 0x34, 0x2e, 0x32, 0xa3, 0x5e, 0x47, 0x0e, 0x00, 0x00, 0x00, 0x26,
  0x74, 0x45, 0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00,
  0x55, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x47, 0x49, 0x46, 0x20, 0x53, 0x6d,
  0x61, 0x72, 0x74, 0x53, 0x61, 0x76, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72,
  0x20, 0x32, 0x2e, 0x30, 0x69, 0x01, 0x6f, 0x3f, 0xcd, 0x06, 0x00, 0x00,
  0x00, 0x0f, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0x63, 0x60, 0x18, 0x30,
  0xc0, 0x4f, 0x5b, 0x06, 0x00, 0x21, 0x14, 0x00, 0xa6, 0xe5, 0x3c, 0xe8,
  0x3a, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
  0x82
};
unsigned int ftv2vertline_png_len = 229;


struct ImageInfo
{
  const char *name;
  unsigned char *data;
  unsigned int len;
} image_info[] =
{
  { "ftv2blank.png",ftv2blank_png,ftv2blank_png_len },
  { "ftv2doc.png",ftv2doc_png,ftv2doc_png_len },
  { "ftv2folderclosed.png",ftv2folderclosed_png,ftv2folderclosed_png_len },
  { "ftv2folderopen.png",ftv2folderopen_png,ftv2folderopen_png_len },
  { "ftv2lastnode.png",ftv2lastnode_png,ftv2lastnode_png_len },
  { "ftv2link.png",ftv2link_png,ftv2link_png_len },
  { "ftv2mlastnode.png",ftv2mlastnode_png,ftv2mlastnode_png_len },
  { "ftv2mnode.png",ftv2mnode_png,ftv2mnode_png_len },
  { "ftv2node.png",ftv2node_png,ftv2node_png_len },
  { "ftv2plastnode.png",ftv2plastnode_png,ftv2plastnode_png_len },
  { "ftv2pnode.png",ftv2pnode_png,ftv2pnode_png_len },
  { "ftv2vertline.png",ftv2vertline_png,ftv2vertline_png_len },
  { 0,0,0 }
};

static void generateFolderTreeViewData()
{
  // Generate tree view script
  QCString fileName=Config_getString("HTML_OUTPUT")+"/treeview.js";
  QFile f(fileName);
  if (!f.open(IO_WriteOnly))
  {
    err("Cannot open file %s for writing!\n",fileName.data());
    return;
  }
  else
  {
    QTextStream t(&f);
    t << treeview_data;
    f.close();
  }

  // Generate alternative index.html as a frame
  fileName=Config_getString("HTML_OUTPUT")+"/index"+htmlFileExtension;
  f.setName(fileName);
  if (!f.open(IO_WriteOnly))
  {
    err("Cannot open file %s for writing!\n",fileName.data());
    return;
  }
  else
  {
    QTextStream t(&f);
#if QT_VERSION >= 200
    t.setEncoding(QTextStream::Latin1);
#endif
    t << "<html><head>";
    t << "<meta http-equiv=\"Content-Type\" content=\"text/html;charset="
      << theTranslator->idLanguageCharset() << "\">\n";
    t << "<title>"; 
    if (Config_getString("PROJECT_NAME").isEmpty())
    {
      t << "Doxygen Documentation";
    }
    else
    {
      t << Config_getString("PROJECT_NAME");
    }
    t << "</title></head>" << endl;
    t << "<frameset cols=\"" << Config_getInt("TREEVIEW_WIDTH") << ",*\">" << endl;
    t << "  <frame src=\"tree" << htmlFileExtension << "\" name=\"treefrm\">" << endl;
    t << "  <frame src=\"main" << htmlFileExtension << "\" name=\"basefrm\">" << endl;
    t << "</frameset>" << endl;
    t << "</html>" << endl;
    f.close();
  }
  
  // Generate tree view frame
  fileName=Config_getString("HTML_OUTPUT")+"/tree"+htmlFileExtension;
  f.setName(fileName);
  if (!f.open(IO_WriteOnly))
  {
    err("Cannot open file %s for writing!\n",fileName.data());
    return;
  }
  else
  {
    QTextStream t(&f);
    t << "<html><head>" << endl;
    t << "<link rel=\"stylesheet\" href=\"";
    QCString cssname=Config_getString("HTML_STYLESHEET");
    if (cssname.isEmpty())
    {
      t << "doxygen.css";
    }
    else
    {
      QFileInfo cssfi(cssname);
      if (!cssfi.exists())
      {
        err("Error: user specified HTML style sheet file does not exist!\n");
      }
      t << cssfi.fileName();
    }
    t << "\">" << endl;
    t << "<script src=\"treeview.js\"></script>" << endl;
    t << "<script src=\"tree.js\"></script>" << endl;
    t << "<script>" << endl;
    t << "initializeDocument()" << endl;
    t << "</script>" << endl;
    t << "</head>" << endl;
    t << "<body bgcolor=\"#ffffff\">" << endl;
    t << "</body>" << endl;
    t << "</html>" << endl;
    f.close();
  }

  // Generate tree view images
  ImageInfo *p = image_info;
  while (p->name)
  {
    QCString fileName=Config_getString("HTML_OUTPUT")+"/"+p->name;
    QFile f(fileName);
    if (f.open(IO_WriteOnly)) 
      f.writeBlock((char *)p->data,p->len);
    else
    {
      fprintf(stderr,"Warning: Cannot open file %s for writing\n",fileName.data());
    }
    f.close();
    p++;
  }
}

//----------------------------------------------------------------------------

FTVHelp *FTVHelp::m_theInstance = 0;

/*! Construm_cts an ftv help object. 
 *  The object has to be \link initialize() initialized\endlink before it can 
 *  be used.
 */
FTVHelp::FTVHelp()
{
  /* initial depth */
  m_dc = 0;
  m_cf = 0;
}

/*! return a reference to the one and only instance of this class. 
 */
FTVHelp *FTVHelp::getInstance()
{
  if (m_theInstance==0) m_theInstance = new FTVHelp;
  return m_theInstance;
}

/*! This will create a folder tree view table of contents file (tree.js).
 *  \sa finalize()
 */
void FTVHelp::initialize()
{
  /* open the contents file */
  QCString fName = Config_getString("HTML_OUTPUT") + "/tree.js";
  m_cf = new QFile(fName);
  if (!m_cf->open(IO_WriteOnly))
  {
    err("Could not open file %s for writing\n",fName.data());
    exit(1);
  }
  /* Write the header of the contents file */
  m_cts.setDevice(m_cf);
#if QT_VERSION >= 200
  m_cts.setEncoding(QTextStream::Latin1);
#endif

  m_cts << "foldersTree = gFld(\"<b>";
  if (Config_getString("PROJECT_NAME").isEmpty())
  {
    m_cts << "Root";
  }
  else
  {
    m_cts << Config_getString("PROJECT_NAME");
  }
  m_cts << "</b>\", \"\", \"\")\n";
}

/*! Finalizes the FTV help. This will finish and close the
 *  contents file (index.js).
 *  \sa initialize()
 */
void FTVHelp::finalize()
{
  m_cts.unsetDevice();
  m_cf->close();
  delete m_cf;
  generateFolderTreeViewData();
}

/*! Increase the level of the contents hierarchy. 
 *  This will start a new sublist in contents file.
 *  \sa decContentsDepth()
 */
int FTVHelp::incContentsDepth()
{
  //int i; for (i=0;i<m_dc+1;i++) m_cts << "  ";
  return ++m_dc;
}

/*! Decrease the level of the contents hierarchy.
 *  This will end the current sublist.
 *  \sa incContentsDepth()
 */
int FTVHelp::decContentsDepth()
{
  //int i; for (i=0;i<m_dc;i++) m_cts << "  ";
  return --m_dc;
}

/*! Add a list item to the contents file.
 *  \param isDir TRUE if the item is a directory, FALSE if it is a text
 *  \param ref  the URL of to the item.
 *  \param file the file containing the definition of the item
 *  \param anchor the anchor within the file.
 *  \param name the name of the item.
 */
void FTVHelp::addContentsItem(bool isDir,
                              const char *ref,
                              const char *file,
                              const char *anchor, 
                              const char *name
                             )
{
  int i; for (i=0;i<m_dc;i++) m_cts << "  ";
  QCString parent;
  QCString tagName = ref;
  QCString tagDir;
  if (ref)
  {
    tagName += ":";
    QCString *s = Doxygen::tagDestinationDict[ref];
    if (s)
    {
      tagDir = *s + "/";
      tagName += tagDir;
    }
  }
  if (m_dc==0) parent="foldersTree"; else parent.sprintf("aux%d",m_dc); 
  if (isDir) // directory entry
  {
    m_cts << "aux" << m_dc+1 << " = insFld(" << parent << ", gFld(\"" 
          << name << "\", \"" << tagName << "\", ";
    if (file)      // file optional param
    {
      m_cts << "\"" << tagDir << file << htmlFileExtension << "\"))";
    }
    else
    {
      m_cts << "\"\"))";
    }
  }
  else // text entry
  {
    m_cts << "     insDoc(" << parent << ", gLnk(\"" 
          << name << "\", \"" << tagName << "\", ";
    if (file)      // ref optional param
    {
      m_cts << "\"" << tagDir << file << htmlFileExtension;
      if (anchor) m_cts << "#" << anchor;  
      m_cts << "\"))";
    }
    else
    {
      m_cts << "\"\"))";
    }
  }
  m_cts << "\n";
}

