/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIResponse;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIInteractionData
extends CMICategory
implements Serializable {
    public Element id = new Element("", "checkIdentifier", "NULL", true, false, false);
    public Vector objectives;
    public Element time = new Element("", "checkTime", "NULL", true, false, false);
    public Element type = new Element("", "checkVocabulary", "Interaction", true, false, false);
    public Vector correct_responses;
    public Element weighting = new Element("", "checkDecimal", "NULL", true, false, false);
    public Element student_response = new Element("", "checkFeedback", "NULL", true, false, false);
    public Element result = new Element("", "checkVocabulary", "Result", true, false, false);
    public Element latency = new Element("", "checkTimespan", "NULL", true, false, false);
    private boolean initialized = false;

    public CMIInteractionData() {
        super(true);
        this.correct_responses = new Vector();
        this.objectives = new Vector();
    }

    public Element getID() {
        return this.id;
    }

    public Element getLatency() {
        return this.latency;
    }

    public Element getResult() {
        return this.result;
    }

    public Element getStudentResponse() {
        return this.student_response;
    }

    public Element getTime() {
        return this.time;
    }

    public Element getType() {
        return this.type;
    }

    public Element getWeighting() {
        return this.weighting;
    }

    public Vector getObjID() {
        return this.objectives;
    }

    public Vector getCorrectResponses() {
        return this.correct_responses;
    }

    public void setID(String inId) {
        this.id.setValue(inId);
        this.initialized = true;
    }

    public void setLatency(String inLatency) {
        this.latency.setValue(inLatency);
        this.initialized = true;
    }

    public void setResult(String inResult) {
        this.result.setValue(inResult);
        this.initialized = true;
    }

    public void setStudentResponse(String inStudentResponse) {
        this.student_response.setValue(inStudentResponse);
        this.initialized = true;
    }

    public void setTime(String inTime) {
        this.time.setValue(inTime);
        this.initialized = true;
    }

    public void setType(String inType) {
        this.type.setValue(inType);
        this.initialized = true;
    }

    public void setWeighting(String inWeighting) {
        this.weighting.setValue(inWeighting);
        this.initialized = true;
    }

    public void setObjID(String inObjId, int index) {
        this.objectives.add(index, inObjId);
    }

    public void setCorrectResponses(CMIResponse inResponse, int index) {
        this.correct_responses.add(index, inResponse);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tInteractionData::performSet()");
        }
        String token = theRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\t\tProcessing next token: " + token);
        }
        if (theRequest.hasMoreTokensToProcess()) {
            if (token.equals("objectives")) {
                token = theRequest.getNextToken();
                if (DebugIndicator.ON) {
                    System.out.println("\t\tProcessing next token " + token);
                }
                this.performSetForObjID(token, theRequest, dmErrorMgr);
            } else if (token.equals("correct_responses")) {
                token = theRequest.getNextToken();
                if (DebugIndicator.ON) {
                    System.out.println("\t\tProcessing next token " + token);
                }
                this.performSetForResponse(token, theRequest, dmErrorMgr);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("\t\tError - Data Model Element not implemented");
                    System.out.println("\t\tElement being processed: " + token + " is not a valid element of the CMI Interactions\n" + "Data Model Category");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else if (theRequest.isAKeywordRequest()) {
            dmErrorMgr.recKeyWordError(theRequest.getElement());
        } else {
            if (DebugIndicator.ON) {
                System.out.println("\t\tPerforming set");
            }
            this.doSet(this, token, theRequest.getValue(), dmErrorMgr);
            this.initialized = true;
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting CMIInteractionData::peformSet()");
        }
    }

    private void performSetForObjID(String token, CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::performSetForObjID()");
        }
        int arrayIndex = this.getArrayIndex(token, theRequest, dmErrorMgr);
        String value = theRequest.getValue();
        try {
            boolean result;
            if (DebugIndicator.ON) {
                System.out.println("\t\tChecking to see if an element already exists");
                System.out.println("\t\tat array position " + arrayIndex);
            }
            Element tmpElement = (Element)this.objectives.elementAt(arrayIndex);
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement already exists");
                System.out.println("\t\tVector size: " + this.objectives.size());
            }
            if (result = this.validateType(this, tmpElement, "id", value, dmErrorMgr)) {
                tmpElement.setValue(value);
                this.objectives.set(arrayIndex, tmpElement);
                if (DebugIndicator.ON) {
                    System.out.println("\t\tVector size: " + this.objectives.size());
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("***** INVALID LMSSetValue() CALL *****");
                    System.out.println("          Invalid Type                ");
                    System.out.println("Element was NOT set!");
                    System.out.println("");
                    System.out.println("\t\tVector size: " + this.objectives.size());
                }
                dmErrorMgr.SetCurrentErrorCode("405");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement does not already exists");
            }
            if (arrayIndex <= this.objectives.size()) {
                Element tmpElement = new Element(theRequest.getValue(), "checkIdentifier", "NULL", true, false, false);
                boolean result = this.validateType(this, tmpElement, "id", theRequest.getValue(), dmErrorMgr);
                if (result) {
                    this.objectives.add(arrayIndex, tmpElement);
                    if (DebugIndicator.ON) {
                        System.out.println("\t\tVector size: " + this.objectives.size());
                    }
                } else {
                    if (DebugIndicator.ON) {
                        System.out.println("***** INVALID LMSSetValue() CALL *****");
                        System.out.println("          Invalid Type                ");
                        System.out.println("Element was NOT set!");
                        System.out.println("");
                        System.out.println("\t\tVector size: " + this.objectives.size());
                    }
                    dmErrorMgr.SetCurrentErrorCode("405");
                }
            }
            dmErrorMgr.SetCurrentErrorCode("201");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting performSetForObjID()");
        }
    }

    private void performSetForResponse(String token, CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::performSetForResponses()");
        }
        int arrayIndex = this.getArrayIndex(token, theRequest, dmErrorMgr);
        String value = theRequest.getValue();
        try {
            if (DebugIndicator.ON) {
                System.out.println("\t\tChecking to see if an element already exists");
                System.out.println("\t\tat array position " + arrayIndex);
            }
            CMIResponse tmpResponse = (CMIResponse)this.correct_responses.elementAt(arrayIndex);
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement already exists");
                System.out.println("\t\tSet the value in the element and replace");
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
            tmpResponse.performSet(theRequest, dmErrorMgr);
            this.correct_responses.set(arrayIndex, tmpResponse);
            if (DebugIndicator.ON) {
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement does not already exists");
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
            if (arrayIndex <= this.correct_responses.size()) {
                CMIResponse response = new CMIResponse();
                response.performSet(theRequest, dmErrorMgr);
                this.correct_responses.add(arrayIndex, response);
                if (DebugIndicator.ON) {
                    System.out.println("\t\tVector size: " + this.correct_responses.size());
                }
            }
            dmErrorMgr.SetCurrentErrorCode("201");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting performSetForResponses()");
        }
    }

    private int getArrayIndex(String token, CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        int index = -1;
        try {
            Integer tmpInt = new Integer(token);
            index = tmpInt;
        }
        catch (NumberFormatException nfe) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tError - Data Model Element not implemented");
                System.out.println("\t\tInvalid data model element: " + theRequest.getRequest());
                System.out.println("\t\tInvalid element " + token + ", Array index expected");
            }
            dmErrorMgr.SetCurrentErrorCode("401");
        }
        return index;
    }

    public String getCount(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::getCount()");
        }
        String result = new String("");
        String token = theRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\t\tProcessing next token: " + token);
        }
        if (token.equals("objectives")) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tProcessing objectives._count");
            }
            int count = 0;
            count = this.objectives.size();
            if (DebugIndicator.ON) {
                System.out.println("\t\tNumber of objective ids: " + count);
            }
            Integer tmpInt = new Integer(count);
            result = tmpInt.toString();
        } else if (token.equals("correct_responses")) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tInteractionData:correct_responses._count");
            }
            int count = 0;
            count = this.correct_responses.size();
            if (DebugIndicator.ON) {
                System.out.println("\t\tNumber of correct_responses: " + count);
            }
            Integer tmpInt = new Integer(count);
            result = tmpInt.toString();
        } else {
            if (DebugIndicator.ON) {
                System.out.println("\t\tInvalid LMSGetValue() request: " + theRequest.getRequest());
                System.out.println("\t\tSCO is not permitted to call LMSGetValue() for cmi.interactions");
            }
            dmErrorMgr.SetCurrentErrorCode("404");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tReturning from getCount() count returning: " + result);
        }
        return result;
    }
}

