import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * Page for the section of the OL
 */
public class OLSectionPage extends WizardPage{

	/**
	 * Constructs a new page
	 */
	public OLSectionPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("OLSectionTitle"));
	}

	/** start text entry widget */
	private TextView enterView;
	/** start entry buffer */
	private TextBuffer enterBuffer;

	/** end text entry widget */
	private TextView exitView;
	/** end Text entry buffer */
	private TextBuffer exitBuffer;
	
	/**
	 * Generate the widgets and set the defaults
	 */
	protected void preShow(){
		System.out.println("OLSection preShow()");
		VBox mainVBox = new VBox(false, 5);

		Label intro = new Label( DomesdayGUI.messages.getString("OLSectionHead"));
		intro.setLineWrap(true);
		mainVBox.packStart(intro,false, false, 5);

		Label enter = new Label( DomesdayGUI.messages.getString("OLSectionStart"));
		mainVBox.packStart(enter, false, false, 0);
	
		enterBuffer = new TextBuffer();
		enterView = new TextView(enterBuffer);
		enterView.setCursorVisible(true);
		try{
			enterBuffer.setText(DomesdayGUI.project.getStringSetting("OL_SEC_START"));
		}catch(Exception e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		
		ScrolledWindow win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(enterView);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);

		Label exit = new Label( DomesdayGUI.messages.getString("OLSectionEnd"));
		mainVBox.packStart(exit, false, false, 0);

		exitBuffer = new TextBuffer();
		exitView = new TextView(exitBuffer);
		exitView.setCursorVisible(true);
		try{
			exitBuffer.setText(DomesdayGUI.project.getStringSetting("OL_SEC_END"));
		}catch(Exception e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		

		win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(exitView);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);

		mainVBox.showAll();
		content =  mainVBox;
	}

	/**
	 * Save the settings
	 */
	protected void postShow(){
		 try{
			DomesdayGUI.project.storeSettingByVar("OL_SEC_START", enterBuffer.getText( enterBuffer.getStartIter(), enterBuffer.getEndIter(), false) );
			DomesdayGUI.project.storeSettingByVar("OL_SEC_END", exitBuffer.getText( exitBuffer.getStartIter(), exitBuffer.getEndIter(), false) );
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
	}
}
