/**
 * A class for storing Keys to HashMaps and other things.
 * These keys are used throughout the Index Generator program, particularly as
 * keys for values in IGFile records. The integer values of the static final
 * keys are also used in bits to determine wanted data.
 */
public class IGKey {
    /*
     * Used value histogram:
     *    0:1,2,3,4,5,6,7,8,9
     *   10:0
     *  100:0,1,2
     *  200:0,1,2,3,4,5
     * 1000:0,1,2
     */

    /** Value used to access title preference */
    public static final IGKey TITLE = new IGKey(1);

    /** Value used to access title preference */
    public static final IGKey AUTHOR = new IGKey(2);

    /** Value used to access title preference */
    public static final IGKey DESCRIPTION = new IGKey(3);

    /** Value used to access title preference */
    public static final IGKey KEYWORDS = new IGKey(4);

    /**  The size of the file (in bytes in the IGFile records) */
    public static final IGKey FILE_SIZE = new IGKey(5);

    /** A String for the file type, e.g. HTML */
    public static final IGKey FILE_TYPE = new IGKey(6);

    /** A String Describing the parser  */
    public static final IGKey PARSER = new IGKey(7);

    /**
     * The name of the file, excluding path. In the case of URLs with no file
     * name, this should be the final section.
     */
    public static final IGKey FILE_NAME = new IGKey(8);

    /**
     * Location relative to the output file. (If it is not possible, this will
     * be an absolute reference)
     */
    public static final IGKey REL_LOCATION = new IGKey(9);

    /** The real location of the file, as used to retrieve it */
    public static final IGKey LOCATION = new IGKey(10);

    /** The character encoding of the file */
    public static final IGKey FILE_ENCODING = new IGKey(11);

    /** Value used to access URL preference */
    public static final IGKey URLS = new IGKey(12);

    /** location separated into sections for each directory - used by sitemapgen */
    public static final IGKey FILE_PARTS = new IGKey(13);


    /** The character of the current section, used in ordered list indices */
    public static final IGKey SECTION_LETTER = new IGKey(100);

    /** The character of the current section, used in ordered list indices */
    public static final IGKey FULL_DIR = new IGKey(101);

    /** The character of the current section, used in ordered list indices */
    public static final IGKey TOP_DIR = new IGKey(102);

    /*
     * Attributes used in IGPlaceholder
     */
    public static final IGKey FILE_SIZE_HUMAN = new IGKey(200);
    public static final IGKey FILE_SIZE_BYTES = new IGKey(201);
    public static final IGKey FILE_SIZE_KB = new IGKey(202);
    public static final IGKey FILE_SIZE_MB = new IGKey(203);
    public static final IGKey FORMAT = new IGKey(204);
    public static final IGKey LIST_SEPARATOR = new IGKey(205);

    /**
     * The following are used by {@link IGReplace}
     */
    public static final IGKey REPLACE_TYPE_FILE = new IGKey(1000);
    public static final IGKey REPLACE_TYPE_DIRECTORY = new IGKey(1001);
    public static final IGKey REPLACE_TYPE_SECTION = new IGKey(1002);

    /** Value of the key - used for instantiations of this. */
    private int value = -1;


    /** Constructs a new IGKey object */
    protected IGKey(int index) {
        value = index;
    }


    /**
     * Determines whether two keys are equal
     * @param other The IGKey object to compare with this
     * @return <tt>true</tt> if this key equals the other.  <tt>false</tt>
     *  otherwise.
     */
    public boolean equals(Object other) {
	if (other == null || ! (other instanceof IGKey))
	    return false;

        return equals((IGKey) other);
    }


    /**
     * Determines whether two keys are equal
     * @param other The IGKey to compare with this
     * @return <tt>true</tt> if this key equals the other.  <tt>false</tt>
     *  otherwise.
     */
    public boolean equals(IGKey other) {
	if (other == null)
	    return false;

	return value == other.getValue();
    }


    /**
     * Retrieve the value of an IGKey
     * @return The int value of the key
     */
    public int getValue() {
        return value;
    }
}
