import java.util.*;
/**
 *
 * Class for storing details of a directory. This will be used by the site map
 * generator as a way of organising the records prior to generating the index.
 *
 * <p>The actual file data is stored in IGFile records, which are primarily
 * referenced by the FileList object. This ojbect will provide a secondary
 * reference to the IGFile records.
 * @see SitemapGen
 * <BR><BR>$Id: IGDirectory.java,v 1.5 2002/08/23 10:41:58 howama Exp $
 * 
 * @author Mark Howard
 */
class IGDirectory{
	public String topDir;
	public String fullRelDir;
	public TreeSet files;
	public TreeMap subDirectories;

	public IGDirectory(String highestName, String fullName){
		topDir = highestName;
		fullRelDir = fullName;
		files = new TreeSet( new Comparator () {
		                public int compare(Object o1, Object o2){
                    // TODO IgnoreCase option?
                    return (  ((IGFile) o1).getLocation() ).compareTo(  ((IGFile) o2).getLocation() );
                }
                public boolean equals(Object o2){
					return false;
                }
		
		});
		subDirectories = new TreeMap();
	}
}

/*
 * $Log: IGDirectory.java,v $
 * Revision 1.5  2002/08/23 10:41:58  howama
 * more work
 *
 * Revision 1.4  2002/08/18 14:15:47  howama
 * upodates
 *
 * Revision 1.3  2002/08/16 11:10:31  howama
 * IGFile changes
 *
 * Revision 1.2  2002/08/12 11:04:15  howama
 * changes to use sorted tree data structures
 *
 * Revision 1.1  2002/08/11 19:49:45  howama
 * new object for storing directory details. to be used by sitemapgen
 *
 *
 */
