/**
 * Class for parsing comment strings out of GIF images.
 *
 * @version $Id: GIFParser.java,v 1.4 2002/08/26 02:35:29 blsecres Exp $
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 */
public class GIFParser extends ImageParser implements FileParser {
    /** Search values for comment segment */
    private static byte[] findSegment = {0x21, (byte) 0xfe};

    /** Number of bytes in length field */
    private static int lengthSize = 1;

    /** GIF length headers don't count themselves in comment length */
    private static boolean sizeInLen = false;

    /** File extensions for GIF files */
    private final static String[] extensions = {"gif"};

    /** Mime types for GIF files */
    private final static String[] mimeTypes = {"image/gif"};

    /** GIF file magic signature */
    private final static byte[][] magic = {{0x47, 0x49, 0x46, 0x38, 0x39, 0x61},
	{0x47, 0x49, 0x46, 0x38, 0x37, 0x61}};

    /** GIF headers are always at the beginning of the file */
    private final static boolean magicOffset = false;

    /** GIF headers are case sensitive */
    private final static boolean magicCase = true;

    /** GIF FileMagic structure */
    private final static FileMagic gifMagic = new FileMagic(magic, magicOffset,
	    magicCase);


    /**
     * Construct a new JPEGParser object with the given parsing options.
     * @param logObj The object to use for logging data
     * @param extract The set of desired fields to extract
     */
    public GIFParser() {
	super(findSegment, lengthSize, sizeInLen);
    }


    /**
     * Supply extensions this parser can handle
     * @return String array of file extensions
     */
    public String[] getExtensions() {
	return(extensions);
    }


    /**
     * Supply mime types this parser can handle
     * @return String array of mime types
     */
    public String[] getMimeTypes() {
	return(mimeTypes);
    }


    /**
     * Supply file magic for files this parser can handle
     * @return Array of byte arrays containing magic signature
     */
    public FileMagic getMagic() {
	return(gifMagic);
    }
}
