/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _SIDEBARWIDGET_H_
#define _SIDEBARWIDGET_H_

#include <qwidget.h>
#include <qlayout.h>
#include <kurl.h>

class SidebarWidgetBase : public QWidget
{
	Q_OBJECT
public:
    enum WidgetType {
        WEmpty = 0,
		BuiltinPlaces = 1,
        BuiltinHistory = 2,
		BuiltinNotes = 3,
		BuiltinClipboard = 4,		
        Plugin = 100
    };

    SidebarWidgetBase(QWidget* parent=0, const char* name=0);	
    virtual ~SidebarWidgetBase();

	const QString& title() const;
	const uint wtype() const;

public slots:
	void ContentViewTypeChanged();
	void ContentSelectedItemChanged();
	void URLChanged();

protected slots:
	void ItemSelected(const KURL& url);
	
signals:
	void urlChangeRequest(const KURL& url);

	//virtual QSize sizeHint() const = 0;

protected:
    virtual bool loadWidget(QWidget* parent) = 0;
    virtual bool unloadWidget() = 0;

	WidgetType m_wtype;
    QString m_title;    
	// not used for now
    //QString m_library;

	//TODO: widget icon 

    QWidget* m_view;
	QVBoxLayout* m_layout;



};

#endif
