/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <kurlbar.h>
#include <qfontmetrics.h>
#include <qdir.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kprotocolinfo.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include "sidebarwidget.h"
#include "myplaces.h"

// Inspired by KFileSpeedBar code
// Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>

MyPlacesWidget::MyPlacesWidget(bool useGlobalItems, QWidget* parent) :
	SidebarWidgetBase(parent)
{
	m_wtype = BuiltinPlaces;
	m_title = QString("My places");

	QVBoxLayout* m_layout = new QVBoxLayout(this);
	PlacesBox* m_view = new PlacesBox(useGlobalItems, this);
	m_layout->addWidget(m_view, 0);

	connect(m_view, SIGNAL(activated(const KURL&)),
		this, SLOT(ItemSelected(const KURL&)));
}


MyPlacesWidget::~MyPlacesWidget()
{
}


bool MyPlacesWidget::loadWidget(QWidget* /*parent*/)
{
	return true;
}

bool MyPlacesWidget::unloadWidget()
{
	return true;
}


PlacesBox::PlacesBox(bool useGlobalItems, QWidget* parent) :
	KURLBar(useGlobalItems, parent)
{
 	setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Expanding) );
	setIconSize(KIcon::SizeSmallMedium);
	readConfig( KGlobal::config(), "KFileDialog Speedbar" );
}

PlacesBox::~PlacesBox()
{
}

QSize PlacesBox::sizeHint() const
{
	QSize sizeHint = KURLBar::sizeHint();
	int ems = KURLBar::fontMetrics().width("mmmmmmmmmmmmmmmm");
	if (sizeHint.width() < ems)
	{
		sizeHint.setWidth(ems);
	}
	return sizeHint;
}
