/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "editbookmarkdialog.h"
#include <qgrid.h>
#include <klocale.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <kiconloader.h>
#include <qpushbutton.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kicondialog.h>
#include <qhbox.h>

#include "bookmark.h"

EditBookmarkDialog::~EditBookmarkDialog()
{
}

bool EditBookmarkDialog::getBookmark(Bookmark& bookmark, const QString& title)
{
    EditBookmarkDialog dialog(bookmark, title);
    return dialog.exec() != 0;
}

void EditBookmarkDialog::slotOk()
{
    m_bookmark.setIcon(m_iconName);
    m_bookmark.setName(m_name->text());
    m_bookmark.setURL(KURL(m_location->text()));

    KDialogBase::slotOk();
}

EditBookmarkDialog::EditBookmarkDialog(Bookmark& bookmark,
                                       const QString& title) :
    KDialogBase(Plain, title, Ok|Cancel, Ok),
    m_iconButton(0),
    m_name(0),
    m_location(0),
    m_bookmark(bookmark)
{
    QVBoxLayout* topLayout = new QVBoxLayout(plainPage(), 0, spacingHint());

    QGrid* grid = new QGrid(2, Qt::Horizontal, plainPage());
    grid->setSpacing(spacingHint());

    // create icon widgets
    new QLabel(i18n("Icon:"), grid);
    m_iconName = bookmark.icon();
    m_iconButton = new QPushButton(SmallIcon(m_iconName), QString::null, grid);
    m_iconButton->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(m_iconButton, SIGNAL(clicked()),
            this, SLOT(selectIcon()));

    // create name widgets
    new QLabel(i18n("Name:"), grid);
    m_name = new QLineEdit(bookmark.name(), grid);
    m_name->selectAll();
    m_name->setFocus();

    // create location widgets
    new QLabel(i18n("Location:"), grid);

    QHBox* locationBox = new QHBox(grid);
    locationBox->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);
    locationBox->setSpacing(spacingHint());
    m_location = new QLineEdit(bookmark.url().prettyURL(), locationBox);
    m_location->setMinimumWidth(320);

    QPushButton* selectLocationButton = new QPushButton(SmallIcon("folder"), QString::null, locationBox);
    selectLocationButton->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(selectLocationButton, SIGNAL(clicked()),
            this, SLOT(selectLocation()));

    topLayout->addWidget(grid);
}

void EditBookmarkDialog::selectIcon()
{
    const QString iconName(KIconDialog::getIcon(KIcon::Small, KIcon::FileSystem));
    if (!iconName.isEmpty()) {
        m_iconName = iconName;
        m_iconButton->setIconSet(SmallIcon(iconName));
    }
}

void EditBookmarkDialog::selectLocation()
{
    const QString location(m_location->text());
    KURL url(KFileDialog::getExistingURL(location));
    if (!url.isEmpty()) {
        m_location->setText(url.prettyURL());
    }
}

#include "editbookmarkdialog.moc"
