// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'uflacs'
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H
#include <cmath>
#include <cstring>
#include <stdexcept>
#include <ufc.h>

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', tetrahedron, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 4;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_0();
  }

};


class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 12;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 3;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 3;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[4] = vals[1];
    values[8] = vals[2];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[5] = vals[1];
    values[9] = vals[2];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[6] = vals[1];
    values[10] = vals[2];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    values[7] = vals[1];
    values[11] = vals[2];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
    dof_coordinates[24] = coordinate_dofs[0];
    dof_coordinates[25] = coordinate_dofs[1];
    dof_coordinates[26] = coordinate_dofs[2];
    dof_coordinates[27] = coordinate_dofs[3];
    dof_coordinates[28] = coordinate_dofs[4];
    dof_coordinates[29] = coordinate_dofs[5];
    dof_coordinates[30] = coordinate_dofs[6];
    dof_coordinates[31] = coordinate_dofs[7];
    dof_coordinates[32] = coordinate_dofs[8];
    dof_coordinates[33] = coordinate_dofs[9];
    dof_coordinates[34] = coordinate_dofs[10];
    dof_coordinates[35] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 3;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

};


class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Real', tetrahedron, 0)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 0;
  }

  const char * family() const final override
  {
    return "Real";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
      y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
      y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    dof_coordinates[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    dof_coordinates[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_2();
  }

};


class hyperelasticity_dofmap_0: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 4;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 3;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    case 3:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
    dofs[3] = entity_indices[0][3];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 2;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 3;
          break;
        }
      case 2:
        {
          dofs[0] = 1;
        dofs[1] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 4:
        {
          dofs[0] = 0;
        dofs[1] = 2;
          break;
        }
      case 5:
        {
          dofs[0] = 0;
        dofs[1] = 1;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_0();
  }

};


class hyperelasticity_dofmap_1: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 3*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 12;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 9;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 6;
        break;
      }
    case 2:
      {
        return 9;
        break;
      }
    case 3:
      {
        return 12;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + entity_indices[0][0];
    dofs[9] = offset + entity_indices[0][1];
    dofs[10] = offset + entity_indices[0][2];
    dofs[11] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 2;
        dofs[1] = 3;
        dofs[2] = 6;
        dofs[3] = 7;
        dofs[4] = 10;
        dofs[5] = 11;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 3;
        dofs[2] = 5;
        dofs[3] = 7;
        dofs[4] = 9;
        dofs[5] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 5;
        dofs[3] = 6;
        dofs[4] = 9;
        dofs[5] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 3;
        dofs[2] = 4;
        dofs[3] = 7;
        dofs[4] = 8;
        dofs[5] = 11;
          break;
        }
      case 4:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 6;
        dofs[4] = 8;
        dofs[5] = 10;
          break;
        }
      case 5:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 4;
        dofs[3] = 5;
        dofs[4] = 8;
        dofs[5] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
        dofs[4] = 6;
        dofs[5] = 7;
        dofs[6] = 9;
        dofs[7] = 10;
        dofs[8] = 11;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 6;
        dofs[5] = 7;
        dofs[6] = 8;
        dofs[7] = 10;
        dofs[8] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 7;
        dofs[6] = 8;
        dofs[7] = 9;
        dofs[8] = 11;
          break;
        }
      case 3:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 6;
        dofs[6] = 8;
        dofs[7] = 9;
        dofs[8] = 10;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
      dofs[6] = 6;
      dofs[7] = 7;
      dofs[8] = 8;
      dofs[9] = 9;
      dofs[10] = 10;
      dofs[11] = 11;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 3;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_1();
  }

};


class hyperelasticity_dofmap_2: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Real', tetrahedron, 0)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 1;
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  std::size_t num_entity_closure_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = 0;
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  void tabulate_entity_closure_dofs(std::size_t * dofs,
                                    std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      case 4:
        {
          
          break;
        }
      case 5:
        {
          
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      case 3:
        {
          
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_2();
  }

};


class hyperelasticity_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_0_otherwise() : ufc::cell_integral()
  {

  }

  ~hyperelasticity_cell_integral_0_otherwise() override
  {

  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
static const std::vector<bool> enabled({true, true, false, true, true});
return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 2
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 2
    //   quadrature_degree:           2
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights4[4] = { 0.0416666666666667, 0.0416666666666667, 0.0416666666666667, 0.0416666666666667 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 4 tables for 4 quadrature points
    alignas(32) static const double FE33_C0_D001_Q4[1][1][4] = { { { -1.0, 0.0, 0.0, 1.0 } } };
    alignas(32) static const double FE33_C0_D010_Q4[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE33_C0_D100_Q4[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE33_C0_Q4[1][4][4] =
        { { { 0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011 },
            { 0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011 },
            { 0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969 },
            { 0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011 } } };
    // Reset element tensor
    memset(A, 0, 12 * sizeof(*A));
    // Unstructured piecewise computations
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE33_C0_D100_Q4[0][0][ic - 0];
    }
    const double J_c4 = coordinate_dofs[1] * FE33_C0_D010_Q4[0][0][0] + coordinate_dofs[4] * FE33_C0_D010_Q4[0][0][1] + coordinate_dofs[7] * FE33_C0_D010_Q4[0][0][2];
    const double J_c8 = coordinate_dofs[2] * FE33_C0_D001_Q4[0][0][0] + coordinate_dofs[5] * FE33_C0_D001_Q4[0][0][1] + coordinate_dofs[8] * FE33_C0_D001_Q4[0][0][2] + coordinate_dofs[11] * FE33_C0_D001_Q4[0][0][3];
    const double J_c5 = coordinate_dofs[1] * FE33_C0_D001_Q4[0][0][0] + coordinate_dofs[4] * FE33_C0_D001_Q4[0][0][1] + coordinate_dofs[7] * FE33_C0_D001_Q4[0][0][2] + coordinate_dofs[10] * FE33_C0_D001_Q4[0][0][3];
    const double J_c7 = coordinate_dofs[2] * FE33_C0_D010_Q4[0][0][0] + coordinate_dofs[5] * FE33_C0_D010_Q4[0][0][1] + coordinate_dofs[8] * FE33_C0_D010_Q4[0][0][2];
    const double J_c0 = coordinate_dofs[0] * FE33_C0_D100_Q4[0][0][0] + coordinate_dofs[3] * FE33_C0_D100_Q4[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE33_C0_D010_Q4[0][0][0] + coordinate_dofs[3] * FE33_C0_D010_Q4[0][0][1] + coordinate_dofs[6] * FE33_C0_D010_Q4[0][0][2];
    const double J_c6 = coordinate_dofs[2] * FE33_C0_D100_Q4[0][0][0] + coordinate_dofs[5] * FE33_C0_D100_Q4[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE33_C0_D100_Q4[0][0][0] + coordinate_dofs[4] * FE33_C0_D100_Q4[0][0][1];
    const double J_c2 = coordinate_dofs[0] * FE33_C0_D001_Q4[0][0][0] + coordinate_dofs[3] * FE33_C0_D001_Q4[0][0][1] + coordinate_dofs[6] * FE33_C0_D001_Q4[0][0][2] + coordinate_dofs[9] * FE33_C0_D001_Q4[0][0][3];
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE33_C0_D010_Q4[0][0][ic - 0];
    }
    double w0_d2_c0 = 0.0;
    for (int ic = 0; ic < 4; ++ic)
    {
        w0_d2_c0 += w[0][ic] * FE33_C0_D001_Q4[0][0][ic - 0];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 4; ic < 6; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE33_C0_D100_Q4[0][0][ic - 4];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 4; ic < 7; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE33_C0_D010_Q4[0][0][ic - 4];
    }
    double w0_d2_c1 = 0.0;
    for (int ic = 4; ic < 8; ++ic)
    {
        w0_d2_c1 += w[0][ic] * FE33_C0_D001_Q4[0][0][ic - 4];
    }
    double w0_d0_c2 = 0.0;
    for (int ic = 8; ic < 10; ++ic)
    {
        w0_d0_c2 += w[0][ic] * FE33_C0_D100_Q4[0][0][ic - 8];
    }
    double w0_d1_c2 = 0.0;
    for (int ic = 8; ic < 11; ++ic)
    {
        w0_d1_c2 += w[0][ic] * FE33_C0_D010_Q4[0][0][ic - 8];
    }
    double w0_d2_c2 = 0.0;
    for (int ic = 8; ic < 12; ++ic)
    {
        w0_d2_c2 += w[0][ic] * FE33_C0_D001_Q4[0][0][ic - 8];
    }
    alignas(32) double sp4[392];
    sp4[0] = J_c4 * J_c8;
    sp4[1] = J_c5 * J_c7;
    sp4[2] = -1 * sp4[1];
    sp4[3] = sp4[0] + sp4[2];
    sp4[4] = J_c0 * sp4[3];
    sp4[5] = J_c5 * J_c6;
    sp4[6] = J_c3 * J_c8;
    sp4[7] = -1 * sp4[6];
    sp4[8] = sp4[5] + sp4[7];
    sp4[9] = J_c1 * sp4[8];
    sp4[10] = sp4[4] + sp4[9];
    sp4[11] = J_c3 * J_c7;
    sp4[12] = J_c4 * J_c6;
    sp4[13] = -1 * sp4[12];
    sp4[14] = sp4[11] + sp4[13];
    sp4[15] = J_c2 * sp4[14];
    sp4[16] = sp4[10] + sp4[15];
    sp4[17] = sp4[3] / sp4[16];
    sp4[18] = w0_d0_c0 * sp4[17];
    sp4[19] = -1 * J_c8;
    sp4[20] = J_c3 * sp4[19];
    sp4[21] = sp4[5] + sp4[20];
    sp4[22] = sp4[21] / sp4[16];
    sp4[23] = w0_d1_c0 * sp4[22];
    sp4[24] = sp4[18] + sp4[23];
    sp4[25] = sp4[14] / sp4[16];
    sp4[26] = w0_d2_c0 * sp4[25];
    sp4[27] = sp4[24] + sp4[26];
    sp4[28] = 1 + sp4[27];
    sp4[29] = J_c2 * J_c7;
    sp4[30] = -1 * J_c1;
    sp4[31] = J_c8 * sp4[30];
    sp4[32] = sp4[29] + sp4[31];
    sp4[33] = sp4[32] / sp4[16];
    sp4[34] = w0_d0_c1 * sp4[33];
    sp4[35] = J_c0 * J_c8;
    sp4[36] = -1 * J_c2;
    sp4[37] = J_c6 * sp4[36];
    sp4[38] = sp4[35] + sp4[37];
    sp4[39] = sp4[38] / sp4[16];
    sp4[40] = w0_d1_c1 * sp4[39];
    sp4[41] = sp4[34] + sp4[40];
    sp4[42] = J_c1 * J_c6;
    sp4[43] = J_c0 * J_c7;
    sp4[44] = -1 * sp4[43];
    sp4[45] = sp4[42] + sp4[44];
    sp4[46] = sp4[45] / sp4[16];
    sp4[47] = w0_d2_c1 * sp4[46];
    sp4[48] = sp4[41] + sp4[47];
    sp4[49] = 1 + sp4[48];
    sp4[50] = J_c1 * J_c5;
    sp4[51] = J_c2 * J_c4;
    sp4[52] = -1 * sp4[51];
    sp4[53] = sp4[50] + sp4[52];
    sp4[54] = sp4[53] / sp4[16];
    sp4[55] = J_c2 * J_c3;
    sp4[56] = J_c0 * J_c5;
    sp4[57] = -1 * sp4[56];
    sp4[58] = sp4[55] + sp4[57];
    sp4[59] = sp4[58] / sp4[16];
    sp4[60] = J_c0 * J_c4;
    sp4[61] = J_c1 * J_c3;
    sp4[62] = -1 * sp4[61];
    sp4[63] = sp4[60] + sp4[62];
    sp4[64] = sp4[63] / sp4[16];
    sp4[65] = sp4[49] * sp4[54];
    sp4[66] = sp4[49] * sp4[59];
    sp4[67] = sp4[49] * sp4[64];
    sp4[68] = w0_d0_c2 * sp4[54];
    sp4[69] = w0_d1_c2 * sp4[59];
    sp4[70] = sp4[68] + sp4[69];
    sp4[71] = w0_d2_c2 * sp4[64];
    sp4[72] = sp4[70] + sp4[71];
    sp4[73] = 1 + sp4[72];
    sp4[74] = sp4[73] * sp4[33];
    sp4[75] = sp4[73] * sp4[39];
    sp4[76] = sp4[73] * sp4[46];
    sp4[77] = w0_d0_c1 * sp4[54];
    sp4[78] = w0_d1_c1 * sp4[59];
    sp4[79] = sp4[77] + sp4[78];
    sp4[80] = w0_d2_c1 * sp4[64];
    sp4[81] = sp4[79] + sp4[80];
    sp4[82] = sp4[81] * sp4[33];
    sp4[83] = sp4[81] * sp4[39];
    sp4[84] = sp4[81] * sp4[46];
    sp4[85] = w0_d0_c2 * sp4[33];
    sp4[86] = w0_d1_c2 * sp4[39];
    sp4[87] = sp4[85] + sp4[86];
    sp4[88] = w0_d2_c2 * sp4[46];
    sp4[89] = sp4[87] + sp4[88];
    sp4[90] = sp4[89] * sp4[54];
    sp4[91] = sp4[89] * sp4[59];
    sp4[92] = sp4[89] * sp4[64];
    sp4[93] = -1 * sp4[82];
    sp4[94] = -1 * sp4[83];
    sp4[95] = -1 * sp4[84];
    sp4[96] = -1 * sp4[90];
    sp4[97] = -1 * sp4[91];
    sp4[98] = -1 * sp4[92];
    sp4[99] = sp4[93] + sp4[65];
    sp4[100] = sp4[94] + sp4[66];
    sp4[101] = sp4[95] + sp4[67];
    sp4[102] = sp4[96] + sp4[74];
    sp4[103] = sp4[97] + sp4[75];
    sp4[104] = sp4[98] + sp4[76];
    sp4[105] = sp4[28] * sp4[99];
    sp4[106] = sp4[28] * sp4[100];
    sp4[107] = sp4[28] * sp4[101];
    sp4[108] = sp4[28] * sp4[102];
    sp4[109] = sp4[28] * sp4[103];
    sp4[110] = sp4[28] * sp4[104];
    sp4[111] = sp4[73] * sp4[49];
    sp4[112] = sp4[81] * sp4[89];
    sp4[113] = -1 * sp4[112];
    sp4[114] = sp4[111] + sp4[113];
    sp4[115] = sp4[114] * sp4[17];
    sp4[116] = sp4[114] * sp4[22];
    sp4[117] = sp4[114] * sp4[25];
    sp4[118] = w0_d0_c2 * sp4[17];
    sp4[119] = w0_d1_c2 * sp4[22];
    sp4[120] = sp4[118] + sp4[119];
    sp4[121] = w0_d2_c2 * sp4[25];
    sp4[122] = sp4[120] + sp4[121];
    sp4[123] = sp4[81] * sp4[122];
    sp4[124] = w0_d0_c1 * sp4[17];
    sp4[125] = w0_d1_c1 * sp4[22];
    sp4[126] = sp4[124] + sp4[125];
    sp4[127] = w0_d2_c1 * sp4[25];
    sp4[128] = sp4[126] + sp4[127];
    sp4[129] = sp4[73] * sp4[128];
    sp4[130] = -1 * sp4[129];
    sp4[131] = sp4[123] + sp4[130];
    sp4[132] = sp4[131] * sp4[33];
    sp4[133] = sp4[131] * sp4[39];
    sp4[134] = sp4[131] * sp4[46];
    sp4[135] = sp4[81] * sp4[17];
    sp4[136] = sp4[81] * sp4[22];
    sp4[137] = sp4[81] * sp4[25];
    sp4[138] = sp4[122] * sp4[54];
    sp4[139] = sp4[122] * sp4[59];
    sp4[140] = sp4[122] * sp4[64];
    sp4[141] = sp4[73] * sp4[17];
    sp4[142] = sp4[73] * sp4[22];
    sp4[143] = sp4[73] * sp4[25];
    sp4[144] = sp4[128] * sp4[54];
    sp4[145] = sp4[128] * sp4[59];
    sp4[146] = sp4[128] * sp4[64];
    sp4[147] = -1 * sp4[144];
    sp4[148] = -1 * sp4[145];
    sp4[149] = -1 * sp4[146];
    sp4[150] = -1 * sp4[141];
    sp4[151] = -1 * sp4[142];
    sp4[152] = -1 * sp4[143];
    sp4[153] = sp4[147] + sp4[135];
    sp4[154] = sp4[148] + sp4[136];
    sp4[155] = sp4[149] + sp4[137];
    sp4[156] = sp4[150] + sp4[138];
    sp4[157] = sp4[151] + sp4[139];
    sp4[158] = sp4[152] + sp4[140];
    sp4[159] = w0_d0_c0 * sp4[33];
    sp4[160] = w0_d1_c0 * sp4[39];
    sp4[161] = sp4[159] + sp4[160];
    sp4[162] = w0_d2_c0 * sp4[46];
    sp4[163] = sp4[161] + sp4[162];
    sp4[164] = sp4[163] * sp4[153];
    sp4[165] = sp4[163] * sp4[154];
    sp4[166] = sp4[155] * sp4[163];
    sp4[167] = sp4[156] * sp4[163];
    sp4[168] = sp4[157] * sp4[163];
    sp4[169] = sp4[158] * sp4[163];
    sp4[170] = sp4[105] + sp4[164];
    sp4[171] = sp4[106] + sp4[165];
    sp4[172] = sp4[107] + sp4[166];
    sp4[173] = sp4[108] + sp4[167];
    sp4[174] = sp4[109] + sp4[168];
    sp4[175] = sp4[169] + sp4[110];
    sp4[176] = sp4[132] + sp4[115];
    sp4[177] = sp4[133] + sp4[116];
    sp4[178] = sp4[117] + sp4[134];
    sp4[179] = sp4[128] * sp4[89];
    sp4[180] = sp4[49] * sp4[122];
    sp4[181] = -1 * sp4[180];
    sp4[182] = sp4[179] + sp4[181];
    sp4[183] = sp4[182] * sp4[54];
    sp4[184] = sp4[182] * sp4[59];
    sp4[185] = sp4[182] * sp4[64];
    sp4[186] = sp4[128] * sp4[33];
    sp4[187] = sp4[128] * sp4[39];
    sp4[188] = sp4[128] * sp4[46];
    sp4[189] = sp4[89] * sp4[17];
    sp4[190] = sp4[89] * sp4[22];
    sp4[191] = sp4[89] * sp4[25];
    sp4[192] = sp4[49] * sp4[17];
    sp4[193] = sp4[49] * sp4[22];
    sp4[194] = sp4[49] * sp4[25];
    sp4[195] = sp4[122] * sp4[33];
    sp4[196] = sp4[122] * sp4[39];
    sp4[197] = sp4[122] * sp4[46];
    sp4[198] = -1 * sp4[192];
    sp4[199] = -1 * sp4[193];
    sp4[200] = -1 * sp4[194];
    sp4[201] = -1 * sp4[195];
    sp4[202] = -1 * sp4[196];
    sp4[203] = -1 * sp4[197];
    sp4[204] = sp4[198] + sp4[186];
    sp4[205] = sp4[199] + sp4[187];
    sp4[206] = sp4[200] + sp4[188];
    sp4[207] = sp4[201] + sp4[189];
    sp4[208] = sp4[202] + sp4[190];
    sp4[209] = sp4[203] + sp4[191];
    sp4[210] = w0_d0_c0 * sp4[54];
    sp4[211] = w0_d1_c0 * sp4[59];
    sp4[212] = sp4[210] + sp4[211];
    sp4[213] = w0_d2_c0 * sp4[64];
    sp4[214] = sp4[212] + sp4[213];
    sp4[215] = sp4[204] * sp4[214];
    sp4[216] = sp4[205] * sp4[214];
    sp4[217] = sp4[214] * sp4[206];
    sp4[218] = sp4[214] * sp4[207];
    sp4[219] = sp4[214] * sp4[208];
    sp4[220] = sp4[214] * sp4[209];
    sp4[221] = sp4[170] + sp4[215];
    sp4[222] = sp4[171] + sp4[216];
    sp4[223] = sp4[172] + sp4[217];
    sp4[224] = sp4[173] + sp4[218];
    sp4[225] = sp4[174] + sp4[219];
    sp4[226] = sp4[175] + sp4[220];
    sp4[227] = sp4[176] + sp4[183];
    sp4[228] = sp4[177] + sp4[184];
    sp4[229] = sp4[178] + sp4[185];
    sp4[230] = sp4[28] * sp4[114];
    sp4[231] = sp4[131] * sp4[163];
    sp4[232] = sp4[230] + sp4[231];
    sp4[233] = sp4[182] * sp4[214];
    sp4[234] = sp4[232] + sp4[233];
    sp4[235] = sp4[221] / sp4[234];
    sp4[236] = sp4[222] / sp4[234];
    sp4[237] = sp4[223] / sp4[234];
    sp4[238] = sp4[224] / sp4[234];
    sp4[239] = sp4[225] / sp4[234];
    sp4[240] = sp4[226] / sp4[234];
    sp4[241] = sp4[227] / sp4[234];
    sp4[242] = sp4[228] / sp4[234];
    sp4[243] = sp4[229] / sp4[234];
    sp4[244] = sp4[235] * w[3][0];
    sp4[245] = sp4[236] * w[3][0];
    sp4[246] = sp4[237] * w[3][0];
    sp4[247] = sp4[238] * w[3][0];
    sp4[248] = sp4[239] * w[3][0];
    sp4[249] = sp4[240] * w[3][0];
    sp4[250] = sp4[241] * w[3][0];
    sp4[251] = sp4[242] * w[3][0];
    sp4[252] = sp4[243] * w[3][0];
    sp4[253] = -1 * sp4[244];
    sp4[254] = -1 * sp4[245];
    sp4[255] = -1 * sp4[246];
    sp4[256] = -1 * sp4[247];
    sp4[257] = -1 * sp4[248];
    sp4[258] = -1 * sp4[249];
    sp4[259] = -1 * sp4[250];
    sp4[260] = -1 * sp4[251];
    sp4[261] = -1 * sp4[252];
    sp4[262] = sp4[28] * sp4[17];
    sp4[263] = sp4[28] * sp4[22];
    sp4[264] = sp4[28] * sp4[25];
    sp4[265] = sp4[262] + sp4[262];
    sp4[266] = sp4[263] + sp4[263];
    sp4[267] = sp4[264] + sp4[264];
    sp4[268] = sp4[128] * sp4[17];
    sp4[269] = sp4[128] * sp4[22];
    sp4[270] = sp4[128] * sp4[25];
    sp4[271] = sp4[268] + sp4[268];
    sp4[272] = sp4[269] + sp4[269];
    sp4[273] = sp4[270] + sp4[270];
    sp4[274] = sp4[122] * sp4[17];
    sp4[275] = sp4[122] * sp4[22];
    sp4[276] = sp4[122] * sp4[25];
    sp4[277] = sp4[274] + sp4[274];
    sp4[278] = sp4[275] + sp4[275];
    sp4[279] = sp4[276] + sp4[276];
    sp4[280] = sp4[163] * sp4[33];
    sp4[281] = sp4[163] * sp4[39];
    sp4[282] = sp4[163] * sp4[46];
    sp4[283] = sp4[280] + sp4[280];
    sp4[284] = sp4[281] + sp4[281];
    sp4[285] = sp4[282] + sp4[282];
    sp4[286] = sp4[49] * sp4[33];
    sp4[287] = sp4[49] * sp4[39];
    sp4[288] = sp4[49] * sp4[46];
    sp4[289] = sp4[286] + sp4[286];
    sp4[290] = sp4[287] + sp4[287];
    sp4[291] = sp4[288] + sp4[288];
    sp4[292] = sp4[89] * sp4[33];
    sp4[293] = sp4[89] * sp4[39];
    sp4[294] = sp4[89] * sp4[46];
    sp4[295] = sp4[292] + sp4[292];
    sp4[296] = sp4[293] + sp4[293];
    sp4[297] = sp4[294] + sp4[294];
    sp4[298] = sp4[295] + sp4[277];
    sp4[299] = sp4[296] + sp4[278];
    sp4[300] = sp4[279] + sp4[297];
    sp4[301] = sp4[289] + sp4[271];
    sp4[302] = sp4[290] + sp4[272];
    sp4[303] = sp4[273] + sp4[291];
    sp4[304] = sp4[283] + sp4[265];
    sp4[305] = sp4[284] + sp4[266];
    sp4[306] = sp4[267] + sp4[285];
    sp4[307] = sp4[214] * sp4[54];
    sp4[308] = sp4[214] * sp4[59];
    sp4[309] = sp4[214] * sp4[64];
    sp4[310] = sp4[307] + sp4[307];
    sp4[311] = sp4[308] + sp4[308];
    sp4[312] = sp4[309] + sp4[309];
    sp4[313] = sp4[81] * sp4[54];
    sp4[314] = sp4[81] * sp4[59];
    sp4[315] = sp4[81] * sp4[64];
    sp4[316] = sp4[313] + sp4[313];
    sp4[317] = sp4[314] + sp4[314];
    sp4[318] = sp4[315] + sp4[315];
    sp4[319] = sp4[73] * sp4[54];
    sp4[320] = sp4[73] * sp4[59];
    sp4[321] = sp4[73] * sp4[64];
    sp4[322] = sp4[319] + sp4[319];
    sp4[323] = sp4[320] + sp4[320];
    sp4[324] = sp4[321] + sp4[321];
    sp4[325] = sp4[298] + sp4[322];
    sp4[326] = sp4[299] + sp4[323];
    sp4[327] = sp4[300] + sp4[324];
    sp4[328] = sp4[301] + sp4[316];
    sp4[329] = sp4[302] + sp4[317];
    sp4[330] = sp4[303] + sp4[318];
    sp4[331] = sp4[304] + sp4[310];
    sp4[332] = sp4[305] + sp4[311];
    sp4[333] = sp4[306] + sp4[312];
    sp4[334] = w[3][0] / 2;
    sp4[335] = sp4[325] * sp4[334];
    sp4[336] = sp4[326] * sp4[334];
    sp4[337] = sp4[327] * sp4[334];
    sp4[338] = sp4[328] * sp4[334];
    sp4[339] = sp4[329] * sp4[334];
    sp4[340] = sp4[330] * sp4[334];
    sp4[341] = sp4[331] * sp4[334];
    sp4[342] = sp4[332] * sp4[334];
    sp4[343] = sp4[333] * sp4[334];
    sp4[344] = sp4[253] + sp4[335];
    sp4[345] = sp4[254] + sp4[336];
    sp4[346] = sp4[255] + sp4[337];
    sp4[347] = sp4[256] + sp4[338];
    sp4[348] = sp4[257] + sp4[339];
    sp4[349] = sp4[258] + sp4[340];
    sp4[350] = sp4[259] + sp4[341];
    sp4[351] = sp4[260] + sp4[342];
    sp4[352] = sp4[261] + sp4[343];
    sp4[353] = 2 * sp4[235];
    sp4[354] = 2 * sp4[236];
    sp4[355] = 2 * sp4[237];
    sp4[356] = 2 * sp4[238];
    sp4[357] = 2 * sp4[239];
    sp4[358] = 2 * sp4[240];
    sp4[359] = 2 * sp4[241];
    sp4[360] = 2 * sp4[242];
    sp4[361] = 2 * sp4[243];
    sp4[362] = std::log(sp4[234]);
    sp4[363] = sp4[353] * sp4[362];
    sp4[364] = sp4[354] * sp4[362];
    sp4[365] = sp4[355] * sp4[362];
    sp4[366] = sp4[356] * sp4[362];
    sp4[367] = sp4[357] * sp4[362];
    sp4[368] = sp4[358] * sp4[362];
    sp4[369] = sp4[359] * sp4[362];
    sp4[370] = sp4[360] * sp4[362];
    sp4[371] = sp4[361] * sp4[362];
    sp4[372] = w[4][0] / 2;
    sp4[373] = sp4[363] * sp4[372];
    sp4[374] = sp4[364] * sp4[372];
    sp4[375] = sp4[365] * sp4[372];
    sp4[376] = sp4[366] * sp4[372];
    sp4[377] = sp4[367] * sp4[372];
    sp4[378] = sp4[368] * sp4[372];
    sp4[379] = sp4[369] * sp4[372];
    sp4[380] = sp4[370] * sp4[372];
    sp4[381] = sp4[371] * sp4[372];
    sp4[382] = sp4[344] + sp4[373];
    sp4[383] = sp4[345] + sp4[374];
    sp4[384] = sp4[346] + sp4[375];
    sp4[385] = sp4[347] + sp4[376];
    sp4[386] = sp4[348] + sp4[377];
    sp4[387] = sp4[349] + sp4[378];
    sp4[388] = sp4[350] + sp4[379];
    sp4[389] = sp4[351] + sp4[380];
    sp4[390] = sp4[352] + sp4[381];
    sp4[391] = std::abs(sp4[16]);
    for (int iq4 = 0; iq4 < 4; ++iq4)
    {
        // Quadrature loop body setup (num_points=4)
        // Unstructured varying computations
        double w1_c0 = 0.0;
        for (int ic = 0; ic < 4; ++ic)
        {
            w1_c0 += w[1][ic] * FE33_C0_Q4[0][iq4][ic - 0];
        }
        double w1_c1 = 0.0;
        for (int ic = 4; ic < 8; ++ic)
        {
            w1_c1 += w[1][ic] * FE33_C0_Q4[0][iq4][ic - 4];
        }
        double w1_c2 = 0.0;
        for (int ic = 8; ic < 12; ++ic)
        {
            w1_c2 += w[1][ic] * FE33_C0_Q4[0][iq4][ic - 8];
        }
        alignas(32) double sv4[16];
        sv4[0] = -1 * w1_c0;
        sv4[1] = -1 * w1_c1;
        sv4[2] = -1 * w1_c2;
        sv4[3] = weights4[iq4] * sp4[391];
        sv4[4] = sp4[382] * sv4[3];
        sv4[5] = sp4[383] * sv4[3];
        sv4[6] = sp4[384] * sv4[3];
        sv4[7] = sp4[385] * sv4[3];
        sv4[8] = sp4[386] * sv4[3];
        sv4[9] = sp4[387] * sv4[3];
        sv4[10] = sp4[388] * sv4[3];
        sv4[11] = sp4[389] * sv4[3];
        sv4[12] = sp4[390] * sv4[3];
        sv4[13] = sv4[0] * sv4[3];
        sv4[14] = sv4[1] * sv4[3];
        sv4[15] = sv4[2] * sv4[3];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            A[ia0] += sv4[10] * FE33_C0_D100_Q4[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv4[11] * FE33_C0_D010_Q4[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            A[ia0] += sv4[13] * FE33_C0_Q4[0][iq4][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            A[ia0] += sv4[12] * FE33_C0_D001_Q4[0][0][ia0 - 0];
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            A[ia0] += sv4[7] * FE33_C0_D100_Q4[0][0][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            A[ia0] += sv4[8] * FE33_C0_D010_Q4[0][0][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            A[ia0] += sv4[14] * FE33_C0_Q4[0][iq4][ia0 - 4];
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            A[ia0] += sv4[9] * FE33_C0_D001_Q4[0][0][ia0 - 4];
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            A[ia0] += sv4[4] * FE33_C0_D100_Q4[0][0][ia0 - 8];
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            A[ia0] += sv4[5] * FE33_C0_D010_Q4[0][0][ia0 - 8];
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            A[ia0] += sv4[15] * FE33_C0_Q4[0][iq4][ia0 - 8];
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            A[ia0] += sv4[6] * FE33_C0_D001_Q4[0][0][ia0 - 8];
        }
    }
  }

};


class hyperelasticity_exterior_facet_integral_0_otherwise: public ufc::exterior_facet_integral
{
public:

  hyperelasticity_exterior_facet_integral_0_otherwise() : ufc::exterior_facet_integral()
  {

  }

  ~hyperelasticity_exterior_facet_integral_0_otherwise() override
  {

  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
static const std::vector<bool> enabled({false, false, true, false, false});
return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 2
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 2
    //   quadrature_degree:           2
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights3[3] = { 0.166666666666667, 0.166666666666667, 0.166666666666667 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 4 tables for 3 quadrature points
    alignas(32) static const double FE15_C0_D001_F_Q3[1][1][4] = { { { -1.0, 0.0, 0.0, 1.0 } } };
    alignas(32) static const double FE15_C0_D010_F_Q3[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE15_C0_D100_F_Q3[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE15_C0_F_Q3[4][3][4] =
        { { { 0.0, 0.666666666666667, 0.166666666666667, 0.166666666666667 },
            { 0.0, 0.166666666666667, 0.166666666666667, 0.666666666666667 },
            { 0.0, 0.166666666666667, 0.666666666666667, 0.166666666666667 } },
          { { 0.666666666666667, 0.0, 0.166666666666667, 0.166666666666667 },
            { 0.166666666666667, 0.0, 0.166666666666667, 0.666666666666667 },
            { 0.166666666666667, 0.0, 0.666666666666667, 0.166666666666667 } },
          { { 0.666666666666667, 0.166666666666667, 0.0, 0.166666666666667 },
            { 0.166666666666667, 0.166666666666667, 0.0, 0.666666666666667 },
            { 0.166666666666667, 0.666666666666667, 0.0, 0.166666666666667 } },
          { { 0.666666666666667, 0.166666666666667, 0.166666666666667, 0.0 },
            { 0.166666666666667, 0.166666666666667, 0.666666666666667, 0.0 },
            { 0.166666666666667, 0.666666666666667, 0.166666666666667, 0.0 } } };
    // Reset element tensor
    memset(A, 0, 12 * sizeof(*A));
    // Unstructured piecewise computations
    const double J_c3 = coordinate_dofs[1] * FE15_C0_D100_F_Q3[0][0][0] + coordinate_dofs[4] * FE15_C0_D100_F_Q3[0][0][1];
    const double J_c4 = coordinate_dofs[1] * FE15_C0_D010_F_Q3[0][0][0] + coordinate_dofs[4] * FE15_C0_D010_F_Q3[0][0][1] + coordinate_dofs[7] * FE15_C0_D010_F_Q3[0][0][2];
    const double J_c5 = coordinate_dofs[1] * FE15_C0_D001_F_Q3[0][0][0] + coordinate_dofs[4] * FE15_C0_D001_F_Q3[0][0][1] + coordinate_dofs[7] * FE15_C0_D001_F_Q3[0][0][2] + coordinate_dofs[10] * FE15_C0_D001_F_Q3[0][0][3];
    const double J_c6 = coordinate_dofs[2] * FE15_C0_D100_F_Q3[0][0][0] + coordinate_dofs[5] * FE15_C0_D100_F_Q3[0][0][1];
    const double J_c7 = coordinate_dofs[2] * FE15_C0_D010_F_Q3[0][0][0] + coordinate_dofs[5] * FE15_C0_D010_F_Q3[0][0][1] + coordinate_dofs[8] * FE15_C0_D010_F_Q3[0][0][2];
    const double J_c8 = coordinate_dofs[2] * FE15_C0_D001_F_Q3[0][0][0] + coordinate_dofs[5] * FE15_C0_D001_F_Q3[0][0][1] + coordinate_dofs[8] * FE15_C0_D001_F_Q3[0][0][2] + coordinate_dofs[11] * FE15_C0_D001_F_Q3[0][0][3];
    const double J_c0 = coordinate_dofs[0] * FE15_C0_D100_F_Q3[0][0][0] + coordinate_dofs[3] * FE15_C0_D100_F_Q3[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE15_C0_D010_F_Q3[0][0][0] + coordinate_dofs[3] * FE15_C0_D010_F_Q3[0][0][1] + coordinate_dofs[6] * FE15_C0_D010_F_Q3[0][0][2];
    const double J_c2 = coordinate_dofs[0] * FE15_C0_D001_F_Q3[0][0][0] + coordinate_dofs[3] * FE15_C0_D001_F_Q3[0][0][1] + coordinate_dofs[6] * FE15_C0_D001_F_Q3[0][0][2] + coordinate_dofs[9] * FE15_C0_D001_F_Q3[0][0][3];
    alignas(32) double sp3[48];
    sp3[0] = tetrahedron_reference_facet_jacobian[facet][0][0] * J_c3;
    sp3[1] = tetrahedron_reference_facet_jacobian[facet][1][0] * J_c4;
    sp3[2] = sp3[0] + sp3[1];
    sp3[3] = J_c5 * tetrahedron_reference_facet_jacobian[facet][2][0];
    sp3[4] = sp3[2] + sp3[3];
    sp3[5] = tetrahedron_reference_facet_jacobian[facet][0][1] * J_c6;
    sp3[6] = tetrahedron_reference_facet_jacobian[facet][1][1] * J_c7;
    sp3[7] = sp3[5] + sp3[6];
    sp3[8] = tetrahedron_reference_facet_jacobian[facet][2][1] * J_c8;
    sp3[9] = sp3[7] + sp3[8];
    sp3[10] = sp3[4] * sp3[9];
    sp3[11] = tetrahedron_reference_facet_jacobian[facet][0][1] * J_c3;
    sp3[12] = J_c4 * tetrahedron_reference_facet_jacobian[facet][1][1];
    sp3[13] = sp3[11] + sp3[12];
    sp3[14] = J_c5 * tetrahedron_reference_facet_jacobian[facet][2][1];
    sp3[15] = sp3[13] + sp3[14];
    sp3[16] = tetrahedron_reference_facet_jacobian[facet][0][0] * J_c6;
    sp3[17] = tetrahedron_reference_facet_jacobian[facet][1][0] * J_c7;
    sp3[18] = sp3[16] + sp3[17];
    sp3[19] = tetrahedron_reference_facet_jacobian[facet][2][0] * J_c8;
    sp3[20] = sp3[18] + sp3[19];
    sp3[21] = sp3[15] * sp3[20];
    sp3[22] = -1 * sp3[21];
    sp3[23] = sp3[10] + sp3[22];
    sp3[24] = sp3[23] * sp3[23];
    sp3[25] = J_c0 * tetrahedron_reference_facet_jacobian[facet][0][1];
    sp3[26] = J_c1 * tetrahedron_reference_facet_jacobian[facet][1][1];
    sp3[27] = sp3[25] + sp3[26];
    sp3[28] = J_c2 * tetrahedron_reference_facet_jacobian[facet][2][1];
    sp3[29] = sp3[27] + sp3[28];
    sp3[30] = sp3[29] * sp3[20];
    sp3[31] = J_c0 * tetrahedron_reference_facet_jacobian[facet][0][0];
    sp3[32] = J_c1 * tetrahedron_reference_facet_jacobian[facet][1][0];
    sp3[33] = sp3[31] + sp3[32];
    sp3[34] = J_c2 * tetrahedron_reference_facet_jacobian[facet][2][0];
    sp3[35] = sp3[33] + sp3[34];
    sp3[36] = sp3[35] * sp3[9];
    sp3[37] = -1 * sp3[36];
    sp3[38] = sp3[30] + sp3[37];
    sp3[39] = sp3[38] * sp3[38];
    sp3[40] = sp3[24] + sp3[39];
    sp3[41] = sp3[35] * sp3[15];
    sp3[42] = sp3[4] * sp3[29];
    sp3[43] = -1 * sp3[42];
    sp3[44] = sp3[41] + sp3[43];
    sp3[45] = sp3[44] * sp3[44];
    sp3[46] = sp3[40] + sp3[45];
    sp3[47] = std::sqrt(sp3[46]);
    for (int iq3 = 0; iq3 < 3; ++iq3)
    {
        // Quadrature loop body setup (num_points=3)
        // Unstructured varying computations
        double w2_c0 = 0.0;
        for (int ic = 0; ic < 4; ++ic)
        {
            w2_c0 += w[2][ic] * FE15_C0_F_Q3[facet][iq3][ic - 0];
        }
        double w2_c1 = 0.0;
        for (int ic = 4; ic < 8; ++ic)
        {
            w2_c1 += w[2][ic] * FE15_C0_F_Q3[facet][iq3][ic - 4];
        }
        double w2_c2 = 0.0;
        for (int ic = 8; ic < 12; ++ic)
        {
            w2_c2 += w[2][ic] * FE15_C0_F_Q3[facet][iq3][ic - 8];
        }
        alignas(32) double sv3[7];
        sv3[0] = -1 * w2_c0;
        sv3[1] = -1 * w2_c1;
        sv3[2] = -1 * w2_c2;
        sv3[3] = weights3[iq3] * sp3[47];
        sv3[4] = sv3[0] * sv3[3];
        sv3[5] = sv3[1] * sv3[3];
        sv3[6] = sv3[2] * sv3[3];
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            A[ia0] += sv3[4] * FE15_C0_F_Q3[facet][iq3][ia0 - 0];
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            A[ia0] += sv3[5] * FE15_C0_F_Q3[facet][iq3][ia0 - 4];
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            A[ia0] += sv3[6] * FE15_C0_F_Q3[facet][iq3][ia0 - 8];
        }
    }
  }

};


class hyperelasticity_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_1_otherwise() : ufc::cell_integral()
  {

  }

  ~hyperelasticity_cell_integral_1_otherwise() override
  {

  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
static const std::vector<bool> enabled({true, true, true});
return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 0
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 0
    //   quadrature_degree:           0
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights1[1] = { 0.166666666666667 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 3 tables for 1 quadrature points
    alignas(32) static const double FE36_C0_D001_Q1[1][1][4] = { { { -1.0, 0.0, 0.0, 1.0 } } };
    alignas(32) static const double FE36_C0_D010_Q1[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE36_C0_D100_Q1[1][1][2] = { { { -1.0, 1.0 } } };
    // Reset element tensor
    memset(A, 0, 144 * sizeof(*A));
    // Unstructured piecewise computations
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE36_C0_D100_Q1[0][0][ic - 0];
    }
    const double J_c4 = coordinate_dofs[1] * FE36_C0_D010_Q1[0][0][0] + coordinate_dofs[4] * FE36_C0_D010_Q1[0][0][1] + coordinate_dofs[7] * FE36_C0_D010_Q1[0][0][2];
    const double J_c8 = coordinate_dofs[2] * FE36_C0_D001_Q1[0][0][0] + coordinate_dofs[5] * FE36_C0_D001_Q1[0][0][1] + coordinate_dofs[8] * FE36_C0_D001_Q1[0][0][2] + coordinate_dofs[11] * FE36_C0_D001_Q1[0][0][3];
    const double J_c5 = coordinate_dofs[1] * FE36_C0_D001_Q1[0][0][0] + coordinate_dofs[4] * FE36_C0_D001_Q1[0][0][1] + coordinate_dofs[7] * FE36_C0_D001_Q1[0][0][2] + coordinate_dofs[10] * FE36_C0_D001_Q1[0][0][3];
    const double J_c7 = coordinate_dofs[2] * FE36_C0_D010_Q1[0][0][0] + coordinate_dofs[5] * FE36_C0_D010_Q1[0][0][1] + coordinate_dofs[8] * FE36_C0_D010_Q1[0][0][2];
    const double J_c0 = coordinate_dofs[0] * FE36_C0_D100_Q1[0][0][0] + coordinate_dofs[3] * FE36_C0_D100_Q1[0][0][1];
    const double J_c1 = coordinate_dofs[0] * FE36_C0_D010_Q1[0][0][0] + coordinate_dofs[3] * FE36_C0_D010_Q1[0][0][1] + coordinate_dofs[6] * FE36_C0_D010_Q1[0][0][2];
    const double J_c6 = coordinate_dofs[2] * FE36_C0_D100_Q1[0][0][0] + coordinate_dofs[5] * FE36_C0_D100_Q1[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE36_C0_D100_Q1[0][0][0] + coordinate_dofs[4] * FE36_C0_D100_Q1[0][0][1];
    const double J_c2 = coordinate_dofs[0] * FE36_C0_D001_Q1[0][0][0] + coordinate_dofs[3] * FE36_C0_D001_Q1[0][0][1] + coordinate_dofs[6] * FE36_C0_D001_Q1[0][0][2] + coordinate_dofs[9] * FE36_C0_D001_Q1[0][0][3];
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE36_C0_D010_Q1[0][0][ic - 0];
    }
    double w0_d2_c0 = 0.0;
    for (int ic = 0; ic < 4; ++ic)
    {
        w0_d2_c0 += w[0][ic] * FE36_C0_D001_Q1[0][0][ic - 0];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 4; ic < 6; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE36_C0_D100_Q1[0][0][ic - 4];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 4; ic < 7; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE36_C0_D010_Q1[0][0][ic - 4];
    }
    double w0_d2_c1 = 0.0;
    for (int ic = 4; ic < 8; ++ic)
    {
        w0_d2_c1 += w[0][ic] * FE36_C0_D001_Q1[0][0][ic - 4];
    }
    double w0_d0_c2 = 0.0;
    for (int ic = 8; ic < 10; ++ic)
    {
        w0_d0_c2 += w[0][ic] * FE36_C0_D100_Q1[0][0][ic - 8];
    }
    double w0_d1_c2 = 0.0;
    for (int ic = 8; ic < 11; ++ic)
    {
        w0_d1_c2 += w[0][ic] * FE36_C0_D010_Q1[0][0][ic - 8];
    }
    double w0_d2_c2 = 0.0;
    for (int ic = 8; ic < 12; ++ic)
    {
        w0_d2_c2 += w[0][ic] * FE36_C0_D001_Q1[0][0][ic - 8];
    }
    alignas(32) double sp1[1499];
    sp1[0] = J_c4 * J_c8;
    sp1[1] = J_c5 * J_c7;
    sp1[2] = -1 * sp1[1];
    sp1[3] = sp1[0] + sp1[2];
    sp1[4] = J_c0 * sp1[3];
    sp1[5] = J_c5 * J_c6;
    sp1[6] = J_c3 * J_c8;
    sp1[7] = -1 * sp1[6];
    sp1[8] = sp1[5] + sp1[7];
    sp1[9] = J_c1 * sp1[8];
    sp1[10] = sp1[4] + sp1[9];
    sp1[11] = J_c3 * J_c7;
    sp1[12] = J_c4 * J_c6;
    sp1[13] = -1 * sp1[12];
    sp1[14] = sp1[11] + sp1[13];
    sp1[15] = J_c2 * sp1[14];
    sp1[16] = sp1[10] + sp1[15];
    sp1[17] = sp1[3] / sp1[16];
    sp1[18] = w0_d0_c0 * sp1[17];
    sp1[19] = -1 * J_c8;
    sp1[20] = J_c3 * sp1[19];
    sp1[21] = sp1[5] + sp1[20];
    sp1[22] = sp1[21] / sp1[16];
    sp1[23] = w0_d1_c0 * sp1[22];
    sp1[24] = sp1[18] + sp1[23];
    sp1[25] = sp1[14] / sp1[16];
    sp1[26] = w0_d2_c0 * sp1[25];
    sp1[27] = sp1[24] + sp1[26];
    sp1[28] = 1 + sp1[27];
    sp1[29] = J_c1 * J_c5;
    sp1[30] = J_c2 * J_c4;
    sp1[31] = -1 * sp1[30];
    sp1[32] = sp1[29] + sp1[31];
    sp1[33] = sp1[32] / sp1[16];
    sp1[34] = J_c2 * J_c3;
    sp1[35] = J_c0 * J_c5;
    sp1[36] = -1 * sp1[35];
    sp1[37] = sp1[34] + sp1[36];
    sp1[38] = sp1[37] / sp1[16];
    sp1[39] = J_c0 * J_c4;
    sp1[40] = J_c1 * J_c3;
    sp1[41] = -1 * sp1[40];
    sp1[42] = sp1[39] + sp1[41];
    sp1[43] = sp1[42] / sp1[16];
    sp1[44] = J_c2 * J_c7;
    sp1[45] = -1 * J_c1;
    sp1[46] = J_c8 * sp1[45];
    sp1[47] = sp1[44] + sp1[46];
    sp1[48] = sp1[47] / sp1[16];
    sp1[49] = J_c0 * J_c8;
    sp1[50] = -1 * J_c2;
    sp1[51] = J_c6 * sp1[50];
    sp1[52] = sp1[49] + sp1[51];
    sp1[53] = sp1[52] / sp1[16];
    sp1[54] = J_c1 * J_c6;
    sp1[55] = J_c0 * J_c7;
    sp1[56] = -1 * sp1[55];
    sp1[57] = sp1[54] + sp1[56];
    sp1[58] = sp1[57] / sp1[16];
    sp1[59] = sp1[48] * sp1[33];
    sp1[60] = sp1[53] * sp1[33];
    sp1[61] = sp1[33] * sp1[58];
    sp1[62] = sp1[48] * sp1[38];
    sp1[63] = sp1[53] * sp1[38];
    sp1[64] = sp1[38] * sp1[58];
    sp1[65] = sp1[48] * sp1[43];
    sp1[66] = sp1[53] * sp1[43];
    sp1[67] = sp1[43] * sp1[58];
    sp1[68] = -1 * sp1[59];
    sp1[69] = -1 * sp1[62];
    sp1[70] = -1 * sp1[65];
    sp1[71] = -1 * sp1[60];
    sp1[72] = -1 * sp1[63];
    sp1[73] = -1 * sp1[66];
    sp1[74] = -1 * sp1[61];
    sp1[75] = -1 * sp1[64];
    sp1[76] = -1 * sp1[67];
    sp1[77] = sp1[68] + sp1[59];
    sp1[78] = sp1[69] + sp1[60];
    sp1[79] = sp1[70] + sp1[61];
    sp1[80] = sp1[71] + sp1[62];
    sp1[81] = sp1[72] + sp1[63];
    sp1[82] = sp1[73] + sp1[64];
    sp1[83] = sp1[74] + sp1[65];
    sp1[84] = sp1[75] + sp1[66];
    sp1[85] = sp1[76] + sp1[67];
    sp1[86] = sp1[28] * sp1[77];
    sp1[87] = sp1[28] * sp1[78];
    sp1[88] = sp1[28] * sp1[79];
    sp1[89] = sp1[28] * sp1[80];
    sp1[90] = sp1[28] * sp1[81];
    sp1[91] = sp1[28] * sp1[82];
    sp1[92] = sp1[28] * sp1[83];
    sp1[93] = sp1[28] * sp1[84];
    sp1[94] = sp1[28] * sp1[85];
    sp1[95] = w0_d0_c1 * sp1[48];
    sp1[96] = w0_d1_c1 * sp1[53];
    sp1[97] = sp1[95] + sp1[96];
    sp1[98] = w0_d2_c1 * sp1[58];
    sp1[99] = sp1[97] + sp1[98];
    sp1[100] = 1 + sp1[99];
    sp1[101] = sp1[100] * sp1[33];
    sp1[102] = sp1[100] * sp1[38];
    sp1[103] = sp1[100] * sp1[43];
    sp1[104] = w0_d0_c2 * sp1[33];
    sp1[105] = w0_d1_c2 * sp1[38];
    sp1[106] = sp1[104] + sp1[105];
    sp1[107] = w0_d2_c2 * sp1[43];
    sp1[108] = sp1[106] + sp1[107];
    sp1[109] = 1 + sp1[108];
    sp1[110] = sp1[109] * sp1[48];
    sp1[111] = sp1[109] * sp1[53];
    sp1[112] = sp1[109] * sp1[58];
    sp1[113] = w0_d0_c1 * sp1[33];
    sp1[114] = w0_d1_c1 * sp1[38];
    sp1[115] = sp1[113] + sp1[114];
    sp1[116] = w0_d2_c1 * sp1[43];
    sp1[117] = sp1[115] + sp1[116];
    sp1[118] = sp1[117] * sp1[48];
    sp1[119] = sp1[117] * sp1[53];
    sp1[120] = sp1[117] * sp1[58];
    sp1[121] = w0_d0_c2 * sp1[48];
    sp1[122] = w0_d1_c2 * sp1[53];
    sp1[123] = sp1[121] + sp1[122];
    sp1[124] = w0_d2_c2 * sp1[58];
    sp1[125] = sp1[123] + sp1[124];
    sp1[126] = sp1[125] * sp1[33];
    sp1[127] = sp1[125] * sp1[38];
    sp1[128] = sp1[125] * sp1[43];
    sp1[129] = -1 * sp1[126];
    sp1[130] = -1 * sp1[127];
    sp1[131] = -1 * sp1[128];
    sp1[132] = -1 * sp1[118];
    sp1[133] = -1 * sp1[119];
    sp1[134] = -1 * sp1[120];
    sp1[135] = sp1[129] + sp1[110];
    sp1[136] = sp1[130] + sp1[111];
    sp1[137] = sp1[131] + sp1[112];
    sp1[138] = sp1[132] + sp1[101];
    sp1[139] = sp1[133] + sp1[102];
    sp1[140] = sp1[134] + sp1[103];
    sp1[141] = sp1[135] * sp1[17];
    sp1[142] = sp1[135] * sp1[22];
    sp1[143] = sp1[135] * sp1[25];
    sp1[144] = sp1[136] * sp1[17];
    sp1[145] = sp1[136] * sp1[22];
    sp1[146] = sp1[136] * sp1[25];
    sp1[147] = sp1[137] * sp1[17];
    sp1[148] = sp1[137] * sp1[22];
    sp1[149] = sp1[137] * sp1[25];
    sp1[150] = sp1[138] * sp1[17];
    sp1[151] = sp1[138] * sp1[22];
    sp1[152] = sp1[138] * sp1[25];
    sp1[153] = sp1[139] * sp1[17];
    sp1[154] = sp1[139] * sp1[22];
    sp1[155] = sp1[139] * sp1[25];
    sp1[156] = sp1[140] * sp1[17];
    sp1[157] = sp1[140] * sp1[22];
    sp1[158] = sp1[140] * sp1[25];
    sp1[159] = sp1[117] * sp1[17];
    sp1[160] = sp1[117] * sp1[22];
    sp1[161] = sp1[117] * sp1[25];
    sp1[162] = w0_d0_c2 * sp1[17];
    sp1[163] = w0_d1_c2 * sp1[22];
    sp1[164] = sp1[162] + sp1[163];
    sp1[165] = w0_d2_c2 * sp1[25];
    sp1[166] = sp1[164] + sp1[165];
    sp1[167] = sp1[166] * sp1[33];
    sp1[168] = sp1[166] * sp1[38];
    sp1[169] = sp1[166] * sp1[43];
    sp1[170] = sp1[109] * sp1[17];
    sp1[171] = sp1[109] * sp1[22];
    sp1[172] = sp1[109] * sp1[25];
    sp1[173] = w0_d0_c1 * sp1[17];
    sp1[174] = w0_d1_c1 * sp1[22];
    sp1[175] = sp1[173] + sp1[174];
    sp1[176] = w0_d2_c1 * sp1[25];
    sp1[177] = sp1[175] + sp1[176];
    sp1[178] = sp1[177] * sp1[33];
    sp1[179] = sp1[177] * sp1[38];
    sp1[180] = sp1[177] * sp1[43];
    sp1[181] = -1 * sp1[170];
    sp1[182] = -1 * sp1[171];
    sp1[183] = -1 * sp1[172];
    sp1[184] = -1 * sp1[178];
    sp1[185] = -1 * sp1[179];
    sp1[186] = -1 * sp1[180];
    sp1[187] = sp1[181] + sp1[167];
    sp1[188] = sp1[182] + sp1[168];
    sp1[189] = sp1[183] + sp1[169];
    sp1[190] = sp1[184] + sp1[159];
    sp1[191] = sp1[185] + sp1[160];
    sp1[192] = sp1[186] + sp1[161];
    sp1[193] = sp1[187] * sp1[48];
    sp1[194] = sp1[187] * sp1[53];
    sp1[195] = sp1[187] * sp1[58];
    sp1[196] = sp1[188] * sp1[48];
    sp1[197] = sp1[188] * sp1[53];
    sp1[198] = sp1[188] * sp1[58];
    sp1[199] = sp1[189] * sp1[48];
    sp1[200] = sp1[189] * sp1[53];
    sp1[201] = sp1[189] * sp1[58];
    sp1[202] = sp1[190] * sp1[48];
    sp1[203] = sp1[190] * sp1[53];
    sp1[204] = sp1[190] * sp1[58];
    sp1[205] = sp1[191] * sp1[48];
    sp1[206] = sp1[191] * sp1[53];
    sp1[207] = sp1[191] * sp1[58];
    sp1[208] = sp1[192] * sp1[48];
    sp1[209] = sp1[192] * sp1[53];
    sp1[210] = sp1[192] * sp1[58];
    sp1[211] = sp1[33] * sp1[17];
    sp1[212] = sp1[33] * sp1[22];
    sp1[213] = sp1[33] * sp1[25];
    sp1[214] = sp1[38] * sp1[17];
    sp1[215] = sp1[38] * sp1[22];
    sp1[216] = sp1[38] * sp1[25];
    sp1[217] = sp1[43] * sp1[17];
    sp1[218] = sp1[43] * sp1[22];
    sp1[219] = sp1[43] * sp1[25];
    sp1[220] = -1 * sp1[211];
    sp1[221] = -1 * sp1[212];
    sp1[222] = -1 * sp1[213];
    sp1[223] = -1 * sp1[214];
    sp1[224] = -1 * sp1[215];
    sp1[225] = -1 * sp1[216];
    sp1[226] = -1 * sp1[217];
    sp1[227] = -1 * sp1[218];
    sp1[228] = -1 * sp1[219];
    sp1[229] = sp1[220] + sp1[211];
    sp1[230] = sp1[221] + sp1[214];
    sp1[231] = sp1[222] + sp1[217];
    sp1[232] = sp1[223] + sp1[212];
    sp1[233] = sp1[224] + sp1[215];
    sp1[234] = sp1[225] + sp1[218];
    sp1[235] = sp1[226] + sp1[213];
    sp1[236] = sp1[227] + sp1[216];
    sp1[237] = sp1[228] + sp1[219];
    sp1[238] = w0_d0_c0 * sp1[48];
    sp1[239] = w0_d1_c0 * sp1[53];
    sp1[240] = sp1[238] + sp1[239];
    sp1[241] = w0_d2_c0 * sp1[58];
    sp1[242] = sp1[240] + sp1[241];
    sp1[243] = sp1[242] * sp1[229];
    sp1[244] = sp1[242] * sp1[230];
    sp1[245] = sp1[242] * sp1[231];
    sp1[246] = sp1[242] * sp1[232];
    sp1[247] = sp1[242] * sp1[233];
    sp1[248] = sp1[242] * sp1[234];
    sp1[249] = sp1[235] * sp1[242];
    sp1[250] = sp1[236] * sp1[242];
    sp1[251] = sp1[237] * sp1[242];
    sp1[252] = sp1[86] + sp1[243];
    sp1[253] = sp1[87] + sp1[244];
    sp1[254] = sp1[88] + sp1[245];
    sp1[255] = sp1[202] + sp1[150];
    sp1[256] = sp1[203] + sp1[151];
    sp1[257] = sp1[152] + sp1[204];
    sp1[258] = sp1[89] + sp1[246];
    sp1[259] = sp1[90] + sp1[247];
    sp1[260] = sp1[91] + sp1[248];
    sp1[261] = sp1[205] + sp1[153];
    sp1[262] = sp1[206] + sp1[154];
    sp1[263] = sp1[155] + sp1[207];
    sp1[264] = sp1[92] + sp1[249];
    sp1[265] = sp1[93] + sp1[250];
    sp1[266] = sp1[251] + sp1[94];
    sp1[267] = sp1[208] + sp1[156];
    sp1[268] = sp1[209] + sp1[157];
    sp1[269] = sp1[158] + sp1[210];
    sp1[270] = sp1[193] + sp1[141];
    sp1[271] = sp1[194] + sp1[142];
    sp1[272] = sp1[143] + sp1[195];
    sp1[273] = sp1[196] + sp1[144];
    sp1[274] = sp1[197] + sp1[145];
    sp1[275] = sp1[146] + sp1[198];
    sp1[276] = sp1[199] + sp1[147];
    sp1[277] = sp1[200] + sp1[148];
    sp1[278] = sp1[149] + sp1[201];
    sp1[279] = sp1[177] * sp1[48];
    sp1[280] = sp1[177] * sp1[53];
    sp1[281] = sp1[177] * sp1[58];
    sp1[282] = sp1[125] * sp1[17];
    sp1[283] = sp1[125] * sp1[22];
    sp1[284] = sp1[125] * sp1[25];
    sp1[285] = sp1[100] * sp1[17];
    sp1[286] = sp1[100] * sp1[22];
    sp1[287] = sp1[100] * sp1[25];
    sp1[288] = sp1[166] * sp1[48];
    sp1[289] = sp1[166] * sp1[53];
    sp1[290] = sp1[166] * sp1[58];
    sp1[291] = -1 * sp1[288];
    sp1[292] = -1 * sp1[289];
    sp1[293] = -1 * sp1[290];
    sp1[294] = -1 * sp1[285];
    sp1[295] = -1 * sp1[286];
    sp1[296] = -1 * sp1[287];
    sp1[297] = sp1[291] + sp1[282];
    sp1[298] = sp1[292] + sp1[283];
    sp1[299] = sp1[293] + sp1[284];
    sp1[300] = sp1[294] + sp1[279];
    sp1[301] = sp1[295] + sp1[280];
    sp1[302] = sp1[296] + sp1[281];
    sp1[303] = sp1[297] * sp1[33];
    sp1[304] = sp1[297] * sp1[38];
    sp1[305] = sp1[297] * sp1[43];
    sp1[306] = sp1[298] * sp1[33];
    sp1[307] = sp1[298] * sp1[38];
    sp1[308] = sp1[298] * sp1[43];
    sp1[309] = sp1[299] * sp1[33];
    sp1[310] = sp1[299] * sp1[38];
    sp1[311] = sp1[299] * sp1[43];
    sp1[312] = sp1[300] * sp1[33];
    sp1[313] = sp1[300] * sp1[38];
    sp1[314] = sp1[300] * sp1[43];
    sp1[315] = sp1[301] * sp1[33];
    sp1[316] = sp1[301] * sp1[38];
    sp1[317] = sp1[301] * sp1[43];
    sp1[318] = sp1[302] * sp1[33];
    sp1[319] = sp1[302] * sp1[38];
    sp1[320] = sp1[302] * sp1[43];
    sp1[321] = sp1[48] * sp1[17];
    sp1[322] = sp1[53] * sp1[17];
    sp1[323] = sp1[58] * sp1[17];
    sp1[324] = sp1[48] * sp1[22];
    sp1[325] = sp1[53] * sp1[22];
    sp1[326] = sp1[58] * sp1[22];
    sp1[327] = sp1[48] * sp1[25];
    sp1[328] = sp1[53] * sp1[25];
    sp1[329] = sp1[25] * sp1[58];
    sp1[330] = -1 * sp1[321];
    sp1[331] = -1 * sp1[322];
    sp1[332] = -1 * sp1[323];
    sp1[333] = -1 * sp1[324];
    sp1[334] = -1 * sp1[325];
    sp1[335] = -1 * sp1[326];
    sp1[336] = -1 * sp1[327];
    sp1[337] = -1 * sp1[328];
    sp1[338] = -1 * sp1[329];
    sp1[339] = sp1[330] + sp1[321];
    sp1[340] = sp1[331] + sp1[324];
    sp1[341] = sp1[332] + sp1[327];
    sp1[342] = sp1[333] + sp1[322];
    sp1[343] = sp1[334] + sp1[325];
    sp1[344] = sp1[335] + sp1[328];
    sp1[345] = sp1[336] + sp1[323];
    sp1[346] = sp1[337] + sp1[326];
    sp1[347] = sp1[338] + sp1[329];
    sp1[348] = w0_d0_c0 * sp1[33];
    sp1[349] = w0_d1_c0 * sp1[38];
    sp1[350] = sp1[348] + sp1[349];
    sp1[351] = w0_d2_c0 * sp1[43];
    sp1[352] = sp1[350] + sp1[351];
    sp1[353] = sp1[352] * sp1[339];
    sp1[354] = sp1[352] * sp1[340];
    sp1[355] = sp1[352] * sp1[341];
    sp1[356] = sp1[352] * sp1[342];
    sp1[357] = sp1[352] * sp1[343];
    sp1[358] = sp1[352] * sp1[344];
    sp1[359] = sp1[352] * sp1[345];
    sp1[360] = sp1[352] * sp1[346];
    sp1[361] = sp1[352] * sp1[347];
    sp1[362] = sp1[252] + sp1[353];
    sp1[363] = sp1[253] + sp1[354];
    sp1[364] = sp1[254] + sp1[355];
    sp1[365] = sp1[255] + sp1[312];
    sp1[366] = sp1[256] + sp1[313];
    sp1[367] = sp1[257] + sp1[314];
    sp1[368] = sp1[258] + sp1[356];
    sp1[369] = sp1[259] + sp1[357];
    sp1[370] = sp1[260] + sp1[358];
    sp1[371] = sp1[261] + sp1[315];
    sp1[372] = sp1[262] + sp1[316];
    sp1[373] = sp1[263] + sp1[317];
    sp1[374] = sp1[264] + sp1[359];
    sp1[375] = sp1[265] + sp1[360];
    sp1[376] = sp1[266] + sp1[361];
    sp1[377] = sp1[267] + sp1[318];
    sp1[378] = sp1[268] + sp1[319];
    sp1[379] = sp1[269] + sp1[320];
    sp1[380] = sp1[270] + sp1[303];
    sp1[381] = sp1[271] + sp1[304];
    sp1[382] = sp1[272] + sp1[305];
    sp1[383] = sp1[273] + sp1[306];
    sp1[384] = sp1[274] + sp1[307];
    sp1[385] = sp1[275] + sp1[308];
    sp1[386] = sp1[276] + sp1[309];
    sp1[387] = sp1[277] + sp1[310];
    sp1[388] = sp1[278] + sp1[311];
    sp1[389] = sp1[28] * sp1[138];
    sp1[390] = sp1[28] * sp1[139];
    sp1[391] = sp1[28] * sp1[140];
    sp1[392] = sp1[28] * sp1[135];
    sp1[393] = sp1[28] * sp1[136];
    sp1[394] = sp1[28] * sp1[137];
    sp1[395] = sp1[109] * sp1[100];
    sp1[396] = sp1[117] * sp1[125];
    sp1[397] = -1 * sp1[396];
    sp1[398] = sp1[395] + sp1[397];
    sp1[399] = sp1[398] * sp1[17];
    sp1[400] = sp1[398] * sp1[22];
    sp1[401] = sp1[398] * sp1[25];
    sp1[402] = sp1[117] * sp1[166];
    sp1[403] = sp1[109] * sp1[177];
    sp1[404] = -1 * sp1[403];
    sp1[405] = sp1[402] + sp1[404];
    sp1[406] = sp1[405] * sp1[48];
    sp1[407] = sp1[405] * sp1[53];
    sp1[408] = sp1[405] * sp1[58];
    sp1[409] = sp1[242] * sp1[190];
    sp1[410] = sp1[242] * sp1[191];
    sp1[411] = sp1[192] * sp1[242];
    sp1[412] = sp1[187] * sp1[242];
    sp1[413] = sp1[188] * sp1[242];
    sp1[414] = sp1[189] * sp1[242];
    sp1[415] = sp1[389] + sp1[409];
    sp1[416] = sp1[390] + sp1[410];
    sp1[417] = sp1[391] + sp1[411];
    sp1[418] = sp1[392] + sp1[412];
    sp1[419] = sp1[393] + sp1[413];
    sp1[420] = sp1[414] + sp1[394];
    sp1[421] = sp1[406] + sp1[399];
    sp1[422] = sp1[407] + sp1[400];
    sp1[423] = sp1[401] + sp1[408];
    sp1[424] = sp1[177] * sp1[125];
    sp1[425] = sp1[100] * sp1[166];
    sp1[426] = -1 * sp1[425];
    sp1[427] = sp1[424] + sp1[426];
    sp1[428] = sp1[427] * sp1[33];
    sp1[429] = sp1[427] * sp1[38];
    sp1[430] = sp1[427] * sp1[43];
    sp1[431] = sp1[300] * sp1[352];
    sp1[432] = sp1[301] * sp1[352];
    sp1[433] = sp1[352] * sp1[302];
    sp1[434] = sp1[352] * sp1[297];
    sp1[435] = sp1[352] * sp1[298];
    sp1[436] = sp1[352] * sp1[299];
    sp1[437] = sp1[415] + sp1[431];
    sp1[438] = sp1[416] + sp1[432];
    sp1[439] = sp1[417] + sp1[433];
    sp1[440] = sp1[418] + sp1[434];
    sp1[441] = sp1[419] + sp1[435];
    sp1[442] = sp1[420] + sp1[436];
    sp1[443] = sp1[421] + sp1[428];
    sp1[444] = sp1[422] + sp1[429];
    sp1[445] = sp1[423] + sp1[430];
    sp1[446] = sp1[28] * sp1[398];
    sp1[447] = sp1[405] * sp1[242];
    sp1[448] = sp1[446] + sp1[447];
    sp1[449] = sp1[427] * sp1[352];
    sp1[450] = sp1[448] + sp1[449];
    sp1[451] = sp1[440] / sp1[450];
    sp1[452] = sp1[441] / sp1[450];
    sp1[453] = sp1[442] / sp1[450];
    sp1[454] = sp1[437] / sp1[450];
    sp1[455] = sp1[438] / sp1[450];
    sp1[456] = sp1[439] / sp1[450];
    sp1[457] = sp1[443] / sp1[450];
    sp1[458] = sp1[444] / sp1[450];
    sp1[459] = sp1[445] / sp1[450];
    sp1[460] = sp1[437] * sp1[451];
    sp1[461] = sp1[437] * sp1[452];
    sp1[462] = sp1[437] * sp1[453];
    sp1[463] = sp1[437] * sp1[454];
    sp1[464] = sp1[437] * sp1[455];
    sp1[465] = sp1[437] * sp1[456];
    sp1[466] = sp1[437] * sp1[457];
    sp1[467] = sp1[437] * sp1[458];
    sp1[468] = sp1[437] * sp1[459];
    sp1[469] = sp1[438] * sp1[451];
    sp1[470] = sp1[438] * sp1[452];
    sp1[471] = sp1[438] * sp1[453];
    sp1[472] = sp1[438] * sp1[454];
    sp1[473] = sp1[438] * sp1[455];
    sp1[474] = sp1[438] * sp1[456];
    sp1[475] = sp1[438] * sp1[457];
    sp1[476] = sp1[438] * sp1[458];
    sp1[477] = sp1[438] * sp1[459];
    sp1[478] = sp1[439] * sp1[451];
    sp1[479] = sp1[439] * sp1[452];
    sp1[480] = sp1[439] * sp1[453];
    sp1[481] = sp1[439] * sp1[454];
    sp1[482] = sp1[439] * sp1[455];
    sp1[483] = sp1[439] * sp1[456];
    sp1[484] = sp1[439] * sp1[457];
    sp1[485] = sp1[439] * sp1[458];
    sp1[486] = sp1[439] * sp1[459];
    sp1[487] = sp1[440] * sp1[451];
    sp1[488] = sp1[440] * sp1[452];
    sp1[489] = sp1[440] * sp1[453];
    sp1[490] = sp1[440] * sp1[454];
    sp1[491] = sp1[440] * sp1[455];
    sp1[492] = sp1[440] * sp1[456];
    sp1[493] = sp1[440] * sp1[457];
    sp1[494] = sp1[440] * sp1[458];
    sp1[495] = sp1[440] * sp1[459];
    sp1[496] = sp1[441] * sp1[451];
    sp1[497] = sp1[441] * sp1[452];
    sp1[498] = sp1[441] * sp1[453];
    sp1[499] = sp1[441] * sp1[454];
    sp1[500] = sp1[441] * sp1[455];
    sp1[501] = sp1[441] * sp1[456];
    sp1[502] = sp1[441] * sp1[457];
    sp1[503] = sp1[441] * sp1[458];
    sp1[504] = sp1[441] * sp1[459];
    sp1[505] = sp1[442] * sp1[451];
    sp1[506] = sp1[442] * sp1[452];
    sp1[507] = sp1[442] * sp1[453];
    sp1[508] = sp1[442] * sp1[454];
    sp1[509] = sp1[442] * sp1[455];
    sp1[510] = sp1[442] * sp1[456];
    sp1[511] = sp1[442] * sp1[457];
    sp1[512] = sp1[442] * sp1[458];
    sp1[513] = sp1[442] * sp1[459];
    sp1[514] = sp1[443] * sp1[451];
    sp1[515] = sp1[443] * sp1[452];
    sp1[516] = sp1[443] * sp1[453];
    sp1[517] = sp1[443] * sp1[454];
    sp1[518] = sp1[443] * sp1[455];
    sp1[519] = sp1[443] * sp1[456];
    sp1[520] = sp1[443] * sp1[457];
    sp1[521] = sp1[443] * sp1[458];
    sp1[522] = sp1[443] * sp1[459];
    sp1[523] = sp1[444] * sp1[451];
    sp1[524] = sp1[444] * sp1[452];
    sp1[525] = sp1[444] * sp1[453];
    sp1[526] = sp1[444] * sp1[454];
    sp1[527] = sp1[444] * sp1[455];
    sp1[528] = sp1[444] * sp1[456];
    sp1[529] = sp1[444] * sp1[457];
    sp1[530] = sp1[444] * sp1[458];
    sp1[531] = sp1[444] * sp1[459];
    sp1[532] = sp1[445] * sp1[451];
    sp1[533] = sp1[445] * sp1[452];
    sp1[534] = sp1[445] * sp1[453];
    sp1[535] = sp1[445] * sp1[454];
    sp1[536] = sp1[445] * sp1[455];
    sp1[537] = sp1[445] * sp1[456];
    sp1[538] = sp1[445] * sp1[457];
    sp1[539] = sp1[445] * sp1[458];
    sp1[540] = sp1[445] * sp1[459];
    sp1[541] = -1 * sp1[460];
    sp1[542] = -1 * sp1[461];
    sp1[543] = -1 * sp1[462];
    sp1[544] = -1 * sp1[463];
    sp1[545] = -1 * sp1[464];
    sp1[546] = -1 * sp1[465];
    sp1[547] = -1 * sp1[466];
    sp1[548] = -1 * sp1[467];
    sp1[549] = -1 * sp1[468];
    sp1[550] = -1 * sp1[469];
    sp1[551] = -1 * sp1[470];
    sp1[552] = -1 * sp1[471];
    sp1[553] = -1 * sp1[472];
    sp1[554] = -1 * sp1[473];
    sp1[555] = -1 * sp1[474];
    sp1[556] = -1 * sp1[475];
    sp1[557] = -1 * sp1[476];
    sp1[558] = -1 * sp1[477];
    sp1[559] = -1 * sp1[478];
    sp1[560] = -1 * sp1[479];
    sp1[561] = -1 * sp1[480];
    sp1[562] = -1 * sp1[481];
    sp1[563] = -1 * sp1[482];
    sp1[564] = -1 * sp1[483];
    sp1[565] = -1 * sp1[484];
    sp1[566] = -1 * sp1[485];
    sp1[567] = -1 * sp1[486];
    sp1[568] = -1 * sp1[487];
    sp1[569] = -1 * sp1[496];
    sp1[570] = -1 * sp1[505];
    sp1[571] = -1 * sp1[514];
    sp1[572] = -1 * sp1[523];
    sp1[573] = -1 * sp1[532];
    sp1[574] = -1 * sp1[488];
    sp1[575] = -1 * sp1[497];
    sp1[576] = -1 * sp1[506];
    sp1[577] = -1 * sp1[515];
    sp1[578] = -1 * sp1[524];
    sp1[579] = -1 * sp1[533];
    sp1[580] = -1 * sp1[489];
    sp1[581] = -1 * sp1[498];
    sp1[582] = -1 * sp1[507];
    sp1[583] = -1 * sp1[516];
    sp1[584] = -1 * sp1[525];
    sp1[585] = -1 * sp1[534];
    sp1[586] = -1 * sp1[490];
    sp1[587] = -1 * sp1[499];
    sp1[588] = -1 * sp1[508];
    sp1[589] = -1 * sp1[517];
    sp1[590] = -1 * sp1[526];
    sp1[591] = -1 * sp1[535];
    sp1[592] = -1 * sp1[491];
    sp1[593] = -1 * sp1[500];
    sp1[594] = -1 * sp1[509];
    sp1[595] = -1 * sp1[518];
    sp1[596] = -1 * sp1[527];
    sp1[597] = -1 * sp1[536];
    sp1[598] = -1 * sp1[492];
    sp1[599] = -1 * sp1[501];
    sp1[600] = -1 * sp1[510];
    sp1[601] = -1 * sp1[519];
    sp1[602] = -1 * sp1[528];
    sp1[603] = -1 * sp1[537];
    sp1[604] = -1 * sp1[493];
    sp1[605] = -1 * sp1[494];
    sp1[606] = -1 * sp1[495];
    sp1[607] = -1 * sp1[502];
    sp1[608] = -1 * sp1[503];
    sp1[609] = -1 * sp1[504];
    sp1[610] = -1 * sp1[511];
    sp1[611] = -1 * sp1[512];
    sp1[612] = -1 * sp1[513];
    sp1[613] = -1 * sp1[520];
    sp1[614] = -1 * sp1[521];
    sp1[615] = -1 * sp1[522];
    sp1[616] = -1 * sp1[529];
    sp1[617] = -1 * sp1[530];
    sp1[618] = -1 * sp1[531];
    sp1[619] = -1 * sp1[538];
    sp1[620] = -1 * sp1[539];
    sp1[621] = -1 * sp1[540];
    sp1[622] = sp1[362] + sp1[541];
    sp1[623] = sp1[363] + sp1[542];
    sp1[624] = sp1[364] + sp1[543];
    sp1[625] = sp1[365] + sp1[547];
    sp1[626] = sp1[366] + sp1[548];
    sp1[627] = sp1[367] + sp1[549];
    sp1[628] = sp1[368] + sp1[550];
    sp1[629] = sp1[369] + sp1[551];
    sp1[630] = sp1[370] + sp1[552];
    sp1[631] = sp1[371] + sp1[556];
    sp1[632] = sp1[372] + sp1[557];
    sp1[633] = sp1[373] + sp1[558];
    sp1[634] = sp1[374] + sp1[559];
    sp1[635] = sp1[375] + sp1[560];
    sp1[636] = sp1[376] + sp1[561];
    sp1[637] = sp1[377] + sp1[565];
    sp1[638] = sp1[378] + sp1[566];
    sp1[639] = sp1[379] + sp1[567];
    sp1[640] = sp1[380] + sp1[571];
    sp1[641] = sp1[381] + sp1[572];
    sp1[642] = sp1[382] + sp1[573];
    sp1[643] = sp1[383] + sp1[577];
    sp1[644] = sp1[384] + sp1[578];
    sp1[645] = sp1[385] + sp1[579];
    sp1[646] = sp1[386] + sp1[583];
    sp1[647] = sp1[387] + sp1[584];
    sp1[648] = sp1[388] + sp1[585];
    sp1[649] = sp1[362] + sp1[586];
    sp1[650] = sp1[363] + sp1[587];
    sp1[651] = sp1[364] + sp1[588];
    sp1[652] = sp1[365] + sp1[589];
    sp1[653] = sp1[366] + sp1[590];
    sp1[654] = sp1[367] + sp1[591];
    sp1[655] = sp1[368] + sp1[592];
    sp1[656] = sp1[369] + sp1[593];
    sp1[657] = sp1[370] + sp1[594];
    sp1[658] = sp1[371] + sp1[595];
    sp1[659] = sp1[372] + sp1[596];
    sp1[660] = sp1[373] + sp1[597];
    sp1[661] = sp1[374] + sp1[598];
    sp1[662] = sp1[375] + sp1[599];
    sp1[663] = sp1[376] + sp1[600];
    sp1[664] = sp1[377] + sp1[601];
    sp1[665] = sp1[378] + sp1[602];
    sp1[666] = sp1[379] + sp1[603];
    sp1[667] = sp1[380] + sp1[604];
    sp1[668] = sp1[381] + sp1[605];
    sp1[669] = sp1[382] + sp1[606];
    sp1[670] = sp1[383] + sp1[607];
    sp1[671] = sp1[384] + sp1[608];
    sp1[672] = sp1[385] + sp1[609];
    sp1[673] = sp1[386] + sp1[610];
    sp1[674] = sp1[387] + sp1[611];
    sp1[675] = sp1[388] + sp1[612];
    sp1[676] = sp1[622] / sp1[450];
    sp1[677] = sp1[623] / sp1[450];
    sp1[678] = sp1[624] / sp1[450];
    sp1[679] = sp1[544] / sp1[450];
    sp1[680] = sp1[545] / sp1[450];
    sp1[681] = sp1[546] / sp1[450];
    sp1[682] = sp1[625] / sp1[450];
    sp1[683] = sp1[626] / sp1[450];
    sp1[684] = sp1[627] / sp1[450];
    sp1[685] = sp1[628] / sp1[450];
    sp1[686] = sp1[629] / sp1[450];
    sp1[687] = sp1[630] / sp1[450];
    sp1[688] = sp1[553] / sp1[450];
    sp1[689] = sp1[554] / sp1[450];
    sp1[690] = sp1[555] / sp1[450];
    sp1[691] = sp1[631] / sp1[450];
    sp1[692] = sp1[632] / sp1[450];
    sp1[693] = sp1[633] / sp1[450];
    sp1[694] = sp1[634] / sp1[450];
    sp1[695] = sp1[635] / sp1[450];
    sp1[696] = sp1[636] / sp1[450];
    sp1[697] = sp1[562] / sp1[450];
    sp1[698] = sp1[563] / sp1[450];
    sp1[699] = sp1[564] / sp1[450];
    sp1[700] = sp1[637] / sp1[450];
    sp1[701] = sp1[638] / sp1[450];
    sp1[702] = sp1[639] / sp1[450];
    sp1[703] = sp1[568] / sp1[450];
    sp1[704] = sp1[569] / sp1[450];
    sp1[705] = sp1[570] / sp1[450];
    sp1[706] = sp1[640] / sp1[450];
    sp1[707] = sp1[641] / sp1[450];
    sp1[708] = sp1[642] / sp1[450];
    sp1[709] = sp1[574] / sp1[450];
    sp1[710] = sp1[575] / sp1[450];
    sp1[711] = sp1[576] / sp1[450];
    sp1[712] = sp1[643] / sp1[450];
    sp1[713] = sp1[644] / sp1[450];
    sp1[714] = sp1[645] / sp1[450];
    sp1[715] = sp1[580] / sp1[450];
    sp1[716] = sp1[581] / sp1[450];
    sp1[717] = sp1[582] / sp1[450];
    sp1[718] = sp1[646] / sp1[450];
    sp1[719] = sp1[647] / sp1[450];
    sp1[720] = sp1[648] / sp1[450];
    sp1[721] = sp1[649] / sp1[450];
    sp1[722] = sp1[650] / sp1[450];
    sp1[723] = sp1[651] / sp1[450];
    sp1[724] = sp1[652] / sp1[450];
    sp1[725] = sp1[653] / sp1[450];
    sp1[726] = sp1[654] / sp1[450];
    sp1[727] = sp1[655] / sp1[450];
    sp1[728] = sp1[656] / sp1[450];
    sp1[729] = sp1[657] / sp1[450];
    sp1[730] = sp1[658] / sp1[450];
    sp1[731] = sp1[659] / sp1[450];
    sp1[732] = sp1[660] / sp1[450];
    sp1[733] = sp1[661] / sp1[450];
    sp1[734] = sp1[662] / sp1[450];
    sp1[735] = sp1[663] / sp1[450];
    sp1[736] = sp1[664] / sp1[450];
    sp1[737] = sp1[665] / sp1[450];
    sp1[738] = sp1[666] / sp1[450];
    sp1[739] = sp1[667] / sp1[450];
    sp1[740] = sp1[668] / sp1[450];
    sp1[741] = sp1[669] / sp1[450];
    sp1[742] = sp1[670] / sp1[450];
    sp1[743] = sp1[671] / sp1[450];
    sp1[744] = sp1[672] / sp1[450];
    sp1[745] = sp1[673] / sp1[450];
    sp1[746] = sp1[674] / sp1[450];
    sp1[747] = sp1[675] / sp1[450];
    sp1[748] = sp1[613] / sp1[450];
    sp1[749] = sp1[614] / sp1[450];
    sp1[750] = sp1[615] / sp1[450];
    sp1[751] = sp1[616] / sp1[450];
    sp1[752] = sp1[617] / sp1[450];
    sp1[753] = sp1[618] / sp1[450];
    sp1[754] = sp1[619] / sp1[450];
    sp1[755] = sp1[620] / sp1[450];
    sp1[756] = sp1[621] / sp1[450];
    sp1[757] = sp1[676] * w[1][0];
    sp1[758] = sp1[677] * w[1][0];
    sp1[759] = sp1[678] * w[1][0];
    sp1[760] = sp1[679] * w[1][0];
    sp1[761] = sp1[680] * w[1][0];
    sp1[762] = sp1[681] * w[1][0];
    sp1[763] = sp1[682] * w[1][0];
    sp1[764] = sp1[683] * w[1][0];
    sp1[765] = sp1[684] * w[1][0];
    sp1[766] = sp1[685] * w[1][0];
    sp1[767] = sp1[686] * w[1][0];
    sp1[768] = sp1[687] * w[1][0];
    sp1[769] = sp1[688] * w[1][0];
    sp1[770] = sp1[689] * w[1][0];
    sp1[771] = sp1[690] * w[1][0];
    sp1[772] = sp1[691] * w[1][0];
    sp1[773] = sp1[692] * w[1][0];
    sp1[774] = sp1[693] * w[1][0];
    sp1[775] = sp1[694] * w[1][0];
    sp1[776] = sp1[695] * w[1][0];
    sp1[777] = sp1[696] * w[1][0];
    sp1[778] = sp1[697] * w[1][0];
    sp1[779] = sp1[698] * w[1][0];
    sp1[780] = sp1[699] * w[1][0];
    sp1[781] = sp1[700] * w[1][0];
    sp1[782] = sp1[701] * w[1][0];
    sp1[783] = sp1[702] * w[1][0];
    sp1[784] = sp1[703] * w[1][0];
    sp1[785] = sp1[704] * w[1][0];
    sp1[786] = sp1[705] * w[1][0];
    sp1[787] = sp1[706] * w[1][0];
    sp1[788] = sp1[707] * w[1][0];
    sp1[789] = sp1[708] * w[1][0];
    sp1[790] = sp1[709] * w[1][0];
    sp1[791] = sp1[710] * w[1][0];
    sp1[792] = sp1[711] * w[1][0];
    sp1[793] = sp1[712] * w[1][0];
    sp1[794] = sp1[713] * w[1][0];
    sp1[795] = sp1[714] * w[1][0];
    sp1[796] = sp1[715] * w[1][0];
    sp1[797] = sp1[716] * w[1][0];
    sp1[798] = sp1[717] * w[1][0];
    sp1[799] = sp1[718] * w[1][0];
    sp1[800] = sp1[719] * w[1][0];
    sp1[801] = sp1[720] * w[1][0];
    sp1[802] = sp1[721] * w[1][0];
    sp1[803] = sp1[722] * w[1][0];
    sp1[804] = sp1[723] * w[1][0];
    sp1[805] = sp1[724] * w[1][0];
    sp1[806] = sp1[725] * w[1][0];
    sp1[807] = sp1[726] * w[1][0];
    sp1[808] = sp1[727] * w[1][0];
    sp1[809] = sp1[728] * w[1][0];
    sp1[810] = sp1[729] * w[1][0];
    sp1[811] = sp1[730] * w[1][0];
    sp1[812] = sp1[731] * w[1][0];
    sp1[813] = sp1[732] * w[1][0];
    sp1[814] = sp1[733] * w[1][0];
    sp1[815] = sp1[734] * w[1][0];
    sp1[816] = sp1[735] * w[1][0];
    sp1[817] = sp1[736] * w[1][0];
    sp1[818] = sp1[737] * w[1][0];
    sp1[819] = sp1[738] * w[1][0];
    sp1[820] = sp1[739] * w[1][0];
    sp1[821] = sp1[740] * w[1][0];
    sp1[822] = sp1[741] * w[1][0];
    sp1[823] = sp1[742] * w[1][0];
    sp1[824] = sp1[743] * w[1][0];
    sp1[825] = sp1[744] * w[1][0];
    sp1[826] = sp1[745] * w[1][0];
    sp1[827] = sp1[746] * w[1][0];
    sp1[828] = sp1[747] * w[1][0];
    sp1[829] = sp1[748] * w[1][0];
    sp1[830] = sp1[749] * w[1][0];
    sp1[831] = sp1[750] * w[1][0];
    sp1[832] = sp1[751] * w[1][0];
    sp1[833] = sp1[752] * w[1][0];
    sp1[834] = sp1[753] * w[1][0];
    sp1[835] = sp1[754] * w[1][0];
    sp1[836] = sp1[755] * w[1][0];
    sp1[837] = sp1[756] * w[1][0];
    sp1[838] = -1 * sp1[757];
    sp1[839] = -1 * sp1[758];
    sp1[840] = -1 * sp1[759];
    sp1[841] = -1 * sp1[760];
    sp1[842] = -1 * sp1[761];
    sp1[843] = -1 * sp1[762];
    sp1[844] = -1 * sp1[763];
    sp1[845] = -1 * sp1[764];
    sp1[846] = -1 * sp1[765];
    sp1[847] = -1 * sp1[766];
    sp1[848] = -1 * sp1[767];
    sp1[849] = -1 * sp1[768];
    sp1[850] = -1 * sp1[769];
    sp1[851] = -1 * sp1[770];
    sp1[852] = -1 * sp1[771];
    sp1[853] = -1 * sp1[772];
    sp1[854] = -1 * sp1[773];
    sp1[855] = -1 * sp1[774];
    sp1[856] = -1 * sp1[775];
    sp1[857] = -1 * sp1[776];
    sp1[858] = -1 * sp1[777];
    sp1[859] = -1 * sp1[778];
    sp1[860] = -1 * sp1[779];
    sp1[861] = -1 * sp1[780];
    sp1[862] = -1 * sp1[781];
    sp1[863] = -1 * sp1[782];
    sp1[864] = -1 * sp1[783];
    sp1[865] = -1 * sp1[784];
    sp1[866] = -1 * sp1[785];
    sp1[867] = -1 * sp1[786];
    sp1[868] = -1 * sp1[787];
    sp1[869] = -1 * sp1[788];
    sp1[870] = -1 * sp1[789];
    sp1[871] = -1 * sp1[790];
    sp1[872] = -1 * sp1[791];
    sp1[873] = -1 * sp1[792];
    sp1[874] = -1 * sp1[793];
    sp1[875] = -1 * sp1[794];
    sp1[876] = -1 * sp1[795];
    sp1[877] = -1 * sp1[796];
    sp1[878] = -1 * sp1[797];
    sp1[879] = -1 * sp1[798];
    sp1[880] = -1 * sp1[799];
    sp1[881] = -1 * sp1[800];
    sp1[882] = -1 * sp1[801];
    sp1[883] = -1 * sp1[802];
    sp1[884] = -1 * sp1[803];
    sp1[885] = -1 * sp1[804];
    sp1[886] = -1 * sp1[805];
    sp1[887] = -1 * sp1[806];
    sp1[888] = -1 * sp1[807];
    sp1[889] = -1 * sp1[808];
    sp1[890] = -1 * sp1[809];
    sp1[891] = -1 * sp1[810];
    sp1[892] = -1 * sp1[811];
    sp1[893] = -1 * sp1[812];
    sp1[894] = -1 * sp1[813];
    sp1[895] = -1 * sp1[814];
    sp1[896] = -1 * sp1[815];
    sp1[897] = -1 * sp1[816];
    sp1[898] = -1 * sp1[817];
    sp1[899] = -1 * sp1[818];
    sp1[900] = -1 * sp1[819];
    sp1[901] = -1 * sp1[820];
    sp1[902] = -1 * sp1[821];
    sp1[903] = -1 * sp1[822];
    sp1[904] = -1 * sp1[823];
    sp1[905] = -1 * sp1[824];
    sp1[906] = -1 * sp1[825];
    sp1[907] = -1 * sp1[826];
    sp1[908] = -1 * sp1[827];
    sp1[909] = -1 * sp1[828];
    sp1[910] = -1 * sp1[829];
    sp1[911] = -1 * sp1[830];
    sp1[912] = -1 * sp1[831];
    sp1[913] = -1 * sp1[832];
    sp1[914] = -1 * sp1[833];
    sp1[915] = -1 * sp1[834];
    sp1[916] = -1 * sp1[835];
    sp1[917] = -1 * sp1[836];
    sp1[918] = -1 * sp1[837];
    sp1[919] = sp1[17] * sp1[17];
    sp1[920] = sp1[17] * sp1[22];
    sp1[921] = sp1[25] * sp1[17];
    sp1[922] = sp1[22] * sp1[22];
    sp1[923] = sp1[25] * sp1[22];
    sp1[924] = sp1[25] * sp1[25];
    sp1[925] = sp1[919] + sp1[919];
    sp1[926] = sp1[920] + sp1[920];
    sp1[927] = sp1[921] + sp1[921];
    sp1[928] = sp1[922] + sp1[922];
    sp1[929] = sp1[923] + sp1[923];
    sp1[930] = sp1[924] + sp1[924];
    sp1[931] = sp1[48] * sp1[48];
    sp1[932] = sp1[48] * sp1[53];
    sp1[933] = sp1[48] * sp1[58];
    sp1[934] = sp1[53] * sp1[53];
    sp1[935] = sp1[53] * sp1[58];
    sp1[936] = sp1[58] * sp1[58];
    sp1[937] = sp1[931] + sp1[931];
    sp1[938] = sp1[932] + sp1[932];
    sp1[939] = sp1[933] + sp1[933];
    sp1[940] = sp1[934] + sp1[934];
    sp1[941] = sp1[935] + sp1[935];
    sp1[942] = sp1[936] + sp1[936];
    sp1[943] = sp1[937] + sp1[925];
    sp1[944] = sp1[938] + sp1[926];
    sp1[945] = sp1[939] + sp1[927];
    sp1[946] = sp1[940] + sp1[928];
    sp1[947] = sp1[941] + sp1[929];
    sp1[948] = sp1[930] + sp1[942];
    sp1[949] = sp1[33] * sp1[33];
    sp1[950] = sp1[33] * sp1[38];
    sp1[951] = sp1[43] * sp1[33];
    sp1[952] = sp1[38] * sp1[38];
    sp1[953] = sp1[43] * sp1[38];
    sp1[954] = sp1[43] * sp1[43];
    sp1[955] = sp1[949] + sp1[949];
    sp1[956] = sp1[950] + sp1[950];
    sp1[957] = sp1[951] + sp1[951];
    sp1[958] = sp1[952] + sp1[952];
    sp1[959] = sp1[953] + sp1[953];
    sp1[960] = sp1[954] + sp1[954];
    sp1[961] = sp1[943] + sp1[955];
    sp1[962] = sp1[944] + sp1[956];
    sp1[963] = sp1[945] + sp1[957];
    sp1[964] = sp1[946] + sp1[958];
    sp1[965] = sp1[947] + sp1[959];
    sp1[966] = sp1[948] + sp1[960];
    sp1[967] = w[1][0] / 2;
    sp1[968] = sp1[961] * sp1[967];
    sp1[969] = sp1[962] * sp1[967];
    sp1[970] = sp1[963] * sp1[967];
    sp1[971] = sp1[964] * sp1[967];
    sp1[972] = sp1[965] * sp1[967];
    sp1[973] = sp1[966] * sp1[967];
    sp1[974] = sp1[841] + sp1[968];
    sp1[975] = sp1[842] + sp1[969];
    sp1[976] = sp1[843] + sp1[970];
    sp1[977] = sp1[850] + sp1[969];
    sp1[978] = sp1[851] + sp1[971];
    sp1[979] = sp1[852] + sp1[972];
    sp1[980] = sp1[859] + sp1[970];
    sp1[981] = sp1[860] + sp1[972];
    sp1[982] = sp1[861] + sp1[973];
    sp1[983] = sp1[865] + sp1[968];
    sp1[984] = sp1[866] + sp1[969];
    sp1[985] = sp1[867] + sp1[970];
    sp1[986] = sp1[871] + sp1[969];
    sp1[987] = sp1[872] + sp1[971];
    sp1[988] = sp1[873] + sp1[972];
    sp1[989] = sp1[877] + sp1[970];
    sp1[990] = sp1[878] + sp1[972];
    sp1[991] = sp1[879] + sp1[973];
    sp1[992] = sp1[910] + sp1[968];
    sp1[993] = sp1[911] + sp1[969];
    sp1[994] = sp1[912] + sp1[970];
    sp1[995] = sp1[913] + sp1[969];
    sp1[996] = sp1[914] + sp1[971];
    sp1[997] = sp1[915] + sp1[972];
    sp1[998] = sp1[916] + sp1[970];
    sp1[999] = sp1[917] + sp1[972];
    sp1[1000] = sp1[918] + sp1[973];
    sp1[1001] = 2 * sp1[451];
    sp1[1002] = 2 * sp1[452];
    sp1[1003] = 2 * sp1[453];
    sp1[1004] = 2 * sp1[454];
    sp1[1005] = 2 * sp1[455];
    sp1[1006] = 2 * sp1[456];
    sp1[1007] = 2 * sp1[457];
    sp1[1008] = 2 * sp1[458];
    sp1[1009] = 2 * sp1[459];
    sp1[1010] = sp1[1001] * sp1[454];
    sp1[1011] = sp1[1001] * sp1[455];
    sp1[1012] = sp1[1001] * sp1[456];
    sp1[1013] = sp1[1001] * sp1[451];
    sp1[1014] = sp1[1001] * sp1[452];
    sp1[1015] = sp1[1001] * sp1[453];
    sp1[1016] = sp1[1001] * sp1[457];
    sp1[1017] = sp1[1001] * sp1[458];
    sp1[1018] = sp1[1001] * sp1[459];
    sp1[1019] = sp1[1002] * sp1[454];
    sp1[1020] = sp1[1002] * sp1[455];
    sp1[1021] = sp1[1002] * sp1[456];
    sp1[1022] = sp1[1002] * sp1[451];
    sp1[1023] = sp1[1002] * sp1[452];
    sp1[1024] = sp1[1002] * sp1[453];
    sp1[1025] = sp1[1002] * sp1[457];
    sp1[1026] = sp1[1002] * sp1[458];
    sp1[1027] = sp1[1002] * sp1[459];
    sp1[1028] = sp1[1003] * sp1[454];
    sp1[1029] = sp1[1003] * sp1[455];
    sp1[1030] = sp1[1003] * sp1[456];
    sp1[1031] = sp1[1003] * sp1[451];
    sp1[1032] = sp1[1003] * sp1[452];
    sp1[1033] = sp1[1003] * sp1[453];
    sp1[1034] = sp1[1003] * sp1[457];
    sp1[1035] = sp1[1003] * sp1[458];
    sp1[1036] = sp1[1003] * sp1[459];
    sp1[1037] = sp1[1004] * sp1[454];
    sp1[1038] = sp1[1004] * sp1[455];
    sp1[1039] = sp1[1004] * sp1[456];
    sp1[1040] = sp1[1004] * sp1[451];
    sp1[1041] = sp1[1004] * sp1[452];
    sp1[1042] = sp1[1004] * sp1[453];
    sp1[1043] = sp1[1004] * sp1[457];
    sp1[1044] = sp1[1004] * sp1[458];
    sp1[1045] = sp1[1004] * sp1[459];
    sp1[1046] = sp1[1005] * sp1[454];
    sp1[1047] = sp1[1005] * sp1[455];
    sp1[1048] = sp1[1005] * sp1[456];
    sp1[1049] = sp1[1005] * sp1[451];
    sp1[1050] = sp1[1005] * sp1[452];
    sp1[1051] = sp1[1005] * sp1[453];
    sp1[1052] = sp1[1005] * sp1[457];
    sp1[1053] = sp1[1005] * sp1[458];
    sp1[1054] = sp1[1005] * sp1[459];
    sp1[1055] = sp1[1006] * sp1[454];
    sp1[1056] = sp1[1006] * sp1[455];
    sp1[1057] = sp1[1006] * sp1[456];
    sp1[1058] = sp1[1006] * sp1[451];
    sp1[1059] = sp1[1006] * sp1[452];
    sp1[1060] = sp1[1006] * sp1[453];
    sp1[1061] = sp1[1006] * sp1[457];
    sp1[1062] = sp1[1006] * sp1[458];
    sp1[1063] = sp1[1006] * sp1[459];
    sp1[1064] = sp1[1007] * sp1[454];
    sp1[1065] = sp1[1007] * sp1[455];
    sp1[1066] = sp1[1007] * sp1[456];
    sp1[1067] = sp1[1007] * sp1[451];
    sp1[1068] = sp1[1007] * sp1[452];
    sp1[1069] = sp1[1007] * sp1[453];
    sp1[1070] = sp1[1007] * sp1[457];
    sp1[1071] = sp1[1007] * sp1[458];
    sp1[1072] = sp1[1007] * sp1[459];
    sp1[1073] = sp1[1008] * sp1[454];
    sp1[1074] = sp1[1008] * sp1[455];
    sp1[1075] = sp1[1008] * sp1[456];
    sp1[1076] = sp1[1008] * sp1[451];
    sp1[1077] = sp1[1008] * sp1[452];
    sp1[1078] = sp1[1008] * sp1[453];
    sp1[1079] = sp1[1008] * sp1[457];
    sp1[1080] = sp1[1008] * sp1[458];
    sp1[1081] = sp1[1008] * sp1[459];
    sp1[1082] = sp1[1009] * sp1[454];
    sp1[1083] = sp1[1009] * sp1[455];
    sp1[1084] = sp1[1009] * sp1[456];
    sp1[1085] = sp1[1009] * sp1[451];
    sp1[1086] = sp1[1009] * sp1[452];
    sp1[1087] = sp1[1009] * sp1[453];
    sp1[1088] = sp1[1009] * sp1[457];
    sp1[1089] = sp1[1009] * sp1[458];
    sp1[1090] = sp1[1009] * sp1[459];
    sp1[1091] = 2 * sp1[676];
    sp1[1092] = 2 * sp1[677];
    sp1[1093] = 2 * sp1[678];
    sp1[1094] = 2 * sp1[679];
    sp1[1095] = 2 * sp1[680];
    sp1[1096] = 2 * sp1[681];
    sp1[1097] = 2 * sp1[682];
    sp1[1098] = 2 * sp1[683];
    sp1[1099] = 2 * sp1[684];
    sp1[1100] = 2 * sp1[685];
    sp1[1101] = 2 * sp1[686];
    sp1[1102] = 2 * sp1[687];
    sp1[1103] = 2 * sp1[688];
    sp1[1104] = 2 * sp1[689];
    sp1[1105] = 2 * sp1[690];
    sp1[1106] = 2 * sp1[691];
    sp1[1107] = 2 * sp1[692];
    sp1[1108] = 2 * sp1[693];
    sp1[1109] = 2 * sp1[694];
    sp1[1110] = 2 * sp1[695];
    sp1[1111] = 2 * sp1[696];
    sp1[1112] = 2 * sp1[697];
    sp1[1113] = 2 * sp1[698];
    sp1[1114] = 2 * sp1[699];
    sp1[1115] = 2 * sp1[700];
    sp1[1116] = 2 * sp1[701];
    sp1[1117] = 2 * sp1[702];
    sp1[1118] = 2 * sp1[703];
    sp1[1119] = 2 * sp1[704];
    sp1[1120] = 2 * sp1[705];
    sp1[1121] = 2 * sp1[706];
    sp1[1122] = 2 * sp1[707];
    sp1[1123] = 2 * sp1[708];
    sp1[1124] = 2 * sp1[709];
    sp1[1125] = 2 * sp1[710];
    sp1[1126] = 2 * sp1[711];
    sp1[1127] = 2 * sp1[712];
    sp1[1128] = 2 * sp1[713];
    sp1[1129] = 2 * sp1[714];
    sp1[1130] = 2 * sp1[715];
    sp1[1131] = 2 * sp1[716];
    sp1[1132] = 2 * sp1[717];
    sp1[1133] = 2 * sp1[718];
    sp1[1134] = 2 * sp1[719];
    sp1[1135] = 2 * sp1[720];
    sp1[1136] = 2 * sp1[721];
    sp1[1137] = 2 * sp1[722];
    sp1[1138] = 2 * sp1[723];
    sp1[1139] = 2 * sp1[724];
    sp1[1140] = 2 * sp1[725];
    sp1[1141] = 2 * sp1[726];
    sp1[1142] = 2 * sp1[727];
    sp1[1143] = 2 * sp1[728];
    sp1[1144] = 2 * sp1[729];
    sp1[1145] = 2 * sp1[730];
    sp1[1146] = 2 * sp1[731];
    sp1[1147] = 2 * sp1[732];
    sp1[1148] = 2 * sp1[733];
    sp1[1149] = 2 * sp1[734];
    sp1[1150] = 2 * sp1[735];
    sp1[1151] = 2 * sp1[736];
    sp1[1152] = 2 * sp1[737];
    sp1[1153] = 2 * sp1[738];
    sp1[1154] = 2 * sp1[739];
    sp1[1155] = 2 * sp1[740];
    sp1[1156] = 2 * sp1[741];
    sp1[1157] = 2 * sp1[742];
    sp1[1158] = 2 * sp1[743];
    sp1[1159] = 2 * sp1[744];
    sp1[1160] = 2 * sp1[745];
    sp1[1161] = 2 * sp1[746];
    sp1[1162] = 2 * sp1[747];
    sp1[1163] = 2 * sp1[748];
    sp1[1164] = 2 * sp1[749];
    sp1[1165] = 2 * sp1[750];
    sp1[1166] = 2 * sp1[751];
    sp1[1167] = 2 * sp1[752];
    sp1[1168] = 2 * sp1[753];
    sp1[1169] = 2 * sp1[754];
    sp1[1170] = 2 * sp1[755];
    sp1[1171] = 2 * sp1[756];
    sp1[1172] = std::log(sp1[450]);
    sp1[1173] = sp1[1091] * sp1[1172];
    sp1[1174] = sp1[1092] * sp1[1172];
    sp1[1175] = sp1[1093] * sp1[1172];
    sp1[1176] = sp1[1094] * sp1[1172];
    sp1[1177] = sp1[1095] * sp1[1172];
    sp1[1178] = sp1[1096] * sp1[1172];
    sp1[1179] = sp1[1097] * sp1[1172];
    sp1[1180] = sp1[1098] * sp1[1172];
    sp1[1181] = sp1[1099] * sp1[1172];
    sp1[1182] = sp1[1100] * sp1[1172];
    sp1[1183] = sp1[1101] * sp1[1172];
    sp1[1184] = sp1[1102] * sp1[1172];
    sp1[1185] = sp1[1103] * sp1[1172];
    sp1[1186] = sp1[1104] * sp1[1172];
    sp1[1187] = sp1[1105] * sp1[1172];
    sp1[1188] = sp1[1106] * sp1[1172];
    sp1[1189] = sp1[1107] * sp1[1172];
    sp1[1190] = sp1[1108] * sp1[1172];
    sp1[1191] = sp1[1109] * sp1[1172];
    sp1[1192] = sp1[1110] * sp1[1172];
    sp1[1193] = sp1[1111] * sp1[1172];
    sp1[1194] = sp1[1112] * sp1[1172];
    sp1[1195] = sp1[1113] * sp1[1172];
    sp1[1196] = sp1[1114] * sp1[1172];
    sp1[1197] = sp1[1115] * sp1[1172];
    sp1[1198] = sp1[1116] * sp1[1172];
    sp1[1199] = sp1[1117] * sp1[1172];
    sp1[1200] = sp1[1118] * sp1[1172];
    sp1[1201] = sp1[1119] * sp1[1172];
    sp1[1202] = sp1[1120] * sp1[1172];
    sp1[1203] = sp1[1121] * sp1[1172];
    sp1[1204] = sp1[1122] * sp1[1172];
    sp1[1205] = sp1[1123] * sp1[1172];
    sp1[1206] = sp1[1124] * sp1[1172];
    sp1[1207] = sp1[1125] * sp1[1172];
    sp1[1208] = sp1[1126] * sp1[1172];
    sp1[1209] = sp1[1127] * sp1[1172];
    sp1[1210] = sp1[1128] * sp1[1172];
    sp1[1211] = sp1[1129] * sp1[1172];
    sp1[1212] = sp1[1130] * sp1[1172];
    sp1[1213] = sp1[1131] * sp1[1172];
    sp1[1214] = sp1[1132] * sp1[1172];
    sp1[1215] = sp1[1133] * sp1[1172];
    sp1[1216] = sp1[1134] * sp1[1172];
    sp1[1217] = sp1[1135] * sp1[1172];
    sp1[1218] = sp1[1136] * sp1[1172];
    sp1[1219] = sp1[1137] * sp1[1172];
    sp1[1220] = sp1[1138] * sp1[1172];
    sp1[1221] = sp1[1139] * sp1[1172];
    sp1[1222] = sp1[1140] * sp1[1172];
    sp1[1223] = sp1[1141] * sp1[1172];
    sp1[1224] = sp1[1142] * sp1[1172];
    sp1[1225] = sp1[1143] * sp1[1172];
    sp1[1226] = sp1[1144] * sp1[1172];
    sp1[1227] = sp1[1145] * sp1[1172];
    sp1[1228] = sp1[1146] * sp1[1172];
    sp1[1229] = sp1[1147] * sp1[1172];
    sp1[1230] = sp1[1148] * sp1[1172];
    sp1[1231] = sp1[1149] * sp1[1172];
    sp1[1232] = sp1[1150] * sp1[1172];
    sp1[1233] = sp1[1151] * sp1[1172];
    sp1[1234] = sp1[1152] * sp1[1172];
    sp1[1235] = sp1[1153] * sp1[1172];
    sp1[1236] = sp1[1154] * sp1[1172];
    sp1[1237] = sp1[1155] * sp1[1172];
    sp1[1238] = sp1[1156] * sp1[1172];
    sp1[1239] = sp1[1157] * sp1[1172];
    sp1[1240] = sp1[1158] * sp1[1172];
    sp1[1241] = sp1[1159] * sp1[1172];
    sp1[1242] = sp1[1160] * sp1[1172];
    sp1[1243] = sp1[1161] * sp1[1172];
    sp1[1244] = sp1[1162] * sp1[1172];
    sp1[1245] = sp1[1163] * sp1[1172];
    sp1[1246] = sp1[1164] * sp1[1172];
    sp1[1247] = sp1[1165] * sp1[1172];
    sp1[1248] = sp1[1166] * sp1[1172];
    sp1[1249] = sp1[1167] * sp1[1172];
    sp1[1250] = sp1[1168] * sp1[1172];
    sp1[1251] = sp1[1169] * sp1[1172];
    sp1[1252] = sp1[1170] * sp1[1172];
    sp1[1253] = sp1[1171] * sp1[1172];
    sp1[1254] = sp1[1010] + sp1[1173];
    sp1[1255] = sp1[1019] + sp1[1174];
    sp1[1256] = sp1[1028] + sp1[1175];
    sp1[1257] = sp1[1037] + sp1[1176];
    sp1[1258] = sp1[1046] + sp1[1177];
    sp1[1259] = sp1[1055] + sp1[1178];
    sp1[1260] = sp1[1064] + sp1[1179];
    sp1[1261] = sp1[1073] + sp1[1180];
    sp1[1262] = sp1[1082] + sp1[1181];
    sp1[1263] = sp1[1011] + sp1[1182];
    sp1[1264] = sp1[1020] + sp1[1183];
    sp1[1265] = sp1[1029] + sp1[1184];
    sp1[1266] = sp1[1038] + sp1[1185];
    sp1[1267] = sp1[1047] + sp1[1186];
    sp1[1268] = sp1[1056] + sp1[1187];
    sp1[1269] = sp1[1065] + sp1[1188];
    sp1[1270] = sp1[1074] + sp1[1189];
    sp1[1271] = sp1[1083] + sp1[1190];
    sp1[1272] = sp1[1012] + sp1[1191];
    sp1[1273] = sp1[1021] + sp1[1192];
    sp1[1274] = sp1[1030] + sp1[1193];
    sp1[1275] = sp1[1039] + sp1[1194];
    sp1[1276] = sp1[1048] + sp1[1195];
    sp1[1277] = sp1[1057] + sp1[1196];
    sp1[1278] = sp1[1066] + sp1[1197];
    sp1[1279] = sp1[1075] + sp1[1198];
    sp1[1280] = sp1[1084] + sp1[1199];
    sp1[1281] = sp1[1013] + sp1[1200];
    sp1[1282] = sp1[1014] + sp1[1201];
    sp1[1283] = sp1[1015] + sp1[1202];
    sp1[1284] = sp1[1016] + sp1[1203];
    sp1[1285] = sp1[1017] + sp1[1204];
    sp1[1286] = sp1[1018] + sp1[1205];
    sp1[1287] = sp1[1022] + sp1[1206];
    sp1[1288] = sp1[1023] + sp1[1207];
    sp1[1289] = sp1[1024] + sp1[1208];
    sp1[1290] = sp1[1025] + sp1[1209];
    sp1[1291] = sp1[1026] + sp1[1210];
    sp1[1292] = sp1[1027] + sp1[1211];
    sp1[1293] = sp1[1031] + sp1[1212];
    sp1[1294] = sp1[1032] + sp1[1213];
    sp1[1295] = sp1[1033] + sp1[1214];
    sp1[1296] = sp1[1034] + sp1[1215];
    sp1[1297] = sp1[1035] + sp1[1216];
    sp1[1298] = sp1[1036] + sp1[1217];
    sp1[1299] = sp1[1040] + sp1[1218];
    sp1[1300] = sp1[1041] + sp1[1219];
    sp1[1301] = sp1[1042] + sp1[1220];
    sp1[1302] = sp1[1043] + sp1[1221];
    sp1[1303] = sp1[1044] + sp1[1222];
    sp1[1304] = sp1[1045] + sp1[1223];
    sp1[1305] = sp1[1049] + sp1[1224];
    sp1[1306] = sp1[1050] + sp1[1225];
    sp1[1307] = sp1[1051] + sp1[1226];
    sp1[1308] = sp1[1052] + sp1[1227];
    sp1[1309] = sp1[1053] + sp1[1228];
    sp1[1310] = sp1[1054] + sp1[1229];
    sp1[1311] = sp1[1058] + sp1[1230];
    sp1[1312] = sp1[1059] + sp1[1231];
    sp1[1313] = sp1[1060] + sp1[1232];
    sp1[1314] = sp1[1061] + sp1[1233];
    sp1[1315] = sp1[1062] + sp1[1234];
    sp1[1316] = sp1[1063] + sp1[1235];
    sp1[1317] = sp1[1067] + sp1[1236];
    sp1[1318] = sp1[1076] + sp1[1237];
    sp1[1319] = sp1[1085] + sp1[1238];
    sp1[1320] = sp1[1068] + sp1[1239];
    sp1[1321] = sp1[1077] + sp1[1240];
    sp1[1322] = sp1[1086] + sp1[1241];
    sp1[1323] = sp1[1069] + sp1[1242];
    sp1[1324] = sp1[1078] + sp1[1243];
    sp1[1325] = sp1[1087] + sp1[1244];
    sp1[1326] = sp1[1070] + sp1[1245];
    sp1[1327] = sp1[1079] + sp1[1246];
    sp1[1328] = sp1[1088] + sp1[1247];
    sp1[1329] = sp1[1071] + sp1[1248];
    sp1[1330] = sp1[1080] + sp1[1249];
    sp1[1331] = sp1[1089] + sp1[1250];
    sp1[1332] = sp1[1072] + sp1[1251];
    sp1[1333] = sp1[1081] + sp1[1252];
    sp1[1334] = sp1[1090] + sp1[1253];
    sp1[1335] = w[2][0] / 2;
    sp1[1336] = sp1[1254] * sp1[1335];
    sp1[1337] = sp1[1255] * sp1[1335];
    sp1[1338] = sp1[1256] * sp1[1335];
    sp1[1339] = sp1[1257] * sp1[1335];
    sp1[1340] = sp1[1258] * sp1[1335];
    sp1[1341] = sp1[1259] * sp1[1335];
    sp1[1342] = sp1[1260] * sp1[1335];
    sp1[1343] = sp1[1261] * sp1[1335];
    sp1[1344] = sp1[1262] * sp1[1335];
    sp1[1345] = sp1[1263] * sp1[1335];
    sp1[1346] = sp1[1264] * sp1[1335];
    sp1[1347] = sp1[1265] * sp1[1335];
    sp1[1348] = sp1[1266] * sp1[1335];
    sp1[1349] = sp1[1267] * sp1[1335];
    sp1[1350] = sp1[1268] * sp1[1335];
    sp1[1351] = sp1[1269] * sp1[1335];
    sp1[1352] = sp1[1270] * sp1[1335];
    sp1[1353] = sp1[1271] * sp1[1335];
    sp1[1354] = sp1[1272] * sp1[1335];
    sp1[1355] = sp1[1273] * sp1[1335];
    sp1[1356] = sp1[1274] * sp1[1335];
    sp1[1357] = sp1[1275] * sp1[1335];
    sp1[1358] = sp1[1276] * sp1[1335];
    sp1[1359] = sp1[1277] * sp1[1335];
    sp1[1360] = sp1[1278] * sp1[1335];
    sp1[1361] = sp1[1279] * sp1[1335];
    sp1[1362] = sp1[1280] * sp1[1335];
    sp1[1363] = sp1[1281] * sp1[1335];
    sp1[1364] = sp1[1282] * sp1[1335];
    sp1[1365] = sp1[1283] * sp1[1335];
    sp1[1366] = sp1[1284] * sp1[1335];
    sp1[1367] = sp1[1285] * sp1[1335];
    sp1[1368] = sp1[1286] * sp1[1335];
    sp1[1369] = sp1[1287] * sp1[1335];
    sp1[1370] = sp1[1288] * sp1[1335];
    sp1[1371] = sp1[1289] * sp1[1335];
    sp1[1372] = sp1[1290] * sp1[1335];
    sp1[1373] = sp1[1291] * sp1[1335];
    sp1[1374] = sp1[1292] * sp1[1335];
    sp1[1375] = sp1[1293] * sp1[1335];
    sp1[1376] = sp1[1294] * sp1[1335];
    sp1[1377] = sp1[1295] * sp1[1335];
    sp1[1378] = sp1[1296] * sp1[1335];
    sp1[1379] = sp1[1297] * sp1[1335];
    sp1[1380] = sp1[1298] * sp1[1335];
    sp1[1381] = sp1[1299] * sp1[1335];
    sp1[1382] = sp1[1300] * sp1[1335];
    sp1[1383] = sp1[1301] * sp1[1335];
    sp1[1384] = sp1[1302] * sp1[1335];
    sp1[1385] = sp1[1303] * sp1[1335];
    sp1[1386] = sp1[1304] * sp1[1335];
    sp1[1387] = sp1[1305] * sp1[1335];
    sp1[1388] = sp1[1306] * sp1[1335];
    sp1[1389] = sp1[1307] * sp1[1335];
    sp1[1390] = sp1[1308] * sp1[1335];
    sp1[1391] = sp1[1309] * sp1[1335];
    sp1[1392] = sp1[1310] * sp1[1335];
    sp1[1393] = sp1[1311] * sp1[1335];
    sp1[1394] = sp1[1312] * sp1[1335];
    sp1[1395] = sp1[1313] * sp1[1335];
    sp1[1396] = sp1[1314] * sp1[1335];
    sp1[1397] = sp1[1315] * sp1[1335];
    sp1[1398] = sp1[1316] * sp1[1335];
    sp1[1399] = sp1[1317] * sp1[1335];
    sp1[1400] = sp1[1318] * sp1[1335];
    sp1[1401] = sp1[1319] * sp1[1335];
    sp1[1402] = sp1[1320] * sp1[1335];
    sp1[1403] = sp1[1321] * sp1[1335];
    sp1[1404] = sp1[1322] * sp1[1335];
    sp1[1405] = sp1[1323] * sp1[1335];
    sp1[1406] = sp1[1324] * sp1[1335];
    sp1[1407] = sp1[1325] * sp1[1335];
    sp1[1408] = sp1[1326] * sp1[1335];
    sp1[1409] = sp1[1327] * sp1[1335];
    sp1[1410] = sp1[1328] * sp1[1335];
    sp1[1411] = sp1[1329] * sp1[1335];
    sp1[1412] = sp1[1330] * sp1[1335];
    sp1[1413] = sp1[1331] * sp1[1335];
    sp1[1414] = sp1[1332] * sp1[1335];
    sp1[1415] = sp1[1333] * sp1[1335];
    sp1[1416] = sp1[1334] * sp1[1335];
    sp1[1417] = sp1[838] + sp1[1336];
    sp1[1418] = sp1[839] + sp1[1337];
    sp1[1419] = sp1[840] + sp1[1338];
    sp1[1420] = sp1[974] + sp1[1339];
    sp1[1421] = sp1[975] + sp1[1340];
    sp1[1422] = sp1[976] + sp1[1341];
    sp1[1423] = sp1[844] + sp1[1342];
    sp1[1424] = sp1[845] + sp1[1343];
    sp1[1425] = sp1[846] + sp1[1344];
    sp1[1426] = sp1[847] + sp1[1345];
    sp1[1427] = sp1[848] + sp1[1346];
    sp1[1428] = sp1[849] + sp1[1347];
    sp1[1429] = sp1[977] + sp1[1348];
    sp1[1430] = sp1[978] + sp1[1349];
    sp1[1431] = sp1[979] + sp1[1350];
    sp1[1432] = sp1[853] + sp1[1351];
    sp1[1433] = sp1[854] + sp1[1352];
    sp1[1434] = sp1[855] + sp1[1353];
    sp1[1435] = sp1[856] + sp1[1354];
    sp1[1436] = sp1[857] + sp1[1355];
    sp1[1437] = sp1[858] + sp1[1356];
    sp1[1438] = sp1[980] + sp1[1357];
    sp1[1439] = sp1[981] + sp1[1358];
    sp1[1440] = sp1[982] + sp1[1359];
    sp1[1441] = sp1[862] + sp1[1360];
    sp1[1442] = sp1[863] + sp1[1361];
    sp1[1443] = sp1[864] + sp1[1362];
    sp1[1444] = sp1[983] + sp1[1363];
    sp1[1445] = sp1[984] + sp1[1364];
    sp1[1446] = sp1[985] + sp1[1365];
    sp1[1447] = sp1[868] + sp1[1366];
    sp1[1448] = sp1[869] + sp1[1367];
    sp1[1449] = sp1[870] + sp1[1368];
    sp1[1450] = sp1[986] + sp1[1369];
    sp1[1451] = sp1[987] + sp1[1370];
    sp1[1452] = sp1[988] + sp1[1371];
    sp1[1453] = sp1[874] + sp1[1372];
    sp1[1454] = sp1[875] + sp1[1373];
    sp1[1455] = sp1[876] + sp1[1374];
    sp1[1456] = sp1[989] + sp1[1375];
    sp1[1457] = sp1[990] + sp1[1376];
    sp1[1458] = sp1[991] + sp1[1377];
    sp1[1459] = sp1[880] + sp1[1378];
    sp1[1460] = sp1[881] + sp1[1379];
    sp1[1461] = sp1[882] + sp1[1380];
    sp1[1462] = sp1[883] + sp1[1381];
    sp1[1463] = sp1[884] + sp1[1382];
    sp1[1464] = sp1[885] + sp1[1383];
    sp1[1465] = sp1[886] + sp1[1384];
    sp1[1466] = sp1[887] + sp1[1385];
    sp1[1467] = sp1[888] + sp1[1386];
    sp1[1468] = sp1[889] + sp1[1387];
    sp1[1469] = sp1[890] + sp1[1388];
    sp1[1470] = sp1[891] + sp1[1389];
    sp1[1471] = sp1[892] + sp1[1390];
    sp1[1472] = sp1[893] + sp1[1391];
    sp1[1473] = sp1[894] + sp1[1392];
    sp1[1474] = sp1[895] + sp1[1393];
    sp1[1475] = sp1[896] + sp1[1394];
    sp1[1476] = sp1[897] + sp1[1395];
    sp1[1477] = sp1[898] + sp1[1396];
    sp1[1478] = sp1[899] + sp1[1397];
    sp1[1479] = sp1[900] + sp1[1398];
    sp1[1480] = sp1[901] + sp1[1399];
    sp1[1481] = sp1[902] + sp1[1400];
    sp1[1482] = sp1[903] + sp1[1401];
    sp1[1483] = sp1[904] + sp1[1402];
    sp1[1484] = sp1[905] + sp1[1403];
    sp1[1485] = sp1[906] + sp1[1404];
    sp1[1486] = sp1[907] + sp1[1405];
    sp1[1487] = sp1[908] + sp1[1406];
    sp1[1488] = sp1[909] + sp1[1407];
    sp1[1489] = sp1[992] + sp1[1408];
    sp1[1490] = sp1[993] + sp1[1409];
    sp1[1491] = sp1[994] + sp1[1410];
    sp1[1492] = sp1[995] + sp1[1411];
    sp1[1493] = sp1[996] + sp1[1412];
    sp1[1494] = sp1[997] + sp1[1413];
    sp1[1495] = sp1[998] + sp1[1414];
    sp1[1496] = sp1[999] + sp1[1415];
    sp1[1497] = sp1[1000] + sp1[1416];
    sp1[1498] = std::abs(sp1[16]);
    // Only 1 quadrature point, no loop
    {
        // Quadrature loop body setup (num_points=1)
        // Unstructured varying computations
        alignas(32) double sv1[82];
        sv1[0] = weights1[0] * sp1[1498];
        sv1[1] = sp1[1417] * sv1[0];
        sv1[2] = sp1[1418] * sv1[0];
        sv1[3] = sp1[1419] * sv1[0];
        sv1[4] = sp1[1420] * sv1[0];
        sv1[5] = sp1[1421] * sv1[0];
        sv1[6] = sp1[1422] * sv1[0];
        sv1[7] = sp1[1423] * sv1[0];
        sv1[8] = sp1[1424] * sv1[0];
        sv1[9] = sp1[1425] * sv1[0];
        sv1[10] = sp1[1426] * sv1[0];
        sv1[11] = sp1[1427] * sv1[0];
        sv1[12] = sp1[1428] * sv1[0];
        sv1[13] = sp1[1429] * sv1[0];
        sv1[14] = sp1[1430] * sv1[0];
        sv1[15] = sp1[1431] * sv1[0];
        sv1[16] = sp1[1432] * sv1[0];
        sv1[17] = sp1[1433] * sv1[0];
        sv1[18] = sp1[1434] * sv1[0];
        sv1[19] = sp1[1435] * sv1[0];
        sv1[20] = sp1[1436] * sv1[0];
        sv1[21] = sp1[1437] * sv1[0];
        sv1[22] = sp1[1438] * sv1[0];
        sv1[23] = sp1[1439] * sv1[0];
        sv1[24] = sp1[1440] * sv1[0];
        sv1[25] = sp1[1441] * sv1[0];
        sv1[26] = sp1[1442] * sv1[0];
        sv1[27] = sp1[1443] * sv1[0];
        sv1[28] = sp1[1444] * sv1[0];
        sv1[29] = sp1[1445] * sv1[0];
        sv1[30] = sp1[1446] * sv1[0];
        sv1[31] = sp1[1447] * sv1[0];
        sv1[32] = sp1[1448] * sv1[0];
        sv1[33] = sp1[1449] * sv1[0];
        sv1[34] = sp1[1450] * sv1[0];
        sv1[35] = sp1[1451] * sv1[0];
        sv1[36] = sp1[1452] * sv1[0];
        sv1[37] = sp1[1453] * sv1[0];
        sv1[38] = sp1[1454] * sv1[0];
        sv1[39] = sp1[1455] * sv1[0];
        sv1[40] = sp1[1456] * sv1[0];
        sv1[41] = sp1[1457] * sv1[0];
        sv1[42] = sp1[1458] * sv1[0];
        sv1[43] = sp1[1459] * sv1[0];
        sv1[44] = sp1[1460] * sv1[0];
        sv1[45] = sp1[1461] * sv1[0];
        sv1[46] = sp1[1462] * sv1[0];
        sv1[47] = sp1[1463] * sv1[0];
        sv1[48] = sp1[1464] * sv1[0];
        sv1[49] = sp1[1465] * sv1[0];
        sv1[50] = sp1[1466] * sv1[0];
        sv1[51] = sp1[1467] * sv1[0];
        sv1[52] = sp1[1468] * sv1[0];
        sv1[53] = sp1[1469] * sv1[0];
        sv1[54] = sp1[1470] * sv1[0];
        sv1[55] = sp1[1471] * sv1[0];
        sv1[56] = sp1[1472] * sv1[0];
        sv1[57] = sp1[1473] * sv1[0];
        sv1[58] = sp1[1474] * sv1[0];
        sv1[59] = sp1[1475] * sv1[0];
        sv1[60] = sp1[1476] * sv1[0];
        sv1[61] = sp1[1477] * sv1[0];
        sv1[62] = sp1[1478] * sv1[0];
        sv1[63] = sp1[1479] * sv1[0];
        sv1[64] = sp1[1480] * sv1[0];
        sv1[65] = sp1[1481] * sv1[0];
        sv1[66] = sp1[1482] * sv1[0];
        sv1[67] = sp1[1483] * sv1[0];
        sv1[68] = sp1[1484] * sv1[0];
        sv1[69] = sp1[1485] * sv1[0];
        sv1[70] = sp1[1486] * sv1[0];
        sv1[71] = sp1[1487] * sv1[0];
        sv1[72] = sp1[1488] * sv1[0];
        sv1[73] = sp1[1489] * sv1[0];
        sv1[74] = sp1[1490] * sv1[0];
        sv1[75] = sp1[1491] * sv1[0];
        sv1[76] = sp1[1492] * sv1[0];
        sv1[77] = sp1[1493] * sv1[0];
        sv1[78] = sp1[1494] * sv1[0];
        sv1[79] = sp1[1495] * sv1[0];
        sv1[80] = sp1[1496] * sv1[0];
        sv1[81] = sp1[1497] * sv1[0];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[73] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[76] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[79] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[64] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[67] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[70] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[7] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[16] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[25] * FE36_C0_D100_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[74] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[77] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[80] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[65] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[68] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[71] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[8] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[17] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[26] * FE36_C0_D010_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[75] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[78] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[81] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[66] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[69] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[72] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[9] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[18] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 0; ia0 < 4; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[27] * FE36_C0_D001_Q1[0][0][ia0 - 0] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[31] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[32] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[33] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[28] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[29] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[30] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[1] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[10] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 6; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[19] * FE36_C0_D100_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[37] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[38] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[39] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[34] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[35] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[36] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[2] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[11] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 7; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[20] * FE36_C0_D010_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[43] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[44] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[45] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[40] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[41] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[42] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[3] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[12] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 4; ia0 < 8; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[21] * FE36_C0_D001_Q1[0][0][ia0 - 4] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[49] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[50] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[51] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[46] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[47] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[48] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[4] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[13] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 10; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[22] * FE36_C0_D100_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[55] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[56] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[57] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[52] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[53] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[54] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[5] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[14] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 11; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[23] * FE36_C0_D010_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[61] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[62] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 0; ia1 < 4; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[63] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 4; ia1 < 6; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[58] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 4; ia1 < 7; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[59] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 4; ia1 < 8; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[60] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 4];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 8; ia1 < 10; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[6] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D100_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 8; ia1 < 11; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[15] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D010_Q1[0][0][ia1 - 8];
            }
        }
        for (int ia0 = 8; ia0 < 12; ++ia0)
        {
            for (int ia1 = 8; ia1 < 12; ++ia1)
            {
                A[12 * ia0 + ia1] += sv1[24] * FE36_C0_D001_Q1[0][0][ia0 - 8] * FE36_C0_D001_Q1[0][0][ia1 - 8];
            }
        }
    }
  }

};


class hyperelasticity_form_0: public ufc::form
{
public:

  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "a07b9447da6ae9d949071750728923b9a3830037df8dc006b3d5d1a798c395ca9f4f9042a3d9dc5ac3f20404c374f55a83569594155770a581a577ace2d220c2";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 5;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new hyperelasticity_exterior_facet_integral_0_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class hyperelasticity_form_1: public ufc::form
{
public:

  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "89b4df7f5669048713d37817883c73cd4ce5dc8d75fb4c6225803635d0742d0817b6a13559cd5dca2c8aaa5729e7969608bcc70b489943c2173ef1583e467241";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 3;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 3, 4});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace HyperElasticity
{

class CoefficientSpace_B: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_T: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_F_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_F_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_F_FunctionSpace_1;

typedef CoefficientSpace_B Form_F_FunctionSpace_2;

typedef CoefficientSpace_T Form_F_FunctionSpace_3;

typedef CoefficientSpace_mu Form_F_FunctionSpace_4;

typedef CoefficientSpace_lmbda Form_F_FunctionSpace_5;

class Form_F: public dolfin::Form
{
public:

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Destructor
  ~Form_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner B;
  dolfin::CoefficientAssigner T;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_F: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_F(V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner B;
  dolfin::MultiMeshCoefficientAssigner T;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

class Form_J_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_J_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_J_FunctionSpace_2;

typedef CoefficientSpace_mu Form_J_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_J_FunctionSpace_4;

class Form_J: public dolfin::Form
{
public:

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Destructor
  ~Form_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_J: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
    add(a);

    }
    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

// Class typedefs
typedef Form_J BilinearForm;
typedef MultiMeshForm_J MultiMeshBilinearForm;
typedef Form_J JacobianForm;
typedef MultiMeshForm_J MultiMeshJacobianForm;
typedef Form_F LinearForm;
typedef MultiMeshForm_F MultiMeshLinearForm;
typedef Form_F ResidualForm;
typedef MultiMeshForm_F MultiMeshResidualForm;
typedef Form_F::TestSpace FunctionSpace;
typedef Form_F::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
