#!/usr/bin/perl
use Debbugs::RemoteBTS::LDAP;
use Data::Dumper;

$ldap = Debbugs::RemoteBTS::LDAP->new ('bugs.debian.org',
				       'port' => 35567,
				       'dn' => 'ou=Bugs,o=Debian Project,c=US');
$ldap->connect or die "$@";

# Dump contents of a BugReport object
$result = $ldap->bugFromID (9697);
print Dumper($result);

# List ids and subjects of e2fsprogs bugs
print "e2fsprogs:\n";
@bugs = $ldap->packageBugs ('e2fsprogs');
foreach $bug (@bugs) {
  printf "%s - %s\n", $bug->{BTSATTRIBS}->{bugid}, $bug->{BTSATTRIBS}->{subject};
}
