#!/usr/bin/perl

package Debbugs::BugReport;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {};
  
  $self->{BTSATTRIBS}={};
  $self->{DMBTATTRIBS}={};
  $self->{USERATTRIBS}={};

  bless ($self, $class);
  return $self;
}

sub init_from_LDAP_entry {
  my $self = shift;
  my ($entry) = @_;

  use Net::LDAP::Entry;

  $self->{BTSATTRIBS}={};
  foreach my $attr ($entry->attributes) {
    # FIXME: no support for multiline fields
    $self->{BTSATTRIBS}->{$attr} = $entry->get($attr)->[0];
  }
}

sub init_from_XML_tree {
  my $self = shift;
  my ($tree) = @_;

  my $attr = shift @$tree;

  while (my $categ = shift @$tree) {
    my $categtree = shift @$tree;
    my $categattr = shift @$categtree;
    while (my $key = shift @$categtree) {
      # FIXME: no support for multiline fields
      $self->{uc ($categ) . 'ATTRIBS'}->{$key} = ${shift @{$categtree}}[2];
    }
  }
}

use XML::Writer;

sub write_to_XML_stream {
  my $self = shift;
  my ($writer) = @_;
  
  $writer->startTag ("bug");

  $writer->startTag ("bts");
  _write_attribs_hash ($writer, $self->{BTSATTRIBS});
  $writer->endTag ("bts");

  $writer->startTag ("dmbt");
  _write_attribs_hash ($writer, $self->{DMBTATTRIBS});  
  $writer->endTag ("dmbt");

  $writer->startTag ("user");
  _write_attribs_hash ($writer, $self->{USERATTRIBS});  
  $writer->endTag ("user");

  $writer->endTag ("bug");
}

sub _write_attribs_hash {
  my ($writer, $attribs) = @_;

  foreach my $key (keys %{$attribs}) {
    $writer->startTag ($key);
#     foreach my $line (@{$attribs->{$key}}) {
#       $writer->characters($line);
#     }
    $writer->characters ($attribs->{$key});
    $writer->endTag ($key);
  }  
}

TRUE;
