/*
 *  dlisp / a dancer's lisp parser library
 *  Copyright (C) 2002-2003 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * header file
 */

/** @file dlispparser.h
    @brief header for file dancer's lisp parser library
 */

#ifndef __DLISPPARSER_H__
#define __DLISPPARSER_H__


/**
   structure representing the lisp data.
 */
typedef struct dlisp_lispentry
{
  /** the main content. Text. NULL if it is a bracket kind of thing. */
  char * name;		
  /** the inside-braces contents ((->child ->child->next))  */
  struct dlisp_lispentry * child;
  /** the next-item (xxx next)  */
  struct dlisp_lispentry * next;	
  /** 
      type of entry.
      
      if dlisp_bracket, child != NULL.
      
      if dlisp_cdata, name != NULL
  */
  enum 
    {
      /** Constant data  */
      dlisp_cdata,
      /** bracket */
      dlisp_bracket,
      /** quoted text '() */
      dlisp_quotedtext, 		
      /** string constant "text" */
      dlisp_stringconstant,	
      /** sharp vector constant #(xx xxx) */
      dlisp_sharp_vector_constant,	
      /** quasi-quote  ` */
      dlisp_quasiquote,		
      /** ,@() */
      dlisp_commaat, 		
      /** ,() */
      dlisp_comma,		
      /** Error content, this should not exist */
      dlisp_error
    } type;			
} dlisp_lispentry;


dlisp_lispentry *
dlisp_read_lisp_bracket (FILE*f);

dlisp_lispentry * 
dlisp_read_lisp_text (FILE*f);

void dlisp_free (dlisp_lispentry * e);

#endif
