/* idlist.h -- definitions for idlist.h
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef DDJ_IDLIST_H
#define DDJ_IDLIST_H

#include <glib.h>

/* The IDList data structure */
typedef struct {
  int num_ids;
  int *ids;
  int current_id;
} IDList;

/* A stack of idlists */
typedef struct {
  IDList *id_lists;
  IDList *current_idlist;
  int stack_pos;
  int stack_size;
} IDStack;

/* Function declarations */
void FreeIDList(IDList *idlist);
void CopyIDList(IDList *src_idlist,IDList *dest_idlist);
void TrimIDList(IDList *idlist,int size);
void RemoveIDs(IDList *idlist,int pos,int num);
void InsertIDs(IDList *idlist,IDList *insert_list,int pos);
void SortIDList(IDList *idlist);
void UniqeIDList(IDList *idlist);
void ScrambleInts(int *list,int size);
IDStack *NewIDStack(int size);
void FreeIDStack(IDStack *idstack);
void PushIDList(IDStack *idstack);
gboolean PopIDList(IDStack *idstack);

#endif /* DDJ_IDLIST_H */
