/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/diff_exception.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::Diff_Exception
 *
 * $Id: test_exception.hpp,v 1.11 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UTIL__DIFF_EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DIFF_EXCEPTION_HPP__INCLUDE_GUARD

#include <diagnostics/unittest/namespace.hpp>

// used as base class
#include <diagnostics/frame/std_exception.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

/**
 * @class Diff_Exception diagnostics/util/diff_exception.hpp 
 *
 * @brief Thrown if the diff generator is unable to generate a diff output
 * (e.g., due to resource limits).
 *
 * @nosubgrouping 
 */
class Diff_Exception :
    public Std_Exception
{
public:
    /**
     * @throw never
     */
    inline Diff_Exception(::std::string const & what) :
	Std_Exception(what)
    {
    }

    /**
     * @throw never
     */
    virtual ~Diff_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    
    /**
     * @throw never
     */
    virtual char const * name() const;
};

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
