/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/test_front_end.hpp
 *
 * $Id: test_front_end.hpp,v 1.21 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Macros for testing
 *
 * @todo diagnostics/macros/test_front_end.t.hpp
 */
#ifndef DIAGNOSTICS__MACROS__TEST_FRONT_END_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__TEST_FRONT_END_HPP__INCLUDE_GUARD

#include <diagnostics/macros/check_annotation.hpp>
#include <diagnostics/macros/assert_annotation.hpp>
#include <diagnostics/macros/block_annotation.hpp>
#include <diagnostics/macros/invariance_annotation.hpp>
#include <diagnostics/macros/throwing_block_annotation.hpp>
#include <diagnostics/macros/exceptionless_block_annotation.hpp>
#include <diagnostics/macros/relation_modifier.hpp>

#include <diagnostics/unittest/test_exception.hpp>

#include <cstring>

////////////////////////////////////////////////////////////////////////////////

// config

#ifndef TEST_BASE_EXCEPTION_TYPE
#  define TEST_BASE_EXCEPTION_TYPE ::diagnostics::Exception
#  include <diagnostics/frame/exception.hpp>
#  define TEST_BASE_EXCEPTION_STR_WHAT(EX) (::std::string("EXCEPTION=\"") + (EX).name() + "\" WHAT=\"" + (EX).what() + "\"")
#endif

#ifndef TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY
#  define TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY 0
#endif


#ifndef TEST_FAILED_ASSERT_ACTION
#  define TEST_FAILED_ASSERT_ACTION(NAME,COND) throw NAME(#COND)
#endif

#ifndef TEST_FAILED_ASSERT_ACTION1
#  define TEST_FAILED_ASSERT_ACTION1(NAME,COND,EXCEP_WHAT) throw NAME(EXCEP_WHAT)
#endif

#ifndef TEST_FAILED_CHECK_ACTION
#  define TEST_FAILED_CHECK_ACTION(NAME,COND) throw NAME(#COND)
#endif

#ifndef TEST_FAILED_CHECK_ACTION1
#  define TEST_FAILED_CHECK_ACTION1(NAME,COND,EXCEP_WHAT) throw NAME(EXCEP_WHAT)
#endif

////////////////////////////////////////////////////////////////////////////////

// derived config


#if TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY == 1
#  include <diagnostics/unittest/test_exception.hpp>
#endif

#ifndef TEST_BASE_EXCEPTION_STR_WHAT
#  warning TEST_BASE_EXCEPTION_STR_WHAT not defined
#endif

////////////////////////////////////////////////////////////////////////////////

#define TEST_TRACE(STR_WHAT) \
   DIAGNOSTICS_BASE_LOG(::diagnostics::LEVEL_TEST, \
                        ::diagnostics::TYPE_TRACE,0,STR_WHAT)
#define TEST_BINARY_TRACE(STR_WHAT) \
   DIAGNOSTICS_BASE_LOG(::diagnostics::LEVEL_TEST, \
                        ::diagnostics::TYPE_TRACE_BINARY,0,STR_WHAT)


#define TEST_BLOCK_ENTER(STR_WHAT)  \
  DIAGNOSTICS_BASE_BLOCK_ENTER(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_BLOCK_ENTER,\
                               ::diagnostics::TYPE_BLOCK_EXIT,\
                               0,\
                               (STR_WHAT))
#define TEST_BLOCK_EXIT DIAGNOSTICS_BASE_BLOCK_EXIT
#define TEST_BLOCK_GUARD(STR_WHAT) \
  DIAGNOSTICS_BASE_BLOCK_GUARD(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_BLOCK_ENTER,\
                               ::diagnostics::TYPE_BLOCK_EXIT,\
                               0, \
                               (STR_WHAT))

#define TEST_PROCEDURE_ENTER(STR_WHAT) \
  DIAGNOSTICS_BASE_BLOCK_ENTER(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_PROCEDURE_ENTER,\
                               ::diagnostics::TYPE_PROCEDURE_EXIT,\
                               0, \
                               ::std::string("procedure=\"") + DIAGNOSTICS_FUNC_NAME + "\" " + (STR_WHAT))
#define TEST_PROCEDURE_EXIT DIAGNOSTICS_BASE_BLOCK_EXIT
#define TEST_PROCEDURE_GUARD(STR_WHAT) \
  DIAGNOSTICS_BASE_BLOCK_GUARD(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_PROCEDURE_ENTER,\
                               ::diagnostics::TYPE_PROCEDURE_EXIT,\
                               0, \
                               ::std::string("procedure=\"") + DIAGNOSTICS_FUNC_NAME + "\" " + (STR_WHAT))


#define TEST_METHOD_ENTER(STR_WHAT) \
  DIAGNOSTICS_BASE_BLOCK_ENTER(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_METHOD_ENTER,\
                               ::diagnostics::TYPE_METHOD_EXIT,\
                               0, \
                               ::std::string("method=\"") + DIAGNOSTICS_FUNC_NAME + "\" " + (STR_WHAT))
#define TEST_METHOD_EXIT DIAGNOSTICS_BASE_BLOCK_EXIT
#define TEST_METHOD_GUARD(STR_WHAT) \
  DIAGNOSTICS_BASE_BLOCK_GUARD(::diagnostics::LEVEL_TEST,\
                               ::diagnostics::TYPE_METHOD_ENTER,\
                               ::diagnostics::TYPE_METHOD_EXIT,\
                               0, \
                               ::std::string("method=\"") + DIAGNOSTICS_FUNC_NAME + "\" " + (STR_WHAT))


////////////////////////////////////////////////////////////////////////////////

#define TEST_ASSERT(COND) \
  DIAGNOSTICS_BASE_ASSERT(::diagnostics::LEVEL_TEST, \
                          0,"CONDITION=\"" #COND "\" EXCEPTION=\"" "Test_Exception" "\"",COND,\
                          TEST_FAILED_ASSERT_ACTION(::diagnostics::unittest::Test_Exception,COND))
#define TEST_ASSERT1(NAME,COND,EXCEP_WHAT) \
  DIAGNOSTICS_BASE_ASSERT(::diagnostics::LEVEL_TEST, \
                          0,\
                          ::std::string("CONDITION=\"" #COND "\" EXCEPTION=\"" #NAME "\" WHAT=\"") + (EXCEP_WHAT) + "\"",\
                          COND,TEST_FAILED_ASSERT_ACTION1(NAME,COND,EXCEP_WHAT))
#define TEST_CHECK(COND) \
  DIAGNOSTICS_BASE_CHECK(::diagnostics::LEVEL_TEST, \
                          0,"CONDITION=\"" #COND "\" EXCEPTION=\"" "Test_Exception" "\"",COND,\
                          TEST_FAILED_CHECK_ACTION(::diagnostics::unittest::Test_Exception,COND))
#define TEST_CHECK1(NAME,COND,STR_WHAT) \
  DIAGNOSTICS_BASE_CHECK(::diagnostics::LEVEL_TEST, \
                         0,\
                         ::std::string("CONDITION=\"" #COND "\" EXCEPTION=\"" #NAME "\" WHAT=\"") + (STR_WHAT) + "\"",\
                         COND,TEST_FAILED_CHECK_ACTION1(NAME,COND,STR_WHAT))


#define TEST_CLASS_THROWING_INVARINACE_ENTER DIAGNOSTICS_BASE_CLASS_THROWING_INVARIANCE_ENTER
#define TEST_CLASS_THROWING_INVARINACE_EXIT \
  DIAGNOSTICS_BASE_CLASS_THROWING_INVARIANCE_EXIT(::diagnostics::LEVEL_TEST,\
                                         0, \
                                         TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY,\
                                         TEST_BASE_EXCEPTION_TYPE,\
                                         TEST_BASE_EXCEPTION_STR_WHAT)

#define TEST_CLASS_INVARINACE_GUARD DIAGNOSTICS_BASE_CLASS_INVARIANCE_GUARD
#define TEST_CLASS_INVARINACE_ENTER DIAGNOSTICS_BASE_CLASS_INVARIANCE_ENTER
#define TEST_CLASS_INVARINACE_EXIT  DIAGNOSTICS_BASE_CLASS_INVARIANCE_EXIT


#define TEST_EXCEPTIONLESS_BLOCK_ENTER  DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER
#define TEST_EXCEPTIONLESS_BLOCK_EXIT \
  DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(::diagnostics::LEVEL_TEST,\
                                            0, \
                                            false,\
                                            TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY,\
                                            TEST_BASE_EXCEPTION_TYPE,\
                                            TEST_BASE_EXCEPTION_STR_WHAT)


#define TEST_THROWING_BLOCK_ENTER       DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER

#define TEST_INTERNAL_THROWING_BLOCK_EXIT_TRUE true
#define TEST_INTERNAL_THROWING_BLOCK_EXIT_EMPTY(e) ""

#define TEST_THROWING_BLOCK_EXIT(EXCEP) \
  DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(::diagnostics::LEVEL_TEST,\
                                       0, \
                                       EXCEP,\
                                       TEST_INTERNAL_THROWING_BLOCK_EXIT_TRUE, \
                                       TEST_INTERNAL_THROWING_BLOCK_EXIT_EMPTY, \
                                       false,\
                                       TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY,\
                                       TEST_BASE_EXCEPTION_TYPE,\
                                       TEST_BASE_EXCEPTION_STR_WHAT)

#define TEST_INTERNAL_THROWING_BLOCK_EXIT_CHECK_WHAT(WHAT) (::strcmp(e.what(),WHAT)==0)

#define TEST_THROWING_BLOCK_EXIT1(EXCEP,WHAT) \
          DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(::diagnostics::LEVEL_TEST,\
                                               0, \
                                               EXCEP,\
                                               TEST_INTERNAL_THROWING_BLOCK_EXIT_CHECK_WHAT(WHAT), \
                                               TEST_BASE_EXCEPTION_STR_WHAT, \
                                               false,\
                                               TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY,\
                                               TEST_BASE_EXCEPTION_TYPE,\
                                               TEST_BASE_EXCEPTION_STR_WHAT)

#define TEST_THROWING_BLOCK_EXIT2(EXCEP,PRED) \
          DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(::diagnostics::LEVEL_TEST,\
                                               0, \
                                               EXCEP,\
                                               PRED, \
                                               TEST_BASE_EXCEPTION_STR_WHAT, \
                                               false,\
                                               TEST_HANDLE_TEST_EXCEPTION_EXPLICITLY,\
                                               TEST_BASE_EXCEPTION_TYPE,\
                                               TEST_BASE_EXCEPTION_STR_WHAT)




#define TEST_ASSERT_RELATION(OP1,REL,OP2) \
       DIAGNOSTICS_RELATION(TEST_ASSERT1,::diagnostics::unittest::Test_Exception,OP1,REL,OP2)
#define TEST_CHECK_RELATION(OP1,REL,OP2) \
       DIAGNOSTICS_RELATION(TEST_ASSERT1,::diagnostics::unittest::Test_Exception,OP1,REL,OP2)

#endif

// vim:ts=4:sw=4
