/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/exceptionless_block_annotation.hpp
 *
 * $Id: exceptionless_block_annotation.hpp,v 1.9 2005/06/23 09:54:21 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref
 * DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER and @ref
 * DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT
 *
 * @test diagnostics/macros/exceptionless_block_annotation.t.cpp
 */
#ifndef DIAGNOSTICS__MACROS__EXCEPTIONLESS_BLOCK_ANNOTATION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__EXCEPTIONLESS_BLOCK_ANNOTATION_HPP__INCLUDE_GUARD

// ::diagnostics::logging_facility::log
#include <diagnostics/frame/logging_facility.hpp>

// DIAGNOSTICS_BASE_CONCAT
#include <diagnostics/util/preprocessor.hpp>

/**
 * @brief opens a @ref DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT
 */
#define DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER \
     do {  \
       try { 


#define DIAGNOSTICS_INTERNAL_EXCEPTIONLESS_HANDLE_TE0(LEVEL,RETHROW,NR_WHAT) 

#define DIAGNOSTICS_INTERNAL_EXCEPTIONLESS_HANDLE_TE1(LEVEL,RETHROW,NR_WHAT) \
    catch(::diagnostics::unittest::Test_Exception & e) { \
      DIAGNOSTICS_BASE_LOG(LEVEL,::diagnostics::TYPE_UNEXPECTED_EXCEPTION,(NR_WHAT), \
			   (::std::string("EXCEPTION=\"") \
			   + e.name() \
			   + "\" WHAT=\"" \
			   + e.what() \
			   + "\"")); \
      if(RETHROW) throw; \
    } 

/**
 * @brief Closes a block which is supposed not to throw any exception
 *
 * If an exception occurs a @ref
 * diagnostics::TYPE_UNEXPECTED_EXCEPTION record is logged. More
 * specifically, (@a LEVEL, @ref
 * diagnostics::TYPE_UNEXPECTED_EXCEPTION, @a NR_WHAT, @a STR_WHAT(e))
 * is logged, where e is the occured execption of type @a BASE. If an
 * occured exception is not of type @a BASE but is of type @ref
 * diagnostics::unittest::Test_Exception, then name/what fields are
 * read out (if @a HANDLE_TE_EXLPLICITLY is 1). Otherwise the message
 * comes with and what="Unkown Exception". If @a RETHROW is true, the
 * exception is rethrown.
 *
 * @param LEVEL of type @ref diagnostics::Level_t is the log-level of all messages to be generated
 * @param NR_WHAT client specific numerical field
 * @param RETHROW is true iff a possibly occuring execption should be rethrown (if false it is dropped)
 * @param HANDLE_TE_EXLPLICITLY is true iff
 * ::diagnostics::unittest::Test_Exception is to be handled explicitly
 * (i.e. it is not a sub-type of @a BASE)
 * @param BASE is the base type of the exception which are could possibly occur 
 * @param STR_WHAT is a macro which takes one argument and should
 * generate a string. It is used to access the name- and what-field of
 * an execption and generate a corresponding string for the
 * log-message
 */
#define DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL,NR_WHAT,RETHROW,HANDLE_TE_EXLPLICITLY,BASE,STR_WHAT) \
    } \
    DIAGNOSTICS_BASE_CONCAT(DIAGNOSTICS_INTERNAL_EXCEPTIONLESS_HANDLE_TE,HANDLE_TE_EXLPLICITLY)(LEVEL,RETHROW,NR_WHAT) \
    catch(BASE & e) { \
      DIAGNOSTICS_BASE_LOG((LEVEL),::diagnostics::TYPE_UNEXPECTED_EXCEPTION,(NR_WHAT),STR_WHAT(e)); \
      if(RETHROW) throw; \
    } \
    catch(...) { \
      DIAGNOSTICS_BASE_LOG((LEVEL),::diagnostics::TYPE_UNEXPECTED_EXCEPTION,(NR_WHAT),"Unknown Exception"); \
      if(RETHROW) throw; \
    } } while(false)

#endif

// vim:ts=4:sw=4
