/**************************************************************
  (C) 1998 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "objstart.h"
#include "iwc.h"
#include "global.h"
#include "filemanager.h"
#include "shell.h"
#include "extension.h"
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>

void ObjectStart(char* object)
{
  char *text,*text2;
  char *pos;
  char *icon;
  char *start=NULL;
  struct stat info2;

  text2=CutHomeDir(object);
  if (text2[strlen(text2)-1]=='/')
    text2[strlen(text2)-1]=0;
  text=malloc(strlen(text2)+2);
  strcpy(text,text2);
  
  GetLinkNameWithoutLast(&text);

  GetFileInfoFromDesktop(text,&pos,&icon,&start);
  if (start==NULL) {
    strcat(text,"/");
    GetFileInfoFromDesktop(text,&pos,&icon,&start);
    if (start==NULL) {
      if (text[strlen(text)-1]=='/')
        text[strlen(text)-1]=0;
      if (text[0]=='~' && text[1]=='/')
        text[0]='.';
      stat(text,&info2);
      if ((info2.st_mode & S_IFMT) == S_IFDIR)
        strcat(text,"/");
      if (text[0]=='.' && text[1]=='/')
        text[0]='~';
      GetExtensionParameter(text,&icon,&start);
    }
  }
  ExecuteShellWithFollowLink(text,start,NULL,0);
  _exit(0);
}
