/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "detect.h"
#include "utils.h"


struct scanner_info *scanner_detect(struct bus_lst *bus){
  struct scsi_info *scsi= (struct scsi_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  static struct scanner_info *first = (struct scanner_info *)NULL;
  struct scanner_info *result = (struct scanner_info *)NULL;

  if(debug)
    fprintf(stdout, "\nProbing SCANNER...\n");


  /********************************************************************/
  /************************** USB SCANNER *****************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing USB scanner...\n");

  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == SCANNER){
      if(!first){
        first = result = (struct scanner_info *)
                                 my_malloc(sizeof(struct scanner_info));
      }else{
        result->next = (struct scanner_info *)
                                 my_malloc(sizeof(struct scanner_info));
        result = result->next;
      }/*endif*/
      result->next = (struct scanner_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->device = s_not_available;
      result->module = usb->modulename;
      result->long_id = usb->id;
      result->bus = USB;
      if(debug)
	fprintf(stdout, "\t\tFound %s", result->model);
    }/*endif*/
  }/*next usb*/
  
  
  /********************************************************************/
  /*************************** SCSI Scanner ***************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing SCSI scanner...\n");

  for(scsi = bus->scsi; scsi; scsi = scsi->next){
    if(scsi->type == SCANNER){
      if(!first){
        first = result = (struct scanner_info *) 
                                 my_malloc(sizeof(struct scanner_info));
      }else{
        result->next = (struct scanner_info *)
                                 my_malloc(sizeof(struct scanner_info));
        result = result->next;
      }/*endif*/
      result->next = (struct scanner_info *)NULL;
      result->vendor = scsi->vendor;
      result->model = scsi->model;
      result->device = scsi->device;
      result->module = s_ignore;
      result->bus = SCSI;
      if(debug)
	fprintf(stdout, ("\t\tFound %s on %s\n"), 
		result->model, result->device);
    }/*endif*/
  }/*next scsi*/
  return first;
}/*endfunc scanner_detect*/
