/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "detect.h"
#include "utils.h"


extern struct bus_lst *init_bus(struct cards_lst *lst){
  struct bus_lst *bus = (struct bus_lst *)
    my_malloc(sizeof(struct bus_lst));

  bus->isa = isa_detect(lst);
  bus->pci = pci_detect(lst);
  bus->pcmcia = pcmcia_detect(lst);
  bus->usb = usb_detect(lst);
  
  bus->ide = ide_detect();
  bus->scsi = scsi_detect();
  
  bus->parallel = parallel_detect();
  bus->serial = serial_detect(lst);
  
  return bus;
}/*endfunc init_bus*/
