#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#ifndef G_OS_WIN32
#include <wait.h>
#endif

#include <errno.h>

#include "print.h"
#include "prefops.h"
#include "exportmudela.h"
#include "utils.h"


/*  Print function 
 *  Save file in lilypond format
 *  Fork and run lilypond
 *  Fork and run tex
 *  Fork and run xdvi
 */
void
print(gpointer callback_data, guint callback_action, GtkWidget *widget)
{
  static GString *filename = NULL;
  static GString *passtosystem;
  pid_t pid;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;

  if(!filename)
    {
       filename = g_string_new(locatedotdenemo ());
       g_string_append(filename, "/denemoprint");
       passtosystem = g_string_new(NULL);
    }

#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork();
#endif

  if(pid == -1)
     {
	fprintf(stderr, "%s: Failed to fork()\n", strerror(errno));
	return;
     }
  else if(pid == 0)
     {
	exportmudela(filename->str,si, 0,0);
	g_string_assign(passtosystem, si->prefs->lilypath->str);
	g_string_append(passtosystem, " -o ");
	g_string_append(passtosystem, filename->str);
	g_string_append(passtosystem, " ");	
	g_string_append(passtosystem, filename->str);
	g_string_append(passtosystem, ".ly");
	
	if(system(passtosystem->str))
          _exit(0);
      	
     	g_string_assign(passtosystem, "tex ");
	g_string_append(passtosystem, filename->str);
	g_string_append(passtosystem, ".tex");
	if(system(passtosystem->str))
	  _exit(0);
	
     	g_string_assign(passtosystem, "xdvi ");
	g_string_append(passtosystem, filename->str);
	g_string_append(passtosystem, ".dvi");
	system("xdvi denemoprint.dvi");
     

	_exit(0);
     }

  
}

