/* lilydirectives.c 
 * Implements lilydirectives which are not notes 
 *
 * A Tee  (c) 2000, 2001, 2002
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chordops.h"
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "datastructures.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"


struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *combobox;
};

static gchar *directives[15] =
  { "ppp", "pp", "p", "mp", "mf", "f", "ff", "fff",
  "sf", "fp", "sfz", "cr", "rc", "dr", "rd"
};




void
insertdirective (GtkWidget * widget, gpointer data)
{

  struct callbackdata *cbdata = data;
  struct scoreinfo *si = cbdata->si;
  gchar *directivestring =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combobox)->entry));
  si->currentmeasure->data =
    g_list_append (si->currentmeasure->data,
		   lily_directive_new (directivestring));

  si->currentobject = g_list_nth (si->currentmeasure->data, si->cursor_x);
  showwhichaccidentalswholestaff (si->currentstaff->data);

  si->cursor_appending = FALSE;
  find_xes_in_all_measures (si);
  nudgerightward (si);
  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}




void
lily_directive (gpointer callback_data, guint callback_action,
		GtkWidget * widget)
{
  int i;
  struct scoreinfo *si = callback_data;
  static struct callbackdata cbdata;
  GtkWidget *dialog;
  GtkWidget *combo;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  GtkWidget *label;
  GList *directivelist = NULL;


  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Insert LilyDirective"));


  label = gtk_label_new (_("Insert Lilydirective:"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);

  combo = gtk_combo_new ();
  if (!directivelist)
    for (i = 0; i < 15; i++)
      {
	directivelist = g_list_append (directivelist, directives[i]);
      }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), directivelist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), directives[0]);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), combo,
		      TRUE, TRUE, 0);
  gtk_widget_show (combo);



  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.combobox = combo;
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (insertdirective), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);
  gtk_widget_grab_focus (combo);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
