/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#include <stdlib.h>
#include <stdio.h>

#include "delo.h"
#include "extents.h"

/*
 * A list of extents.
 */
void extentlist_clear(struct extentlist **head, struct extentlist **last)
{
	if (head)
		while (*head) {
			struct extentlist *tmp = *head;
			*head = tmp->next;
			free(tmp);
		}
	if (last)
		*last = NULL;
}

int32_t extentlist_add_tail(struct extentlist **head,
			    struct extentlist **last, uint32_t extent,
			    uint32_t count)
{
	struct extentlist *tmp;

	tmp = (struct extentlist *)malloc(sizeof(struct extentlist));
	if (!tmp)
		return 1;

	tmp->next = NULL;
	tmp->extent = extent;
	tmp->count = count;

	if (*head)
		(*last)->next = tmp;
	else
		*head = tmp;

	*last = tmp;

	return 0;
}

uint32_t extentlist_size(struct extentlist *head)
{
	uint32_t count = 0;

	while (head) {
		count += head->count;
		head = head->next;
	}
	return count * SECTOR_SIZE;
}

void extentlist_dump(struct extentlist *head)
{
	printf("Extents: ");
	while (head) {
		printf("%d/%d ", head->extent, head->count);
		head = head->next;
	}
	printf("\n");
}
