/* $Id: find.c,v 1.1.1.1 2000/10/13 06:45:02 kitame Exp $

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <gnome.h>

#include "dedit.h"
#include "mdi.h"
#include "find.h"

/****************************************************************************/

static gint string_search(gchar * pattern, gchar * text);
static void find_destroy_cb(GtkWidget * w, GdkEventAny * e, gpointer data);
static void find_cb(GtkWidget * w, gint button, gpointer data);

/****************************************************************************/

static gint
string_search(gchar * pattern, gchar * text)
{
    gint i, j, k;
    gint M = strlen(pattern);
    gint N = strlen(text);

    for (i = 0, j = M - 1; j >= 0; j--) {
		while (pattern[j] != text[i + j]) {
			for (k = 0; j - k >= 0 && pattern[j - k] != text[i + j]; k++);
			i += k;
			j = M - 1;
			if ((i + j) > N)
				return -1;
		}
    }
    return i;
}

void
find_dialog(GtkWidget *w, gpointer data)
{
    DEdit *tmp;
    GtkWidget *entry;

    const gchar *find_history = "find_history";

#ifdef TRACE_FUNC
    printf("find_dialog()\n");
#endif
    
    tmp = get_doc_from_mdi_child();
    if(tmp) {
        entry = gnome_entry_new(find_history);
        gnome_entry_load_history(GNOME_ENTRY(entry));
        gtk_widget_show(entry);

        tmp->find = gnome_dialog_new(_("Find string"),
                                     _("Find"),
                                     GNOME_STOCK_BUTTON_CLOSE,
                                     NULL);
        gtk_window_set_modal(GTK_WINDOW(tmp->find), TRUE);

        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(tmp->find)->vbox),
                           entry, TRUE, TRUE, GNOME_PAD);
        gtk_signal_connect(GTK_OBJECT(tmp->find), "delete_event",
                           find_destroy_cb, NULL);
        gtk_signal_connect(GTK_OBJECT(tmp->find), "clicked",
                           find_cb, entry);

        gtk_window_position(GTK_WINDOW(tmp->find), GTK_WIN_POS_MOUSE);
        gtk_widget_show(tmp->find);
    }

    return;
}

static void
find_cb(GtkWidget *w, gint button, gpointer data)
{
    DEdit *tmp;
    GtkWidget *entry;

#ifdef TRACE_FUNC
    printf("find_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        entry = gnome_entry_gtk_entry(GNOME_ENTRY(data));
        g_free(tmp->search_str);
        tmp->search_str = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));

        if (button == 0) {
            find_again_cb(NULL, NULL);
        } else {
            find_destroy_cb(w, NULL, NULL);
        }
    }
    return;
}

static void
find_destroy_cb(GtkWidget *w, GdkEventAny *e, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("find_destroy_cb()\n");
#endif
  
    tmp = get_doc_from_mdi_child();
    if(tmp) {
        gtk_widget_destroy(GTK_WIDGET(tmp->find));
    }
    return;
}

void
find_again_cb(GtkWidget *w, gpointer data)
{
    DEdit *tmp;

    GtkText *t;

    gchar *pattern;
    gchar *text;

    gint len;

    gint result;

#ifdef TRACE_FUNC
    printf("find_again_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        // gnome_appbar_push(tmp->tit_bar, _("Searching..."));
        
        t = (GtkText *)tmp->text;

        pattern = tmp->search_str;

        len = gtk_text_get_length(t);
        text = gtk_editable_get_chars(GTK_EDITABLE(t), 0, len);
        
        if(!pattern) {
            // gnome_appbar_pop(tmp->tit_bar);
            gnome_app_flash(GNOME_APP(DEmdi), _("No search string was specified!"));
            return;
        }

        result = string_search(pattern, text + tmp->search_pos);

        if (result != -1) {
            result += tmp->search_pos;
            tmp->search_pos = result + strlen(pattern);
            gtk_editable_set_position(GTK_EDITABLE(t), result);
            gtk_editable_select_region(GTK_EDITABLE(t), result, tmp->search_pos);
        } else {
            tmp->search_pos = 0;
        }

        // gnome_appbar_pop(tmp->tit_bar);
    }
    return;
}
