#ifndef __cfg_h__
#define __cfg_h__


#include "dictionary.h"
#include "set.h"
#include <stdio.h>


/** Maximum number of symbols. */
#define SYMBOLS 256

/**
 * Maximum number of symbols on the right-hand-side of a production.
 */
#define MAX_RHS 16


/** Production. */
typedef struct {
	/** Left-hand-side symbol. */
	int lhs;

	/** Number of right-hand-side symbols. */
	int count;

	/** Right-hand-side symbols. */
	int rhs[MAX_RHS];
} Production;


/** Context free gramar. */
typedef struct {
	/** Symbol table. */
	Dictionary symbols;

	/** Set of non-terminal symbols. */
	Set nonterminal;

	/** Set of terminal symbols. */
	Set terminal;

	/** Precedence of symbols. */
	int precedence[SYMBOLS];

	/** Number of productions alloted. */
	int max;

	/** Number of productions. */
	int count;

	/** Productions. */
	Production* productions;
} CFG;


void clear_cfg( CFG* cfg);
void destroy_cfg( CFG* cfg);
void print_production( const Production* production,
		const Dictionary* symbols);
void print_cfg( const CFG* cfg);
void read_cfg( CFG* cfg, FILE* file);
void read_precedence( CFG* g, FILE* file);


#endif
