#ifndef __dfa_h__
#define __dfa_h__


#include <limits.h>
#include <stdio.h>
#include "set.h"


/** Maximum number of states. */
#define STATES 1024

/** Initial state. */
#define INITIAL_STATE 0

/** No transition. */
#define NO_TRANSITION -1


/** Discrete finite automaton. */
typedef struct {
	/** Adjacency matrix representing possible state transitions. */
	int transition[ STATES][ CHAR_MAX];

	/** Final states. */
	Set final;

	/** Tokens associated with each final state. */
	int tokens[ STATES];
} DFA;


void clear_dfa( DFA* dfa);
void print_dfa( const DFA* dfa);
void read_dfa( DFA* dfa, FILE* file);


#endif
