/*
 * main.c
 *   $Last modified: Thu Mar 30 22:07:03 2000$
 * $Id: main.c,v 1.6 2000/03/30 13:09:24 kamop Exp $
 */

#define _MAIN_C

#include "debwrap.h"

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>
extern int errno;
char global_buff[BUFSIZE*2];
int wait_time = 0;
/*
 * MODULE: main
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
int main(int argc, char *argv[])
{
  int res;
  char *env;
#if 0
  setlocale(LC_MESSAGES, "C");
  setlocale(LC_ALL, "C");
  setlocale(LC_CTYPE, "C");
#endif
  setenv("LC_ALL", "C", 1);
#ifdef DEBUG
  fprintf(stderr, "argc=%d %s %s\n", argc, argv[0], argv[1]);
#endif
  init_dwrap(argc, argv);

  if((env = getenv("DEBWRAP_WAIT")) != NULL){
    wait_time = atoi(env);
  }else{
    wait_time = 0;
  }

  init_qanda();
  init_search_line();
  res = wrapper();
#if 0
  printf("%d\n", errno);
#endif
  return(res);
} /* main() */


/*
 * MODULE: wrapper
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
int wrapper()
{
  char buf[BUFSIZE + 1];
  char line[BUFSIZE + 1];
  char *rstr;
  int size;
  int i,j;
  int pid, status;
  dwrap_t *dwrap;

  static char letter[] = "pqrstu";
  static char number[] = "0123456789abcdef";
  static char master[] = "/dev/ptyXX";
  static char slave[]  = "/dev/ttyXX";
  struct termios t;

  int fd1 = -1;
#if 0
  int res;
  int fd2 = -1;
  int bp = 0;
  int fdtty = -1;
#endif

  dwrap = get_dwrap();

  /* Open pseudo-terminal */
  for(i = 0; i < sizeof(letter) && (fd1 == -1); i++){
    master[8] = letter[i];
    for(j = 0; j < sizeof(number) && (fd1 == -1); j++){
      master[9] = number[j];
#ifdef NONBLOCK
      fd1 = open(master, O_RDWR|O_NDELAY|O_NONBLOCK);
#else
      fd1 = open(master, O_RDWR);
#endif
    }
  }
  if(fd1 == -1){
    fprintf(logfp, "Cannot open pseudo-terminal.\n");
    exit(1);
  }
#ifdef DEBUG
  fprintf(logfp, "Open pseudo-terminal %s\n", master);
  fprintf(logfp, "TERM %s %d\n", ttyname(fd1), isatty(fd1));
#endif
  slave[8] = master[8];
  slave[9] = master[9];

  /* Setup pseudo-terminal */

  tcgetattr(fd1, &t);
  cfmakeraw(&t);
  t.c_lflag &= ~ECHO;
  (void) tcsetattr(fd1, TCSANOW, &t);

#ifdef DEBUG
  fprintf(stderr, "Let's fork()\n");
#endif
  /* fork and start subprocess */
  switch(pid = fork()){
    case -1:
      dwrap_syserr("fork");
      break;
    case 0:
      exec_subprocess(slave, fd1);
      exit(1);
  } /* switch(fork()) */

  j = 0;
#ifndef NONBLOCK
  while((size = read(fd1, buf, BUFSIZE)) > 0){
#else
  while(1){
#ifdef DEBUG
    fprintf(logfp, "READBUF\n");
#endif
    size = read(fd1, buf, BUFSIZE);
    if(size == -1){
#ifdef DEBUG
      fprintf(logfp, "ERRNO(%d)\n", errno);
      fflush(NULL);
#endif
      if(errno == EAGAIN){
        usleep(50);
        continue;
      }
      if(errno == EIO){
        break;
      }
      continue;
    }
    if(size == 0){
#ifdef DEBUG
      fprintf(logfp, "ENDFILE\n");
#endif
      fflush(NULL);
      break;
    }
#endif
    fflush(NULL);
    buf[size] = '\0';
#if 0
    fprintf(logfp, "BUF(%d): '%s'\n__END\n", size, buf);
    fflush(NULL);
#endif
#ifdef DEBUG
    fprintf(logfp, "BUF(%d): '%s'\n__END\n", size, buf);
#endif
    fflush(NULL);
    for(i = 0; i < size; i++){
      if(buf[i] != '\n'){
        line[j++] = buf[i];
        continue;
      }else if(j > 0){
        line[j++] = '\n';
        line[j++] = '\0';
#ifdef DEBUG
        fprintf(logfp, "LINE: %s_ENDLINE\n", line);
#else
        fprintf(logfp, "%s", line);
#endif
        fflush(NULL);
        if((rstr = search_line(line)) != NULL){
          fflush(NULL);
          fprintf(logfp, "%s", rstr);
          fflush(NULL);
          usleep(wait_time);
          write(fd1, rstr, strlen(rstr));
          fflush(NULL);
        }
        j = 0;
      }
    } /* for(i) */
    if(j != 0){
      line[j] = '\n';
      line[j+1] = '\0';
      /*fprintf(logfp, "line: %s\n", line);*/
#ifdef DEBUG
      fprintf(logfp, "LINE: %s_ENDLINE\n", line);
#else
      fprintf(logfp, "%s", line);
#endif
      fflush(NULL);
      if((rstr = search_line(line)) != NULL){
        fflush(NULL);
        printf("%s", rstr);
        fflush(NULL);
        fprintf(logfp, "%s", rstr);
        fflush(NULL);
        usleep(wait_time);
        write(fd1, rstr, strlen(rstr));
        fflush(NULL);
        j = 0;
      }
    }
    /*fprintf(logfp, "1\n");*/
    fflush(NULL);
  } /* while(read) */
  /*fprintf(logfp, "2\n");*/
  fflush(NULL);
  fprintf(logfp, "ERRNO(%d)\n", errno);
  waitpid(pid, &status, WNOHANG);
  return(WEXITSTATUS(status));
} /* wrapper() */

/*
 * MODULE: exec_subprocess
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void exec_subprocess(char *slave, int fd1)
{
  dwrap_t *dwrap;
  int fd2;
  int sid;
#ifdef DEBUG
  int i;
#endif
  int res;
  int flag;
#if 0
  int pres;
  int status;
  int pid;
#endif
  dwrap = get_dwrap();

  /* New Session */
  sid = setsid();
#ifdef DEBUG
  fprintf(logfp, "SID=%d\n", sid);
#endif

  if((fd2 = open(slave, O_RDWR)) == -1){
    close(fd1);
    dwrap_syserr("Cannot open fd2");
    exit(1);
  }
  
  flag = fcntl(fd2, F_GETFD);
  flag |= FD_CLOEXEC;
  fcntl(fd2, F_SETFD, flag);

  /* Connect fd2 to STDIN, STDOUT, STDERR */
  dup2(fd2, 0);
  dup2(fd2, 1);
  dup2(fd2, 2);

  close(fd1);

#ifdef DEBUG
  fprintf(logfp, "SubProcess %s\n", dwrap->command);
  i = 0;
  while(1){
    if((dwrap->argv)[i] == NULL) break;
    fprintf(logfp, "arg[%d] %s\n", i, (dwrap->argv)[i]);
    i++;
  }
#endif


  res = execvp(dwrap->command, dwrap->argv);

  fflush(NULL);
#ifdef DEBUG
  fprintf(logfp, "End %s(%d)\n", dwrap->command, res);
#endif
#if 0
  printf("End %s(%d)\n", dwrap->command, pres);
  system("touch /tmp/OK");
  return(res);
#endif
  close(fd2);
  exit(1);
} /* exec_subprocess() */

/*
 * MODULE: dwrap_syserr
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void dwrap_syserr(char *strings)
{
  fprintf(logfp, "%s\n", strings);
} /* dwrap_syserr() */

/*
 * MODULE: dwrap_fatal
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void dwrap_fatal(char *strings)
{
  fprintf(logfp, "%s\n", strings);
  exit(1);
} /* dwrap_fatal() */
