#include <string.h>

#include <deborphan.h>
#include <xalloc.h>

/* This function compares two 'dep' structures. It returns 1 if the packages
   match, 0 if they do not.
*/
inline unsigned int
pkgcmp(const dep a, const dep b)
{
    if (a.namehash == b.namehash)
	return (strcmp(a.name, b.name) ? 0 : 1);

    return 0;
}

/* Simple function to hash a string to an unsigned int. 
*/
inline unsigned int
strhash(const char *line)
{
    unsigned int r = 0;

    do {
	r ^= *line;
	r <<= 1;
    }
    while (*(line++));

    return r;
}

/* This function removes all occurences of the character 'c' from the
   string 's'.
*/
inline void
strstripchr(char *s, int c)
{
    register char *t;

    /* No need to shift while c is not found. Thank you, Wessel. */
    for (; *s && *s != c; s++);
    t = s;

    do {
	if (*s != c)
	    *(t++) = *s;
    }
    while (*(s++));

    *t = '\0';
}

int
string_to_priority(const char *priority)
{
    switch (upcase(*priority)) {
    case 'R':			/*equired */
	return 1;
    case 'I':			/*mportant */
	return 2;
    case 'S':			/*tandard */
	return 3;
    case 'O':			/*ptional */
	return 4;
    case 'E':			/*xtra */
	return 5;
    default:			/*unknown/error */
	return 0;
    }
}

const char *
priority_to_string(unsigned int priority)
{
    static const char *priorities[] = { "unknown", "required", "important",
	"standard", "optional", "extra"
    };

    return priorities[priority > 5 ? 0 : priority];
}
