/* exit.c - Exit routines and help messages for deborphan
   Copyright (C) 2000 Cris van Pelt

   Distributed under the terms of the Artistic License. */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <deborphan.h>

#ifdef HAVE_ERRNO_H
#  include <errno.h>
extern int errno;
#endif

#ifdef ENABLE_NLS
#  include <libintl.h>
#endif

#ifdef USE_XALLOC
#  include <xalloc.h>
#endif

/* The calling program should set this. */
extern char *program_name;

/* Print an error message stating the program name, an optional,
   user defined string and an error message as produced by strerror(error_no). 
   If exit_status is non-nil, the program will terminate. */
void
error(int exit_status, int error_no, const char *format, ...)
{
    va_list args;
    va_start(args, format);

    fprintf(stderr, "%s", program_name);
    if (format != NULL) {
	fprintf(stderr, ": ");
	vfprintf(stderr, format, args);
    }
    va_end(args);

    if (error_no)
	fprintf(stderr, ": %s\n", strerror(error_no));
    else
	fprintf(stderr, "\n");

    fflush(stderr);

    if (exit_status)
	exit(exit_status);
}

void
exit_help()
{
    print_usage(stdout);

    printf(_("\nThe following options are available:\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--help,           ");
#endif
    printf(_("-h        This help.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--version,        ");
#endif
    printf(_("-v        Version information.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--status-file,    ");
#endif
    printf(_("-f FILE   Use FILE as statusfile.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--show-deps,      ");
#endif
    printf(_("-d        Show dependencies for packages that have them.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--nice-mode,      ");
#endif

#ifdef DEFAULT_NICE
    printf(_("-n        Disable checks for `recommends' and `suggests'.\n"));
#else
    printf(_("-n        Enable checks for `recommends' and `suggests'.\n"));
#endif
#ifdef HAVE_GETOPT_LONG
    printf("--all-packages,   ");
#endif
    printf(_("-a        Compare all packages, not just libs.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--priority,       ");
#endif
    printf(_("-p PRIOR  Select only packages with priority >= PRIOR.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--show-section,   ");
#endif
    printf(_("-s        Show the sections the packages are in.\n"));
#ifdef HAVE_GETOPT_LONG
    printf(_("--no-show-section           Do not show sections.\n"));
#endif
#ifdef HAVE_GETOPT_LONG
    printf("--show-priority,  ");
#endif
    printf(_("-P        Show the packages' priorities.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--force-hold,     ");
#endif
    printf(_("-H        Ignore hold flags.\n"));
#ifdef HAVE_GETOPT_LONG
    printf(_("--guess-dev,                Try to report development packages.\n"));
    printf(_("--guess-perl,               Try to report perl libraries.\n"));
    printf(_("--guess-section,            Try to report libraries in wrong sections.\n"));
    printf(_("--guess-debug,              Try to report debugging libraries.\n"));
    printf(_("--guess-all,                Try all of the above.\n"));
#endif
#ifdef HAVE_GETOPT_LONG
    printf(_("--guess-only,               Generate reports based on package names.\n"));
#endif
#ifdef HAVE_GETOPT_LONG
    printf("--add-keep,       ");
#endif
    printf(_("-A PKGS.. Never report PKGS.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--del-keep,       ");
#endif
    printf(_("-R PKGS.. Report PKGS if there are no dependencies.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--list-keep,      ");
#endif
    printf(_("-L        List the packages that are never reported.\n"));
#ifdef HAVE_GETOPT_LONG
    printf("--keep-file,      ");
#endif
    printf(_("-k FILE   Use FILE to get/store info about kept packages.\n"));
#if (defined HAVE_GETOPT_LONG) && (defined DEBFOSTER_KEEP)
    printf(_("--df-keep,                  Read debfoster's keepers file.\n"));
    printf(_("--no-df-keep,               Do not read debfoster's keepers file.\n"));
#endif
    printf(_("\n\
See also: deborphan(1), orphaner(8)\n\
Report bugs to: Cris van Pelt <tribbel@tribe.eu.org>\n"));

    exit(EXIT_SUCCESS);
}

void
exit_version()
{
    printf(_("\
%s %s - Find packages without other packages depending on them\n\
Distributed under the terms of the Artistic License.\n\
\n\
THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR\n\
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED\n\
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n\
\n\
Copyright (C) 2000 Cris van Pelt <tribbel@tribe.eu.org>.\n"), PACKAGE, VERSION);

    exit(EXIT_SUCCESS);
}

void
print_usage(FILE * output)
{
    fprintf(output, _("Usage: %s [OPTIONS] [PACKAGE]...\n"), program_name);
}
