/*!

\if MANPAGES
\page dump2dcm Convert ASCII dump to DICOM file
\else
\page dump2dcm dump2dcm: Convert ASCII dump to DICOM file
\endif

\section synopsis SYNOPSIS

\verbatim
dump2dcm [options] dumpfile-in dcmfile-out
\endverbatim

\section description DESCRIPTION

The \b dump2dcm utility converts an ASCII dumpfile to a dicom file.  The
dumpfile has the same format as the output of \b dcmdump.  Thus it is possible
to capture the output of \b dcmdump into a file, modify some attributes and
create a new dicom file.  However, \b dump2dcm is not really suitable for
generating dicom files containing pixel data.

\section parameters PARAMETERS

\verbatim
dumpfile-in  dump input filename

dcmfile-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information
\endverbatim

\subsection input_options input options
\verbatim
  +l   --line  [m]ax-length: integer
         maximum line length m (default 4096)
\endverbatim

\subsection output_options output options
\verbatim
output file format:

  +F   --write-file
         write file format (default)

  -F   --write-dataset
         write data set without file meta information

output transfer syntax:

  +te  --write-xfer-little
         write with explicit VR little endian (default)

  +tb  --write-xfer-big
         write with explicit VR big endian TS

  +ti  --write-xfer-implicit
         write with implicit VR little endian TS

error handling:

  -E   --stop-on-error
         do not write if dump is damaged (default)

  +E   --ignore-errors
         attempt to write even if dump is damaged

post-1993 value representations:

  +u   --enable-new-vr
         enable support for new VRs (UN/UT) (default)

  -u   --disable-new-vr
         disable support for new VRs, convert to OB

group length encoding:

  +g=  --group-length-recalc
         recalculate group lengths if present (default)

  +g   --group-length-create
         always write with group length elements

  -g   --group-length-remove
         always write without group length elements

length encoding in sequences and items:

  +e   --length-explicit
         write with explicit lengths (default)

  -e   --length-undefined
         write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p=  --padding-retain
         do not change padding (default if not --write-dataset)

  -p   --padding-off
         no padding (implicit if --write-dataset)

  +p   --padding-create  [f]ile-pad [i]tem-pad: integer
         align file on multiple of f bytes
         and items on multiple of i bytes
\endverbatim

\section notes NOTES

\subsection notes_description Dump File Description

The input file can be an output of dcmdump.  One element (Tag, VR, value) must
be written into one line separated by arbitrary spaces or tab characters.
A # begins a comment that ends at the line end.  Empty lines are allowed.

The parts of a line have the following syntax:

\verbatim
Tag:   (gggg,eeee)
       with gggg and eeee are 4 character hexadecimal values
       representing group and element tag.  Spaces and Tabs can be
       anywhere in a Tag specification
VR:    Value Representation must be written as 2 characters as in
       Part 6 of the DICOM standard.  No Spaces or Tabs are allowed
       between the two characters.  If the VR can be determined from
       the Tag, this part of a line is optional.
Value: There are several rules for writing values:
       1. US, SS, SL, UL, FD, FL are written as decimal strings that
          can be read by scanf.
       2. AT is written as '(gggg,eeee)' with additional spaces
          stripped off automatically and gggg and eeee being decimal
          strings that can be read by scanf.
       3. OB, OW values are written as byte or word hexadecimal
          values separated by '\\' character.  Alternatively, OB or OW
          values can be read from a separate file by writing the
          filename prefixed by a '=' character (e.g. '=largepix.dat').
          The contents of the file will be read as is.  OW data is
          expected to be little endian ordered and will be swapped if
          necessary.  No checks will be made to ensure that the amount
          of data is reasonable in terms of other attributes such as
          Rows or Columns.
       4. UI is written as '=Name' in data dictionary or as unique
          identifer string (see 6.), e.g. '[1.2.840.....]'.
       5. Strings without () <> [] spaces, tabs and # can be written
          directly.
       6. Other strings with must be surrounded by [ ].  No bracket
          structure is passed.  The value ends at the last ']' in the
          line.  Anything after the ']' is interpreted as comment.
       7. '(' and '<' are interpreted special and may not be used when
          writing an input file by hand as beginning characters of a
          string. Multiple Value are separated by '\\'.  The lines need
          not be sorted into ascending tag order.  References in DICOM
          Directories are not supported.  Semantic errors are not
          detected.
\endverbatim

\subsection notes_example Example

\verbatim
 (0008,0020) DA [19921012]            #  8, 1 StudyDate
 (0008,0016) UI =MRImageStorage       # 26, 1 SOPClassUID
 (0002,0012) UI [1.2.276.0.7230010.100.1.1]
 (0020,0032) DS [0.0\\0.0]             #  8, 2 ImagePositionPatient
 (0028,0009) AT (3004,000c)           #  4, 1 FrameIncrementPointer
 (0028,0010) US 256                   #  4, 1 Rows
 (0002,0001) OB 01\\00
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dump2dcm utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmdump</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1996-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
