<?php
/*
 * $Id: class.htmlSearchBox.inc.php,v 1.1.2.2 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');
LoadStringResource('tck');

class htmlSearchBox
{
	var $oView;

	function htmlSearchBox()
	{
		$this->oView = CreateObject('dcl.boView');
		$this->oView->style = 'report';
	}

	function submitSearch()
	{
		commonHeader();

		$this->oView->table = $GLOBALS['which'];
		switch ($GLOBALS['which'])
		{
			case 'workorders':
				if (ereg('^([0-9]+)[-]?([0-9]*)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg))
					$this->findWorkOrders($reg[1], $reg[2]);
				else if (ereg('^([0-9]+)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg))
					$this->findWorkOrders($reg[1], 0);
				else
					$this->searchWorkOrders($GLOBALS['HTTP_POST_VARS']['search_text']);
				break;
			case 'dcl_projects':
				if (ereg('^([0-9]+)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg))
					$this->findProject($reg[1], 0);
				else
					$this->searchProjects($GLOBALS['HTTP_POST_VARS']['search_text']);
				break;
			case 'tickets':
				if (ereg('^([0-9]+)$', $GLOBALS['HTTP_POST_VARS']['search_text'], $reg))
					$this->findTicket($reg[1], 0);
				else
					$this->searchTickets($GLOBALS['HTTP_POST_VARS']['search_text']);
				break;
			default:
				print('Error');
				break;
		}
	}

	function findWorkOrders($woid, $seq)
	{
		commonHeader();
		if ($woid == '' || $woid < 1)
		{
			print(STR_WO_NEEDJCNERR);
			return;
		}

		if ($seq > 0)
		{
			$obj = CreateObject('dcl.htmlWorkOrderDetail');
			$obj->Show($woid, $seq);
			return;
		}

		$this->oView->title = STR_WO_RESULTSTITLE;

		$this->oView->AddDef('filter', 'jcn', $woid);
		if ($seq > 0)
			$this->oView->AddDef('filter', 'seq', $seq);

		$this->oView->AddDef('columns', '',
			array('jcn', 'seq', 'responsible.short', 'products.name', 'statuses.name', 'eststarton', 'deadlineon',
				'etchours', 'totalhours', 'summary'));

		$this->oView->AddDef('order', '', array('jcn', 'seq'));

		$this->oView->AddDef('columnhdrs', '',
			array(STR_WO_JCN, STR_WO_SEQ, STR_WO_RESPONSIBLE, STR_WO_PRODUCT,
				STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));

		$objHV = CreateViewObject($this->oView->table);
		$objHV->Render($this->oView);
	}

	function searchWorkOrders($searchText)
	{
		commonHeader();

		$this->oView->title = STR_WO_RESULTSTITLE;

		$this->oView->AddDef('filterlike', 'description', $searchText);
		$this->oView->AddDef('filterlike', 'summary', $searchText);
		$this->oView->AddDef('filterlike', 'workorders.contact', $searchText);
		$this->oView->AddDef('filterlike', 'contactphone', $searchText);
		$this->oView->AddDef('filterlike', 'notes', $searchText);

		$this->oView->AddDef('columns', '',
			array('jcn', 'seq', 'responsible.short', 'products.name', 'statuses.name', 'eststarton', 'deadlineon',
				'etchours', 'totalhours', 'summary'));

		$this->oView->AddDef('order', '', array('jcn', 'seq'));

		$this->oView->AddDef('columnhdrs', '',
			array(STR_WO_JCN, STR_WO_SEQ, STR_WO_RESPONSIBLE, STR_WO_PRODUCT,
				STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));

		$objHV = CreateViewObject($this->oView->table);
		$objHV->Render($this->oView);
	}

	function findTicket($ticketid)
	{
		commonHeader();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($ticketid);

		if ($obj->Load($ticketid) != -1)
		{
			$objHT = CreateObject('dcl.htmlTicketDetail');
			$objHT->Show($obj);
		}
		else
		{
			print('<center><h3>');
			printf(STR_TCK_COULDNOTFIND, $ticketid);
			print('</h3></center>');
		}
	}

	function searchTickets($searchText)
	{
		commonHeader();

		$this->oView->title = STR_TCK_RESULTSTITLE;
		$this->oView->table = 'tickets';

		$this->oView->AddDef('filterlike', 'issue', $searchText);
		$this->oView->AddDef('filterlike', 'summary', $searchText);
		$this->oView->AddDef('filterlike', 'tickets.contact', $searchText);
		$this->oView->AddDef('filterlike', 'contactphone', $searchText);
		$this->oView->AddDef('filterlike', 'contactemail', $searchText);

		$this->oView->AddDef('columns', '',
			array('ticketid', 'responsible', 'product', 'account', 'status', 'contact', 'contactphone', 'summary'));

		$this->oView->AddDef('order', '', array('ticketid'));

		$this->oView->AddDef('columnhdrs', '',
			array(STR_TCK_TICKETID, STR_TCK_RESPONSIBLE, STR_TCK_PRODUCT,
				STR_TCK_ACCOUNT, STR_TCK_STATUS, STR_TCK_CONTACT, STR_TCK_CONTACTPHONE, STR_TCK_SUMMARY));

		$objHV = CreateViewObject($this->oView->table);
		$objHV->Render($this->oView);
	}

	function findProject($projectid)
	{
		commonHeader();

		$obj = CreateObject('dcl.htmlProjectsdetail');
		$obj->show($projectid, 0, 0);
	}

	function searchProjects($searchText)
	{
		commonHeader();
	}
}
?>