<?php
/*
 * $Id: class.htmlLookup.inc.php,v 1.1.1.1.2.1.2.1 2002/07/03 18:35:04 dneighbors Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('lkp');
class htmlLookup
{
	var $id;
	var $active;
	var $name;
	var $mode;

	function htmlLookup()
	{
		$this->id = 0;
		$this->active = 'Y';
		$this->name = '';
		$this->mode = DCL_MODE_ADD;
	}

	function Show($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlLookup.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('CMB_ACTIVE', GetYesNoCombo($this->active, 'dcl_lookup_active', 0, false));
		$Template->set_var('VAL_NAME', htmlspecialchars($this->name));
		$Template->set_var('TXT_NAME', STR_LKP_NAME);
		$Template->set_var('TXT_ACTIVE', STR_LKP_ACTIVE);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);

		if ($this->mode == DCL_MODE_EDIT)
		{
			$Template->set_var('TXT_TITLE', STR_LKP_EDITTITLE);
			$hiddenvars = GetHiddenVar('menuAction', 'boLookup.dbmodify');
			$hiddenvars .= GetHiddenVar('dcl_lookup_id', $this->id);
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_LKP_ADDTITLE);
			$hiddenvars = GetHiddenVar('menuAction', 'boLookup.dbadd');
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->pparse('out', 'hForm');
	}

	function ViewItems()
	{
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbLookup');
		$obj->Connect();
		if ($obj->Load($this->id) == -1)
		{
			print('<center>');
			PrintWithChocoFont(STR_LKP_NOTFOUND, $this->id);
			print('</center>');
			return;
		}

		$oView = CreateObject('dcl.boView');
	}

	function showall()
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbLookup');
		$obj->Connect();

		$obj->Query("SELECT dcl_lookup_id, dcl_lookup_active, dcl_lookup_name FROM dcl_lookup ORDER BY dcl_lookup_name");
		$allRecs = $obj->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="alight" href="' . menuLink('', 'menuAction=boLookup.add') . '">[ ' . STR_CMMN_NEW . ' ]</a>';
		else
			$titleLink = '';

		if (is_array($allRecs))
		{
			$allName = array(
					0 => STR_LKP_ID, 
					1 => STR_LKP_ACTIVEABB, 
					2 => STR_LKP_NAME);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = STR_LKP_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boLookup.view&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_VIEW . '</a>';
					$options .= "&nbsp;";
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boLookup.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
					$options .= "&nbsp;";
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boLookup.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, STR_LKP_TABLETITLE, '', $titleLink);
		}
		else
		{
			print('<center>');
			PrintWithChocoFont(STR_LKP_NOLOOKUPS . '&nbsp;&nbsp;' . $titleLink);
			print('</center>');
		}
	}
}
?>
