<?php
/*
 * $Id: class.htmlAttributesetdetail.inc.php,v 1.2.2.1.2.1 2003/04/22 02:58:34 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('attr');

class htmlAttributesetdetail
{
	function Show($obj)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		if (!is_object($obj))
		{
			print('<center>');
			PrintWithChocoFont('[htmlAttributesets::Show] ' . STR_ATTR_OBJECTNOTPASSED);
			print('</center>');
		}

		$Template = CreateTemplate(array('hForm' => 'htmlAttributesetdetail.tpl'));

		$Template->set_block('hForm', 'actions', 'hActions');
		$Template->set_block('hForm', 'priorities', 'hPriorities');
		$Template->set_block('hForm', 'severities', 'hSeverities');
		$Template->set_block('hForm', 'statuses', 'hStatuses');

		$Template->set_var('hActions', '');
		$Template->set_var('hPriorities', '');
		$Template->set_var('hSeverities', '');
		$Template->set_var('hStatuses', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_ATTRIBUTESETLINK', menuLink('', 'menuAction=boAttributesets.showall'));
		$Template->set_var('TXT_ATTRIBUTESET', STR_ATTR_ATTRIBUTESET);
		$Template->set_var('VAL_ATTRIBUTESETNAME', $obj->name);
		$Template->set_var('TXT_ACTIONS', STR_ATTR_ACTIONS);
		$Template->set_var('TXT_PRIORITIES', STR_ATTR_PRIORITIES);
		$Template->set_var('TXT_SEVERITIES', STR_ATTR_SEVERITIES);
		$Template->set_var('TXT_STATUSES', STR_ATTR_STATUSES);
		$Template->set_var('TXT_MAP', STR_ATTR_MAP);

		$cnt = 0;
		$col = 0;
		$bNeedTable = false;

		$objA = CreateObject('dcl.dbActions');
		$objA->Connect();

		$theAttributes = array('actions', 'priorities', 'severities', 'statuses');

		for ($cnt = 0; $cnt < count($theAttributes); $cnt++)
		{
			$typeid = $cnt + 1;
			$section = $theAttributes[$cnt];
			$handle = 'h' . ucfirst($section);

			if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$Template->set_var('LNK_MAP' . strtoupper($section),
					menuLink('', 'menuAction=boAttributesets.showmapping&setid=' . $obj->id . '&typeid=' . $typeid));
			}
			else
				$Template->set_var('LNK_MAP', '&nbsp;');

			$query = 'SELECT a.name FROM ' . $section . ' a, attributesetsmap b WHERE a.id=b.keyid ';
			$query .= ' AND b.setid=' . $obj->id;
			$query .= ' AND b.typeid=' . $typeid;
			$query .= ' ORDER BY ';
			if ($handle == 'hPriorities' || $handle == 'hSeverities')
				$query .= 'b.weight';
			else
				$query .= 'a.name';

			if ($objA->Query($query) != -1)
			{
				$i = 0;
				while ($objA->next_record())
				{
					$Template->set_var('VAL_NAME', $objA->f(0));
					$Template->set_var('ROW_COLOR', $i++ % 2 == 0 ? '#ffffff' : $dcl_info['DCL_COLOR_LIGHT']);
					$Template->parse($handle, $section, true);
				}
			}
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
