<?php
/*
 * $Id: class.dbPersonnel.inc.php,v 1.3.4.1 2003/01/29 05:18:52 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbPersonnel extends dclDB
{
	var $id;
	var $short;
	var $lastname;
	var $firstname;
	var $reportto;
	var $department;
	var $pwd;
	var $security;
	var $email;
	var $active;

       // Not real fields, but handy!
	var $lastNameFirst;
	var $firstNameLast;

	function dbPersonnel()
	{
           // Table Fields
		$this->fieldArray = array('id', 'short', 'lastname', 'firstname', 'reportto',
				'department', 'pwd', 'security', 'email', 'active');

           // Foreign Keys
		$this->foreignKeys = array(
				'workorders' => array('responsible', 'createby', 'closedby'),
				'timecards' => array('actionby', 'reassign_from_id', 'reassign_to_id'), 
				'tickets' => array('responsible', 'createdby', 'closedby'),
				'ticketresolutions' => 'loggedby',
				'watches' => 'whoid',
				'views' => 'whoid',
				'products' => array('reportto', 'ticketsto'), 
				'dcl_projects' => 'reportto',
				'personnel' => 'reportto');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('personnel');
		$query = 'INSERT INTO personnel (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'short,lastname,firstname,reportto,department,pwd,security,email,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->lastname) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->firstname) . '\',';
		$query .= $this->reportto . ',';
		$query .= $this->department . ',';
		$query .= '\'' . $this->pwd . '\',';
		$query .= $this->security . ',';
		$query .= '\'' . $this->DBAddSlashes($this->email) . '\',\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_USERINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
               // NOTE: pwd should not be edited from here.
		$query = 'UPDATE personnel SET ';
		$query .= 'short=\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= 'lastname=\'' . $this->DBAddSlashes($this->lastname) . '\',';
		$query .= 'firstname=\'' . $this->DBAddSlashes($this->firstname) . '\',';
		$query .= 'reportto=' . $this->reportto . ',';
		$query .= 'department=' . $this->department . ',';
		$query .= 'security=' . $this->security . ',';
		$query .= 'email=\'' . $this->DBAddSlashes($this->email) . '\',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM personnel WHERE id=' . $this->id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE personnel SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE id=' . $this->id;

		return $this->Execute($query);
	}

	function InitFromGlobals()
	{
		while (list($key, $field) = each($this->fieldArray))
		{
			if (IsSet($GLOBALS[$field]))
				$this->$field = $this->GPCStripSlashes($GLOBALS[$field]);
		}

           // Fill in our convenience fields
		$this->lastNameFirst = $this->lastname . ', ' . $this->firstname;
		$this->firstNameLast = $this->firstname . ' ' . $this->lastname;
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->id = $this->f('id');
			$this->short = trim($this->f('short'));
			$this->lastname = trim($this->f('lastname'));
			$this->firstname = trim($this->f('firstname'));
			$this->reportto = $this->f('reportto');
			$this->department = $this->f('department');
			$this->pwd = $this->f('pwd');
			$this->security = $this->f('security');
			$this->email = trim($this->f('email'));
			$this->active = $this->f('active');

               // Fill in our convenience fields
			$this->lastNameFirst = $this->lastname . ', ' . $this->firstname;
			$this->firstNameLast = $this->firstname . ' ' . $this->lastname;

			if ($this->cacheEnabled)
				$this->CacheRow($this->id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
		{
               // Fill in our convenience fields
			$this->lastNameFirst = $this->lastname . ', ' . $this->firstname;
			$this->firstNameLast = $this->firstname . ' ' . $this->lastname;

			return 0;
		}

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM personnel WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->id = 0;
		$this->short = '';
		$this->lastname = '';
		$this->firstname = '';
		$this->reportto = 0;
		$this->department = 0;
		$this->pwd = '';
		$this->security = 0;
		$this->email = 0;
		$this->lastNameFirst = '';
		$this->firstNameLast = '';
		$this->active = '';
	}

	function IsPasswordOK($userID, $password)
	{
		$this->Load($userID);
		if (md5($password) == $this->pwd)
			return true;
		else
			return false;
	}

	function ChangePassword($userID, $oldPassword, $newPassword, $confirmPassword)
	{
		if ($this->conn == 0)
		{
			if ($this->Connect() == -1)
				print(STR_DB_CONNECTIONFAILED);
		}
		if ($GLOBALS['DCLID'] > 1)
		{
			if ($this->IsPasswordOK($userID, $oldPassword) == false)
			{
				print(STR_DB_WRONGPWD);
				$objPersonnel = CreateObject('dcl.htmlPersonnel');
				$objPersonnel->DisplayPasswdForm();
				return;
			}
		}

		$query = 'UPDATE personnel SET pwd=\'' . md5($newPassword) . '\' WHERE id=' . $userID;
		$this->Execute($query);
		echo '<CENTER>' . STR_DB_PWDCHGSUCCESS . '</CENTER>';
	}

	function Encrypt()
	{
		$this->pwd = md5($this->pwd);
	}
}
?>
